/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.parser.lexparser.AbstractTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.BaseLexicon;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.TreeCollinizer;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.international.tuebadz.TueBaDZHeadFinder;
import edu.stanford.nlp.trees.international.tuebadz.TueBaDZLanguagePack;
import edu.stanford.nlp.trees.international.tuebadz.TueBaDZTreeReaderFactory;
import edu.stanford.nlp.util.Index;
import java.util.ArrayList;
import java.util.List;

public class TueBaDZParserParams
extends AbstractTreebankParserParams {
    private HeadFinder hf = new TueBaDZHeadFinder();
    private int nodeCleanup = 0;
    private boolean markKonjParent = false;
    private boolean markContainsV = true;
    private boolean markZu = true;
    private boolean markColons = false;
    private boolean leftPhrasal = false;
    private boolean markHDParent = false;
    private boolean leaveGF = false;
    private static final long serialVersionUID = 7303189408025355170L;

    public TueBaDZParserParams() {
        super(new TueBaDZLanguagePack());
    }

    @Override
    public List<? extends HasWord> defaultTestSentence() {
        return Sentence.toWordList("Veruntreute", "die", "AWO", "Spendengeld", "?");
    }

    @Override
    public String[] sisterSplitters() {
        return new String[0];
    }

    @Override
    public TreeTransformer collinizer() {
        return new TreeCollinizer(this.treebankLanguagePack());
    }

    @Override
    public TreeTransformer collinizerEvalb() {
        return new TreeCollinizer(this.treebankLanguagePack());
    }

    @Override
    public MemoryTreebank memoryTreebank() {
        return new MemoryTreebank(this.treeReaderFactory());
    }

    @Override
    public DiskTreebank diskTreebank() {
        return new DiskTreebank(this.treeReaderFactory());
    }

    @Override
    public TreeReaderFactory treeReaderFactory() {
        return new TueBaDZTreeReaderFactory(this.treebankLanguagePack(), this.nodeCleanup);
    }

    @Override
    public Lexicon lex(Options op, Index<String> wordIndex, Index<String> tagIndex) {
        if (op.lexOptions.uwModelTrainer == null) {
            op.lexOptions.uwModelTrainer = "edu.stanford.nlp.parser.lexparser.GermanUnknownWordModelTrainer";
        }
        return new BaseLexicon(op, wordIndex, tagIndex);
    }

    @Override
    public int setOptionFlag(String[] args, int i) {
        if (args[i].equalsIgnoreCase("-nodeCleanup")) {
            this.nodeCleanup = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-markKonjParent")) {
            this.markKonjParent = Boolean.parseBoolean(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-markContainsV")) {
            this.markContainsV = Boolean.parseBoolean(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-markZu")) {
            this.markZu = Boolean.parseBoolean(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-markColons")) {
            this.markColons = Boolean.parseBoolean(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-leftPhrasal")) {
            this.leftPhrasal = Boolean.parseBoolean(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-markHDParent")) {
            this.markHDParent = Boolean.parseBoolean(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-leaveGF")) {
            this.leaveGF = Boolean.parseBoolean(args[i + 1]);
            ((TueBaDZLanguagePack)this.treebankLanguagePack()).setLeaveGF(this.leaveGF);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-evalGF")) {
            this.setEvalGF(Boolean.parseBoolean(args[i + 1]));
            i += 2;
        } else if (args[i].equalsIgnoreCase("-limitedGF")) {
            ((TueBaDZLanguagePack)this.treebankLanguagePack()).setLimitedGF(Boolean.parseBoolean(args[i + 1]));
            i += 2;
        } else if (args[i].equalsIgnoreCase("-gfCharacter")) {
            String gfChar = args[i + 1];
            if (gfChar.length() > 1) {
                System.out.println("Warning! gfCharacter argument ignored; must specify a character, not a String");
            }
            this.treebankLanguagePack().setGfCharacter(gfChar.charAt(0));
            i += 2;
        }
        return i;
    }

    @Override
    public void display() {
        System.err.println("TueBaDZParserParams nodeCleanup=" + this.nodeCleanup + " mKonjParent=" + this.markKonjParent + " mContainsV=" + this.markContainsV + " mZu=" + this.markZu + " mColons=" + this.markColons);
    }

    @Override
    public HeadFinder headFinder() {
        return this.hf;
    }

    @Override
    public HeadFinder typedDependencyHeadFinder() {
        return this.headFinder();
    }

    @Override
    public Tree transformTree(Tree t, Tree root) {
        if (t == null || t.isLeaf()) {
            return t;
        }
        ArrayList<String> annotations = new ArrayList<String>();
        Label lab = t.label();
        String word = null;
        if (lab instanceof HasWord) {
            word = ((HasWord)((Object)lab)).word();
        }
        String tag = null;
        if (lab instanceof HasTag) {
            tag = ((HasTag)((Object)lab)).tag();
        }
        String cat = lab.value();
        if (t.isPhrasal()) {
            List<String> childBasicCats = this.childBasicCats(t);
            if (this.markZu && cat.startsWith("V") && (childBasicCats.contains("PTKZU") || childBasicCats.contains("PTKZU-HD") || childBasicCats.contains("VVIZU") || childBasicCats.contains("VVIZU-HD"))) {
                annotations.add("%ZU");
            }
            if (this.markContainsV && TueBaDZParserParams.containsV(t)) {
                annotations.add("%vp");
            }
            if (this.markKonjParent) {
                for (String cCat : childBasicCats) {
                    if (!cCat.contains("-KONJ")) continue;
                    annotations.add("%konjp");
                    break;
                }
            }
            if (this.markHDParent) {
                for (String cCat : childBasicCats) {
                    if (!cCat.contains("-HD")) continue;
                    annotations.add("%hdp");
                    break;
                }
            }
        } else {
            if (this.markColons && cat.equals("$.") && word != null && (word.equals(":") || word.equals(";"))) {
                annotations.add("-%colon");
            }
            if (this.leftPhrasal && TueBaDZParserParams.leftPhrasal(t)) {
                annotations.add("%LP");
            }
        }
        StringBuilder catSB = new StringBuilder(cat);
        for (String annotation : annotations) {
            catSB.append(annotation);
        }
        t.setLabel(new CategoryWordTag(catSB.toString(), word, tag));
        return t;
    }

    private static boolean leftPhrasal(Tree t) {
        while (!t.isLeaf()) {
            String str = (t = t.lastChild()).label().value();
            if (!str.startsWith("NP") && !str.startsWith("PP") && !str.startsWith("VP") && !str.startsWith("S") && !str.startsWith("Q") && !str.startsWith("A")) continue;
            return true;
        }
        return false;
    }

    private List<String> childBasicCats(Tree t) {
        Tree[] kids = t.children();
        ArrayList<String> l = new ArrayList<String>();
        for (Tree kid : kids) {
            l.add(this.basicCat(kid.label().value()));
        }
        return l;
    }

    private String basicCat(String str) {
        return this.tlp.basicCategory(str);
    }

    private static boolean containsV(Tree t) {
        Tree[] kids;
        String cat = t.label().value();
        if (cat.startsWith("V")) {
            return true;
        }
        for (Tree kid : kids = t.children()) {
            if (!TueBaDZParserParams.containsV(kid)) continue;
            return true;
        }
        return false;
    }
}

