/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex;

import edu.stanford.nlp.ling.AnnotationLookup;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.ling.tokensregex.MatchedExpression;
import edu.stanford.nlp.ling.tokensregex.types.Value;
import edu.stanford.nlp.pipeline.CoreMapAttributeAggregator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class EnvLookup {
    private EnvLookup() {
    }

    public static Class lookupAnnotationKey(Env env, String name) {
        AnnotationLookup.KeyLookup lookup;
        Object obj;
        if (env != null && (obj = env.get(name)) != null) {
            if (obj instanceof Class) {
                return (Class)obj;
            }
            if (obj instanceof Value && (obj = ((Value)obj).get()) instanceof Class) {
                return (Class)obj;
            }
        }
        if ((lookup = AnnotationLookup.getCoreKey(name)) != null) {
            return lookup.coreKey;
        }
        try {
            Class<?> clazz = Class.forName(name);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static Map<Class, CoreMapAttributeAggregator> getDefaultTokensAggregators(Env env) {
        Map<Class, CoreMapAttributeAggregator> obj;
        if (env != null && (obj = env.getDefaultTokensAggregators()) != null) {
            return obj;
        }
        return CoreMapAttributeAggregator.DEFAULT_NUMERIC_TOKENS_AGGREGATORS;
    }

    public static List<Class> getDefaultTokensResultAnnotationKey(Env env) {
        List<Class> obj;
        if (env != null && (obj = env.getDefaultTokensResultAnnotationKey()) != null) {
            return obj;
        }
        return null;
    }

    public static List<Class> getDefaultResultAnnotationKey(Env env) {
        List<Class> obj;
        if (env != null && (obj = env.getDefaultResultAnnotationKey()) != null) {
            return obj;
        }
        return null;
    }

    public static Function<MatchedExpression, ?> getDefaultResultAnnotationExtractor(Env env) {
        Function<MatchedExpression, ?> obj;
        if (env != null && (obj = env.getDefaultResultsAnnotationExtractor()) != null) {
            return obj;
        }
        return null;
    }

    public static Class getDefaultNestedResultsAnnotationKey(Env env) {
        Class obj;
        if (env != null && (obj = env.getDefaultNestedResultsAnnotationKey()) != null) {
            return obj;
        }
        return null;
    }

    public static Class getDefaultTextAnnotationKey(Env env) {
        Class obj;
        if (env != null && (obj = env.getDefaultTextAnnotationKey()) != null) {
            return obj;
        }
        return CoreAnnotations.TextAnnotation.class;
    }

    public static Class getDefaultTokensAnnotationKey(Env env) {
        Class obj;
        if (env != null && (obj = env.getDefaultTokensAnnotationKey()) != null) {
            return obj;
        }
        return CoreAnnotations.TokensAnnotation.class;
    }
}

