/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.parser.shiftreduce.FeatureFactory;
import edu.stanford.nlp.parser.shiftreduce.ShiftReduceUtils;
import edu.stanford.nlp.parser.shiftreduce.State;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.TreeShapedStack;
import java.util.List;

public class BasicFeatureFactory
extends FeatureFactory {
    private static final long serialVersionUID = 1L;

    public static void addUnaryStackFeatures(List<String> features, CoreLabel label, String conFeature, String wordTagFeature, String tagFeature, String wordConFeature, String tagConFeature) {
        if (label == null) {
            features.add(conFeature + "*NULL*");
            return;
        }
        String constituent = BasicFeatureFactory.getFeatureFromCoreLabel(label, FeatureFactory.FeatureComponent.VALUE);
        String tag = BasicFeatureFactory.getFeatureFromCoreLabel(label, FeatureFactory.FeatureComponent.HEADTAG);
        String word = BasicFeatureFactory.getFeatureFromCoreLabel(label, FeatureFactory.FeatureComponent.HEADWORD);
        features.add(conFeature + constituent);
        features.add(wordTagFeature + word + "-" + tag);
        features.add(tagFeature + tag);
        features.add(wordConFeature + word + "-" + constituent);
        features.add(tagConFeature + tag + "-" + constituent);
    }

    public static void addUnaryQueueFeatures(List<String> features, CoreLabel label, String wtFeature) {
        if (label == null) {
            features.add(wtFeature + "*NULL*");
            return;
        }
        String tag = ((Tree)label.get(TreeCoreAnnotations.HeadTagAnnotation.class)).label().value();
        String word = ((Tree)label.get(TreeCoreAnnotations.HeadWordAnnotation.class)).label().value();
        features.add(wtFeature + tag + "-" + word);
    }

    public static void addBinaryFeatures(List<String> features, String name1, CoreLabel label1, FeatureFactory.FeatureComponent feature11, FeatureFactory.FeatureComponent feature12, String name2, CoreLabel label2, FeatureFactory.FeatureComponent feature21, FeatureFactory.FeatureComponent feature22) {
        if (label1 == null) {
            if (label2 == null) {
                features.add(name1 + "n" + name2 + "n");
            } else {
                BasicFeatureFactory.addUnaryFeature(features, name1 + "n" + name2 + feature21.shortName() + "-", label2, feature21);
                BasicFeatureFactory.addUnaryFeature(features, name1 + "n" + name2 + feature22.shortName() + "-", label2, feature22);
            }
        } else if (label2 == null) {
            BasicFeatureFactory.addUnaryFeature(features, name1 + feature11.shortName() + name2 + "n-", label1, feature11);
            BasicFeatureFactory.addUnaryFeature(features, name1 + feature12.shortName() + name2 + "n-", label1, feature12);
        } else {
            BasicFeatureFactory.addBinaryFeature(features, name1 + feature11.shortName() + name2 + feature21.shortName() + "-", label1, feature11, label2, feature21);
            BasicFeatureFactory.addBinaryFeature(features, name1 + feature11.shortName() + name2 + feature22.shortName() + "-", label1, feature11, label2, feature22);
            BasicFeatureFactory.addBinaryFeature(features, name1 + feature12.shortName() + name2 + feature21.shortName() + "-", label1, feature12, label2, feature21);
            BasicFeatureFactory.addBinaryFeature(features, name1 + feature12.shortName() + name2 + feature22.shortName() + "-", label1, feature12, label2, feature22);
        }
    }

    public static void addUnaryFeature(List<String> features, String featureType, CoreLabel label, FeatureFactory.FeatureComponent feature) {
        String value = BasicFeatureFactory.getFeatureFromCoreLabel(label, feature);
        features.add(featureType + value);
    }

    public static void addBinaryFeature(List<String> features, String featureType, CoreLabel label1, FeatureFactory.FeatureComponent feature1, CoreLabel label2, FeatureFactory.FeatureComponent feature2) {
        String value1 = BasicFeatureFactory.getFeatureFromCoreLabel(label1, feature1);
        String value2 = BasicFeatureFactory.getFeatureFromCoreLabel(label2, feature2);
        features.add(featureType + value1 + "-" + value2);
    }

    public static void addTrigramFeature(List<String> features, String featureType, CoreLabel label1, FeatureFactory.FeatureComponent feature1, CoreLabel label2, FeatureFactory.FeatureComponent feature2, CoreLabel label3, FeatureFactory.FeatureComponent feature3) {
        String value1 = BasicFeatureFactory.getFeatureFromCoreLabel(label1, feature1);
        String value2 = BasicFeatureFactory.getFeatureFromCoreLabel(label2, feature2);
        String value3 = BasicFeatureFactory.getFeatureFromCoreLabel(label3, feature3);
        features.add(featureType + value1 + "-" + value2 + "-" + value3);
    }

    public static void addPositionFeatures(List<String> features, State state) {
        if (state.tokenPosition >= state.sentence.size()) {
            features.add("QUEUE_FINISHED");
        }
        if (state.tokenPosition >= state.sentence.size() && state.stack.size() == 1) {
            features.add("QUEUE_FINISHED_STACK_SINGLETON");
        }
    }

    public static void addSeparatorFeature(List<String> features, String featureType, State.HeadPosition separator) {
        if (separator == null) {
            return;
        }
        features.add(featureType + (Object)((Object)separator));
    }

    public static void addSeparatorFeature(List<String> features, String featureType, CoreLabel label, FeatureFactory.FeatureComponent feature, State.HeadPosition separator) {
        if (separator == null) {
            return;
        }
        String value = BasicFeatureFactory.getFeatureFromCoreLabel(label, feature);
        features.add(featureType + value + "-" + (Object)((Object)separator));
    }

    public static void addSeparatorFeature(List<String> features, String featureType, CoreLabel label, FeatureFactory.FeatureComponent feature, boolean between) {
        String value = BasicFeatureFactory.getFeatureFromCoreLabel(label, feature);
        features.add(featureType + value + "-" + between);
    }

    public static void addSeparatorFeature(List<String> features, String featureType, CoreLabel label1, FeatureFactory.FeatureComponent feature1, CoreLabel label2, FeatureFactory.FeatureComponent feature2, boolean between) {
        String value1 = BasicFeatureFactory.getFeatureFromCoreLabel(label1, feature1);
        String value2 = BasicFeatureFactory.getFeatureFromCoreLabel(label2, feature2);
        features.add(featureType + value1 + "-" + value2 + "-" + between);
    }

    public static void addSeparatorFeatures(List<String> features, String name1, CoreLabel label1, String name2, CoreLabel label2, String separatorBetween, int countBetween) {
        if (label1 == null || label2 == null) {
            return;
        }
        if (separatorBetween != null) {
            String separatorBetweenName = "Sepb" + name1 + name2 + "-" + separatorBetween + "-";
            BasicFeatureFactory.addUnaryFeature(features, name1 + "w" + separatorBetweenName, label1, FeatureFactory.FeatureComponent.HEADWORD);
            BasicFeatureFactory.addBinaryFeature(features, name1 + "wc" + separatorBetweenName, label1, FeatureFactory.FeatureComponent.HEADWORD, label1, FeatureFactory.FeatureComponent.VALUE);
            BasicFeatureFactory.addUnaryFeature(features, name2 + "w" + separatorBetweenName, label2, FeatureFactory.FeatureComponent.HEADWORD);
            BasicFeatureFactory.addBinaryFeature(features, name2 + "wc" + separatorBetweenName, label2, FeatureFactory.FeatureComponent.HEADWORD, label2, FeatureFactory.FeatureComponent.VALUE);
            BasicFeatureFactory.addBinaryFeature(features, name1 + "c" + name2 + "c" + separatorBetweenName, label1, FeatureFactory.FeatureComponent.VALUE, label2, FeatureFactory.FeatureComponent.VALUE);
        }
        String countBetweenName = "Sepb" + name1 + name2 + "-" + countBetween + "-";
        BasicFeatureFactory.addUnaryFeature(features, name1 + "w" + countBetweenName, label1, FeatureFactory.FeatureComponent.HEADWORD);
        BasicFeatureFactory.addBinaryFeature(features, name1 + "wc" + countBetweenName, label1, FeatureFactory.FeatureComponent.HEADWORD, label1, FeatureFactory.FeatureComponent.VALUE);
        BasicFeatureFactory.addUnaryFeature(features, name2 + "w" + countBetweenName, label2, FeatureFactory.FeatureComponent.HEADWORD);
        BasicFeatureFactory.addBinaryFeature(features, name2 + "wc" + countBetweenName, label2, FeatureFactory.FeatureComponent.HEADWORD, label2, FeatureFactory.FeatureComponent.VALUE);
        BasicFeatureFactory.addBinaryFeature(features, name1 + "c" + name2 + "c" + countBetweenName, label1, FeatureFactory.FeatureComponent.VALUE, label2, FeatureFactory.FeatureComponent.VALUE);
    }

    public static void addSeparatorFeatures(List<String> features, CoreLabel s0Label, CoreLabel s1Label, State.HeadPosition s0Separator, State.HeadPosition s1Separator) {
        boolean between = false;
        if (s0Separator != null && (s0Separator == State.HeadPosition.BOTH || s0Separator == State.HeadPosition.LEFT) || s1Separator != null && (s1Separator == State.HeadPosition.BOTH || s1Separator == State.HeadPosition.RIGHT)) {
            between = true;
        }
        BasicFeatureFactory.addSeparatorFeature(features, "s0sep-", s0Separator);
        BasicFeatureFactory.addSeparatorFeature(features, "s1sep-", s1Separator);
        BasicFeatureFactory.addSeparatorFeature(features, "s0ws0sep-", s0Label, FeatureFactory.FeatureComponent.HEADWORD, s0Separator);
        BasicFeatureFactory.addSeparatorFeature(features, "s0ws1sep-", s0Label, FeatureFactory.FeatureComponent.HEADWORD, s1Separator);
        BasicFeatureFactory.addSeparatorFeature(features, "s1ws0sep-", s1Label, FeatureFactory.FeatureComponent.HEADWORD, s0Separator);
        BasicFeatureFactory.addSeparatorFeature(features, "s1ws1sep-", s1Label, FeatureFactory.FeatureComponent.HEADWORD, s1Separator);
        BasicFeatureFactory.addSeparatorFeature(features, "s0cs0sep-", s0Label, FeatureFactory.FeatureComponent.VALUE, s0Separator);
        BasicFeatureFactory.addSeparatorFeature(features, "s0cs1sep-", s0Label, FeatureFactory.FeatureComponent.VALUE, s1Separator);
        BasicFeatureFactory.addSeparatorFeature(features, "s1cs0sep-", s1Label, FeatureFactory.FeatureComponent.VALUE, s0Separator);
        BasicFeatureFactory.addSeparatorFeature(features, "s1cs1sep-", s1Label, FeatureFactory.FeatureComponent.VALUE, s1Separator);
        BasicFeatureFactory.addSeparatorFeature(features, "s0ts0sep-", s0Label, FeatureFactory.FeatureComponent.HEADTAG, s0Separator);
        BasicFeatureFactory.addSeparatorFeature(features, "s0ts1sep-", s0Label, FeatureFactory.FeatureComponent.HEADTAG, s1Separator);
        BasicFeatureFactory.addSeparatorFeature(features, "s1ts0sep-", s1Label, FeatureFactory.FeatureComponent.HEADTAG, s0Separator);
        BasicFeatureFactory.addSeparatorFeature(features, "s1ts1sep-", s1Label, FeatureFactory.FeatureComponent.HEADTAG, s1Separator);
        if (s0Label != null && s1Label != null) {
            BasicFeatureFactory.addSeparatorFeature(features, "s0wsb-", s0Label, FeatureFactory.FeatureComponent.HEADWORD, between);
            BasicFeatureFactory.addSeparatorFeature(features, "s1wsb-", s1Label, FeatureFactory.FeatureComponent.HEADWORD, between);
            BasicFeatureFactory.addSeparatorFeature(features, "s0csb-", s0Label, FeatureFactory.FeatureComponent.VALUE, between);
            BasicFeatureFactory.addSeparatorFeature(features, "s1csb-", s1Label, FeatureFactory.FeatureComponent.VALUE, between);
            BasicFeatureFactory.addSeparatorFeature(features, "s0tsb-", s0Label, FeatureFactory.FeatureComponent.HEADTAG, between);
            BasicFeatureFactory.addSeparatorFeature(features, "s1tsb-", s1Label, FeatureFactory.FeatureComponent.HEADTAG, between);
            BasicFeatureFactory.addSeparatorFeature(features, "s0cs1csb-", s0Label, FeatureFactory.FeatureComponent.VALUE, s1Label, FeatureFactory.FeatureComponent.VALUE, between);
        }
    }

    public void addEdgeFeatures(List<String> features, State state, String nodeName, String neighborName, Tree node, Tree neighbor) {
        if (node == null) {
            return;
        }
        int left = ShiftReduceUtils.leftIndex(node);
        int right = ShiftReduceUtils.rightIndex(node);
        if (right == left) {
            features.add(nodeName + "SZ1");
            return;
        }
        BasicFeatureFactory.addUnaryQueueFeatures(features, BasicFeatureFactory.getCoreLabel(state.sentence.get(left)), nodeName + "EL-");
        BasicFeatureFactory.addUnaryQueueFeatures(features, BasicFeatureFactory.getCoreLabel(state.sentence.get(right)), nodeName + "ER-");
        if (neighbor != null) {
            BasicFeatureFactory.addBinaryFeatures(features, nodeName, BasicFeatureFactory.getCoreLabel(state.sentence.get(right)), FeatureFactory.FeatureComponent.HEADWORD, FeatureFactory.FeatureComponent.HEADTAG, neighborName, BasicFeatureFactory.getCoreLabel(neighbor), FeatureFactory.FeatureComponent.HEADWORD, FeatureFactory.FeatureComponent.HEADTAG);
        }
        if (right - left == 1) {
            features.add(nodeName + "SZ2");
            return;
        }
        if (right - left == 2) {
            features.add(nodeName + "SZ3");
            BasicFeatureFactory.addUnaryQueueFeatures(features, BasicFeatureFactory.getCoreLabel(state.sentence.get(left + 1)), nodeName + "EM-");
            return;
        }
        features.add(nodeName + "SZB");
        BasicFeatureFactory.addUnaryQueueFeatures(features, BasicFeatureFactory.getCoreLabel(state.sentence.get(left + 1)), nodeName + "El-");
        BasicFeatureFactory.addUnaryQueueFeatures(features, BasicFeatureFactory.getCoreLabel(state.sentence.get(right - 1)), nodeName + "Er-");
    }

    public void addEdgeFeatures2(List<String> features, State state, String nodeName, Tree node) {
        if (node == null) {
            return;
        }
        int left = ShiftReduceUtils.leftIndex(node);
        int right = ShiftReduceUtils.rightIndex(node);
        CoreLabel nodeLabel = BasicFeatureFactory.getCoreLabel(node);
        String nodeValue = BasicFeatureFactory.getFeatureFromCoreLabel(nodeLabel, FeatureFactory.FeatureComponent.VALUE) + "-";
        CoreLabel leftLabel = BasicFeatureFactory.getQueueLabel(state, left);
        CoreLabel rightLabel = BasicFeatureFactory.getQueueLabel(state, right);
        BasicFeatureFactory.addUnaryQueueFeatures(features, leftLabel, nodeName + "EL-" + nodeValue);
        BasicFeatureFactory.addUnaryQueueFeatures(features, rightLabel, nodeName + "ER-" + nodeValue);
        CoreLabel previousLabel = BasicFeatureFactory.getQueueLabel(state, left - 1);
        BasicFeatureFactory.addUnaryQueueFeatures(features, previousLabel, nodeName + "EP-" + nodeValue);
        CoreLabel nextLabel = BasicFeatureFactory.getQueueLabel(state, right + 1);
        BasicFeatureFactory.addUnaryQueueFeatures(features, nextLabel, nodeName + "EN-" + nodeValue);
    }

    @Override
    public List<String> featurize(State state, List<String> features) {
        TreeShapedStack<Tree> stack = state.stack;
        List<Tree> sentence = state.sentence;
        int tokenPosition = state.tokenPosition;
        CoreLabel s0Label = BasicFeatureFactory.getStackLabel(stack, 0, new FeatureFactory.Transition[0]);
        CoreLabel s1Label = BasicFeatureFactory.getStackLabel(stack, 1, new FeatureFactory.Transition[0]);
        CoreLabel s2Label = BasicFeatureFactory.getStackLabel(stack, 2, new FeatureFactory.Transition[0]);
        CoreLabel s3Label = BasicFeatureFactory.getStackLabel(stack, 3, new FeatureFactory.Transition[0]);
        CoreLabel s0LLabel = BasicFeatureFactory.getStackLabel(stack, 0, FeatureFactory.Transition.LEFT);
        CoreLabel s0RLabel = BasicFeatureFactory.getStackLabel(stack, 0, FeatureFactory.Transition.RIGHT);
        CoreLabel s0ULabel = BasicFeatureFactory.getStackLabel(stack, 0, FeatureFactory.Transition.UNARY);
        CoreLabel s0LLLabel = BasicFeatureFactory.getStackLabel(stack, 0, FeatureFactory.Transition.LEFT, FeatureFactory.Transition.LEFT);
        CoreLabel s0LRLabel = BasicFeatureFactory.getStackLabel(stack, 0, FeatureFactory.Transition.LEFT, FeatureFactory.Transition.RIGHT);
        CoreLabel s0LULabel = BasicFeatureFactory.getStackLabel(stack, 0, FeatureFactory.Transition.LEFT, FeatureFactory.Transition.UNARY);
        CoreLabel s0RLLabel = BasicFeatureFactory.getStackLabel(stack, 0, FeatureFactory.Transition.RIGHT, FeatureFactory.Transition.LEFT);
        CoreLabel s0RRLabel = BasicFeatureFactory.getStackLabel(stack, 0, FeatureFactory.Transition.RIGHT, FeatureFactory.Transition.RIGHT);
        CoreLabel s0RULabel = BasicFeatureFactory.getStackLabel(stack, 0, FeatureFactory.Transition.RIGHT, FeatureFactory.Transition.UNARY);
        CoreLabel s0ULLabel = BasicFeatureFactory.getStackLabel(stack, 0, FeatureFactory.Transition.UNARY, FeatureFactory.Transition.LEFT);
        CoreLabel s0URLabel = BasicFeatureFactory.getStackLabel(stack, 0, FeatureFactory.Transition.UNARY, FeatureFactory.Transition.RIGHT);
        CoreLabel s0UULabel = BasicFeatureFactory.getStackLabel(stack, 0, FeatureFactory.Transition.UNARY, FeatureFactory.Transition.UNARY);
        CoreLabel s1LLabel = BasicFeatureFactory.getStackLabel(stack, 1, FeatureFactory.Transition.LEFT);
        CoreLabel s1RLabel = BasicFeatureFactory.getStackLabel(stack, 1, FeatureFactory.Transition.RIGHT);
        CoreLabel s1ULabel = BasicFeatureFactory.getStackLabel(stack, 1, FeatureFactory.Transition.UNARY);
        CoreLabel q0Label = BasicFeatureFactory.getQueueLabel(sentence, tokenPosition, 0);
        CoreLabel q1Label = BasicFeatureFactory.getQueueLabel(sentence, tokenPosition, 1);
        CoreLabel q2Label = BasicFeatureFactory.getQueueLabel(sentence, tokenPosition, 2);
        CoreLabel q3Label = BasicFeatureFactory.getQueueLabel(sentence, tokenPosition, 3);
        CoreLabel qP1Label = BasicFeatureFactory.getQueueLabel(sentence, tokenPosition, -1);
        CoreLabel qP2Label = BasicFeatureFactory.getQueueLabel(sentence, tokenPosition, -2);
        BasicFeatureFactory.addUnaryStackFeatures(features, s0Label, "S0C-", "S0WT-", "S0T-", "S0WC-", "S0TC-");
        BasicFeatureFactory.addUnaryStackFeatures(features, s1Label, "S1C-", "S1WT-", "S1T-", "S1WC-", "S1TC-");
        BasicFeatureFactory.addUnaryStackFeatures(features, s2Label, "S2C-", "S2WT-", "S2T-", "S2WC-", "S2TC-");
        BasicFeatureFactory.addUnaryStackFeatures(features, s3Label, "S3C-", "S3WT-", "S3T-", "S3WC-", "S3TC-");
        BasicFeatureFactory.addUnaryStackFeatures(features, s0LLabel, "S0LC-", "S0LWT-", "S0LT-", "S0LWC-", "S0LTC-");
        BasicFeatureFactory.addUnaryStackFeatures(features, s0RLabel, "S0RC-", "S0RWT-", "S0RT-", "S0RWC-", "S0RTC-");
        BasicFeatureFactory.addUnaryStackFeatures(features, s0ULabel, "S0UC-", "S0UWT-", "S0UT-", "S0UWC-", "S0UTC-");
        BasicFeatureFactory.addUnaryStackFeatures(features, s0LLLabel, "S0LLC-", "S0LLWT-", "S0LLT-", "S0LLWC-", "S0LLTC-");
        BasicFeatureFactory.addUnaryStackFeatures(features, s0LRLabel, "S0LRC-", "S0LRWT-", "S0LRT-", "S0LRWC-", "S0LRTC-");
        BasicFeatureFactory.addUnaryStackFeatures(features, s0LULabel, "S0LUC-", "S0LUWT-", "S0LUT-", "S0LUWC-", "S0LUTC-");
        BasicFeatureFactory.addUnaryStackFeatures(features, s0RLLabel, "S0RLC-", "S0RLWT-", "S0RLT-", "S0RLWC-", "S0RLTC-");
        BasicFeatureFactory.addUnaryStackFeatures(features, s0RRLabel, "S0RRC-", "S0RRWT-", "S0RRT-", "S0RRWC-", "S0RRTC-");
        BasicFeatureFactory.addUnaryStackFeatures(features, s0RULabel, "S0RUC-", "S0RUWT-", "S0RUT-", "S0RUWC-", "S0RUTC-");
        BasicFeatureFactory.addUnaryStackFeatures(features, s0ULLabel, "S0ULC-", "S0ULWT-", "S0ULT-", "S0ULWC-", "S0ULTC-");
        BasicFeatureFactory.addUnaryStackFeatures(features, s0URLabel, "S0URC-", "S0URWT-", "S0URT-", "S0URWC-", "S0URTC-");
        BasicFeatureFactory.addUnaryStackFeatures(features, s0UULabel, "S0UUC-", "S0UUWT-", "S0UUT-", "S0UUWC-", "S0UUTC-");
        BasicFeatureFactory.addUnaryStackFeatures(features, s1LLabel, "S1LC-", "S1LWT-", "S1LT-", "S1LWC-", "S1LTC-");
        BasicFeatureFactory.addUnaryStackFeatures(features, s1RLabel, "S1RC-", "S1RWT-", "S1RT-", "S1RWC-", "S1RTC-");
        BasicFeatureFactory.addUnaryStackFeatures(features, s1ULabel, "S1UC-", "S1UWT-", "S1UT-", "S1UWC-", "S1UTC-");
        BasicFeatureFactory.addUnaryQueueFeatures(features, q0Label, "Q0WT-");
        BasicFeatureFactory.addUnaryQueueFeatures(features, q1Label, "Q1WT-");
        BasicFeatureFactory.addUnaryQueueFeatures(features, q2Label, "Q2WT-");
        BasicFeatureFactory.addUnaryQueueFeatures(features, q3Label, "Q3WT-");
        BasicFeatureFactory.addUnaryQueueFeatures(features, qP1Label, "QP1WT-");
        BasicFeatureFactory.addUnaryQueueFeatures(features, qP2Label, "QP2WT-");
        CoreLabel recentL0Label = BasicFeatureFactory.getRecentDependent(stack, FeatureFactory.Transition.LEFT, 0);
        CoreLabel recentR0Label = BasicFeatureFactory.getRecentDependent(stack, FeatureFactory.Transition.RIGHT, 0);
        CoreLabel recentL1Label = BasicFeatureFactory.getRecentDependent(stack, FeatureFactory.Transition.LEFT, 1);
        CoreLabel recentR1Label = BasicFeatureFactory.getRecentDependent(stack, FeatureFactory.Transition.RIGHT, 1);
        BasicFeatureFactory.addUnaryStackFeatures(features, recentL0Label, "recL0C-", "recL0WT-", "recL0T-", "recL0WC-", "recL0TC-");
        BasicFeatureFactory.addUnaryStackFeatures(features, recentR0Label, "recR0C-", "recR0WT-", "recR0T-", "recR0WC-", "recR0TC-");
        BasicFeatureFactory.addUnaryStackFeatures(features, recentL1Label, "recL1C-", "recL1WT-", "recL1T-", "recL1WC-", "recL1TC-");
        BasicFeatureFactory.addUnaryStackFeatures(features, recentR1Label, "recR1C-", "recR1WT-", "recR1T-", "recR1WC-", "recR1TC-");
        BasicFeatureFactory.addBinaryFeatures(features, "S0", s0Label, FeatureFactory.FeatureComponent.HEADWORD, FeatureFactory.FeatureComponent.VALUE, "S1", s1Label, FeatureFactory.FeatureComponent.HEADWORD, FeatureFactory.FeatureComponent.VALUE);
        BasicFeatureFactory.addBinaryFeatures(features, "S0", s0Label, FeatureFactory.FeatureComponent.HEADWORD, FeatureFactory.FeatureComponent.VALUE, "Q0", q0Label, FeatureFactory.FeatureComponent.HEADWORD, FeatureFactory.FeatureComponent.HEADTAG);
        BasicFeatureFactory.addBinaryFeatures(features, "S1", s1Label, FeatureFactory.FeatureComponent.HEADWORD, FeatureFactory.FeatureComponent.VALUE, "Q0", q0Label, FeatureFactory.FeatureComponent.HEADWORD, FeatureFactory.FeatureComponent.HEADTAG);
        BasicFeatureFactory.addBinaryFeatures(features, "Q0", q0Label, FeatureFactory.FeatureComponent.HEADWORD, FeatureFactory.FeatureComponent.HEADTAG, "Q1", q1Label, FeatureFactory.FeatureComponent.HEADWORD, FeatureFactory.FeatureComponent.HEADTAG);
        BasicFeatureFactory.addTrigramFeature(features, "S0cS1cS2c-", s0Label, FeatureFactory.FeatureComponent.VALUE, s1Label, FeatureFactory.FeatureComponent.VALUE, s2Label, FeatureFactory.FeatureComponent.VALUE);
        BasicFeatureFactory.addTrigramFeature(features, "S0wS1cS2c-", s0Label, FeatureFactory.FeatureComponent.HEADWORD, s1Label, FeatureFactory.FeatureComponent.VALUE, s2Label, FeatureFactory.FeatureComponent.VALUE);
        BasicFeatureFactory.addTrigramFeature(features, "S0cS1wS2c-", s0Label, FeatureFactory.FeatureComponent.VALUE, s1Label, FeatureFactory.FeatureComponent.HEADWORD, s2Label, FeatureFactory.FeatureComponent.VALUE);
        BasicFeatureFactory.addTrigramFeature(features, "S0cS1cS2w-", s0Label, FeatureFactory.FeatureComponent.VALUE, s1Label, FeatureFactory.FeatureComponent.VALUE, s2Label, FeatureFactory.FeatureComponent.HEADWORD);
        BasicFeatureFactory.addTrigramFeature(features, "S0cS1cQ0t-", s0Label, FeatureFactory.FeatureComponent.VALUE, s1Label, FeatureFactory.FeatureComponent.VALUE, q0Label, FeatureFactory.FeatureComponent.HEADTAG);
        BasicFeatureFactory.addTrigramFeature(features, "S0wS1cQ0t-", s0Label, FeatureFactory.FeatureComponent.HEADWORD, s1Label, FeatureFactory.FeatureComponent.VALUE, q0Label, FeatureFactory.FeatureComponent.HEADTAG);
        BasicFeatureFactory.addTrigramFeature(features, "S0cS1wQ0t-", s0Label, FeatureFactory.FeatureComponent.VALUE, s1Label, FeatureFactory.FeatureComponent.HEADWORD, q0Label, FeatureFactory.FeatureComponent.HEADTAG);
        BasicFeatureFactory.addTrigramFeature(features, "S0cS1cQ0w-", s0Label, FeatureFactory.FeatureComponent.VALUE, s1Label, FeatureFactory.FeatureComponent.VALUE, q0Label, FeatureFactory.FeatureComponent.HEADWORD);
        BasicFeatureFactory.addPositionFeatures(features, state);
        Tree s0Node = state.getStackNode(0);
        Tree s1Node = state.getStackNode(1);
        Tree q0Node = state.getQueueNode(0);
        BasicFeatureFactory.addSeparatorFeatures(features, "S0", s0Label, "S1", s1Label, state.getSeparatorBetween(s0Node, s1Node), state.getSeparatorCount(s0Node, s1Node));
        BasicFeatureFactory.addSeparatorFeatures(features, "S0", s0Label, "Q0", q0Label, state.getSeparatorBetween(q0Node, s0Node), state.getSeparatorCount(q0Node, s0Node));
        return features;
    }
}

