/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Index;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.concurrent.Semaphore;

public class HashIndex<E>
extends AbstractCollection<E>
implements Index<E>,
RandomAccess {
    ArrayList<E> objects = new ArrayList();
    Map<E, Integer> indexes = Generics.newHashMap();
    boolean locked;
    private final Semaphore semaphore = new Semaphore(1);
    private static final long serialVersionUID = 5398562825928375260L;

    @Override
    public void clear() {
        this.objects.clear();
        this.indexes.clear();
    }

    public int[] indices(Collection<E> elems) {
        int[] indices = new int[elems.size()];
        int i = 0;
        for (E elem : elems) {
            indices[i++] = this.indexOf(elem);
        }
        return indices;
    }

    @Override
    public Collection<E> objects(final int[] indices) {
        return new AbstractList<E>(){

            @Override
            public E get(int index) {
                return HashIndex.this.objects.get(indices[index]);
            }

            @Override
            public int size() {
                return indices.length;
            }
        };
    }

    @Override
    public int size() {
        return this.objects.size();
    }

    @Override
    public E get(int i) {
        if (i < 0 || i >= this.objects.size()) {
            throw new ArrayIndexOutOfBoundsException("Index " + i + " outside the bounds [0," + this.size() + ")");
        }
        return this.objects.get(i);
    }

    @Override
    public List<E> objectsList() {
        return this.objects;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void lock() {
        this.locked = true;
    }

    @Override
    public void unlock() {
        this.locked = false;
    }

    @Override
    public int indexOf(E o) {
        return this.indexOf(o, false);
    }

    @Override
    public int indexOf(E o, boolean add) {
        Integer index = this.indexes.get(o);
        if (index == null) {
            if (add && !this.locked) {
                try {
                    this.semaphore.acquire();
                    index = this.indexes.get(o);
                    if (index == null) {
                        index = this.objects.size();
                        this.objects.add(o);
                        this.indexes.put(o, index);
                    }
                    this.semaphore.release();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            } else {
                return -1;
            }
        }
        return index;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (E element : c) {
            changed |= this.add(element);
        }
        return changed;
    }

    @Override
    public boolean add(E o) {
        Integer index = this.indexes.get(o);
        if (index == null && !this.locked) {
            index = this.objects.size();
            this.objects.add(o);
            this.indexes.put(o, index);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexes.containsKey(o);
    }

    public HashIndex() {
    }

    public HashIndex(int capacity) {
        this.objects = new ArrayList(capacity);
        this.indexes = Generics.newHashMap(capacity);
    }

    public HashIndex(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    public HashIndex(Index<? extends E> index) {
        this();
        this.addAll(index.objectsList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveToFilename(String file) {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(file));
            int sz = this.size();
            for (int i = 0; i < sz; ++i) {
                bw.write(i + "=" + this.get(i) + '\n');
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Index<String> loadFromFilename(String file) {
        HashIndex<String> index = new HashIndex<String>();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                int start = line.indexOf(61);
                if (start == -1 || start == line.length() - 1) continue;
                index.add(line.substring(start + 1));
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return index;
    }

    @Override
    public void saveToWriter(Writer bw) throws IOException {
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            bw.write(i + "=" + this.get(i) + '\n');
        }
    }

    public static Index<String> loadFromReader(BufferedReader br) throws IOException {
        HashIndex<String> index = new HashIndex<String>();
        String line = br.readLine();
        while (line != null && line.length() > 0) {
            int start = line.indexOf(61);
            if (start == -1 || start == line.length() - 1) continue;
            index.add(line.substring(start + 1));
            line = br.readLine();
        }
        return index;
    }

    @Override
    public String toString() {
        return this.toString(Integer.MAX_VALUE);
    }

    public String toStringOneEntryPerLine() {
        return this.toStringOneEntryPerLine(Integer.MAX_VALUE);
    }

    public String toString(int n) {
        int i;
        StringBuilder buff = new StringBuilder("[");
        int sz = this.objects.size();
        if (n > sz) {
            n = sz;
        }
        for (i = 0; i < n; ++i) {
            E e = this.objects.get(i);
            buff.append(i).append('=').append(e);
            if (i >= sz - 1) continue;
            buff.append(',');
        }
        if (i < sz) {
            buff.append("...");
        }
        buff.append(']');
        return buff.toString();
    }

    public String toStringOneEntryPerLine(int n) {
        int i;
        StringBuilder buff = new StringBuilder();
        int sz = this.objects.size();
        if (n > sz) {
            n = sz;
        }
        for (i = 0; i < n; ++i) {
            E e = this.objects.get(i);
            buff.append(e);
            if (i >= sz - 1) continue;
            buff.append('\n');
        }
        if (i < sz) {
            buff.append("...");
        }
        return buff.toString();
    }

    @Override
    public Iterator<E> iterator() {
        return this.objects.iterator();
    }

    public HashIndex<E> unmodifiableView() {
        HashIndex newIndex = new HashIndex<E>(){
            private static final long serialVersionUID = 3415903369787491736L;

            @Override
            public void unlock() {
                throw new UnsupportedOperationException("This is an unmodifiable view!");
            }
        };
        newIndex.objects = this.objects;
        newIndex.indexes = this.indexes;
        newIndex.lock();
        return newIndex;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> e) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Index<String> loadFromFileWithList(String file) {
        HashIndex<String> index = new HashIndex<String>();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                index.add(line.trim());
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return index;
    }
}

