/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex;

import edu.stanford.nlp.trees.HasParent;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.VariableStrings;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class TregexMatcher {
    final Tree root;
    Tree tree;
    IdentityHashMap<Tree, Tree> nodesToParents;
    final Map<String, Tree> namesToNodes;
    final VariableStrings variableStrings;
    Iterator<Tree> findIterator;
    Tree findCurrent;

    TregexMatcher(Tree root, Tree tree, IdentityHashMap<Tree, Tree> nodesToParents, Map<String, Tree> namesToNodes, VariableStrings variableStrings) {
        this.root = root;
        this.tree = tree;
        this.nodesToParents = nodesToParents;
        this.namesToNodes = namesToNodes;
        this.variableStrings = variableStrings;
    }

    public void reset() {
        this.findIterator = null;
        this.findCurrent = null;
        this.namesToNodes.clear();
    }

    void resetChildIter(Tree tree) {
        this.tree = tree;
        this.resetChildIter();
    }

    void resetChildIter() {
    }

    public abstract boolean matches();

    public boolean matchesAt(Tree node) {
        this.resetChildIter(node);
        return this.matches();
    }

    public abstract Tree getMatch();

    public boolean find() {
        if (this.findIterator == null) {
            this.findIterator = this.root.iterator();
        }
        if (this.findCurrent != null && this.matches()) {
            return true;
        }
        while (this.findIterator.hasNext()) {
            this.findCurrent = this.findIterator.next();
            this.resetChildIter(this.findCurrent);
            if (!this.matches()) continue;
            return true;
        }
        return false;
    }

    public boolean findAt(Tree node) {
        if (this.findCurrent != null && this.findCurrent != node) {
            throw new AssertionError((Object)"Error: must call reset() before changing nodes for a call to findRootedAt");
        }
        if (this.findCurrent != null) {
            return this.matches();
        }
        this.findCurrent = node;
        this.resetChildIter(this.findCurrent);
        return this.matches();
    }

    public boolean findNextMatchingNode() {
        Tree lastMatchingNode = this.getMatch();
        while (this.find()) {
            if (this.getMatch() == lastMatchingNode) continue;
            return true;
        }
        return false;
    }

    abstract boolean getChangesVariables();

    public Tree getNode(String name) {
        return this.namesToNodes.get(name);
    }

    public Set<String> getNodeNames() {
        return this.namesToNodes.keySet();
    }

    Tree getParent(Tree node) {
        if (node instanceof HasParent) {
            return node.parent();
        }
        if (this.nodesToParents == null) {
            this.nodesToParents = new IdentityHashMap();
        }
        if (this.nodesToParents.size() == 0) {
            this.fillNodesToParents(this.root, null);
        }
        return this.nodesToParents.get(node);
    }

    private void fillNodesToParents(Tree node, Tree parent) {
        this.nodesToParents.put(node, parent);
        for (Tree child : node.children()) {
            this.fillNodesToParents(child, node);
        }
    }

    Tree getRoot() {
        return this.root;
    }

    public String getVariableString(String var) {
        return this.variableStrings.getString(var);
    }
}

