/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.math.SloppyMath;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.TwoDimensionalCounterInterface;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.MapFactory;
import edu.stanford.nlp.util.MutableDouble;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TwoDimensionalCounter<K1, K2>
implements TwoDimensionalCounterInterface<K1, K2>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<K1, ClassicCounter<K2>> map;
    private double total;
    private MapFactory<K1, ClassicCounter<K2>> outerMF;
    private MapFactory<K2, MutableDouble> innerMF;
    private double defaultValue = 0.0;

    @Override
    public void defaultReturnValue(double rv) {
        this.defaultValue = rv;
    }

    @Override
    public double defaultReturnValue() {
        return this.defaultValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TwoDimensionalCounter)) {
            return false;
        }
        return ((Object)((TwoDimensionalCounter)o).map).equals(this.map);
    }

    public int hashCode() {
        return ((Object)this.map).hashCode() + 17;
    }

    @Override
    public ClassicCounter<K2> getCounter(K1 o) {
        ClassicCounter<K2> c = this.map.get(o);
        if (c == null) {
            c = new ClassicCounter<K2>(this.innerMF);
            c.setDefaultReturnValue(this.defaultValue);
            this.map.put(o, c);
        }
        return c;
    }

    public Set<Map.Entry<K1, ClassicCounter<K2>>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public int size() {
        int result = 0;
        for (K1 o : this.firstKeySet()) {
            ClassicCounter<K2> c = this.map.get(o);
            result += c.size();
        }
        return result;
    }

    public int sizeOuterMap() {
        return this.map.size();
    }

    @Override
    public boolean containsKey(K1 o1, K2 o2) {
        if (!this.map.containsKey(o1)) {
            return false;
        }
        ClassicCounter<K2> c = this.map.get(o1);
        return c.containsKey(o2);
    }

    @Override
    public void incrementCount(K1 o1, K2 o2) {
        this.incrementCount(o1, o2, 1.0);
    }

    @Override
    public void incrementCount(K1 o1, K2 o2, double count) {
        Counter c = this.getCounter((Object)o1);
        ((ClassicCounter)c).incrementCount(o2, count);
        this.total += count;
    }

    @Override
    public void decrementCount(K1 o1, K2 o2) {
        this.incrementCount(o1, o2, -1.0);
    }

    @Override
    public void decrementCount(K1 o1, K2 o2, double count) {
        this.incrementCount(o1, o2, -count);
    }

    @Override
    public void setCount(K1 o1, K2 o2, double count) {
        Counter c = this.getCounter((Object)o1);
        double oldCount = this.getCount(o1, o2);
        this.total -= oldCount;
        ((ClassicCounter)c).setCount(o2, count);
        this.total += count;
    }

    @Override
    public double remove(K1 o1, K2 o2) {
        Counter c = this.getCounter((Object)o1);
        double oldCount = this.getCount(o1, o2);
        this.total -= oldCount;
        ((ClassicCounter)c).remove(o2);
        if (((ClassicCounter)c).size() == 0) {
            this.map.remove(o1);
        }
        return oldCount;
    }

    @Override
    public double getCount(K1 o1, K2 o2) {
        Counter c = this.getCounter((Object)o1);
        if (((ClassicCounter)c).totalCount() == 0.0 && !((ClassicCounter)c).keySet().contains(o2)) {
            return this.defaultReturnValue();
        }
        return ((ClassicCounter)c).getCount(o2);
    }

    @Override
    public double totalCount() {
        return this.total;
    }

    @Override
    public double totalCount(K1 k1) {
        Counter c = this.getCounter((Object)k1);
        return ((ClassicCounter)c).totalCount();
    }

    @Override
    public Set<K1> firstKeySet() {
        return this.map.keySet();
    }

    public ClassicCounter<K2> setCounter(K1 o, Counter<K2> c) {
        Counter old = this.getCounter((Object)o);
        this.total -= ((ClassicCounter)old).totalCount();
        if (c instanceof ClassicCounter) {
            this.map.put(o, (ClassicCounter)c);
        } else {
            this.map.put(o, new ClassicCounter<K2>(c));
        }
        this.total += c.totalCount();
        return old;
    }

    public static <K1, K2> TwoDimensionalCounter<K2, K1> reverseIndexOrder(TwoDimensionalCounter<K1, K2> cc) {
        TwoDimensionalCounter result = new TwoDimensionalCounter(cc.outerMF, cc.innerMF);
        for (K1 key1 : cc.firstKeySet()) {
            Counter c = cc.getCounter((Object)key1);
            for (Object key2 : ((ClassicCounter)c).keySet()) {
                double count = ((ClassicCounter)c).getCount(key2);
                result.setCount(key2, key1, count);
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        for (K1 key1 : this.map.keySet()) {
            Counter c = this.getCounter((Object)key1);
            for (Object key2 : ((ClassicCounter)c).keySet()) {
                double score = ((ClassicCounter)c).getCount(key2);
                buff.append(key1).append("\t").append(key2).append("\t").append(score).append("\n");
            }
        }
        return buff.toString();
    }

    @Override
    public String toMatrixString(int cellSize) {
        ArrayList<K1> firstKeys = new ArrayList<K1>(this.firstKeySet());
        ArrayList<K2> secondKeys = new ArrayList<K2>(this.secondKeySet());
        Collections.sort(firstKeys);
        Collections.sort(secondKeys);
        double[][] counts = this.toMatrix(firstKeys, secondKeys);
        return ArrayMath.toString(counts, cellSize, firstKeys.toArray(), secondKeys.toArray(), (NumberFormat)new DecimalFormat(), true);
    }

    @Override
    public double[][] toMatrix(List<K1> firstKeys, List<K2> secondKeys) {
        double[][] counts = new double[firstKeys.size()][secondKeys.size()];
        for (int i = 0; i < firstKeys.size(); ++i) {
            for (int j = 0; j < secondKeys.size(); ++j) {
                counts[i][j] = this.getCount(firstKeys.get(i), secondKeys.get(j));
            }
        }
        return counts;
    }

    @Override
    public String toCSVString(NumberFormat nf) {
        ArrayList<K1> firstKeys = new ArrayList<K1>(this.firstKeySet());
        ArrayList<K2> secondKeys = new ArrayList<K2>(this.secondKeySet());
        Collections.sort(firstKeys);
        Collections.sort(secondKeys);
        StringBuilder b = new StringBuilder();
        String[] headerRow = new String[secondKeys.size() + 1];
        headerRow[0] = "";
        for (int j = 0; j < secondKeys.size(); ++j) {
            headerRow[j + 1] = secondKeys.get(j).toString();
        }
        b.append(StringUtils.toCSVString(headerRow)).append("\n");
        for (Object rowLabel : firstKeys) {
            String[] row = new String[secondKeys.size() + 1];
            row[0] = rowLabel.toString();
            for (int j = 0; j < secondKeys.size(); ++j) {
                Object colLabel = secondKeys.get(j);
                row[j + 1] = nf.format(this.getCount(rowLabel, colLabel));
            }
            b.append(StringUtils.toCSVString(row)).append("\n");
        }
        return b.toString();
    }

    @Override
    public Set<K2> secondKeySet() {
        Set result = Generics.newHashSet();
        for (K1 k1 : this.firstKeySet()) {
            for (Object k2 : ((ClassicCounter)this.getCounter((Object)k1)).keySet()) {
                result.add(k2);
            }
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public ClassicCounter<Pair<K1, K2>> flatten() {
        ClassicCounter<Pair<K1, K2>> result = new ClassicCounter<Pair<K1, K2>>();
        result.setDefaultReturnValue(this.defaultValue);
        for (K1 key1 : this.firstKeySet()) {
            Counter inner = this.getCounter((Object)key1);
            for (Object key2 : ((ClassicCounter)inner).keySet()) {
                result.setCount(new Pair(key1, key2), ((ClassicCounter)inner).getCount(key2));
            }
        }
        return result;
    }

    public void addAll(TwoDimensionalCounterInterface<K1, K2> c) {
        for (K1 key : c.firstKeySet()) {
            Counter<K2> inner = c.getCounter(key);
            Counter myInner = this.getCounter((Object)key);
            Counters.addInPlace(myInner, inner);
            this.total += inner.totalCount();
        }
    }

    public void addAll(K1 key, Counter<K2> c) {
        Counter myInner = this.getCounter((Object)key);
        Counters.addInPlace(myInner, c);
        this.total += c.totalCount();
    }

    public void subtractAll(K1 key, Counter<K2> c) {
        Counter myInner = this.getCounter((Object)key);
        Counters.subtractInPlace(myInner, c);
        this.total -= c.totalCount();
    }

    public void subtractAll(TwoDimensionalCounterInterface<K1, K2> c, boolean removeKeys) {
        for (K1 key : c.firstKeySet()) {
            Counter<K2> inner = c.getCounter(key);
            Counter myInner = this.getCounter((Object)key);
            Counters.subtractInPlace(myInner, inner);
            if (removeKeys) {
                Counters.retainNonZeros(myInner);
            }
            this.total -= inner.totalCount();
        }
    }

    public Counter<K1> sumInnerCounter() {
        ClassicCounter<K1> summed = new ClassicCounter<K1>();
        for (K1 key : this.firstKeySet()) {
            summed.incrementCount(key, ((ClassicCounter)this.getCounter((Object)key)).totalCount());
        }
        return summed;
    }

    public void removeZeroCounts() {
        Set<K1> firstKeySet = Generics.newHashSet(this.firstKeySet());
        for (K1 k1 : firstKeySet) {
            Counter c = this.getCounter((Object)k1);
            Counters.retainNonZeros(c);
            if (((ClassicCounter)c).size() != 0) continue;
            this.map.remove(k1);
        }
    }

    @Override
    public void remove(K1 key) {
        ClassicCounter<K2> counter = this.map.get(key);
        if (counter != null) {
            this.total -= counter.totalCount();
        }
        this.map.remove(key);
    }

    public void clean() {
        for (K1 key1 : Generics.newHashSet(this.map.keySet())) {
            ClassicCounter<K2> c = this.map.get(key1);
            for (K2 key2 : Generics.newHashSet(c.keySet())) {
                if (!SloppyMath.isCloseTo(0.0, c.getCount(key2))) continue;
                c.remove(key2);
            }
            if (!c.keySet().isEmpty()) continue;
            this.map.remove(key1);
        }
    }

    public MapFactory<K1, ClassicCounter<K2>> getOuterMapFactory() {
        return this.outerMF;
    }

    public MapFactory<K2, MutableDouble> getInnerMapFactory() {
        return this.innerMF;
    }

    public TwoDimensionalCounter() {
        this(MapFactory.hashMapFactory(), MapFactory.hashMapFactory());
    }

    public TwoDimensionalCounter(MapFactory<K1, ClassicCounter<K2>> outerFactory, MapFactory<K2, MutableDouble> innerFactory) {
        this.innerMF = innerFactory;
        this.outerMF = outerFactory;
        this.map = outerFactory.newMap();
        this.total = 0.0;
    }

    public void recomputeTotal() {
        this.total = 0.0;
        for (Map.Entry<K1, ClassicCounter<K2>> c : this.map.entrySet()) {
            this.total += c.getValue().totalCount();
        }
    }

    public static void main(String[] args) {
        TwoDimensionalCounter<String, String> cc = new TwoDimensionalCounter<String, String>();
        cc.setCount("a", "c", 1.0);
        cc.setCount("b", "c", 1.0);
        cc.setCount("a", "d", 1.0);
        cc.setCount("a", "d", -1.0);
        cc.setCount("b", "d", 1.0);
        System.out.println(cc);
        cc.incrementCount("b", "d", 1.0);
        System.out.println(cc);
        TwoDimensionalCounter cc2 = TwoDimensionalCounter.reverseIndexOrder(cc);
        System.out.println(cc2);
    }
}

