/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import java.util.HashMap;
import java.util.Map;

public class LeastRecentlyUsedCache<K, V> {
    private Map<K, Node<K, V>> map = new HashMap<K, Node<K, V>>();
    private LinkedList<K, V> list = new LinkedList();
    private final int maxSize;

    public LeastRecentlyUsedCache(int maxSize) {
        this.maxSize = maxSize;
    }

    public V getOrDefault(K key, V defaultValue) {
        Node node = this.map.getOrDefault(key, null);
        if (node == null) {
            return defaultValue;
        }
        this.list.remove(node);
        this.list.push(node);
        return node.value;
    }

    public void add(K key, V value) {
        Node<K, V> node = this.map.getOrDefault(key, null);
        if (node != null) {
            this.list.remove(node);
        }
        node = this.list.push(key, value);
        this.map.put(key, node);
        if (this.list.size > this.maxSize) {
            node = this.list.pop();
            this.map.remove(node.key);
        }
    }

    public int size() {
        return this.list.size;
    }

    private static class LinkedList<K, V> {
        final Node<K, V> BEGIN = new Node<Object, Object>(null, null);
        final Node<K, V> END = new Node<Object, Object>(null, null);
        int size = 0;

        LinkedList() {
            this.BEGIN.next = this.END;
            this.END.prev = this.BEGIN;
        }

        void remove(Node<K, V> node) {
            Node prev;
            Node next = node.next;
            next.prev = prev = node.prev;
            prev.next = next;
            --this.size;
        }

        Node<K, V> pop() {
            if (this.size == 0) {
                throw new IndexOutOfBoundsException();
            }
            Node node = this.BEGIN.next;
            this.remove(this.BEGIN.next);
            return node;
        }

        Node<K, V> push(Node<K, V> node) {
            Node prev = this.END.prev;
            node.next = this.END;
            node.prev = prev;
            prev.next = node;
            this.END.prev = node;
            ++this.size;
            return node;
        }

        Node<K, V> push(K key, V value) {
            Node<K, V> node = new Node<K, V>(key, value);
            return this.push(node);
        }
    }

    private static class Node<K, V> {
        Node<K, V> next;
        Node<K, V> prev;
        K key;
        V value;

        Node(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

