/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.french.pipeline;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeReader;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.international.french.FrenchTreeReaderFactory;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.TregexParseException;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.Tsurgeon;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class FTBCorrector
implements TreeTransformer {
    private static Redwood.RedwoodChannels log = Redwood.channels(FTBCorrector.class);
    private static final boolean DEBUG = false;
    private final List<Pair<TregexPattern, TsurgeonPattern>> ops = this.loadOps();
    private static final String editStr = "@PUNC=punc <: __ >, @SENT\ndelete punc\n\n@PUNC=punc <: __ >>- @SENT $, @PUNC\ndelete punc\n\n@PUNC=punc <: __ >>- @SENT $, @PUNC\ndelete punc\n\n@PUNC <: /^[^!\\.\\?]$/=term >>- @SENT !$, @PUNC\nrelabel term /./\n\n@PUNC=punc <: (/^[!\\.\\?]$/ . __)\ndelete punc\n\n@PUNC=punc <: /^[\\.!\\?]$/ >>- (@SENT <- __=sfpos) !> @SENT\nmove punc $- sfpos\n\n!@PUNC <: /^[^\\.!\\?]$/ >>- (@SENT <- __=loc)\ninsert (PUNC .) $- loc\n\n@PUNC <: /^[\\.!\\?]+$/=punc . (@PUNC <: /[\\.!\\?]/)\nprune punc\n\n@NP=bad > @MWADV\nexcise bad bad\n\nX=bad < demi\nrelabel bad A\n\nPC=pc < D'|depuis|apr\u00e8s\nrelabel pc P\n\n";

    private List<Pair<TregexPattern, TsurgeonPattern>> loadOps() {
        ArrayList<Pair<TregexPattern, TsurgeonPattern>> ops = new ArrayList<Pair<TregexPattern, TsurgeonPattern>>();
        String line = null;
        try {
            BufferedReader br = new BufferedReader(new StringReader(editStr));
            ArrayList<TsurgeonPattern> tsp = new ArrayList<TsurgeonPattern>();
            while ((line = br.readLine()) != null) {
                TregexPattern matchPattern = TregexPattern.compile(line);
                tsp.clear();
                while (FTBCorrector.continuing(line = br.readLine())) {
                    TsurgeonPattern p = Tsurgeon.parseOperation(line);
                    tsp.add(p);
                }
                if (tsp.isEmpty()) continue;
                TsurgeonPattern tp = Tsurgeon.collectOperations(tsp);
                ops.add(new Pair<TregexPattern, TsurgeonPattern>(matchPattern, tp));
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return ops;
    }

    private static boolean continuing(String str) {
        return str != null && !str.matches("\\s*");
    }

    @Override
    public Tree transformTree(Tree t) {
        return Tsurgeon.processPatternsOnTree(this.ops, t);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            log.info("Usage: java " + FTBCorrector.class.getName() + " filename\n");
            System.exit(-1);
        }
        FTBCorrector tt = new FTBCorrector();
        File f = new File(args[0]);
        try {
            Tree t;
            TregexPattern pBadTree = TregexPattern.compile("@SENT <: @PUNC");
            TregexPattern pBadTree2 = TregexPattern.compile("@SENT <1 @PUNC <2 @PUNC !<3 __");
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
            FrenchTreeReaderFactory trf = new FrenchTreeReaderFactory();
            TreeReader tr = trf.newTreeReader(br);
            int nTrees = 0;
            while ((t = tr.readTree()) != null) {
                TregexMatcher m = pBadTree.matcher(t);
                TregexMatcher m2 = pBadTree2.matcher(t);
                if (m.find() || m2.find()) {
                    log.info("Discarding tree: " + t.toString());
                } else {
                    Tree fixedT = tt.transformTree(t);
                    System.out.println(fixedT.toString());
                }
                ++nTrees;
            }
            tr.close();
            System.err.printf("Wrote %d trees%n", nTrees);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TregexParseException e) {
            e.printStackTrace();
        }
    }
}

