/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.nndep;

import edu.stanford.nlp.international.Language;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.parser.nndep.ArcStandard;
import edu.stanford.nlp.parser.nndep.Classifier;
import edu.stanford.nlp.parser.nndep.Config;
import edu.stanford.nlp.parser.nndep.Configuration;
import edu.stanford.nlp.parser.nndep.Dataset;
import edu.stanford.nlp.parser.nndep.DependencyTree;
import edu.stanford.nlp.parser.nndep.ParsingSystem;
import edu.stanford.nlp.parser.nndep.Util;
import edu.stanford.nlp.process.DocumentPreprocessor;
import edu.stanford.nlp.process.WhitespaceTokenizer;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.IntCounter;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.trees.EnglishGrammaticalRelations;
import edu.stanford.nlp.trees.EnglishGrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.TreeGraphNode;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.trees.UniversalEnglishGrammaticalRelations;
import edu.stanford.nlp.trees.UniversalEnglishGrammaticalStructure;
import edu.stanford.nlp.trees.international.pennchinese.ChineseGrammaticalRelations;
import edu.stanford.nlp.trees.international.pennchinese.ChineseGrammaticalStructure;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.ReflectionLoading;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class DependencyParser {
    private static final Redwood.RedwoodChannels log = Redwood.channels(DependencyParser.class);
    public static final String DEFAULT_MODEL = "edu/stanford/nlp/models/parser/nndep/english_UD.gz";
    private List<String> knownWords;
    private List<String> knownPos;
    private List<String> knownLabels;
    private Map<String, Integer> wordIDs;
    private Map<String, Integer> posIDs;
    private Map<String, Integer> labelIDs;
    private List<Integer> preComputed;
    private Classifier classifier;
    private ParsingSystem system;
    private final Config config;
    private final Language language;
    private static final int POS_OFFSET = 18;
    private static final int DEP_OFFSET = 36;
    private static final int STACK_OFFSET = 6;
    private static final int STACK_NUMBER = 6;
    private static final Map<String, Integer> numArgs = new HashMap<String, Integer>();

    public Set<String> getPosSet() {
        Set<String> foo = Generics.newHashSet(this.knownPos);
        foo.remove("-NULL-");
        foo.remove("-UNKNOWN-");
        foo.remove("-ROOT-");
        foo.add(".$$.");
        return Collections.unmodifiableSet(foo);
    }

    DependencyParser() {
        this(new Properties());
    }

    public DependencyParser(Properties properties) {
        this.config = new Config(properties);
        this.language = this.config.language;
    }

    public int getWordID(String s) {
        return this.wordIDs.containsKey(s) ? this.wordIDs.get(s).intValue() : this.wordIDs.get("-UNKNOWN-").intValue();
    }

    public int getPosID(String s) {
        return this.posIDs.containsKey(s) ? this.posIDs.get(s).intValue() : this.posIDs.get("-UNKNOWN-").intValue();
    }

    public int getLabelID(String s) {
        return this.labelIDs.get(s);
    }

    public List<Integer> getFeatures(Configuration c) {
        int index;
        int j;
        ArrayList<Integer> fWord = new ArrayList<Integer>(18);
        ArrayList<Integer> fPos = new ArrayList<Integer>(18);
        ArrayList<Integer> fLabel = new ArrayList<Integer>(12);
        for (j = 2; j >= 0; --j) {
            index = c.getStack(j);
            fWord.add(this.getWordID(c.getWord(index)));
            fPos.add(this.getPosID(c.getPOS(index)));
        }
        for (j = 0; j <= 2; ++j) {
            index = c.getBuffer(j);
            fWord.add(this.getWordID(c.getWord(index)));
            fPos.add(this.getPosID(c.getPOS(index)));
        }
        for (j = 0; j <= 1; ++j) {
            int k = c.getStack(j);
            int index2 = c.getLeftChild(k);
            fWord.add(this.getWordID(c.getWord(index2)));
            fPos.add(this.getPosID(c.getPOS(index2)));
            fLabel.add(this.getLabelID(c.getLabel(index2)));
            index2 = c.getRightChild(k);
            fWord.add(this.getWordID(c.getWord(index2)));
            fPos.add(this.getPosID(c.getPOS(index2)));
            fLabel.add(this.getLabelID(c.getLabel(index2)));
            index2 = c.getLeftChild(k, 2);
            fWord.add(this.getWordID(c.getWord(index2)));
            fPos.add(this.getPosID(c.getPOS(index2)));
            fLabel.add(this.getLabelID(c.getLabel(index2)));
            index2 = c.getRightChild(k, 2);
            fWord.add(this.getWordID(c.getWord(index2)));
            fPos.add(this.getPosID(c.getPOS(index2)));
            fLabel.add(this.getLabelID(c.getLabel(index2)));
            index2 = c.getLeftChild(c.getLeftChild(k));
            fWord.add(this.getWordID(c.getWord(index2)));
            fPos.add(this.getPosID(c.getPOS(index2)));
            fLabel.add(this.getLabelID(c.getLabel(index2)));
            index2 = c.getRightChild(c.getRightChild(k));
            fWord.add(this.getWordID(c.getWord(index2)));
            fPos.add(this.getPosID(c.getPOS(index2)));
            fLabel.add(this.getLabelID(c.getLabel(index2)));
        }
        ArrayList<Integer> feature = new ArrayList<Integer>(48);
        feature.addAll(fWord);
        feature.addAll(fPos);
        feature.addAll(fLabel);
        return feature;
    }

    private int[] getFeatureArray(Configuration c) {
        int index;
        int j;
        int[] feature = new int[48];
        for (j = 2; j >= 0; --j) {
            index = c.getStack(j);
            feature[2 - j] = this.getWordID(c.getWord(index));
            feature[18 + (2 - j)] = this.getPosID(c.getPOS(index));
        }
        for (j = 0; j <= 2; ++j) {
            index = c.getBuffer(j);
            feature[3 + j] = this.getWordID(c.getWord(index));
            feature[21 + j] = this.getPosID(c.getPOS(index));
        }
        for (j = 0; j <= 1; ++j) {
            int k = c.getStack(j);
            int index2 = c.getLeftChild(k);
            feature[6 + j * 6] = this.getWordID(c.getWord(index2));
            feature[24 + j * 6] = this.getPosID(c.getPOS(index2));
            feature[36 + j * 6] = this.getLabelID(c.getLabel(index2));
            index2 = c.getRightChild(k);
            feature[6 + j * 6 + 1] = this.getWordID(c.getWord(index2));
            feature[24 + j * 6 + 1] = this.getPosID(c.getPOS(index2));
            feature[36 + j * 6 + 1] = this.getLabelID(c.getLabel(index2));
            index2 = c.getLeftChild(k, 2);
            feature[6 + j * 6 + 2] = this.getWordID(c.getWord(index2));
            feature[24 + j * 6 + 2] = this.getPosID(c.getPOS(index2));
            feature[36 + j * 6 + 2] = this.getLabelID(c.getLabel(index2));
            index2 = c.getRightChild(k, 2);
            feature[6 + j * 6 + 3] = this.getWordID(c.getWord(index2));
            feature[24 + j * 6 + 3] = this.getPosID(c.getPOS(index2));
            feature[36 + j * 6 + 3] = this.getLabelID(c.getLabel(index2));
            index2 = c.getLeftChild(c.getLeftChild(k));
            feature[6 + j * 6 + 4] = this.getWordID(c.getWord(index2));
            feature[24 + j * 6 + 4] = this.getPosID(c.getPOS(index2));
            feature[36 + j * 6 + 4] = this.getLabelID(c.getLabel(index2));
            index2 = c.getRightChild(c.getRightChild(k));
            feature[6 + j * 6 + 5] = this.getWordID(c.getWord(index2));
            feature[24 + j * 6 + 5] = this.getPosID(c.getPOS(index2));
            feature[36 + j * 6 + 5] = this.getLabelID(c.getLabel(index2));
        }
        return feature;
    }

    public Dataset genTrainExamples(List<CoreMap> sents, List<DependencyTree> trees) {
        int numTrans = this.system.numTransitions();
        Dataset ret = new Dataset(48, numTrans);
        IntCounter<Integer> tokPosCount = new IntCounter<Integer>();
        log.info("###################");
        log.info("Generate training examples...");
        for (int i = 0; i < sents.size(); ++i) {
            if (i > 0) {
                if (i % 1000 == 0) {
                    log.info(i + " ");
                }
                if (i % 10000 == 0 || i == sents.size() - 1) {
                    log.info(new Object[0]);
                }
            }
            if (!trees.get(i).isProjective()) continue;
            Configuration c = this.system.initialConfiguration(sents.get(i));
            while (!this.system.isTerminal(c)) {
                int j;
                String oracle = this.system.getOracle(c, trees.get(i));
                List<Integer> feature = this.getFeatures(c);
                ArrayList<Integer> label = new ArrayList<Integer>();
                for (j = 0; j < numTrans; ++j) {
                    String str = this.system.transitions.get(j);
                    if (str.equals(oracle)) {
                        label.add(1);
                        continue;
                    }
                    if (this.system.canApply(c, str)) {
                        label.add(0);
                        continue;
                    }
                    label.add(-1);
                }
                ret.addExample(feature, label);
                for (j = 0; j < feature.size(); ++j) {
                    tokPosCount.incrementCount(feature.get(j) * feature.size() + j);
                }
                this.system.apply(c, oracle);
            }
        }
        log.info("#Train Examples: " + ret.n);
        List sortedTokens = Counters.toSortedList(tokPosCount, false);
        this.preComputed = new ArrayList<Integer>(sortedTokens.subList(0, Math.min(this.config.numPreComputed, sortedTokens.size())));
        return ret;
    }

    private void generateIDs() {
        this.wordIDs = new HashMap<String, Integer>();
        this.posIDs = new HashMap<String, Integer>();
        this.labelIDs = new HashMap<String, Integer>();
        int index = 0;
        for (String word : this.knownWords) {
            this.wordIDs.put(word, index++);
        }
        for (String pos : this.knownPos) {
            this.posIDs.put(pos, index++);
        }
        for (String label : this.knownLabels) {
            this.labelIDs.put(label, index++);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void genDictionaries(List<CoreMap> sents, List<DependencyTree> trees) {
        void var7_10;
        ArrayList<String> word = new ArrayList<String>();
        ArrayList<String> pos = new ArrayList<String>();
        ArrayList<String> label = new ArrayList<String>();
        for (CoreMap coreMap : sents) {
            List tokens = (List)coreMap.get(CoreAnnotations.TokensAnnotation.class);
            for (CoreLabel token : tokens) {
                word.add(token.word());
                pos.add(token.tag());
            }
        }
        String rootLabel = null;
        for (DependencyTree tree : trees) {
            for (int k = 1; k <= tree.n; ++k) {
                if (tree.getHead(k) == 0) {
                    rootLabel = tree.getLabel(k);
                    continue;
                }
                label.add(tree.getLabel(k));
            }
        }
        this.knownWords = Util.generateDict(word, this.config.wordCutOff);
        this.knownPos = Util.generateDict(pos);
        this.knownLabels = Util.generateDict(label);
        this.knownLabels.add(0, rootLabel);
        boolean bl = true;
        while (var7_10 < this.knownLabels.size()) {
            if (this.knownLabels.get((int)var7_10).equals(rootLabel)) {
                this.knownLabels.remove((int)var7_10);
                break;
            }
            ++var7_10;
        }
        this.knownWords.add(0, "-UNKNOWN-");
        this.knownWords.add(1, "-NULL-");
        this.knownWords.add(2, "-ROOT-");
        this.knownPos.add(0, "-UNKNOWN-");
        this.knownPos.add(1, "-NULL-");
        this.knownPos.add(2, "-ROOT-");
        this.knownLabels.add(0, "-NULL-");
        this.generateIDs();
        log.info("###################");
        log.info("#Word: " + this.knownWords.size());
        log.info("#POS:" + this.knownPos.size());
        log.info("#Label: " + this.knownLabels.size());
    }

    public void writeModelFile(String modelFile) {
        try {
            int i;
            int j;
            double[][] W1 = this.classifier.getW1();
            double[] b1 = this.classifier.getb1();
            double[][] W2 = this.classifier.getW2();
            double[][] E = this.classifier.getE();
            PrintWriter output = IOUtils.getPrintWriter(modelFile);
            ((Writer)output).write("language=" + (Object)((Object)this.language) + "\n");
            ((Writer)output).write("tlp=" + this.config.tlp.getClass().getCanonicalName() + "\n");
            ((Writer)output).write("dict=" + this.knownWords.size() + "\n");
            ((Writer)output).write("pos=" + this.knownPos.size() + "\n");
            ((Writer)output).write("label=" + this.knownLabels.size() + "\n");
            ((Writer)output).write("embeddingSize=" + E[0].length + "\n");
            ((Writer)output).write("hiddenSize=" + b1.length + "\n");
            ((Writer)output).write("numTokens=" + W1[0].length / E[0].length + "\n");
            ((Writer)output).write("preComputed=" + this.preComputed.size() + "\n");
            int index = 0;
            for (String word : this.knownWords) {
                index = DependencyParser.writeEmbedding(E[index], output, index, word);
            }
            for (String pos : this.knownPos) {
                index = DependencyParser.writeEmbedding(E[index], output, index, pos);
            }
            for (String label : this.knownLabels) {
                index = DependencyParser.writeEmbedding(E[index], output, index, label);
            }
            for (j = 0; j < W1[0].length; ++j) {
                for (int i2 = 0; i2 < W1.length; ++i2) {
                    ((Writer)output).write(String.valueOf(W1[i2][j]));
                    if (i2 == W1.length - 1) {
                        ((Writer)output).write("\n");
                        continue;
                    }
                    ((Writer)output).write(" ");
                }
            }
            for (i = 0; i < b1.length; ++i) {
                ((Writer)output).write(String.valueOf(b1[i]));
                if (i == b1.length - 1) {
                    ((Writer)output).write("\n");
                    continue;
                }
                ((Writer)output).write(" ");
            }
            for (j = 0; j < W2[0].length; ++j) {
                for (int i3 = 0; i3 < W2.length; ++i3) {
                    ((Writer)output).write(String.valueOf(W2[i3][j]));
                    if (i3 == W2.length - 1) {
                        ((Writer)output).write("\n");
                        continue;
                    }
                    ((Writer)output).write(" ");
                }
            }
            for (i = 0; i < this.preComputed.size(); ++i) {
                ((Writer)output).write(String.valueOf(this.preComputed.get(i)));
                if ((i + 1) % 100 == 0 || i == this.preComputed.size() - 1) {
                    ((Writer)output).write("\n");
                    continue;
                }
                ((Writer)output).write(" ");
            }
            ((Writer)output).close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private static int writeEmbedding(double[] doubles, Writer output, int index, String word) throws IOException {
        output.write(word);
        for (double aDouble : doubles) {
            output.write(" " + aDouble);
        }
        output.write("\n");
        return ++index;
    }

    public static DependencyParser loadFromModelFile(String modelFile) {
        return DependencyParser.loadFromModelFile(modelFile, null);
    }

    public static DependencyParser loadFromModelFile(String modelFile, Properties extraProperties) {
        DependencyParser parser = extraProperties == null ? new DependencyParser() : new DependencyParser(extraProperties);
        parser.loadModelFile(modelFile, false);
        return parser;
    }

    public void loadModelFile(String modelFile) {
        this.loadModelFile(modelFile, true);
    }

    private static boolean isModelNewFormat(String firstLine) {
        return firstLine.startsWith("language=");
    }

    void loadModelFile(String modelFile, boolean verbose) {
        Timing t = new Timing();
        try (BufferedReader input = IOUtils.readerFromString(modelFile);){
            int i;
            int i2;
            String[] splits;
            int k;
            log.info("Loading depparse model: " + modelFile + " ... ");
            String s = input.readLine();
            if (DependencyParser.isModelNewFormat(s)) {
                this.config.language = Config.getLanguage(s.substring(9, s.length() - 1));
                s = input.readLine();
                String tlpCanonicalName = s.substring(4, s.length());
                try {
                    this.config.tlp = (TreebankLanguagePack)ReflectionLoading.loadByReflection(tlpCanonicalName, new Object[0]);
                    log.info("Loaded TreebankLanguagePack: " + tlpCanonicalName);
                }
                catch (Exception e) {
                    log.warn("Error: Failed to load TreebankLanguagePack: " + tlpCanonicalName);
                }
                s = input.readLine();
            }
            int nDict = Integer.parseInt(s.substring(s.indexOf(61) + 1));
            s = input.readLine();
            int nPOS = Integer.parseInt(s.substring(s.indexOf(61) + 1));
            s = input.readLine();
            int nLabel = Integer.parseInt(s.substring(s.indexOf(61) + 1));
            s = input.readLine();
            int eSize = Integer.parseInt(s.substring(s.indexOf(61) + 1));
            s = input.readLine();
            int hSize = Integer.parseInt(s.substring(s.indexOf(61) + 1));
            s = input.readLine();
            int nTokens = Integer.parseInt(s.substring(s.indexOf(61) + 1));
            s = input.readLine();
            int nPreComputed = Integer.parseInt(s.substring(s.indexOf(61) + 1));
            this.knownWords = new ArrayList<String>();
            this.knownPos = new ArrayList<String>();
            this.knownLabels = new ArrayList<String>();
            double[][] E = new double[nDict + nPOS + nLabel][eSize];
            int index = 0;
            for (k = 0; k < nDict; ++k) {
                s = input.readLine();
                splits = s.split(" ");
                this.knownWords.add(splits[0]);
                for (i2 = 0; i2 < eSize; ++i2) {
                    E[index][i2] = Double.parseDouble(splits[i2 + 1]);
                }
                ++index;
            }
            for (k = 0; k < nPOS; ++k) {
                s = input.readLine();
                splits = s.split(" ");
                this.knownPos.add(splits[0]);
                for (i2 = 0; i2 < eSize; ++i2) {
                    E[index][i2] = Double.parseDouble(splits[i2 + 1]);
                }
                ++index;
            }
            for (k = 0; k < nLabel; ++k) {
                s = input.readLine();
                splits = s.split(" ");
                this.knownLabels.add(splits[0]);
                for (i2 = 0; i2 < eSize; ++i2) {
                    E[index][i2] = Double.parseDouble(splits[i2 + 1]);
                }
                ++index;
            }
            this.generateIDs();
            double[][] W1 = new double[hSize][eSize * nTokens];
            for (int j = 0; j < W1[0].length; ++j) {
                s = input.readLine();
                splits = s.split(" ");
                for (i = 0; i < W1.length; ++i) {
                    W1[i][j] = Double.parseDouble(splits[i]);
                }
            }
            double[] b1 = new double[hSize];
            s = input.readLine();
            splits = s.split(" ");
            for (i = 0; i < b1.length; ++i) {
                b1[i] = Double.parseDouble(splits[i]);
            }
            double[][] W2 = new double[nLabel * 2 - 1][hSize];
            for (int j = 0; j < W2[0].length; ++j) {
                s = input.readLine();
                splits = s.split(" ");
                for (int i3 = 0; i3 < W2.length; ++i3) {
                    W2[i3][j] = Double.parseDouble(splits[i3]);
                }
            }
            this.preComputed = new ArrayList<Integer>();
            while (this.preComputed.size() < nPreComputed) {
                s = input.readLine();
                for (String split : splits = s.split(" ")) {
                    this.preComputed.add(Integer.parseInt(split));
                }
            }
            this.config.hiddenSize = hSize;
            this.config.embeddingSize = eSize;
            this.classifier = new Classifier(this.config, E, W1, b1, W2, this.preComputed);
            t.report(log, "Done reading from disk");
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        this.initialize(verbose);
        t.done(log, "Initializing dependency parser");
    }

    private double[][] readEmbedFile(String embedFile, Map<String, Integer> embedID) {
        double[][] embeddings = null;
        if (embedFile != null) {
            try (BufferedReader input = IOUtils.readerFromString(embedFile);){
                String s;
                ArrayList<String> lines = new ArrayList<String>();
                while ((s = input.readLine()) != null) {
                    lines.add(s);
                }
                int nWords = lines.size();
                String[] splits = ((String)lines.get(0)).split("\\s+");
                int dim = splits.length - 1;
                embeddings = new double[nWords][dim];
                log.info("Embedding File " + embedFile + ": #Words = " + nWords + ", dim = " + dim);
                if (dim != this.config.embeddingSize) {
                    throw new IllegalArgumentException("The dimension of embedding file does not match config.embeddingSize");
                }
                for (int i = 0; i < lines.size(); ++i) {
                    splits = ((String)lines.get(i)).split("\\s+");
                    embedID.put(splits[0], i);
                    for (int j = 0; j < dim; ++j) {
                        embeddings[i][j] = Double.parseDouble(splits[j + 1]);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            embeddings = Util.scaling(embeddings, 0.0, 1.0);
        }
        return embeddings;
    }

    public void train(String trainFile, String devFile, String modelFile, String embedFile, String preModel) {
        log.info("Train File: " + trainFile);
        log.info("Dev File: " + devFile);
        log.info("Model File: " + modelFile);
        log.info("Embedding File: " + embedFile);
        log.info("Pre-trained Model File: " + preModel);
        ArrayList<CoreMap> trainSents = new ArrayList<CoreMap>();
        ArrayList<DependencyTree> trainTrees = new ArrayList<DependencyTree>();
        Util.loadConllFile(trainFile, trainSents, trainTrees, this.config.unlabeled, this.config.cPOS);
        Util.printTreeStats("Train", trainTrees);
        ArrayList<CoreMap> devSents = new ArrayList<CoreMap>();
        ArrayList<DependencyTree> devTrees = new ArrayList<DependencyTree>();
        if (devFile != null) {
            Util.loadConllFile(devFile, devSents, devTrees, this.config.unlabeled, this.config.cPOS);
            Util.printTreeStats("Dev", devTrees);
        }
        this.genDictionaries(trainSents, trainTrees);
        ArrayList<String> lDict = new ArrayList<String>(this.knownLabels);
        lDict.remove(0);
        this.system = new ArcStandard(this.config.tlp, lDict, true);
        this.setupClassifierForTraining(trainSents, trainTrees, embedFile, preModel);
        log.info("###################");
        this.config.printParameters();
        long startTime = System.currentTimeMillis();
        double bestUAS = 0.0;
        for (int iter = 0; iter < this.config.maxIter; ++iter) {
            log.info("##### Iteration " + iter);
            Classifier.Cost cost = this.classifier.computeCostFunction(this.config.batchSize, this.config.regParameter, this.config.dropProb);
            log.info("Cost = " + cost.getCost() + ", Correct(%) = " + cost.getPercentCorrect());
            this.classifier.takeAdaGradientStep(cost, this.config.adaAlpha, this.config.adaEps);
            log.info("Elapsed Time: " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " (s)");
            if (devFile != null && iter % this.config.evalPerIter == 0) {
                this.classifier.preCompute();
                List<DependencyTree> predicted = devSents.stream().map(this::predictInner).collect(Collectors.toList());
                double uas = this.config.noPunc ? this.system.getUASnoPunc(devSents, predicted, devTrees) : this.system.getUAS(devSents, predicted, devTrees);
                log.info("UAS: " + uas);
                if (this.config.saveIntermediate && uas > bestUAS) {
                    log.info("Exceeds best previous UAS of %f. Saving model file.%n", bestUAS);
                    bestUAS = uas;
                    this.writeModelFile(modelFile);
                }
            }
            if (this.config.clearGradientsPerIter <= 0 || iter % this.config.clearGradientsPerIter != 0) continue;
            log.info("Clearing gradient histories..");
            this.classifier.clearGradientHistories();
        }
        this.classifier.finalizeTraining();
        if (devFile != null) {
            double uas;
            List<DependencyTree> predicted = devSents.stream().map(this::predictInner).collect(Collectors.toList());
            double d = uas = this.config.noPunc ? this.system.getUASnoPunc(devSents, predicted, devTrees) : this.system.getUAS(devSents, predicted, devTrees);
            if (uas > bestUAS) {
                log.info(String.format("Final model UAS: %f%n", uas));
                log.info(String.format("Exceeds best previous UAS of %f. Saving model file..%n", bestUAS));
                this.writeModelFile(modelFile);
            }
        } else {
            this.writeModelFile(modelFile);
        }
    }

    public void train(String trainFile, String devFile, String modelFile, String embedFile) {
        this.train(trainFile, devFile, modelFile, embedFile, null);
    }

    public void train(String trainFile, String devFile, String modelFile) {
        this.train(trainFile, devFile, modelFile, null);
    }

    public void train(String trainFile, String modelFile) {
        this.train(trainFile, null, modelFile);
    }

    /*
     * Unable to fully structure code
     */
    private void setupClassifierForTraining(List<CoreMap> trainSents, List<DependencyTree> trainTrees, String embedFile, String preModel) {
        block42: {
            E = new double[this.knownWords.size() + this.knownPos.size() + this.knownLabels.size()][this.config.embeddingSize];
            W1 = new double[this.config.hiddenSize][this.config.embeddingSize * 48];
            b1 = new double[this.config.hiddenSize];
            W2 = new double[this.system.numTransitions()][this.config.hiddenSize];
            random = Util.getRandom();
            for (i = 0; i < W1.length; ++i) {
                for (j = 0; j < W1[i].length; ++j) {
                    W1[i][j] = random.nextDouble() * 2.0 * this.config.initRange - this.config.initRange;
                }
            }
            for (i = 0; i < b1.length; ++i) {
                b1[i] = random.nextDouble() * 2.0 * this.config.initRange - this.config.initRange;
            }
            for (i = 0; i < W2.length; ++i) {
                for (j = 0; j < W2[i].length; ++j) {
                    W2[i][j] = random.nextDouble() * 2.0 * this.config.initRange - this.config.initRange;
                }
            }
            embedID = new HashMap<String, Integer>();
            embeddings = this.readEmbedFile(embedFile, embedID);
            foundEmbed = 0;
            for (i = 0; i < E.length; ++i) {
                index = -1;
                if (i < this.knownWords.size()) {
                    str = this.knownWords.get(i);
                    if (embedID.containsKey(str)) {
                        index = (Integer)embedID.get(str);
                    } else if (embedID.containsKey(str.toLowerCase())) {
                        index = (Integer)embedID.get(str.toLowerCase());
                    }
                }
                if (index >= 0) {
                    ++foundEmbed;
                    System.arraycopy(embeddings[index], 0, E[i], 0, E[i].length);
                    continue;
                }
                for (j = 0; j < E[i].length; ++j) {
                    E[i][j] = random.nextDouble() * 0.02 - 0.01;
                }
            }
            DependencyParser.log.info(new Object[]{"Found embeddings: " + foundEmbed + " / " + this.knownWords.size()});
            if (preModel == null) break block42;
            try {
                input = IOUtils.readerFromString(preModel);
                var14_20 = null;
                try {
                    DependencyParser.log.info(new Object[]{"Loading pre-trained model file: " + preModel + " ... "});
                    s = input.readLine();
                    nDict = Integer.parseInt(s.substring(s.indexOf(61) + 1));
                    s = input.readLine();
                    nPOS = Integer.parseInt(s.substring(s.indexOf(61) + 1));
                    s = input.readLine();
                    nLabel = Integer.parseInt(s.substring(s.indexOf(61) + 1));
                    s = input.readLine();
                    eSize = Integer.parseInt(s.substring(s.indexOf(61) + 1));
                    s = input.readLine();
                    hSize = Integer.parseInt(s.substring(s.indexOf(61) + 1));
                    s = input.readLine();
                    nTokens = Integer.parseInt(s.substring(s.indexOf(61) + 1));
                    s = input.readLine();
                    for (k = 0; k < nDict; ++k) {
                        s = input.readLine();
                        splits = s.split(" ");
                        if (!this.wordIDs.containsKey(splits[0]) || eSize != this.config.embeddingSize) continue;
                        index = this.getWordID(splits[0]);
                        for (i = 0; i < eSize; ++i) {
                            E[index][i] = Double.parseDouble(splits[i + 1]);
                        }
                    }
                    for (k = 0; k < nPOS; ++k) {
                        s = input.readLine();
                        splits = s.split(" ");
                        if (!this.posIDs.containsKey(splits[0]) || eSize != this.config.embeddingSize) continue;
                        index = this.getPosID(splits[0]);
                        for (i = 0; i < eSize; ++i) {
                            E[index][i] = Double.parseDouble(splits[i + 1]);
                        }
                    }
                    for (k = 0; k < nLabel; ++k) {
                        s = input.readLine();
                        splits = s.split(" ");
                        if (!this.labelIDs.containsKey(splits[0]) || eSize != this.config.embeddingSize) continue;
                        index = this.getLabelID(splits[0]);
                        for (i = 0; i < eSize; ++i) {
                            E[index][i] = Double.parseDouble(splits[i + 1]);
                        }
                    }
                    if (hSize != this.config.hiddenSize || this.config.embeddingSize != eSize) ** GOTO lbl-1000
                    if (48 == nTokens) {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = copyLayer1 = false;
                    }
                    if (copyLayer1) {
                        DependencyParser.log.info(new Object[]{"Copying parameters W1 && b1..."});
                    }
                    for (j = 0; j < eSize * nTokens; ++j) {
                        s = input.readLine();
                        if (!copyLayer1) continue;
                        splits = s.split(" ");
                        for (i = 0; i < hSize; ++i) {
                            W1[i][j] = Double.parseDouble(splits[i]);
                        }
                    }
                    s = input.readLine();
                    if (copyLayer1) {
                        splits = s.split(" ");
                        for (i = 0; i < hSize; ++i) {
                            b1[i] = Double.parseDouble(splits[i]);
                        }
                    }
                    v1 = copyLayer2 = nLabel * 2 - 1 == this.system.numTransitions() && hSize == this.config.hiddenSize;
                    if (copyLayer2) {
                        DependencyParser.log.info(new Object[]{"Copying parameters W2..."});
                    }
                    for (j = 0; j < hSize; ++j) {
                        s = input.readLine();
                        if (!copyLayer2) continue;
                        splits = s.split(" ");
                        for (i = 0; i < nLabel * 2 - 1; ++i) {
                            W2[i][j] = Double.parseDouble(splits[i]);
                        }
                    }
                }
                catch (Throwable var15_24) {
                    var14_20 = var15_24;
                    throw var15_24;
                }
                finally {
                    if (input != null) {
                        if (var14_20 != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable var15_23) {
                                var14_20.addSuppressed(var15_23);
                            }
                        } else {
                            input.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
        trainSet = this.genTrainExamples(trainSents, trainTrees);
        this.classifier = new Classifier(this.config, trainSet, E, W1, b1, W2, this.preComputed);
    }

    private DependencyTree predictInner(CoreMap sentence) {
        int numTrans = this.system.numTransitions();
        Configuration c = this.system.initialConfiguration(sentence);
        while (!this.system.isTerminal(c)) {
            if (Thread.interrupted()) {
                throw new RuntimeInterruptedException();
            }
            double[] scores = this.classifier.computeScores(this.getFeatureArray(c));
            double optScore = Double.NEGATIVE_INFINITY;
            String optTrans = null;
            for (int j = 0; j < numTrans; ++j) {
                String tr;
                if (!(scores[j] > optScore) || !this.system.canApply(c, tr = this.system.transitions.get(j))) continue;
                optScore = scores[j];
                optTrans = tr;
            }
            this.system.apply(c, optTrans);
        }
        return c.tree;
    }

    public GrammaticalStructure predict(CoreMap sentence) {
        if (this.system == null) {
            throw new IllegalStateException("Parser has not been  loaded and initialized; first load a model.");
        }
        DependencyTree result = this.predictInner(sentence);
        List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        ArrayList<TypedDependency> dependencies = new ArrayList<TypedDependency>();
        IndexedWord root = new IndexedWord(new Word("ROOT"));
        root.set(CoreAnnotations.IndexAnnotation.class, 0);
        for (int i = 1; i <= result.n; ++i) {
            int head = result.getHead(i);
            String label = result.getLabel(i);
            IndexedWord thisWord = new IndexedWord((CoreLabel)tokens.get(i - 1));
            IndexedWord headWord = head == 0 ? root : new IndexedWord((CoreLabel)tokens.get(head - 1));
            GrammaticalRelation relation = head == 0 ? GrammaticalRelation.ROOT : this.makeGrammaticalRelation(label);
            dependencies.add(new TypedDependency(relation, headWord, thisWord));
        }
        TreeGraphNode rootNode = new TreeGraphNode(root);
        return this.makeGrammaticalStructure(dependencies, rootNode);
    }

    private GrammaticalRelation makeGrammaticalRelation(String label) {
        switch (this.language) {
            case English: {
                GrammaticalRelation stored = EnglishGrammaticalRelations.shortNameToGRel.get(label);
                if (stored == null) break;
                return stored;
            }
            case UniversalEnglish: {
                GrammaticalRelation stored = UniversalEnglishGrammaticalRelations.shortNameToGRel.get(label);
                if (stored == null) break;
                return stored;
            }
            case Chinese: {
                GrammaticalRelation stored = ChineseGrammaticalRelations.shortNameToGRel.get(label);
                if (stored == null) break;
                return stored;
            }
        }
        return new GrammaticalRelation(this.language, label, null, GrammaticalRelation.DEPENDENT);
    }

    private GrammaticalStructure makeGrammaticalStructure(List<TypedDependency> dependencies, TreeGraphNode rootNode) {
        switch (this.language) {
            case English: {
                return new EnglishGrammaticalStructure(dependencies, rootNode);
            }
            case UniversalEnglish: {
                return new UniversalEnglishGrammaticalStructure(dependencies, rootNode);
            }
            case Chinese: {
                return new ChineseGrammaticalStructure(dependencies, rootNode);
            }
        }
        return new UniversalEnglishGrammaticalStructure(dependencies, rootNode);
    }

    public GrammaticalStructure predict(List<? extends HasWord> sentence) {
        CoreLabel sentenceLabel = new CoreLabel();
        ArrayList<CoreLabel> tokens = new ArrayList<CoreLabel>();
        int i = 1;
        for (HasWord hasWord : sentence) {
            CoreLabel label;
            if (hasWord instanceof CoreLabel) {
                label = (CoreLabel)hasWord;
                if (label.tag() == null) {
                    throw new IllegalArgumentException("Parser requires words with part-of-speech tag annotations");
                }
            } else {
                label = new CoreLabel();
                label.setValue(hasWord.word());
                label.setWord(hasWord.word());
                if (!(hasWord instanceof HasTag)) {
                    throw new IllegalArgumentException("Parser requires words with part-of-speech tag annotations");
                }
                label.setTag(((HasTag)((Object)hasWord)).tag());
            }
            label.setIndex(i);
            ++i;
            tokens.add(label);
        }
        sentenceLabel.set(CoreAnnotations.TokensAnnotation.class, tokens);
        return this.predict(sentenceLabel);
    }

    public double testCoNLL(String testFile, String outFile) {
        log.info("Test File: " + testFile);
        Timing timer = new Timing();
        ArrayList<CoreMap> testSents = new ArrayList<CoreMap>();
        ArrayList<DependencyTree> testTrees = new ArrayList<DependencyTree>();
        Util.loadConllFile(testFile, testSents, testTrees, this.config.unlabeled, this.config.cPOS);
        int numWords = 0;
        int numOOVWords = 0;
        int numSentences = 0;
        for (CoreMap testSent : testSents) {
            ++numSentences;
            List tokens = (List)testSent.get(CoreAnnotations.TokensAnnotation.class);
            for (CoreLabel token : tokens) {
                String word = token.word();
                ++numWords;
                if (this.wordIDs.containsKey(word)) continue;
                ++numOOVWords;
            }
        }
        log.info(String.format("OOV Words: %d / %d = %.2f%%\n", numOOVWords, numWords, (double)numOOVWords * 100.0 / (double)numWords));
        List<DependencyTree> predicted = testSents.stream().map(this::predictInner).collect(Collectors.toList());
        Map<String, Double> result = this.system.evaluate(testSents, predicted, testTrees);
        double uas = this.config.noPunc ? result.get("UASnoPunc").doubleValue() : result.get("UAS").doubleValue();
        double las = this.config.noPunc ? result.get("LASnoPunc").doubleValue() : result.get("LAS").doubleValue();
        log.info(String.format("UAS = %.4f%n", uas));
        log.info(String.format("LAS = %.4f%n", las));
        long millis = timer.stop();
        double wordspersec = (double)numWords / ((double)millis / 1000.0);
        double sentspersec = (double)numSentences / ((double)millis / 1000.0);
        log.info(String.format("%s parsed %d words in %d sentences in %.1fs at %.1f w/s, %.1f sent/s.%n", StringUtils.getShortClassName(this), numWords, numSentences, (double)millis / 1000.0, wordspersec, sentspersec));
        if (outFile != null) {
            Util.writeConllFile(outFile, testSents, predicted);
        }
        return las;
    }

    private void parseTextFile(BufferedReader input, PrintWriter output) {
        DocumentPreprocessor preprocessor = new DocumentPreprocessor(input);
        preprocessor.setSentenceFinalPuncWords(this.config.tlp.sentenceFinalPunctuationWords());
        preprocessor.setEscaper(this.config.escaper);
        preprocessor.setSentenceDelimiter(this.config.sentenceDelimiter);
        if (this.config.preTokenized) {
            preprocessor.setTokenizerFactory(WhitespaceTokenizer.factory());
        } else {
            preprocessor.setTokenizerFactory(this.config.tlp.getTokenizerFactory());
        }
        Timing timer = new Timing();
        MaxentTagger tagger = new MaxentTagger(this.config.tagger);
        ArrayList<List<TaggedWord>> tagged = new ArrayList<List<TaggedWord>>();
        for (Object sentence : preprocessor) {
            tagged.add(tagger.tagSentence((List<? extends HasWord>)sentence));
        }
        log.info(String.format("Tagging completed in %.2f sec.%n", (double)timer.stop() / 1000.0));
        timer.start();
        int numSentences = 0;
        for (List list : tagged) {
            GrammaticalStructure parse = this.predict(list);
            Collection<TypedDependency> deps = parse.typedDependencies();
            for (TypedDependency dep : deps) {
                output.println(dep);
            }
            output.println();
            ++numSentences;
        }
        long millis = timer.stop();
        double seconds = (double)millis / 1000.0;
        log.info(String.format("Parsed %d sentences in %.2f seconds (%.2f sents/sec).%n", numSentences, seconds, (double)numSentences / seconds));
    }

    private void initialize(boolean verbose) {
        if (this.knownLabels == null) {
            throw new IllegalStateException("Model has not been loaded or trained");
        }
        ArrayList<String> lDict = new ArrayList<String>(this.knownLabels);
        lDict.remove(0);
        this.system = new ArcStandard(this.config.tlp, lDict, verbose);
        if (this.config.numPreComputed > 0) {
            this.classifier.preCompute();
        }
    }

    public static void main(String[] args) {
        Properties props = StringUtils.argsToProperties(args, numArgs);
        DependencyParser parser = new DependencyParser(props);
        if (props.containsKey("trainFile")) {
            parser.train(props.getProperty("trainFile"), props.getProperty("devFile"), props.getProperty("model"), props.getProperty("embedFile"), props.getProperty("preModel"));
        }
        boolean loaded = false;
        if (props.containsKey("testFile")) {
            parser.loadModelFile(props.getProperty("model"));
            loaded = true;
            parser.testCoNLL(props.getProperty("testFile"), props.getProperty("outFile"));
        }
        if (props.containsKey("textFile")) {
            PrintWriter output;
            BufferedReader input;
            if (!loaded) {
                parser.loadModelFile(props.getProperty("model"));
                loaded = true;
            }
            String encoding = parser.config.tlp.getEncoding();
            String inputFilename = props.getProperty("textFile");
            try {
                input = inputFilename.equals("-") ? IOUtils.readerFromStdin(encoding) : IOUtils.readerFromString(inputFilename, encoding);
            }
            catch (IOException e) {
                throw new RuntimeIOException("No input file provided (use -textFile)", e);
            }
            String outputFilename = props.getProperty("outFile");
            try {
                output = outputFilename == null || outputFilename.equals("-") ? IOUtils.encodedOutputStreamPrintWriter(System.out, encoding, true) : IOUtils.getPrintWriter(outputFilename, encoding);
            }
            catch (IOException e) {
                throw new RuntimeIOException("Error opening output file", e);
            }
            parser.parseTextFile(input, output);
        }
    }

    static {
        numArgs.put("textFile", 1);
        numArgs.put("outFile", 1);
    }
}

