/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.parser.lexparser.ParserQuery;
import edu.stanford.nlp.parser.lexparser.ParserQueryFactory;
import edu.stanford.nlp.util.concurrent.ThreadsafeProcessor;
import java.io.PrintWriter;
import java.util.List;

class ParsingThreadsafeProcessor
implements ThreadsafeProcessor<List<? extends HasWord>, ParserQuery> {
    ParserQueryFactory pqFactory;
    PrintWriter pwErr;

    ParsingThreadsafeProcessor(ParserQueryFactory pqFactory) {
        this(pqFactory, null);
    }

    ParsingThreadsafeProcessor(ParserQueryFactory pqFactory, PrintWriter pwErr) {
        this.pqFactory = pqFactory;
        this.pwErr = pwErr;
    }

    @Override
    public ParserQuery process(List<? extends HasWord> sentence) {
        ParserQuery pq = this.pqFactory.parserQuery();
        if (this.pwErr != null) {
            pq.parseAndReport(sentence, this.pwErr);
        } else {
            pq.parse(sentence);
        }
        return pq;
    }

    @Override
    public ThreadsafeProcessor<List<? extends HasWord>, ParserQuery> newInstance() {
        return this;
    }
}

