/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.french.process;

import edu.stanford.nlp.international.french.process.FrenchLexer;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.process.AbstractTokenizer;
import edu.stanford.nlp.process.CoreLabelTokenFactory;
import edu.stanford.nlp.process.LexedTokenFactory;
import edu.stanford.nlp.process.Tokenizer;
import edu.stanford.nlp.process.TokenizerFactory;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.StringUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class FrenchTokenizer<T extends HasWord>
extends AbstractTokenizer<T> {
    private final FrenchLexer lexer;
    private static final Properties ftbOptions;

    public static FrenchTokenizer<CoreLabel> newFrenchTokenizer(Reader r, Properties lexerProperties) {
        return new FrenchTokenizer<CoreLabel>(r, new CoreLabelTokenFactory(), lexerProperties);
    }

    public FrenchTokenizer(Reader r, LexedTokenFactory<T> tf, Properties lexerProperties) {
        this.lexer = new FrenchLexer(r, tf, lexerProperties);
    }

    @Override
    protected T getNext() {
        try {
            HasWord nextToken = null;
            while ((nextToken = (HasWord)this.lexer.next()) != null && nextToken.word().length() == 0) {
            }
            return (T)nextToken;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static TokenizerFactory<CoreLabel> factory() {
        return FrenchTokenizerFactory.newTokenizerFactory();
    }

    public static TokenizerFactory<CoreLabel> ftbFactory() {
        TokenizerFactory<CoreLabel> tf = FrenchTokenizerFactory.newTokenizerFactory();
        for (String option : ftbOptions.stringPropertyNames()) {
            tf.setOptions(option);
        }
        return tf;
    }

    private static String usage() {
        StringBuffer sb = new StringBuffer();
        String nl = System.getProperty("line.separator");
        sb.append(String.format("Usage: java %s [OPTIONS] < file%n%n", FrenchTokenizer.class.getName()));
        sb.append("Options:").append(nl);
        sb.append("   -help          : Print this message.").append(nl);
        sb.append("   -ftb           : Tokenization for experiments in Green et al. (2011).").append(nl);
        sb.append("   -lowerCase     : Apply lowercasing.").append(nl);
        sb.append("   -encoding type : Encoding format.").append(nl);
        return sb.toString();
    }

    private static Map<String, Integer> argOptionDefs() {
        Map<String, Integer> argOptionDefs = Generics.newHashMap();
        argOptionDefs.put("help", 0);
        argOptionDefs.put("ftb", 0);
        argOptionDefs.put("lowerCase", 0);
        argOptionDefs.put("encoding", 1);
        return argOptionDefs;
    }

    public static void main(String[] args) {
        Properties options = StringUtils.argsToProperties(args, FrenchTokenizer.argOptionDefs());
        if (options.containsKey("help")) {
            System.err.println(FrenchTokenizer.usage());
            System.exit(-1);
        }
        TokenizerFactory<CoreLabel> tf = options.containsKey("ftb") ? FrenchTokenizer.ftbFactory() : FrenchTokenizer.factory();
        for (String option : options.stringPropertyNames()) {
            tf.setOptions(option);
        }
        tf.setOptions("tokenizeNLs");
        int nLines = 0;
        int nTokens = 0;
        String encoding = options.getProperty("encoding", "UTF-8");
        boolean toLower = PropertiesUtils.getBool(options, "lowerCase", false);
        try {
            Tokenizer<CoreLabel> tokenizer = tf.getTokenizer(new InputStreamReader(System.in, encoding));
            boolean printSpace = false;
            while (tokenizer.hasNext()) {
                ++nTokens;
                String word = tokenizer.next().word();
                if (word.equals("*NL*")) {
                    ++nLines;
                    printSpace = false;
                    System.out.println();
                    continue;
                }
                if (printSpace) {
                    System.out.print(" ");
                }
                System.out.print(toLower ? word.toLowerCase(Locale.FRENCH) : word);
                printSpace = true;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        System.err.printf("Done! Tokenized %d lines (%d tokens)%n", nLines, nTokens);
    }

    static {
        String[] optionToks;
        ftbOptions = new Properties();
        String optionsStr = "";
        for (String option : optionToks = optionsStr.split(",")) {
            ftbOptions.put(option, "true");
        }
    }

    public static class FrenchTokenizerFactory<T extends HasWord>
    implements TokenizerFactory<T>,
    Serializable {
        private static final long serialVersionUID = 946818805507187330L;
        protected final LexedTokenFactory<T> factory;
        protected Properties lexerProperties = new Properties();

        public static TokenizerFactory<CoreLabel> newTokenizerFactory() {
            return new FrenchTokenizerFactory<CoreLabel>(new CoreLabelTokenFactory());
        }

        private FrenchTokenizerFactory(LexedTokenFactory<T> factory) {
            this.factory = factory;
        }

        @Override
        public Iterator<T> getIterator(Reader r) {
            return this.getTokenizer(r);
        }

        @Override
        public Tokenizer<T> getTokenizer(Reader r) {
            return new FrenchTokenizer<T>(r, this.factory, this.lexerProperties);
        }

        @Override
        public void setOptions(String options) {
            String[] optionList;
            for (String option : optionList = options.split(",")) {
                this.lexerProperties.put(option, "true");
            }
        }

        @Override
        public Tokenizer<T> getTokenizer(Reader r, String extraOptions) {
            this.setOptions(extraOptions);
            return this.getTokenizer(r);
        }
    }
}

