/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.parser.lexparser.AbstractUnknownWordModelTrainer;
import edu.stanford.nlp.parser.lexparser.FrenchUnknownWordModel;
import edu.stanford.nlp.parser.lexparser.IntTaggedWord;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.UnknownWordModel;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.util.Index;

public class FrenchUnknownWordModelTrainer
extends AbstractUnknownWordModelTrainer {
    ClassicCounter<IntTaggedWord> seenCounter;
    ClassicCounter<IntTaggedWord> unSeenCounter;
    double indexToStartUnkCounting;
    private static final String BOUNDARY_TAG = ".$$.";
    UnknownWordModel model;

    @Override
    public void initializeTraining(Options op, Lexicon lex, Index<String> wordIndex, Index<String> tagIndex, double totalTrees) {
        super.initializeTraining(op, lex, wordIndex, tagIndex, totalTrees);
        this.indexToStartUnkCounting = totalTrees * op.trainOptions.fractionBeforeUnseenCounting;
        this.seenCounter = new ClassicCounter();
        this.unSeenCounter = new ClassicCounter();
        this.model = new FrenchUnknownWordModel(op, lex, wordIndex, tagIndex, this.unSeenCounter);
    }

    @Override
    public void train(TaggedWord tw, int loc, double weight) {
        IntTaggedWord iTW = new IntTaggedWord(tw.word(), tw.tag(), (Index<String>)this.wordIndex, (Index<String>)this.tagIndex);
        IntTaggedWord iT = new IntTaggedWord(-1, iTW.tag);
        IntTaggedWord iW = new IntTaggedWord(iTW.word, -1);
        this.seenCounter.incrementCount(iW, weight);
        IntTaggedWord i = NULL_ITW;
        if (this.treesRead > this.indexToStartUnkCounting && this.seenCounter.getCount(iW) < 2.0) {
            int s = this.model.getSignatureIndex(iTW.word, loc, (String)this.wordIndex.get(iTW.word));
            IntTaggedWord iTS = new IntTaggedWord(s, iTW.tag);
            IntTaggedWord iS = new IntTaggedWord(s, -1);
            this.unSeenCounter.incrementCount(iTS, weight);
            this.unSeenCounter.incrementCount(iT, weight);
            this.unSeenCounter.incrementCount(iS, weight);
            this.unSeenCounter.incrementCount(i, weight);
        }
    }

    @Override
    public UnknownWordModel finishTraining() {
        if (this.unSeenCounter.isEmpty()) {
            System.err.printf("%s: WARNING: Unseen word counter is empty!", this.getClass().getName());
            int numTags = this.tagIndex.size();
            for (int tt = 0; tt < numTags; ++tt) {
                if (BOUNDARY_TAG.equals(this.tagIndex.get(tt))) continue;
                IntTaggedWord iT = new IntTaggedWord(-1, tt);
                IntTaggedWord i = NULL_ITW;
                this.unSeenCounter.incrementCount(iT);
                this.unSeenCounter.incrementCount(i);
            }
        }
        return this.model;
    }
}

