/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.nndep;

import edu.stanford.nlp.parser.nndep.DependencyParser;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

class DependencyParserCache {
    private static Map<DependencyParserSpecification, WeakReference<DependencyParser>> modelCache = new HashMap<DependencyParserSpecification, WeakReference<DependencyParser>>();

    DependencyParserCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DependencyParser loadFromModelFile(String modelFile, Properties extraProperties) {
        DependencyParserSpecification spec = new DependencyParserSpecification(modelFile, extraProperties);
        Map<DependencyParserSpecification, WeakReference<DependencyParser>> map = modelCache;
        synchronized (map) {
            DependencyParser parser;
            WeakReference ref = modelCache.getOrDefault(spec, null);
            if (ref != null && (parser = (DependencyParser)ref.get()) != null) {
                return parser;
            }
            parser = spec.loadModelFile();
            modelCache.put(spec, new WeakReference<DependencyParser>(parser));
            return parser;
        }
    }

    private static class DependencyParserSpecification {
        private final Properties props;
        private final String modelFile;

        DependencyParserSpecification(String modelFile, Properties extraProperties) {
            this.modelFile = modelFile;
            this.props = new Properties();
            if (extraProperties != null) {
                for (String key : extraProperties.stringPropertyNames()) {
                    this.props.setProperty(key, extraProperties.getProperty(key));
                }
            }
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof DependencyParserSpecification)) {
                return false;
            }
            DependencyParserSpecification other = (DependencyParserSpecification)obj;
            return this.modelFile.equals(other.modelFile) && this.props.equals(other.props);
        }

        public int hashCode() {
            return this.modelFile.hashCode() + this.props.hashCode();
        }

        DependencyParser loadModelFile() {
            DependencyParser parser = new DependencyParser(this.props);
            parser.loadModelFile(this.modelFile, false);
            return parser;
        }

        public String toString() {
            return this.modelFile + " ... " + this.props;
        }
    }
}

