/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.optimization;

import edu.stanford.nlp.optimization.FloatFunction;
import edu.stanford.nlp.util.ConvertByteArray;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;

public class ResultStoringFloatMonitor
implements FloatFunction {
    private static Redwood.RedwoodChannels log = Redwood.channels(ResultStoringFloatMonitor.class);
    int i = 0;
    final int outputFreq;
    final String filename;

    public ResultStoringFloatMonitor(int outputFreq, String filename) {
        this.filename = filename.lastIndexOf(46) >= 0 ? filename.substring(0, filename.lastIndexOf(46)) + ".fdat" : filename + ".fdat";
        this.outputFreq = outputFreq;
    }

    @Override
    public float valueAt(float[] x) {
        if (++this.i % this.outputFreq == 0) {
            log.info("Storing interim (float) weights to " + this.filename + " ... ");
            try {
                DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(this.filename))));
                ConvertByteArray.saveFloatArr(dos, x);
                dos.close();
            }
            catch (IOException e) {
                log.error("!");
                return 1.0f;
            }
            log.info("DONE.");
        }
        return 0.0f;
    }

    @Override
    public int domainDimension() {
        return 0;
    }
}

