/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ie.EntityBIO;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.sequences.ListeningSequenceModel;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.List;

public abstract class EntityCachingAbstractSequencePriorBIO<IN extends CoreMap>
implements ListeningSequenceModel {
    private static Redwood.RedwoodChannels log = Redwood.channels(EntityCachingAbstractSequencePriorBIO.class);
    protected int[] sequence;
    protected final int backgroundSymbol;
    protected final int numClasses;
    protected final int[] possibleValues;
    protected final Index<String> classIndex;
    protected final Index<String> tagIndex;
    private final List<String> wordDoc;
    private boolean VERBOSE = false;
    EntityBIO[] entities;

    public EntityCachingAbstractSequencePriorBIO(String backgroundSymbol, Index<String> classIndex, Index<String> tagIndex, List<IN> doc) {
        this.classIndex = classIndex;
        this.tagIndex = tagIndex;
        this.backgroundSymbol = classIndex.indexOf(backgroundSymbol);
        this.numClasses = classIndex.size();
        this.possibleValues = new int[this.numClasses];
        for (int i = 0; i < this.numClasses; ++i) {
            this.possibleValues[i] = i;
        }
        this.wordDoc = new ArrayList<String>(doc.size());
        for (CoreMap w : doc) {
            this.wordDoc.add((String)w.get(CoreAnnotations.TextAnnotation.class));
        }
    }

    @Override
    public int leftWindow() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int rightWindow() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int[] getPossibleValues(int position) {
        return this.possibleValues;
    }

    @Override
    public double scoreOf(int[] sequence, int pos) {
        return this.scoresOf(sequence, pos)[sequence[pos]];
    }

    @Override
    public int length() {
        return this.wordDoc.size();
    }

    public int getNumClasses() {
        return this.classIndex.size();
    }

    public double[] getConditionalDistribution(int[] sequence, int position) {
        double[] probs = this.scoresOf(sequence, position);
        ArrayMath.logNormalize(probs);
        probs = ArrayMath.exp(probs);
        return probs;
    }

    @Override
    public double[] scoresOf(int[] sequence, int position) {
        int origClass;
        double[] probs = new double[this.numClasses];
        int oldVal = origClass = sequence[position];
        for (int label = 0; label < this.numClasses; ++label) {
            if (label == origClass) continue;
            sequence[position] = label;
            this.updateSequenceElement(sequence, position, oldVal);
            probs[label] = this.scoreOf(sequence);
            oldVal = label;
        }
        sequence[position] = origClass;
        this.updateSequenceElement(sequence, position, oldVal);
        probs[origClass] = this.scoreOf(sequence);
        return probs;
    }

    @Override
    public void setInitialSequence(int[] initialSequence) {
        this.sequence = initialSequence;
        this.entities = new EntityBIO[initialSequence.length];
        for (int i = 0; i < initialSequence.length; ++i) {
            String rawTag;
            String[] parts;
            if (initialSequence[i] == this.backgroundSymbol || !(parts = (rawTag = this.classIndex.get(this.sequence[i])).split("-"))[0].equals("B")) continue;
            EntityBIO entity = this.extractEntity(initialSequence, i, parts[1]);
            this.addEntityToEntitiesArray(entity);
            i += entity.words.size() - 1;
        }
    }

    private void addEntityToEntitiesArray(EntityBIO entity) {
        for (int j = entity.startPosition; j < entity.startPosition + entity.words.size(); ++j) {
            this.entities[j] = entity;
        }
    }

    public EntityBIO extractEntity(int[] sequence, int position, String tag) {
        String rawTag;
        String[] parts;
        EntityBIO entity = new EntityBIO();
        entity.type = this.tagIndex.indexOf(tag);
        entity.startPosition = position;
        entity.words = new ArrayList<String>();
        entity.words.add(this.wordDoc.get(position));
        for (int pos = position + 1; pos < sequence.length && (parts = (rawTag = this.classIndex.get(sequence[pos])).split("-"))[0].equals("I") && parts[1].equals(tag); ++pos) {
            String word = this.wordDoc.get(pos);
            entity.words.add(word);
        }
        entity.otherOccurrences = this.otherOccurrences(entity);
        return entity;
    }

    public int[] otherOccurrences(EntityBIO entity) {
        ArrayList<Integer> other = new ArrayList<Integer>();
        for (int i = 0; i < this.wordDoc.size(); ++i) {
            if (i == entity.startPosition || !this.matches(entity, i)) continue;
            other.add(i);
        }
        return EntityCachingAbstractSequencePriorBIO.toArray(other);
    }

    public static int[] toArray(List<Integer> list) {
        int[] arr = new int[list.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = list.get(i);
        }
        return arr;
    }

    public boolean matches(EntityBIO entity, int position) {
        String word = this.wordDoc.get(position);
        if (word.equalsIgnoreCase(entity.words.get(0))) {
            for (int j = 1; j < entity.words.size(); ++j) {
                if (position + j >= this.wordDoc.size()) {
                    return false;
                }
                String nextWord = this.wordDoc.get(position + j);
                if (nextWord.equalsIgnoreCase(entity.words.get(j))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void updateSequenceElement(int[] sequence, int position, int oldVal) {
        this.sequence = sequence;
        if (sequence[position] == oldVal) {
            return;
        }
        if (this.VERBOSE) {
            log.info("changing position " + position + " from " + this.classIndex.get(oldVal) + " to " + this.classIndex.get(sequence[position]));
        }
        if (sequence[position] == this.backgroundSymbol) {
            String oldRawTag = this.classIndex.get(oldVal);
            String[] oldParts = oldRawTag.split("-");
            if (oldParts[0].equals("B")) {
                EntityBIO entity = this.entities[position];
                if (entity == null) {
                    throw new RuntimeException("oldTag starts with B, entity at position should not be null");
                }
                for (int i = 0; i < entity.words.size(); ++i) {
                    this.entities[position + i] = null;
                }
            } else if (this.entities[position] != null) {
                int i;
                if (this.VERBOSE) {
                    log.info("splitting off prev entity");
                }
                EntityBIO oldEntity = this.entities[position];
                int oldLen = oldEntity.words.size();
                int offset = position - oldEntity.startPosition;
                ArrayList<String> newWords = new ArrayList<String>();
                for (i = 0; i < offset; ++i) {
                    newWords.add(oldEntity.words.get(i));
                }
                oldEntity.words = newWords;
                oldEntity.otherOccurrences = this.otherOccurrences(oldEntity);
                for (i = 0; i < oldLen - offset; ++i) {
                    this.entities[position + i] = null;
                }
                if (this.VERBOSE && position > 0) {
                    log.info("position:" + position + ", entities[position-1] = " + this.entities[position - 1].toString(this.tagIndex));
                }
            }
        } else {
            String rawTag = this.classIndex.get(sequence[position]);
            String[] parts = rawTag.split("-");
            if (parts[0].equals("B")) {
                if (oldVal == this.backgroundSymbol) {
                    EntityBIO entity = this.extractEntity(sequence, position, parts[1]);
                    this.addEntityToEntitiesArray(entity);
                } else {
                    String oldRawTag = this.classIndex.get(oldVal);
                    String[] oldParts = oldRawTag.split("-");
                    if (oldParts[0].equals("B")) {
                        EntityBIO oldEntity = this.entities[position];
                        if (oldEntity.words.size() > 1) {
                            for (int i = 0; i < oldEntity.words.size(); ++i) {
                                this.entities[position + i] = null;
                            }
                            EntityBIO entity = this.extractEntity(sequence, position, parts[1]);
                            this.addEntityToEntitiesArray(entity);
                        } else {
                            EntityBIO entity = this.extractEntity(sequence, position, parts[1]);
                            this.addEntityToEntitiesArray(entity);
                        }
                    } else {
                        EntityBIO oldEntity = this.entities[position];
                        if (oldEntity != null) {
                            int i;
                            int oldLen = oldEntity.words.size();
                            int offset = position - oldEntity.startPosition;
                            ArrayList<String> newWords = new ArrayList<String>();
                            for (i = 0; i < offset; ++i) {
                                newWords.add(oldEntity.words.get(i));
                            }
                            oldEntity.words = newWords;
                            oldEntity.otherOccurrences = this.otherOccurrences(oldEntity);
                            for (i = 0; i < oldLen - offset; ++i) {
                                this.entities[position + i] = null;
                            }
                        }
                        EntityBIO entity = this.extractEntity(sequence, position, parts[1]);
                        this.addEntityToEntitiesArray(entity);
                    }
                }
            } else if (oldVal == this.backgroundSymbol) {
                if (position > 0 && this.entities[position - 1] != null) {
                    String oldTag = this.tagIndex.get(this.entities[position - 1].type);
                    EntityBIO entity = this.extractEntity(sequence, position - 1 - this.entities[position - 1].words.size() + 1, oldTag);
                    this.addEntityToEntitiesArray(entity);
                }
            } else {
                String oldRawTag = this.classIndex.get(oldVal);
                String[] oldParts = oldRawTag.split("-");
                if (oldParts[0].equals("B")) {
                    EntityBIO oldEntity = this.entities[position];
                    for (int i = 0; i < oldEntity.words.size(); ++i) {
                        this.entities[position + i] = null;
                    }
                    if (position > 0 && this.entities[position - 1] != null) {
                        String oldTag = this.tagIndex.get(this.entities[position - 1].type);
                        if (this.VERBOSE) {
                            log.info("position:" + position + ", entities[position-1] = " + this.entities[position - 1].toString(this.tagIndex));
                        }
                        EntityBIO entity = this.extractEntity(sequence, position - 1 - this.entities[position - 1].words.size() + 1, oldTag);
                        this.addEntityToEntitiesArray(entity);
                    }
                } else if (this.entities[position] != null) {
                    int i;
                    EntityBIO oldEntity = this.entities[position];
                    int oldLen = oldEntity.words.size();
                    int offset = position - oldEntity.startPosition;
                    ArrayList<String> newWords = new ArrayList<String>();
                    for (i = 0; i < offset; ++i) {
                        newWords.add(oldEntity.words.get(i));
                    }
                    oldEntity.words = newWords;
                    oldEntity.otherOccurrences = this.otherOccurrences(oldEntity);
                    for (i = 0; i < oldLen - offset; ++i) {
                        this.entities[position + i] = null;
                    }
                } else if (position > 0 && this.entities[position - 1] != null) {
                    String oldTag = this.tagIndex.get(this.entities[position - 1].type);
                    EntityBIO entity = this.extractEntity(sequence, position - 1 - this.entities[position - 1].words.size() + 1, oldTag);
                    this.addEntityToEntitiesArray(entity);
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.entities.length; ++i) {
            sb.append(i);
            sb.append('\t');
            String word = this.wordDoc.get(i);
            sb.append(word);
            sb.append('\t');
            sb.append(this.classIndex.get(this.sequence[i]));
            if (this.entities[i] != null) {
                sb.append('\t');
                sb.append(this.entities[i].toString(this.tagIndex));
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public String toString(int pos) {
        StringBuilder sb = new StringBuilder();
        for (int i = Math.max(0, pos - 3); i < Math.min(this.entities.length, pos + 3); ++i) {
            sb.append(i);
            sb.append('\t');
            String word = this.wordDoc.get(i);
            sb.append(word);
            sb.append('\t');
            sb.append(this.classIndex.get(this.sequence[i]));
            if (this.entities[i] != null) {
                sb.append('\t');
                sb.append(this.entities[i].toString(this.tagIndex));
            }
            sb.append('\n');
        }
        return sb.toString();
    }
}

