/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.parser.impl;

import de.jollyday.Holiday;
import de.jollyday.HolidayType;
import de.jollyday.config.FixedWeekdayRelativeToFixed;
import de.jollyday.config.Holidays;
import de.jollyday.config.When;
import de.jollyday.parser.AbstractHolidayParser;
import java.util.Set;
import org.joda.time.LocalDate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedWeekdayRelativeToFixedParser
extends AbstractHolidayParser {
    @Override
    public void parse(int year, Set<Holiday> holidays, Holidays config) {
        for (FixedWeekdayRelativeToFixed f : config.getFixedWeekdayRelativeToFixed()) {
            if (!this.isValid(f, year)) continue;
            LocalDate day = this.calendarUtil.create(year, f.getDay());
            day = this.moveDateToFirstOccurenceOfWeekday(f, day);
            int days = this.determineNumberOfDays(f);
            day = f.getWhen() == When.AFTER ? day.plusDays(days) : day.minusDays(days);
            HolidayType type = this.xmlUtil.getType(f.getLocalizedType());
            holidays.add(new Holiday(day, f.getDescriptionPropertiesKey(), type));
        }
    }

    private LocalDate moveDateToFirstOccurenceOfWeekday(FixedWeekdayRelativeToFixed f, LocalDate day) {
        LocalDate movingDay = day;
        while ((movingDay = f.getWhen() == When.AFTER ? movingDay.plusDays(1) : movingDay.minusDays(1)).getDayOfWeek() != this.xmlUtil.getWeekday(f.getWeekday())) {
        }
        return movingDay;
    }

    private int determineNumberOfDays(FixedWeekdayRelativeToFixed f) {
        switch (f.getWhich()) {
            case SECOND: {
                return 7;
            }
            case THIRD: {
                return 14;
            }
            case FOURTH: {
                return 21;
            }
        }
        return 0;
    }
}

