/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Heap;
import edu.stanford.nlp.util.Scored;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class ArrayHeap<E>
extends AbstractSet<E>
implements Heap<E> {
    private static Redwood.RedwoodChannels log = Redwood.channels(ArrayHeap.class);
    private final ArrayList<HeapEntry<E>> indexToEntry;
    private final Map<E, HeapEntry<E>> objectToEntry;
    private final Comparator<? super E> cmp;

    private static int parent(int index) {
        return (index - 1) / 2;
    }

    private HeapEntry<E> parent(HeapEntry<E> entry) {
        int index = entry.index;
        return index > 0 ? this.indexToEntry.get((index - 1) / 2) : null;
    }

    private HeapEntry<E> leftChild(HeapEntry<E> entry) {
        int index = entry.index;
        int leftIndex = index * 2 + 1;
        return leftIndex < this.size() ? this.indexToEntry.get(leftIndex) : null;
    }

    private HeapEntry<E> rightChild(HeapEntry<E> entry) {
        int index = entry.index;
        int rightIndex = index * 2 + 2;
        return rightIndex < this.size() ? this.indexToEntry.get(rightIndex) : null;
    }

    private int compare(HeapEntry<E> entryA, HeapEntry<E> entryB) {
        return this.cmp.compare(entryA.object, entryB.object);
    }

    private void swap(HeapEntry<E> entryA, HeapEntry<E> entryB) {
        int indexB;
        int indexA = entryA.index;
        entryA.index = indexB = entryB.index;
        entryB.index = indexA;
        this.indexToEntry.set(indexA, entryB);
        this.indexToEntry.set(indexB, entryA);
    }

    private void removeLast(HeapEntry<E> entry) {
        this.indexToEntry.remove(entry.index);
        this.objectToEntry.remove(entry.object);
    }

    private HeapEntry<E> getEntry(E o) {
        HeapEntry<E> entry = this.objectToEntry.get(o);
        if (entry == null) {
            entry = new HeapEntry();
            entry.index = this.size();
            entry.object = o;
            this.indexToEntry.add(entry);
            this.objectToEntry.put(o, entry);
        }
        return entry;
    }

    private int heapifyUp(HeapEntry<E> entry) {
        HeapEntry<E> parentEntry;
        int numSwaps = 0;
        while (entry.index != 0 && this.compare(entry, parentEntry = this.parent(entry)) < 0) {
            ++numSwaps;
            this.swap(entry, parentEntry);
        }
        return numSwaps;
    }

    private void heapifyDown(HeapEntry<E> entry) {
        HeapEntry<E> minEntry;
        do {
            HeapEntry<E> rightEntry;
            minEntry = entry;
            HeapEntry<E> leftEntry = this.leftChild(entry);
            if (leftEntry != null && this.compare(minEntry, leftEntry) > 0) {
                minEntry = leftEntry;
            }
            if ((rightEntry = this.rightChild(entry)) != null && this.compare(minEntry, rightEntry) > 0) {
                minEntry = rightEntry;
            }
            if (minEntry == entry) continue;
            this.swap(minEntry, entry);
        } while (minEntry != entry);
    }

    @Override
    public E extractMin() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        HeapEntry<E> minEntry = this.indexToEntry.get(0);
        int lastIndex = this.size() - 1;
        if (lastIndex > 0) {
            HeapEntry<E> lastEntry = this.indexToEntry.get(lastIndex);
            this.swap(lastEntry, minEntry);
            this.removeLast(minEntry);
            this.heapifyDown(lastEntry);
        } else {
            this.removeLast(minEntry);
        }
        return minEntry.object;
    }

    @Override
    public E min() {
        HeapEntry<E> minEntry = this.indexToEntry.get(0);
        return minEntry.object;
    }

    @Override
    public boolean add(E o) {
        this.decreaseKey(o);
        return true;
    }

    @Override
    public int decreaseKey(E o) {
        HeapEntry<E> entry = this.getEntry(o);
        if (o != entry.object && this.cmp.compare(o, entry.object) < 0) {
            entry.object = o;
        }
        return this.heapifyUp(entry);
    }

    @Override
    public boolean isEmpty() {
        return this.indexToEntry.isEmpty();
    }

    @Override
    public int size() {
        return this.indexToEntry.size();
    }

    @Override
    public Iterator<E> iterator() {
        ArrayHeap<E> tempHeap = new ArrayHeap<E>(this.cmp, this.size());
        ArrayList tempList = new ArrayList(this.size());
        for (E obj : this.objectToEntry.keySet()) {
            tempHeap.add(obj);
        }
        while (!tempHeap.isEmpty()) {
            tempList.add(tempHeap.extractMin());
        }
        return tempList.iterator();
    }

    @Override
    public void clear() {
        this.indexToEntry.clear();
        this.objectToEntry.clear();
    }

    public void dump() {
        for (int j = 0; j < this.indexToEntry.size(); ++j) {
            log.info(" " + j + " " + ((Scored)this.indexToEntry.get((int)j).object).score());
        }
    }

    public void verify() {
        for (int i = 0; i < this.indexToEntry.size(); ++i) {
            if (i != 0 && this.compare(this.indexToEntry.get(i), this.indexToEntry.get(ArrayHeap.parent(i))) < 0) {
                log.info("Error in the ordering of the heap! (" + i + ")");
                this.dump();
                System.exit(0);
            }
            if (i == this.indexToEntry.get((int)i).index) continue;
            log.info("Error in placement in the heap!");
        }
    }

    public ArrayHeap(Comparator<? super E> cmp) {
        this.cmp = cmp;
        this.indexToEntry = new ArrayList();
        this.objectToEntry = Generics.newHashMap();
    }

    public ArrayHeap(Comparator<? super E> cmp, int initCapacity) {
        this.cmp = cmp;
        this.indexToEntry = new ArrayList(initCapacity);
        this.objectToEntry = Generics.newHashMap(initCapacity);
    }

    public List<E> asList() {
        return new LinkedList(this);
    }

    @Override
    public String toString() {
        ArrayList<E> result = new ArrayList<E>();
        for (E key : this.objectToEntry.keySet()) {
            result.add(key);
        }
        Collections.sort(result, this.cmp);
        return result.toString();
    }

    private static final class HeapEntry<E> {
        public E object;
        public int index;

        private HeapEntry() {
        }
    }
}

