/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.regexp;

import edu.stanford.nlp.ie.AbstractSequenceClassifier;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.sequences.DocumentReaderAndWriter;
import edu.stanford.nlp.time.TimeExpressionExtractor;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PaddedList;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;

public class ChineseNumberSequenceClassifier
extends AbstractSequenceClassifier<CoreLabel> {
    private static Redwood.RedwoodChannels log = Redwood.channels(ChineseNumberSequenceClassifier.class);
    private static final boolean DEBUG = false;
    private final boolean useSUTime;
    public static final boolean USE_SUTIME_DEFAULT = false;
    public static final String USE_SUTIME_PROPERTY = "ner.useSUTime";
    public static final String USE_SUTIME_PROPERTY_BASE = "useSUTime";
    public static final String SUTIME_PROPERTY = "sutime";
    private final TimeExpressionExtractor timexExtractor;
    public static final String NUMBER_TAG = "NUMBER";
    public static final String DATE_TAG = "DATE";
    public static final String TIME_TAG = "TIME";
    public static final String MONEY_TAG = "MONEY";
    public static final String ORDINAL_TAG = "ORDINAL";
    public static final String PERCENT_TAG = "PERCENT";
    public static final Pattern CURRENCY_WORD_PATTERN = Pattern.compile("\u5143|\u5200|(?:\u7f8e|\u6b27|\u6fb3|\u52a0|\u65e5|\u97e9)\u5143|\u82f1?\u9551|\u6cd5\u90ce|\u5362\u6bd4|\u5362\u5e03|\u9a6c\u514b|\u5148\u4ee4|\u514b\u6717|\u6cf0?\u94e2|(?:\u8d8a\u5357)?\u76fe|\u7f8e\u5206|\u4fbf\u58eb|\u5757\u94b1|\u6bdb\u94b1|\u89d2\u94b1");
    public static final Pattern PERCENT_WORD_PATTERN1 = Pattern.compile("(?:\u767e\u5206\u4e4b|\u5343\u5206\u4e4b).+");
    public static final Pattern PERCENT_WORD_PATTERN2 = Pattern.compile(".+%");
    public static final Pattern DATE_PATTERN1 = Pattern.compile(".+(?:\u5e74\u4ee3?|\u6708\u4efd?|\u65e5|\u53f7|\u4e16\u7eaa)");
    public static final Pattern DATE_PATTERN2 = Pattern.compile("(?:\u661f\u671f|\u5468|\u793c\u62dc).+");
    public static final Pattern DATE_PATTERN3 = Pattern.compile("[0-9\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u96f6\u3007\u5341]{2,4}");
    public static final Pattern DATE_PATTERN4 = Pattern.compile("(?:[0-9]{2,4}[/\\-\\.][0-9]+[/\\-\\.][0-9]+|[0-9]+[/\\-\\.][0-9]+[/\\-\\.][0-9]{2,4}|[0-9]+[/\\-\\.]?[0-9]+)");
    public static final Pattern DATE_PATTERN5 = Pattern.compile("[\u6628\u4eca\u660e][\u5929\u6668\u665a\u591c\u65e9]");
    public static final Pattern TIME_PATTERN1 = Pattern.compile(".+(?::|\u70b9|\u65f6)(?:\u8fc7|\u6b20|\u5dee)?(?:.+(?::|\u5206)?|\u6574?|\u949f?|.+\u523b)?(?:.+\u79d2?)");
    private static final Pattern CHINESE_AND_ARABIC_NUMERALS_PATTERN = Pattern.compile("[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u96f6\u5341\u3007\\d]+");
    private static final String DATE_AGE_LOCALIZER = "\u540e";
    public static final String[] CURRENCY_WORDS_VALUES = new String[]{"\u8d8a\u5357\u76fe", "\u7f8e\u5143", "\u6b27\u5143", "\u6fb3\u5143", "\u52a0\u5143", "\u65e5\u5143", "\u97e9\u5143", "\u82f1\u9551", "\u6cd5\u90ce", "\u5362\u6bd4", "\u5362\u5e03", "\u9a6c\u514b", "\u5148\u4ee4", "\u514b\u6717", "\u6cf0\u94e2", "\u76fe", "\u94e2", "\u5200", "\u9551", "\u5143"};
    public static final String[] DATE_WORDS_VALUES = new String[]{"\u660e\u5929", "\u540e\u5929", "\u6628\u5929", "\u524d\u5929", "\u660e\u5e74", "\u540e\u5e74", "\u53bb\u5e74", "\u524d\u5e74", "\u6628\u65e5", "\u660e\u65e5", "\u6765\u5e74", "\u4e0a\u6708", "\u672c\u6708", "\u76ee\u524d", "\u4eca\u540e", "\u672a\u6765", "\u65e5\u524d", "\u6700\u8fd1", "\u5f53\u65f6", "\u540e\u6765", "\u90a3\u65f6", "\u8fd9\u65f6", "\u4eca", "\u4eca\u5929", "\u5f53\u4eca", "\u5982\u4eca", "\u4e4b\u540e", "\u5f53\u4ee3", "\u4ee5\u524d", "\u73b0\u5728", "\u5c06\u6765", "\u6b64\u65f6", "\u6b64\u524d", "\u5143\u65e6"};
    public static final HashSet<String> DATE_WORDS = new HashSet<String>(Arrays.asList(DATE_WORDS_VALUES));
    public static final String[] TIME_WORDS_VALUES = new String[]{"\u65e9\u6668", "\u6e05\u6668", "\u51cc\u6668", "\u4e0a\u5348", "\u4e2d\u5348", "\u4e0b\u5348", "\u508d\u665a", "\u665a\u4e0a", "\u591c\u95f4", "\u6668\u95f4", "\u665a\u95f4", "\u5348\u524d", "\u5348\u540e", "\u65e9", "\u665a"};
    public static final HashSet<String> TIME_WORDS = new HashSet<String>(Arrays.asList(TIME_WORDS_VALUES));

    public ChineseNumberSequenceClassifier() {
        this(new Properties(), false, new Properties());
    }

    public ChineseNumberSequenceClassifier(boolean useSUTime) {
        this(new Properties(), useSUTime, new Properties());
    }

    public ChineseNumberSequenceClassifier(Properties props, boolean useSUTime, Properties sutimeProps) {
        super(props);
        this.useSUTime = useSUTime;
        if (this.useSUTime) {
            log.warn("SUTime currently does not support Chinese. Ignore property ner.useSUTime.");
        }
        this.timexExtractor = null;
    }

    @Override
    public List<CoreLabel> classify(List<CoreLabel> document) {
        PaddedList<CoreMap> pl = new PaddedList<CoreMap>(document, this.pad);
        int sz = pl.size();
        for (int i = 0; i < sz; ++i) {
            CoreLabel me = (CoreLabel)pl.get(i);
            CoreLabel prev = (CoreLabel)pl.get(i - 1);
            CoreLabel next = (CoreLabel)pl.get(i + 1);
            me.set(CoreAnnotations.AnswerAnnotation.class, this.flags.backgroundSymbol);
            if (me.getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("OD")) {
                me.set(CoreAnnotations.AnswerAnnotation.class, ORDINAL_TAG);
                continue;
            }
            if (CURRENCY_WORD_PATTERN.matcher(me.word()).matches() && prev.getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("CD")) {
                me.set(CoreAnnotations.AnswerAnnotation.class, MONEY_TAG);
                continue;
            }
            if (me.getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("CD")) {
                if (PERCENT_WORD_PATTERN1.matcher(me.word()).matches() || PERCENT_WORD_PATTERN2.matcher(me.word()).matches()) {
                    me.set(CoreAnnotations.AnswerAnnotation.class, PERCENT_TAG);
                    continue;
                }
                if (ChineseNumberSequenceClassifier.rightScanFindsMoneyWord(pl, i)) {
                    me.set(CoreAnnotations.AnswerAnnotation.class, MONEY_TAG);
                    continue;
                }
                if (me.word().length() == 2 && CHINESE_AND_ARABIC_NUMERALS_PATTERN.matcher(me.word()).matches() && DATE_AGE_LOCALIZER.equals(next.word())) {
                    me.set(CoreAnnotations.AnswerAnnotation.class, DATE_TAG);
                    continue;
                }
                me.set(CoreAnnotations.AnswerAnnotation.class, NUMBER_TAG);
                continue;
            }
            if (me.getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("NT")) {
                if (DATE_PATTERN1.matcher(me.word()).matches() || DATE_PATTERN2.matcher(me.word()).matches() || DATE_PATTERN3.matcher(me.word()).matches() || DATE_PATTERN4.matcher(me.word()).matches() || DATE_PATTERN5.matcher(me.word()).matches() || DATE_WORDS.contains(me.word())) {
                    me.set(CoreAnnotations.AnswerAnnotation.class, DATE_TAG);
                    continue;
                }
                if (TIME_PATTERN1.matcher(me.word()).matches() || TIME_WORDS.contains(me.word())) {
                    me.set(CoreAnnotations.AnswerAnnotation.class, TIME_TAG);
                    continue;
                }
                me.set(CoreAnnotations.AnswerAnnotation.class, TIME_TAG);
                continue;
            }
            if (!DATE_AGE_LOCALIZER.equals(me.word()) || prev.word().length() != 2 || !CHINESE_AND_ARABIC_NUMERALS_PATTERN.matcher(prev.word()).matches()) continue;
            me.set(CoreAnnotations.AnswerAnnotation.class, DATE_TAG);
        }
        return document;
    }

    private static boolean rightScanFindsMoneyWord(List<CoreLabel> pl, int i) {
        int j;
        int sz = pl.size();
        for (j = i; j < sz && pl.get(j).getString(CoreAnnotations.PartOfSpeechAnnotation.class).equals("CD"); ++j) {
        }
        if (j >= sz) {
            return false;
        }
        String tag = pl.get(j).getString(CoreAnnotations.PartOfSpeechAnnotation.class);
        String word = pl.get(j).word();
        return (tag.equals("M") || tag.equals("NN") || tag.equals("NNS")) && CURRENCY_WORD_PATTERN.matcher(word).matches();
    }

    @Override
    public List<CoreLabel> classifyWithGlobalInformation(List<CoreLabel> tokenSequence, CoreMap document, CoreMap sentence) {
        if (this.useSUTime) {
            log.fatal("ChineseNumberSequenceClassifier does not have SUTime implementation.");
        }
        return this.classify(tokenSequence);
    }

    @Override
    public void train(Collection<List<CoreLabel>> docs, DocumentReaderAndWriter<CoreLabel> readerAndWriter) {
    }

    @Override
    public void serializeClassifier(String serializePath) {
    }

    @Override
    public void serializeClassifier(ObjectOutputStream oos) {
    }

    @Override
    public void loadClassifier(ObjectInputStream in, Properties props) throws IOException, ClassCastException, ClassNotFoundException {
    }

    public static void main(String[] args) throws IOException {
    }
}

