/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LabelDictionary
implements Serializable {
    private static final long serialVersionUID = 6790400453922524056L;
    private final boolean DEBUG = false;
    private final int DEFAULT_CAPACITY = 30000;
    private Counter<String> observationCounts = new ClassicCounter<String>(30000);
    private Map<String, Set<String>> observedLabels = Generics.newHashMap(30000);
    private Index<String> observationIndex;
    private int[][] labelDictionary;

    public void increment(String observation, String label) {
        if (this.labelDictionary != null) {
            throw new RuntimeException("Label dictionary is already locked.");
        }
        this.observationCounts.incrementCount(observation);
        if (!this.observedLabels.containsKey(observation)) {
            this.observedLabels.put(observation, new HashSet());
        }
        this.observedLabels.get(observation).add(label.intern());
    }

    public boolean isConstrained(String observation) {
        return this.observationIndex.indexOf(observation) >= 0;
    }

    public int[] getConstrainedSet(String observation) {
        int i = this.observationIndex.indexOf(observation);
        return i >= 0 ? this.labelDictionary[i] : null;
    }

    public void lock(int threshold, Index<String> labelIndex) {
        if (this.labelDictionary != null) {
            throw new RuntimeException("Label dictionary is already locked");
        }
        System.err.println("Label dictionary enabled");
        System.err.printf("#observations: %d%n", (int)this.observationCounts.totalCount());
        Counters.retainAbove(this.observationCounts, (double)threshold);
        Set<String> constrainedObservations = this.observationCounts.keySet();
        this.labelDictionary = new int[constrainedObservations.size()][];
        this.observationIndex = new HashIndex<String>(constrainedObservations.size());
        for (String observation : constrainedObservations) {
            int i = this.observationIndex.addToIndex(observation);
            assert (i < this.labelDictionary.length);
            Set<String> allowedLabels = this.observedLabels.get(observation);
            this.labelDictionary[i] = new int[allowedLabels.size()];
            int j = 0;
            for (String label : allowedLabels) {
                this.labelDictionary[i][j++] = labelIndex.indexOf(label);
            }
        }
        this.observationIndex.lock();
        System.err.printf("#constraints: %d%n", this.labelDictionary.length);
        this.observationCounts = null;
        this.observedLabels = null;
    }
}

