/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.fsm.DFSA;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RegExFileFilter;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.objectbank.ResettableReaderIteratorFactory;
import edu.stanford.nlp.process.CoreLabelTokenFactory;
import edu.stanford.nlp.process.CoreTokenFactory;
import edu.stanford.nlp.sequences.DocumentReaderAndWriter;
import edu.stanford.nlp.sequences.FeatureFactory;
import edu.stanford.nlp.sequences.KBestSequenceFinder;
import edu.stanford.nlp.sequences.LatticeWriter;
import edu.stanford.nlp.sequences.ObjectBankWrapper;
import edu.stanford.nlp.sequences.PlainTextDocumentReaderAndWriter;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.sequences.SequenceModel;
import edu.stanford.nlp.sequences.SequenceSampler;
import edu.stanford.nlp.sequences.ViterbiSearchGraphBuilder;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.Sampler;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.MetaClass;
import edu.stanford.nlp.util.ReflectionLoading;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.Triple;
import edu.stanford.nlp.util.concurrent.MulticoreWrapper;
import edu.stanford.nlp.util.concurrent.ThreadsafeProcessor;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

public abstract class AbstractSequenceClassifier<IN extends CoreMap>
implements Function<String, String> {
    public SeqClassifierFlags flags;
    public Index<String> classIndex;
    public List<FeatureFactory<IN>> featureFactories;
    protected IN pad;
    private CoreTokenFactory<IN> tokenFactory;
    public int windowSize;
    protected Set<String> knownLCWords = null;
    private DocumentReaderAndWriter<IN> defaultReaderAndWriter;
    private DocumentReaderAndWriter<IN> plainTextReaderAndWriter;
    public static final String CUT_LABEL = "Cut";
    private transient PrintWriter cliqueWriter;
    private transient int writtenNum;

    public DocumentReaderAndWriter<IN> defaultReaderAndWriter() {
        return this.defaultReaderAndWriter;
    }

    public DocumentReaderAndWriter<IN> plainTextReaderAndWriter() {
        return this.plainTextReaderAndWriter;
    }

    public AbstractSequenceClassifier(Properties props) {
        this(new SeqClassifierFlags(props));
    }

    public AbstractSequenceClassifier(SeqClassifierFlags flags) {
        this.flags = flags;
        this.featureFactories = Generics.newArrayList();
        if (flags.featureFactory != null) {
            FeatureFactory factory = (FeatureFactory)new MetaClass(flags.featureFactory).createInstance(flags.featureFactoryArgs);
            this.featureFactories.add(factory);
        }
        if (flags.featureFactories != null) {
            for (int i = 0; i < flags.featureFactories.length; ++i) {
                FeatureFactory indFeatureFactory = (FeatureFactory)new MetaClass(flags.featureFactories[i]).createInstance(flags.featureFactoriesArgs.get(i));
                this.featureFactories.add(indFeatureFactory);
            }
        }
        this.tokenFactory = flags.tokenFactory == null ? new CoreLabelTokenFactory() : (CoreTokenFactory)new MetaClass(flags.tokenFactory).createInstance(flags.tokenFactoryArgs);
        this.pad = this.tokenFactory.makeToken();
        this.windowSize = flags.maxLeft + 1;
        this.reinit();
    }

    protected final void reinit() {
        this.pad.set(CoreAnnotations.AnswerAnnotation.class, (String)this.flags.backgroundSymbol);
        this.pad.set(CoreAnnotations.GoldAnswerAnnotation.class, (String)this.flags.backgroundSymbol);
        for (FeatureFactory<IN> featureFactory : this.featureFactories) {
            featureFactory.init(this.flags);
        }
        this.defaultReaderAndWriter = this.makeReaderAndWriter();
        this.plainTextReaderAndWriter = this.flags.readerAndWriter != null && this.flags.readerAndWriter.equals(this.flags.plainTextDocumentReaderAndWriter) ? this.defaultReaderAndWriter : this.makePlainTextReaderAndWriter();
        if (!this.flags.useKnownLCWords) {
            this.knownLCWords = Collections.emptySet();
        } else if (this.knownLCWords == null || this.knownLCWords.isEmpty()) {
            this.knownLCWords = Collections.newSetFromMap(new ConcurrentHashMap());
        }
    }

    public DocumentReaderAndWriter<IN> makeReaderAndWriter() {
        DocumentReaderAndWriter readerAndWriter;
        try {
            readerAndWriter = (DocumentReaderAndWriter)ReflectionLoading.loadByReflection(this.flags.readerAndWriter, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Error loading flags.readerAndWriter: '%s'", this.flags.readerAndWriter), e);
        }
        readerAndWriter.init(this.flags);
        return readerAndWriter;
    }

    public DocumentReaderAndWriter<IN> makePlainTextReaderAndWriter() {
        DocumentReaderAndWriter readerAndWriter;
        String readerClassName = this.flags.plainTextDocumentReaderAndWriter;
        if (readerClassName == null) {
            readerClassName = "edu.stanford.nlp.sequences.PlainTextDocumentReaderAndWriter";
        }
        try {
            readerAndWriter = (DocumentReaderAndWriter)ReflectionLoading.loadByReflection(readerClassName, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Error loading flags.plainTextDocumentReaderAndWriter: '%s'", this.flags.plainTextDocumentReaderAndWriter), e);
        }
        readerAndWriter.init(this.flags);
        return readerAndWriter;
    }

    public String backgroundSymbol() {
        return this.flags.backgroundSymbol;
    }

    public Set<String> labels() {
        return Generics.newHashSet(this.classIndex.objectsList());
    }

    public List<IN> classifySentence(List<? extends HasWord> sentence) {
        ArrayList<Object> document = new ArrayList<Object>();
        int i = 0;
        for (HasWord hasWord : sentence) {
            Object wi;
            if (hasWord instanceof CoreMap) {
                wi = this.tokenFactory.makeToken((CoreMap)((Object)hasWord));
            } else {
                wi = this.tokenFactory.makeToken();
                wi.set(CoreAnnotations.TextAnnotation.class, (String)hasWord.word());
            }
            wi.set(CoreAnnotations.PositionAnnotation.class, (String)Integer.toString(i));
            wi.set(CoreAnnotations.AnswerAnnotation.class, this.backgroundSymbol());
            document.add(wi);
            ++i;
        }
        ObjectBankWrapper<Object> wrapper = new ObjectBankWrapper<Object>(this.flags, null, this.knownLCWords);
        wrapper.processDocument(document);
        this.classify(document);
        return document;
    }

    public List<IN> classifySentenceWithGlobalInformation(List<? extends HasWord> tokenSequence, CoreMap doc, CoreMap sentence) {
        ArrayList<Object> document = new ArrayList<Object>();
        int i = 0;
        for (HasWord hasWord : tokenSequence) {
            Object wi;
            if (hasWord instanceof CoreMap) {
                wi = this.tokenFactory.makeToken((CoreMap)((Object)hasWord));
            } else {
                wi = this.tokenFactory.makeToken();
                wi.set(CoreAnnotations.TextAnnotation.class, (String)hasWord.word());
            }
            wi.set(CoreAnnotations.PositionAnnotation.class, (String)Integer.toString(i));
            wi.set(CoreAnnotations.AnswerAnnotation.class, this.backgroundSymbol());
            document.add(wi);
            ++i;
        }
        ObjectBankWrapper<Object> wrapper = new ObjectBankWrapper<Object>(this.flags, null, this.knownLCWords);
        wrapper.processDocument(document);
        this.classifyWithGlobalInformation(document, doc, sentence);
        return document;
    }

    public SequenceModel getSequenceModel(List<IN> doc) {
        throw new UnsupportedOperationException();
    }

    public Sampler<List<IN>> getSampler(final List<IN> input) {
        return new Sampler<List<IN>>(){
            SequenceModel model;
            SequenceSampler sampler;
            {
                this.model = AbstractSequenceClassifier.this.getSequenceModel(input);
                this.sampler = new SequenceSampler();
            }

            @Override
            public List<IN> drawSample() {
                int[] sampleArray = this.sampler.bestSequence(this.model);
                ArrayList<CoreMap> sample = new ArrayList<CoreMap>();
                int i = 0;
                for (CoreMap word : input) {
                    CoreMap newWord = AbstractSequenceClassifier.this.tokenFactory.makeToken(word);
                    newWord.set(CoreAnnotations.AnswerAnnotation.class, AbstractSequenceClassifier.this.classIndex.get(sampleArray[i++]));
                    sample.add(newWord);
                }
                return sample;
            }
        };
    }

    public Counter<List<IN>> classifyKBest(List<IN> doc, Class<? extends CoreAnnotation<String>> answerField, int k) {
        if (doc.isEmpty()) {
            return new ClassicCounter<List<IN>>();
        }
        ObjectBankWrapper<IN> obw = new ObjectBankWrapper<IN>(this.flags, null, this.knownLCWords);
        doc = obw.processDocument(doc);
        SequenceModel model = this.getSequenceModel(doc);
        KBestSequenceFinder tagInference = new KBestSequenceFinder();
        Counter<int[]> bestSequences = tagInference.kBestSequences(model, k);
        ClassicCounter<List<IN>> kBest = new ClassicCounter<List<IN>>();
        for (int[] seq : bestSequences.keySet()) {
            ArrayList<CoreMap> kth = new ArrayList<CoreMap>();
            int pos = model.leftWindow();
            for (CoreMap fi : doc) {
                CoreMap newFL = this.tokenFactory.makeToken(fi);
                String guess = this.classIndex.get(seq[pos]);
                fi.remove(CoreAnnotations.AnswerAnnotation.class);
                newFL.set(answerField, guess);
                ++pos;
                kth.add(newFL);
            }
            kBest.setCount(kth, bestSequences.getCount(seq));
        }
        return kBest;
    }

    public DFSA<String, Integer> getViterbiSearchGraph(List<IN> doc, Class<? extends CoreAnnotation<String>> answerField) {
        if (doc.isEmpty()) {
            return new DFSA<String, Integer>(null);
        }
        ObjectBankWrapper<IN> obw = new ObjectBankWrapper<IN>(this.flags, null, this.knownLCWords);
        doc = obw.processDocument(doc);
        SequenceModel model = this.getSequenceModel(doc);
        return ViterbiSearchGraphBuilder.getGraph(model, this.classIndex);
    }

    public List<List<IN>> classify(String str) {
        ObjectBank<List<IN>> documents = this.makeObjectBankFromString(str, this.plainTextReaderAndWriter);
        ArrayList<List<IN>> result = new ArrayList<List<IN>>();
        for (List<IN> document : documents) {
            this.classify(document);
            ArrayList<CoreMap> sentence = new ArrayList<CoreMap>();
            for (CoreMap wi : document) {
                sentence.add(wi);
            }
            result.add(sentence);
        }
        return result;
    }

    public List<List<IN>> classifyRaw(String str, DocumentReaderAndWriter<IN> readerAndWriter) {
        ObjectBank<List<IN>> documents = this.makeObjectBankFromString(str, readerAndWriter);
        ArrayList<List<IN>> result = new ArrayList<List<IN>>();
        for (List<IN> document : documents) {
            this.classify(document);
            ArrayList<CoreMap> sentence = new ArrayList<CoreMap>();
            for (CoreMap wi : document) {
                sentence.add(wi);
            }
            result.add(sentence);
        }
        return result;
    }

    public List<List<IN>> classifyFile(String filename) {
        ObjectBank<List<IN>> documents = this.makeObjectBankFromFile(filename, this.plainTextReaderAndWriter);
        ArrayList<List<IN>> result = new ArrayList<List<IN>>();
        for (List<IN> document : documents) {
            this.classify(document);
            ArrayList<CoreMap> sentence = new ArrayList<CoreMap>();
            for (CoreMap wi : document) {
                sentence.add(wi);
            }
            result.add(sentence);
        }
        return result;
    }

    @Override
    public String apply(String in) {
        return this.classifyWithInlineXML(in);
    }

    public String classifyToString(String sentences, String outputFormat, boolean preserveSpacing) {
        PlainTextDocumentReaderAndWriter.OutputStyle outFormat = PlainTextDocumentReaderAndWriter.OutputStyle.fromShortName(outputFormat);
        ObjectBank<List<IN>> documents = this.makeObjectBankFromString(sentences, this.plainTextReaderAndWriter);
        StringBuilder sb = new StringBuilder();
        for (List<IN> doc : documents) {
            List<IN> docOutput = this.classify(doc);
            if (this.plainTextReaderAndWriter instanceof PlainTextDocumentReaderAndWriter) {
                sb.append(((PlainTextDocumentReaderAndWriter)this.plainTextReaderAndWriter).getAnswers(docOutput, outFormat, preserveSpacing));
                continue;
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.plainTextReaderAndWriter.printAnswers(docOutput, pw);
            pw.flush();
            sb.append(sw.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public String classifyWithInlineXML(String sentences) {
        return this.classifyToString(sentences, "inlineXML", true);
    }

    public String classifyToString(String sentences) {
        return this.classifyToString(sentences, "slashTags", true);
    }

    public List<Triple<String, Integer, Integer>> classifyToCharacterOffsets(String sentences) {
        ObjectBank<List<IN>> documents = this.makeObjectBankFromString(sentences, this.plainTextReaderAndWriter);
        ArrayList<Triple<String, Integer, Integer>> entities = new ArrayList<Triple<String, Integer, Integer>>();
        for (List<IN> doc : documents) {
            String prevEntityType = this.flags.backgroundSymbol;
            Triple prevEntity = null;
            this.classify(doc);
            for (CoreMap fl : doc) {
                String guessedAnswer = (String)fl.get(CoreAnnotations.AnswerAnnotation.class);
                if (guessedAnswer.equals(this.flags.backgroundSymbol)) {
                    if (prevEntity != null) {
                        entities.add(prevEntity);
                        prevEntity = null;
                    }
                } else if (!guessedAnswer.equals(prevEntityType)) {
                    if (prevEntity != null) {
                        entities.add(prevEntity);
                    }
                    prevEntity = new Triple(guessedAnswer, fl.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class), fl.get(CoreAnnotations.CharacterOffsetEndAnnotation.class));
                } else {
                    assert (prevEntity != null);
                    prevEntity.setThird(fl.get(CoreAnnotations.CharacterOffsetEndAnnotation.class));
                }
                prevEntityType = guessedAnswer;
            }
            if (prevEntity == null) continue;
            entities.add(prevEntity);
        }
        return entities;
    }

    public List<String> segmentString(String sentence) {
        return this.segmentString(sentence, this.defaultReaderAndWriter);
    }

    public List<String> segmentString(String sentence, DocumentReaderAndWriter<IN> readerAndWriter) {
        ObjectBank<List<IN>> docs = this.makeObjectBankFromString(sentence, readerAndWriter);
        StringWriter stringWriter = new StringWriter();
        PrintWriter stringPrintWriter = new PrintWriter(stringWriter);
        for (List<IN> doc : docs) {
            this.classify(doc);
            readerAndWriter.printAnswers(doc, stringPrintWriter);
            stringPrintWriter.println();
        }
        stringPrintWriter.close();
        String segmented = stringWriter.toString();
        return Arrays.asList(segmented.split("\\s"));
    }

    public abstract List<IN> classify(List<IN> var1);

    public abstract List<IN> classifyWithGlobalInformation(List<IN> var1, CoreMap var2, CoreMap var3);

    public void finalizeClassification(CoreMap document) {
    }

    public void train() {
        if (this.flags.trainFiles != null) {
            this.train(this.flags.baseTrainDir, this.flags.trainFiles, this.defaultReaderAndWriter);
        } else if (this.flags.trainFileList != null) {
            String[] files = this.flags.trainFileList.split(",");
            this.train(files, this.defaultReaderAndWriter);
        } else {
            this.train(this.flags.trainFile, this.defaultReaderAndWriter);
        }
    }

    public void train(String filename) {
        this.train(filename, this.defaultReaderAndWriter);
    }

    public void train(String filename, DocumentReaderAndWriter<IN> readerAndWriter) {
        this.flags.ocrTrain = true;
        this.train(this.makeObjectBankFromFile(filename, readerAndWriter), readerAndWriter);
    }

    public void train(String baseTrainDir, String trainFiles, DocumentReaderAndWriter<IN> readerAndWriter) {
        this.flags.ocrTrain = true;
        this.train(this.makeObjectBankFromFiles(baseTrainDir, trainFiles, readerAndWriter), readerAndWriter);
    }

    public void train(String[] trainFileList, DocumentReaderAndWriter<IN> readerAndWriter) {
        this.flags.ocrTrain = true;
        this.train(this.makeObjectBankFromFiles(trainFileList, readerAndWriter), readerAndWriter);
    }

    public void train(Collection<List<IN>> docs) {
        this.train(docs, this.defaultReaderAndWriter);
    }

    public abstract void train(Collection<List<IN>> var1, DocumentReaderAndWriter<IN> var2);

    public ObjectBank<List<IN>> makeObjectBankFromString(String string, DocumentReaderAndWriter<IN> readerAndWriter) {
        if (this.flags.announceObjectBankEntries) {
            System.err.print("Reading data using " + readerAndWriter.getClass());
            if (this.flags.inputEncoding == null) {
                System.err.println("Getting data from " + string + " (default encoding)");
            } else {
                System.err.println("Getting data from " + string + " (" + this.flags.inputEncoding + " encoding)");
            }
        }
        return new ObjectBankWrapper(this.flags, new ObjectBank(new ResettableReaderIteratorFactory(string), readerAndWriter), this.knownLCWords);
    }

    public ObjectBank<List<IN>> makeObjectBankFromFile(String filename) {
        return this.makeObjectBankFromFile(filename, this.defaultReaderAndWriter);
    }

    public ObjectBank<List<IN>> makeObjectBankFromFile(String filename, DocumentReaderAndWriter<IN> readerAndWriter) {
        String[] fileAsArray = new String[]{filename};
        return this.makeObjectBankFromFiles(fileAsArray, readerAndWriter);
    }

    public ObjectBank<List<IN>> makeObjectBankFromFiles(String[] trainFileList, DocumentReaderAndWriter<IN> readerAndWriter) {
        ArrayList<File> files = new ArrayList<File>();
        for (String trainFile : trainFileList) {
            File f = new File(trainFile);
            files.add(f);
        }
        return new ObjectBankWrapper(this.flags, new ObjectBank(new ResettableReaderIteratorFactory(files, this.flags.inputEncoding), readerAndWriter), this.knownLCWords);
    }

    public ObjectBank<List<IN>> makeObjectBankFromFiles(String baseDir, String filePattern, DocumentReaderAndWriter<IN> readerAndWriter) {
        File path = new File(baseDir);
        RegExFileFilter filter = new RegExFileFilter(Pattern.compile(filePattern));
        File[] origFiles = path.listFiles(filter);
        ArrayList<File> files = new ArrayList<File>();
        for (File file : origFiles) {
            if (!file.isFile()) continue;
            if (this.flags.announceObjectBankEntries) {
                System.err.println("Getting data from " + file + " (" + this.flags.inputEncoding + " encoding)");
            }
            files.add(file);
        }
        if (files.isEmpty()) {
            throw new RuntimeException("No matching files: " + baseDir + '\t' + filePattern);
        }
        return new ObjectBankWrapper(this.flags, new ObjectBank(new ResettableReaderIteratorFactory(files, this.flags.inputEncoding), readerAndWriter), this.knownLCWords);
    }

    public ObjectBank<List<IN>> makeObjectBankFromFiles(Collection<File> files, DocumentReaderAndWriter<IN> readerAndWriter) {
        if (files.isEmpty()) {
            throw new RuntimeException("Attempt to make ObjectBank with empty file list");
        }
        return new ObjectBankWrapper(this.flags, new ObjectBank(new ResettableReaderIteratorFactory(files, this.flags.inputEncoding), readerAndWriter), this.knownLCWords);
    }

    public ObjectBank<List<IN>> makeObjectBankFromReader(BufferedReader in, DocumentReaderAndWriter<IN> readerAndWriter) {
        if (this.flags.announceObjectBankEntries) {
            System.err.println("Reading data using " + readerAndWriter.getClass());
        }
        return new ObjectBankWrapper(this.flags, new ObjectBank(new ResettableReaderIteratorFactory(in), readerAndWriter), this.knownLCWords);
    }

    public void printProbs(String filename, DocumentReaderAndWriter<IN> readerAndWriter) {
        this.flags.ocrTrain = false;
        ObjectBank<List<IN>> docs = this.makeObjectBankFromFile(filename, readerAndWriter);
        this.printProbsDocuments(docs);
    }

    public void printProbsDocuments(ObjectBank<List<IN>> documents) {
        for (List<IN> doc : documents) {
            this.printProbsDocument(doc);
            System.out.println();
        }
    }

    public void classifyStdin() throws IOException {
        this.classifyStdin(this.plainTextReaderAndWriter);
    }

    public void classifyStdin(DocumentReaderAndWriter<IN> readerWriter) throws IOException {
        String line;
        BufferedReader is = IOUtils.readerFromStdin(this.flags.inputEncoding);
        while ((line = is.readLine()) != null) {
            Collection<List<Object>> documents = this.makeObjectBankFromString(line, readerWriter);
            if (this.flags.keepEmptySentences && documents.size() == 0) {
                documents = Collections.singletonList(Collections.emptyList());
            }
            this.classifyAndWriteAnswers(documents, readerWriter, false);
        }
    }

    public abstract void printProbsDocument(List<IN> var1);

    public void classifyAndWriteAnswers(String testFile) throws IOException {
        this.classifyAndWriteAnswers(testFile, this.plainTextReaderAndWriter, false);
    }

    public void classifyAndWriteAnswers(String testFile, DocumentReaderAndWriter<IN> readerWriter, boolean outputScores) throws IOException {
        ObjectBank<List<IN>> documents = this.makeObjectBankFromFile(testFile, readerWriter);
        this.classifyAndWriteAnswers(documents, readerWriter, outputScores);
    }

    public void classifyAndWriteAnswers(String testFile, OutputStream outStream, DocumentReaderAndWriter<IN> readerWriter, boolean outputScores) throws IOException {
        ObjectBank<List<IN>> documents = this.makeObjectBankFromFile(testFile, readerWriter);
        PrintWriter pw = IOUtils.encodedOutputStreamPrintWriter(outStream, this.flags.outputEncoding, true);
        this.classifyAndWriteAnswers(documents, pw, readerWriter, outputScores);
    }

    public void classifyAndWriteAnswers(String baseDir, String filePattern, DocumentReaderAndWriter<IN> readerWriter, boolean outputScores) throws IOException {
        ObjectBank<List<IN>> documents = this.makeObjectBankFromFiles(baseDir, filePattern, readerWriter);
        this.classifyAndWriteAnswers(documents, readerWriter, outputScores);
    }

    public void classifyFilesAndWriteAnswers(Collection<File> testFiles) throws IOException {
        this.classifyFilesAndWriteAnswers(testFiles, this.plainTextReaderAndWriter, false);
    }

    public void classifyFilesAndWriteAnswers(Collection<File> testFiles, DocumentReaderAndWriter<IN> readerWriter, boolean outputScores) throws IOException {
        ObjectBank<List<IN>> documents = this.makeObjectBankFromFiles(testFiles, readerWriter);
        this.classifyAndWriteAnswers(documents, readerWriter, outputScores);
    }

    public void classifyAndWriteAnswers(Collection<List<IN>> documents, DocumentReaderAndWriter<IN> readerWriter, boolean outputScores) throws IOException {
        this.classifyAndWriteAnswers(documents, IOUtils.encodedOutputStreamPrintWriter(System.out, this.flags.outputEncoding, true), readerWriter, outputScores);
    }

    public void dumpFeatures(Collection<List<IN>> documents) {
    }

    public void classifyAndWriteAnswers(Collection<List<IN>> documents, PrintWriter printWriter, DocumentReaderAndWriter<IN> readerWriter, boolean outputScores) throws IOException {
        if (this.flags.exportFeatures != null) {
            this.dumpFeatures(documents);
        }
        Timing timer = new Timing();
        ClassicCounter<String> entityTP = new ClassicCounter<String>();
        ClassicCounter<String> entityFP = new ClassicCounter<String>();
        ClassicCounter<String> entityFN = new ClassicCounter<String>();
        boolean resultsCounted = outputScores;
        int numWords = 0;
        int numDocs = 0;
        final AtomicInteger threadCompletionCounter = new AtomicInteger(0);
        ThreadsafeProcessor threadProcessor = new ThreadsafeProcessor<List<IN>, List<IN>>(){

            @Override
            public List<IN> process(List<IN> doc) {
                doc = AbstractSequenceClassifier.this.classify(doc);
                int completedNo = threadCompletionCounter.incrementAndGet();
                if (AbstractSequenceClassifier.this.flags.verboseMode) {
                    System.err.println(completedNo + " examples completed");
                }
                return doc;
            }

            @Override
            public ThreadsafeProcessor<List<IN>, List<IN>> newInstance() {
                return this;
            }
        };
        MulticoreWrapper wrapper = null;
        if (this.flags.multiThreadClassifier != 0) {
            wrapper = new MulticoreWrapper(this.flags.multiThreadClassifier, threadProcessor);
        }
        for (List<IN> doc : documents) {
            List results;
            numWords += doc.size();
            ++numDocs;
            if (this.flags.multiThreadClassifier != 0) {
                wrapper.put(doc);
                while (wrapper.peek()) {
                    results = (List)wrapper.poll();
                    this.writeAnswers(results, printWriter, readerWriter);
                    resultsCounted = resultsCounted && this.countResults(results, entityTP, entityFP, entityFN);
                }
                continue;
            }
            results = (List)threadProcessor.process(doc);
            this.writeAnswers(results, printWriter, readerWriter);
            resultsCounted = resultsCounted && this.countResults(results, entityTP, entityFP, entityFN);
        }
        if (this.flags.multiThreadClassifier != 0) {
            wrapper.join();
            while (wrapper.peek()) {
                List results = (List)wrapper.poll();
                this.writeAnswers(results, printWriter, readerWriter);
                resultsCounted = resultsCounted && this.countResults(results, entityTP, entityFP, entityFN);
            }
        }
        long millis = timer.stop();
        double wordspersec = (double)numWords / ((double)millis / 1000.0);
        DecimalFormat nf = new DecimalFormat("0.00");
        System.err.println(StringUtils.getShortClassName(this) + " tagged " + numWords + " words in " + numDocs + " documents at " + nf.format(wordspersec) + " words per second.");
        if (resultsCounted) {
            AbstractSequenceClassifier.printResults(entityTP, entityFP, entityFN);
        }
    }

    public void classifyAndWriteAnswersKBest(String testFile, int k, DocumentReaderAndWriter<IN> readerAndWriter) throws IOException {
        ObjectBank<List<IN>> documents = this.makeObjectBankFromFile(testFile, readerAndWriter);
        PrintWriter pw = IOUtils.encodedOutputStreamPrintWriter(System.out, this.flags.outputEncoding, true);
        this.classifyAndWriteAnswersKBest(documents, k, pw, readerAndWriter);
    }

    public void classifyAndWriteAnswersKBest(ObjectBank<List<IN>> documents, int k, PrintWriter printWriter, DocumentReaderAndWriter<IN> readerAndWriter) throws IOException {
        Timing timer = new Timing();
        int numWords = 0;
        int numSentences = 0;
        for (List<IN> doc : documents) {
            Counter<List<IN>> kBest = this.classifyKBest(doc, CoreAnnotations.AnswerAnnotation.class, k);
            numWords += doc.size();
            List<List<IN>> sorted = Counters.toSortedList(kBest);
            int n = 1;
            for (List<IN> l : sorted) {
                System.out.println("<sentence id=" + numSentences + " k=" + n + " logProb=" + kBest.getCount(l) + " prob=" + Math.exp(kBest.getCount(l)) + '>');
                this.writeAnswers(l, printWriter, readerAndWriter);
                System.out.println("</sentence>");
                ++n;
            }
            ++numSentences;
        }
        long millis = timer.stop();
        double wordspersec = (double)numWords / ((double)millis / 1000.0);
        DecimalFormat nf = new DecimalFormat("0.00");
        System.err.println(this.getClass().getName() + " tagged " + numWords + " words in " + numSentences + " documents at " + nf.format(wordspersec) + " words per second.");
    }

    public void classifyAndWriteViterbiSearchGraph(String testFile, String searchGraphPrefix, DocumentReaderAndWriter<IN> readerAndWriter) throws IOException {
        Timing timer = new Timing();
        ObjectBank<List<IN>> documents = this.makeObjectBankFromFile(testFile, readerAndWriter);
        int numWords = 0;
        int numSentences = 0;
        for (List<IN> doc : documents) {
            DFSA<String, Integer> tagLattice = this.getViterbiSearchGraph(doc, CoreAnnotations.AnswerAnnotation.class);
            numWords += doc.size();
            PrintWriter latticeWriter = new PrintWriter(new FileOutputStream(searchGraphPrefix + '.' + numSentences + ".wlattice"));
            PrintWriter vsgWriter = new PrintWriter(new FileOutputStream(searchGraphPrefix + '.' + numSentences + ".lattice"));
            if (readerAndWriter instanceof LatticeWriter) {
                ((LatticeWriter)((Object)readerAndWriter)).printLattice(tagLattice, doc, latticeWriter);
            }
            tagLattice.printAttFsmFormat(vsgWriter);
            latticeWriter.close();
            vsgWriter.close();
            ++numSentences;
        }
        long millis = timer.stop();
        double wordspersec = (double)numWords / ((double)millis / 1000.0);
        DecimalFormat nf = new DecimalFormat("0.00");
        System.err.println(this.getClass().getName() + " tagged " + numWords + " words in " + numSentences + " documents at " + nf.format(wordspersec) + " words per second.");
    }

    public void writeAnswers(List<IN> doc, PrintWriter printWriter, DocumentReaderAndWriter<IN> readerAndWriter) throws IOException {
        if (this.flags.lowerNewgeneThreshold) {
            return;
        }
        if (this.flags.numRuns <= 1) {
            readerAndWriter.printAnswers(doc, printWriter);
            printWriter.flush();
        }
    }

    public boolean countResults(List<IN> doc, Counter<String> entityTP, Counter<String> entityFP, Counter<String> entityFN) {
        String bg;
        String string = bg = this.flags.evaluateBackground ? null : this.flags.backgroundSymbol;
        if (this.flags.entitySubclassification.equalsIgnoreCase("iob2")) {
            bg = this.flags.backgroundSymbol;
            return AbstractSequenceClassifier.countResultsIOB2(doc, entityTP, entityFP, entityFN, bg);
        }
        if (this.flags.iobTags) {
            bg = this.flags.backgroundSymbol;
            return AbstractSequenceClassifier.countResultsIOB(doc, entityTP, entityFP, entityFN, bg);
        }
        if (this.flags.sighanPostProcessing) {
            return AbstractSequenceClassifier.countResultsSegmenter(doc, entityTP, entityFP, entityFN);
        }
        return AbstractSequenceClassifier.countResults(doc, entityTP, entityFP, entityFN, bg);
    }

    public static boolean countResultsSegmenter(List<? extends CoreMap> doc, Counter<String> entityTP, Counter<String> entityFP, Counter<String> entityFN) {
        for (int i = 1; i < doc.size(); ++i) {
            CoreMap word = doc.get(i);
            String gold = (String)word.get(CoreAnnotations.GoldAnswerAnnotation.class);
            String guess = (String)word.get(CoreAnnotations.AnswerAnnotation.class);
            if (gold == null || guess == null) {
                return false;
            }
            if (gold.equals("1") && guess.equals("1")) {
                entityTP.incrementCount(CUT_LABEL, 1.0);
                continue;
            }
            if (gold.equals("0") && guess.equals("1")) {
                entityFP.incrementCount(CUT_LABEL, 1.0);
                continue;
            }
            if (!gold.equals("1") || !guess.equals("0")) continue;
            entityFN.incrementCount(CUT_LABEL, 1.0);
        }
        return true;
    }

    public static boolean countResultsIOB2(List<? extends CoreMap> doc, Counter<String> entityTP, Counter<String> entityFP, Counter<String> entityFN, String background) {
        boolean entityCorrect = true;
        String previousGold = background;
        String previousGuess = background;
        String previousGoldEntity = "";
        String previousGuessEntity = "";
        for (CoreMap coreMap : doc) {
            boolean guessEnded;
            String gold = (String)coreMap.get(CoreAnnotations.GoldAnswerAnnotation.class);
            String guess = (String)coreMap.get(CoreAnnotations.AnswerAnnotation.class);
            String goldEntity = !gold.equals(background) ? gold.substring(2) : "";
            String guessEntity = !guess.equals(background) ? guess.substring(2) : "";
            boolean newGold = !gold.equals(background) && !goldEntity.equals(previousGoldEntity) || gold.startsWith("B-");
            boolean newGuess = !guess.equals(background) && !guessEntity.equals(previousGuessEntity) || guess.startsWith("B-");
            boolean goldEnded = !previousGold.equals(background) && (gold.startsWith("B-") || !goldEntity.equals(previousGoldEntity));
            boolean bl = guessEnded = !previousGuess.equals(background) && (guess.startsWith("B-") || !guessEntity.equals(previousGuessEntity));
            if (goldEnded && !guessEnded) {
                entityFN.incrementCount(previousGoldEntity, 1.0);
                boolean bl2 = entityCorrect = gold.equals(background) && guess.equals(background);
            }
            if (goldEnded && guessEnded) {
                if (entityCorrect) {
                    entityTP.incrementCount(previousGoldEntity, 1.0);
                } else {
                    entityFN.incrementCount(previousGoldEntity, 1.0);
                    entityFP.incrementCount(previousGuessEntity, 1.0);
                }
                entityCorrect = gold.equals(guess);
            }
            if (!goldEnded && guessEnded) {
                entityCorrect = false;
                entityFP.incrementCount(previousGuessEntity, 1.0);
            }
            if (newGold && !newGuess) {
                entityCorrect = false;
            }
            if (newGold && newGuess) {
                entityCorrect = guessEntity.equals(goldEntity);
            }
            if (!newGold && newGuess) {
                entityCorrect = false;
            }
            previousGold = gold;
            previousGuess = guess;
            previousGoldEntity = goldEntity;
            previousGuessEntity = guessEntity;
        }
        if (!previousGold.equals(background)) {
            if (entityCorrect) {
                entityTP.incrementCount(previousGoldEntity, 1.0);
            } else {
                entityFN.incrementCount(previousGoldEntity, 1.0);
            }
        }
        if (!previousGuess.equals(background) && !entityCorrect) {
            entityFP.incrementCount(previousGuessEntity, 1.0);
        }
        return true;
    }

    public static boolean countResultsIOB(List<? extends CoreMap> doc, Counter<String> entityTP, Counter<String> entityFP, Counter<String> entityFN, String background) {
        for (CoreMap coreMap : doc) {
            String gold = (String)coreMap.get(CoreAnnotations.GoldAnswerAnnotation.class);
            String guess = (String)coreMap.get(CoreAnnotations.AnswerAnnotation.class);
            if (gold == null) {
                System.err.println("Blank gold answer");
                return false;
            }
            if (guess == null) {
                System.err.println("Blank guess");
                return false;
            }
            if (!(gold.equals(background) || gold.startsWith("B-") || gold.startsWith("I-"))) {
                System.err.println("Unexpected gold answer " + gold);
                return false;
            }
            if (guess.equals(background) || guess.startsWith("B-") || guess.startsWith("I-")) continue;
            System.err.println("Unexpected guess " + guess);
            return false;
        }
        int index = 0;
        while (index < doc.size()) {
            index = AbstractSequenceClassifier.tallyOneEntityIOB(doc, index, CoreAnnotations.GoldAnswerAnnotation.class, CoreAnnotations.AnswerAnnotation.class, entityTP, entityFN, background);
        }
        index = 0;
        while (index < doc.size()) {
            index = AbstractSequenceClassifier.tallyOneEntityIOB(doc, index, CoreAnnotations.AnswerAnnotation.class, CoreAnnotations.GoldAnswerAnnotation.class, null, entityFP, background);
        }
        return true;
    }

    public static int tallyOneEntityIOB(List<? extends CoreMap> doc, int index, Class<? extends CoreAnnotation<String>> source, Class<? extends CoreAnnotation<String>> target, Counter<String> positive, Counter<String> negative, String background) {
        CoreMap line = doc.get(index);
        String gold = (String)line.get(source);
        String guess = (String)line.get(target);
        if (gold.equals(background)) {
            return index + 1;
        }
        String entity = gold.substring(2);
        boolean correct = gold.equals(guess);
        ++index;
        while (index < doc.size()) {
            line = doc.get(index);
            gold = (String)line.get(source);
            guess = (String)line.get(target);
            if (!gold.equals("I-" + entity)) {
                if (!guess.equals("I-" + entity)) break;
                correct = false;
                break;
            }
            if (!gold.equals(guess)) {
                correct = false;
            }
            ++index;
        }
        if (correct) {
            if (positive != null) {
                positive.incrementCount(entity, 1.0);
            }
        } else {
            negative.incrementCount(entity, 1.0);
        }
        return index;
    }

    public static boolean countResults(List<? extends CoreMap> doc, Counter<String> entityTP, Counter<String> entityFP, Counter<String> entityFN, String background) {
        int index = 0;
        int goldIndex = 0;
        int guessIndex = 0;
        String lastGold = background;
        String lastGuess = background;
        for (CoreMap coreMap : doc) {
            String gold = (String)coreMap.get(CoreAnnotations.GoldAnswerAnnotation.class);
            String guess = (String)coreMap.get(CoreAnnotations.AnswerAnnotation.class);
            if (gold == null || guess == null) {
                return false;
            }
            if (lastGold != null && !lastGold.equals(gold) && !lastGold.equals(background)) {
                if (lastGuess.equals(lastGold) && !lastGuess.equals(guess) && goldIndex == guessIndex) {
                    entityTP.incrementCount(lastGold, 1.0);
                } else {
                    entityFN.incrementCount(lastGold, 1.0);
                }
            }
            if (!(lastGuess == null || lastGuess.equals(guess) || lastGuess.equals(background) || lastGuess.equals(lastGold) && !lastGuess.equals(guess) && goldIndex == guessIndex && !lastGold.equals(gold))) {
                entityFP.incrementCount(lastGuess, 1.0);
            }
            if (lastGold == null || !lastGold.equals(gold)) {
                lastGold = gold;
                goldIndex = index;
            }
            if (lastGuess == null || !lastGuess.equals(guess)) {
                lastGuess = guess;
                guessIndex = index;
            }
            ++index;
        }
        if (lastGold != null && !lastGold.equals(background)) {
            if (lastGold.equals(lastGuess) && goldIndex == guessIndex) {
                entityTP.incrementCount(lastGold, 1.0);
            } else {
                entityFN.incrementCount(lastGold, 1.0);
            }
        }
        if (!(lastGuess == null || lastGuess.equals(background) || lastGold.equals(lastGuess) && goldIndex == guessIndex)) {
            entityFP.incrementCount(lastGuess, 1.0);
        }
        return true;
    }

    public static void printResults(Counter<String> entityTP, Counter<String> entityFP, Counter<String> entityFN) {
        TreeSet<String> entities = new TreeSet<String>();
        entities.addAll(entityTP.keySet());
        entities.addAll(entityFP.keySet());
        entities.addAll(entityFN.keySet());
        boolean printedHeader = false;
        for (String entity : entities) {
            double tp = entityTP.getCount(entity);
            double fp = entityFP.getCount(entity);
            double fn = entityFN.getCount(entity);
            printedHeader = AbstractSequenceClassifier.printPRLine(entity, tp, fp, fn, printedHeader);
        }
        double tp = entityTP.totalCount();
        double fp = entityFP.totalCount();
        double fn = entityFN.totalCount();
        printedHeader = AbstractSequenceClassifier.printPRLine("Totals", tp, fp, fn, printedHeader);
    }

    private static boolean printPRLine(String entity, double tp, double fp, double fn, boolean printedHeader) {
        double f1;
        if (tp == 0.0 && (fp == 0.0 || fn == 0.0)) {
            return printedHeader;
        }
        double precision = tp / (tp + fp);
        double recall = tp / (tp + fn);
        double d = f1 = precision == 0.0 || recall == 0.0 ? 0.0 : 2.0 / (1.0 / precision + 1.0 / recall);
        if (!printedHeader) {
            System.err.println("         Entity\tP\tR\tF1\tTP\tFP\tFN");
            printedHeader = true;
        }
        System.err.format("%15s\t%.4f\t%.4f\t%.4f\t%.0f\t%.0f\t%.0f\n", entity, precision, recall, f1, tp, fp, fn);
        return printedHeader;
    }

    public abstract void serializeClassifier(String var1);

    public void loadClassifierNoExceptions(InputStream in, Properties props) {
        try {
            this.loadClassifier(in, props);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
    }

    public void loadClassifier(InputStream in) throws IOException, ClassCastException, ClassNotFoundException {
        this.loadClassifier(in, null);
    }

    public void loadClassifier(InputStream in, Properties props) throws IOException, ClassCastException, ClassNotFoundException {
        this.loadClassifier(new ObjectInputStream(in), props);
    }

    public abstract void loadClassifier(ObjectInputStream var1, Properties var2) throws IOException, ClassCastException, ClassNotFoundException;

    private InputStream loadStreamFromClasspath(String path) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(path);
        if (is == null) {
            return null;
        }
        try {
            is = path.endsWith(".gz") ? new GZIPInputStream(new BufferedInputStream(is)) : new BufferedInputStream(is);
        }
        catch (IOException e) {
            System.err.println("CLASSPATH resource " + path + " is not a GZIP stream!");
        }
        return is;
    }

    public void loadClassifier(String loadPath) throws ClassCastException, IOException, ClassNotFoundException {
        this.loadClassifier(loadPath, null);
    }

    public void loadClassifier(String loadPath, Properties props) throws ClassCastException, IOException, ClassNotFoundException {
        InputStream is = this.loadStreamFromClasspath(loadPath);
        if (is != null) {
            Timing.startDoing("Loading classifier from " + loadPath);
            this.loadClassifier(is, props);
            is.close();
            Timing.endDoing();
        } else {
            this.loadClassifier(new File(loadPath), props);
        }
    }

    public void loadClassifierNoExceptions(String loadPath) {
        this.loadClassifierNoExceptions(loadPath, null);
    }

    public void loadClassifierNoExceptions(String loadPath, Properties props) {
        InputStream is = this.loadStreamFromClasspath(loadPath);
        if (is != null) {
            Timing.startDoing("Loading classifier from " + loadPath);
            this.loadClassifierNoExceptions(is, props);
            try {
                is.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Timing.endDoing();
        } else {
            this.loadClassifierNoExceptions(new File(loadPath), props);
        }
    }

    public void loadClassifier(File file) throws ClassCastException, IOException, ClassNotFoundException {
        this.loadClassifier(file, null);
    }

    public void loadClassifier(File file, Properties props) throws ClassCastException, IOException, ClassNotFoundException {
        Timing.startDoing("Loading classifier from " + file.getAbsolutePath());
        BufferedInputStream bis = file.getName().endsWith(".gz") ? new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))) : new BufferedInputStream(new FileInputStream(file));
        this.loadClassifier(bis, props);
        bis.close();
        Timing.endDoing();
    }

    public void loadClassifierNoExceptions(File file) {
        this.loadClassifierNoExceptions(file, null);
    }

    public void loadClassifierNoExceptions(File file, Properties props) {
        try {
            this.loadClassifier(file, props);
        }
        catch (Exception e) {
            System.err.println("Error deserializing " + file.getAbsolutePath());
            throw new RuntimeException(e);
        }
    }

    public void loadJarClassifier(String modelName, Properties props) {
        Timing.startDoing("Loading JAR-internal classifier " + modelName);
        try {
            InputStream is = this.getClass().getResourceAsStream(modelName);
            if (modelName.endsWith(".gz")) {
                is = new GZIPInputStream(is);
            }
            is = new BufferedInputStream(is);
            this.loadClassifier(is, props);
            is.close();
            Timing.endDoing();
        }
        catch (Exception e) {
            String msg = "Error loading classifier from jar file (most likely you are not running this code from a jar file or the named classifier is not stored in the jar file)";
            throw new RuntimeException(msg, e);
        }
    }

    protected void printFeatures(IN wi, Collection<String> features) {
        if (this.flags.printFeatures == null || this.writtenNum >= this.flags.printFeaturesUpto) {
            return;
        }
        if (this.cliqueWriter == null) {
            this.cliqueWriter = IOUtils.getPrintWriterOrDie("features-" + this.flags.printFeatures + ".txt");
            this.writtenNum = 0;
        }
        if (wi instanceof CoreLabel) {
            this.cliqueWriter.print((String)wi.get(CoreAnnotations.TextAnnotation.class) + ' ' + (String)wi.get(CoreAnnotations.PartOfSpeechAnnotation.class) + ' ' + (String)wi.get(CoreAnnotations.GoldAnswerAnnotation.class) + '\t');
        } else {
            this.cliqueWriter.print((String)wi.get(CoreAnnotations.TextAnnotation.class) + (String)wi.get(CoreAnnotations.GoldAnswerAnnotation.class) + '\t');
        }
        boolean first = true;
        ArrayList<String> featsList = new ArrayList<String>(features);
        Collections.sort(featsList);
        for (String feat : featsList) {
            if (first) {
                first = false;
            } else {
                this.cliqueWriter.print(" ");
            }
            this.cliqueWriter.print(feat);
        }
        this.cliqueWriter.println();
        ++this.writtenNum;
    }

    protected void printFeatureLists(IN wi, Collection<List<String>> features) {
        if (this.flags.printFeatures == null || this.writtenNum >= this.flags.printFeaturesUpto) {
            return;
        }
        this.printFeatureListsHelper(wi, features);
    }

    private void printFeatureListsHelper(IN wi, Collection<List<String>> features) {
        if (this.cliqueWriter == null) {
            this.cliqueWriter = IOUtils.getPrintWriterOrDie("features-" + this.flags.printFeatures + ".txt");
            this.writtenNum = 0;
        }
        if (wi instanceof CoreLabel) {
            this.cliqueWriter.print((String)wi.get(CoreAnnotations.TextAnnotation.class) + ' ' + (String)wi.get(CoreAnnotations.PartOfSpeechAnnotation.class) + ' ' + (String)wi.get(CoreAnnotations.GoldAnswerAnnotation.class) + '\t');
        } else {
            this.cliqueWriter.print((String)wi.get(CoreAnnotations.TextAnnotation.class) + (String)wi.get(CoreAnnotations.GoldAnswerAnnotation.class) + '\t');
        }
        boolean first = true;
        for (List<String> featList : features) {
            ArrayList<String> sortedFeatList = new ArrayList<String>(featList);
            Collections.sort(sortedFeatList);
            for (String feat : sortedFeatList) {
                if (first) {
                    first = false;
                } else {
                    this.cliqueWriter.print(" ");
                }
                this.cliqueWriter.print(feat);
            }
            this.cliqueWriter.print("  ");
        }
        this.cliqueWriter.println();
        ++this.writtenNum;
    }

    public int windowSize() {
        return this.windowSize;
    }
}

