/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.demo;

import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import java.util.List;

public class NERDemo {
    public static void main(String[] args) throws Exception {
        String serializedClassifier = "classifiers/english.all.3class.distsim.crf.ser.gz";
        if (args.length > 0) {
            serializedClassifier = args[0];
        }
        CRFClassifier<CoreLabel> classifier = CRFClassifier.getClassifier(serializedClassifier);
        if (args.length > 1) {
            String fileContents = IOUtils.slurpFile(args[1]);
            List out2 = classifier.classify(fileContents);
            for (List sentence : out2) {
                for (CoreLabel word : sentence) {
                    System.out.print(word.word() + '/' + (String)word.get(CoreAnnotations.AnswerAnnotation.class) + ' ');
                }
                System.out.println();
            }
            System.out.println("---");
            out2 = classifier.classifyFile(args[1]);
            for (List sentence : out2) {
                for (CoreLabel word : sentence) {
                    System.out.print(word.word() + '/' + (String)word.get(CoreAnnotations.AnswerAnnotation.class) + ' ');
                }
                System.out.println();
            }
        } else {
            String[] example;
            for (String str : example = new String[]{"Good afternoon Rajat Raina, how are you today?", "I go to school at Stanford University, which is located in California."}) {
                System.out.println(classifier.classifyToString(str));
            }
            System.out.println("---");
            for (String str : example) {
                System.out.print(classifier.classifyToString(str, "slashTags", false));
            }
            System.out.println("---");
            for (String str : example) {
                System.out.println(classifier.classifyWithInlineXML(str));
            }
            System.out.println("---");
            for (String str : example) {
                System.out.println(classifier.classifyToString(str, "xml", true));
            }
            System.out.println("---");
            int i = 0;
            for (String str : example) {
                for (List lcl : classifier.classify(str)) {
                    for (CoreLabel cl : lcl) {
                        System.out.print(i++ + ": ");
                        System.out.println(cl.toShorterString(new String[0]));
                    }
                }
            }
        }
    }
}

