/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.CoindexationGenerator;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.util.Generics;
import java.util.Map;

class TsurgeonPatternRoot
extends TsurgeonPattern {
    CoindexationGenerator coindexer;
    Map<String, Tree> newNodeNames;

    public TsurgeonPatternRoot(TsurgeonPattern child) {
        this(new TsurgeonPattern[]{child});
    }

    public TsurgeonPatternRoot(TsurgeonPattern[] children) {
        super("operations: ", children);
        this.setRoot(this);
    }

    void setCoindexes() {
        this.coindexer = new CoindexationGenerator();
    }

    @Override
    public Tree evaluate(Tree t, TregexMatcher m) {
        this.newNodeNames = Generics.newHashMap();
        if (this.coindexer != null) {
            this.coindexer.setLastIndex(t);
        }
        for (TsurgeonPattern child : this.children) {
            if ((t = child.evaluate(t, m)) != null) continue;
            return null;
        }
        return t;
    }
}

