/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.Tsurgeon;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;

class ExciseNode
extends TsurgeonPattern {
    public ExciseNode(TsurgeonPattern top, TsurgeonPattern bottom) {
        super("excise", new TsurgeonPattern[]{top, bottom});
    }

    public ExciseNode(TsurgeonPattern node) {
        super("excise", new TsurgeonPattern[]{node, node});
    }

    @Override
    public Tree evaluate(Tree t, TregexMatcher m) {
        Tree topNode = this.children[0].evaluate(t, m);
        Tree bottomNode = this.children[1].evaluate(t, m);
        if (Tsurgeon.verbose) {
            System.err.println("Excising...original tree:");
            t.pennPrint(System.err);
            System.err.println("top: " + topNode + "\nbottom:" + bottomNode);
        }
        if (topNode == t) {
            return null;
        }
        Tree parent = topNode.parent(t);
        if (Tsurgeon.verbose) {
            System.err.println("Parent: " + parent);
        }
        int i = Trees.objectEqualityIndexOf(parent, topNode);
        parent.removeChild(i);
        for (Tree child : bottomNode.children()) {
            parent.addChild(i, child);
            ++i;
        }
        if (Tsurgeon.verbose) {
            t.pennPrint(System.err);
        }
        return t;
    }
}

