/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.HasIndex;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.process.Tokenizer;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreebankTokenizer;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.TreeReader;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public class PennTreeReader
implements TreeReader {
    private final Reader reader;
    private final Tokenizer<String> tokenizer;
    private final TreeNormalizer treeNormalizer;
    private final TreeFactory treeFactory;
    private static final boolean DEBUG = false;
    private Tree currentTree;
    private ArrayList<Tree> stack;
    private static final String leftParen = "(";
    private static final String rightParen = ")";

    public PennTreeReader(Reader in) {
        this(in, new LabeledScoredTreeFactory());
    }

    public PennTreeReader(Reader in, TreeFactory tf) {
        this(in, tf, null, new PennTreebankTokenizer(in));
    }

    public PennTreeReader(Reader in, TreeFactory tf, TreeNormalizer tn) {
        this(in, tf, tn, new PennTreebankTokenizer(in));
    }

    public PennTreeReader(Reader in, TreeFactory tf, TreeNormalizer tn, Tokenizer<String> st) {
        String first;
        this.reader = in;
        this.treeFactory = tf;
        this.treeNormalizer = tn;
        this.tokenizer = st;
        String string = first = st.hasNext() ? st.peek() : null;
        if (first != null && first.startsWith("*x*x*x")) {
            int foundCount = 0;
            while (foundCount < 4 && st.hasNext()) {
                first = st.next();
                if (first == null || !first.startsWith("*x*x*x")) continue;
                ++foundCount;
            }
        }
    }

    @Override
    public Tree readTree() throws IOException {
        Tree t = null;
        while (this.tokenizer.hasNext() && t == null) {
            this.currentTree = null;
            this.stack = new ArrayList();
            try {
                t = this.getTreeFromInputStream();
            }
            catch (NoSuchElementException e) {
                throw new IOException("End of token stream encountered before parsing could complete.");
            }
            if (t == null || this.treeNormalizer == null || this.treeFactory == null) continue;
            t = this.treeNormalizer.normalizeWholeTree(t, this.treeFactory);
        }
        return t;
    }

    private Tree getTreeFromInputStream() throws NoSuchElementException {
        int wordIndex = 1;
        while (this.tokenizer.hasNext()) {
            String token = this.tokenizer.next();
            if (token.equals(leftParen)) {
                String label = this.tokenizer.peek().equals(leftParen) ? null : this.tokenizer.next();
                if (rightParen.equals(label)) continue;
                if (this.treeNormalizer != null) {
                    label = this.treeNormalizer.normalizeNonterminal(label);
                }
                Tree newTree = this.treeFactory.newTreeNode(label, null);
                if (this.currentTree == null) {
                    this.stack.add(newTree);
                } else {
                    this.currentTree.addChild(newTree);
                    this.stack.add(this.currentTree);
                }
                this.currentTree = newTree;
                continue;
            }
            if (token.equals(rightParen)) {
                if (this.stack.isEmpty()) {
                    System.err.println("PennTreeReader: warning: file has extra non-matching right parenthesis [ignored]");
                    break;
                }
                this.currentTree = this.stack.remove(this.stack.size() - 1);
                if (!this.stack.isEmpty()) continue;
                return this.currentTree;
            }
            if (this.currentTree == null) break;
            String terminal = this.treeNormalizer == null ? token : this.treeNormalizer.normalizeTerminal(token);
            Tree leaf = this.treeFactory.newLeaf(terminal);
            if (leaf.label() instanceof HasIndex) {
                HasIndex hi = (HasIndex)((Object)leaf.label());
                hi.setIndex(wordIndex);
            }
            if (leaf.label() instanceof HasWord) {
                HasWord hw = (HasWord)((Object)leaf.label());
                hw.setWord(leaf.label().value());
            }
            ++wordIndex;
            this.currentTree.addChild(leaf);
        }
        if (this.currentTree != null) {
            System.err.println("PennTreeReader: warning: incomplete tree (extra left parentheses in input): " + this.currentTree);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public static void main(String[] args) {
        try {
            LabeledScoredTreeFactory tf = new LabeledScoredTreeFactory();
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(args[0]), "UTF-8"));
            PennTreeReader tr = new PennTreeReader(r, tf);
            Tree t = tr.readTree();
            while (t != null) {
                System.out.println(t);
                System.out.println();
                t = tr.readTree();
            }
            ((Reader)r).close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

