/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.stats;

import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.ProbabilityDistribution;
import edu.stanford.nlp.stats.Sampler;
import edu.stanford.nlp.stats.SimpleGoodTuring;
import edu.stanford.nlp.util.Generics;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;

public class Distribution<E>
implements Sampler<E>,
ProbabilityDistribution<E> {
    private static final long serialVersionUID = 6707148234288637809L;
    private int numberOfKeys;
    private double reservedMass;
    protected Counter<E> counter;
    private static final int NUM_ENTRIES_IN_STRING = 20;
    private static boolean verbose = false;

    public Counter<E> getCounter() {
        return this.counter;
    }

    @Override
    public E drawSample() {
        return this.sampleFrom();
    }

    @Override
    public E drawSample(Random random) {
        return this.sampleFrom(random);
    }

    public String toString(NumberFormat nf) {
        return Counters.toString(this.counter, nf);
    }

    public double getReservedMass() {
        return this.reservedMass;
    }

    public int getNumberOfKeys() {
        return this.numberOfKeys;
    }

    public Set<E> keySet() {
        return this.counter.keySet();
    }

    public boolean containsKey(E key) {
        return this.counter.containsKey(key);
    }

    public double getCount(E key) {
        return this.counter.getCount(key);
    }

    public static <E> Distribution<E> getDistributionFromPartiallySpecifiedCounter(Counter<E> c, int numKeys) {
        Distribution<E> d;
        double total = c.totalCount();
        if (total >= 1.0) {
            d = Distribution.getDistribution(c);
            d.numberOfKeys = numKeys;
        } else {
            d = new Distribution<E>();
            d.numberOfKeys = numKeys;
            d.counter = c;
            d.reservedMass = 1.0 - total;
        }
        return d;
    }

    public static <E> Distribution<E> getUniformDistribution(Set<E> s) {
        Distribution<E> norm = new Distribution<E>();
        norm.counter = new ClassicCounter();
        norm.numberOfKeys = s.size();
        norm.reservedMass = 0.0;
        double total = s.size();
        double count = 1.0 / total;
        for (E key : s) {
            norm.counter.setCount(key, count);
        }
        return norm;
    }

    public static <E> Distribution<E> getPerturbedUniformDistribution(Set<E> s, Random r) {
        Distribution<E> norm = new Distribution<E>();
        norm.counter = new ClassicCounter();
        norm.numberOfKeys = s.size();
        norm.reservedMass = 0.0;
        double total = s.size();
        double prob = 1.0 / total;
        double stdev = prob / 1000.0;
        for (E key : s) {
            norm.counter.setCount(key, prob + r.nextGaussian() * stdev);
        }
        return norm;
    }

    public static <E> Distribution<E> getPerturbedDistribution(Counter<E> wordCounter, Random r) {
        Distribution<E> norm = new Distribution<E>();
        norm.counter = new ClassicCounter();
        norm.numberOfKeys = wordCounter.size();
        norm.reservedMass = 0.0;
        double totalCount = wordCounter.totalCount();
        double stdev = 1.0 / (double)norm.numberOfKeys / 1000.0;
        for (E key : wordCounter.keySet()) {
            double prob = wordCounter.getCount(key) / totalCount;
            double perturbedProb = prob + r.nextGaussian() * stdev;
            if (perturbedProb < 0.0) {
                perturbedProb = 0.0;
            }
            norm.counter.setCount(key, perturbedProb);
        }
        return norm;
    }

    public static <E> Distribution<E> getDistribution(Counter<E> counter) {
        return Distribution.getDistributionWithReservedMass(counter, 0.0);
    }

    public static <E> Distribution<E> getDistributionWithReservedMass(Counter<E> counter, double reservedMass) {
        Distribution<E> norm = new Distribution<E>();
        norm.counter = new ClassicCounter();
        norm.numberOfKeys = counter.size();
        norm.reservedMass = reservedMass;
        double total = counter.totalCount() * (1.0 + reservedMass);
        if (total == 0.0) {
            total = 1.0;
        }
        for (E key : counter.keySet()) {
            double count = counter.getCount(key) / total;
            norm.counter.setCount(key, count);
        }
        return norm;
    }

    public static <E> Distribution<E> getDistributionFromLogValues(Counter<E> counter) {
        ClassicCounter<E> c = new ClassicCounter<E>();
        double max = Counters.max(counter);
        for (E key : counter.keySet()) {
            double count = Math.exp(counter.getCount(key) - max);
            c.setCount(key, count);
        }
        return Distribution.getDistribution(c);
    }

    public static <E> Distribution<E> absolutelyDiscountedDistribution(Counter<E> counter, int numberOfKeys, double discount) {
        Distribution<E> norm = new Distribution<E>();
        norm.counter = new ClassicCounter();
        double total = counter.totalCount();
        double reservedMass = 0.0;
        for (E key : counter.keySet()) {
            double count = counter.getCount(key);
            if (count > discount) {
                double newCount = (count - discount) / total;
                norm.counter.setCount(key, newCount);
                reservedMass += discount;
                continue;
            }
            reservedMass += count;
        }
        norm.numberOfKeys = numberOfKeys;
        norm.reservedMass = reservedMass / total;
        if (verbose) {
            System.err.println("unseenKeys=" + (norm.numberOfKeys - norm.counter.size()) + " seenKeys=" + norm.counter.size() + " reservedMass=" + norm.reservedMass);
            double zeroCountProb = norm.reservedMass / (double)(numberOfKeys - norm.counter.size());
            System.err.println("0 count prob: " + zeroCountProb);
            if (discount >= 1.0) {
                System.err.println("1 count prob: " + zeroCountProb);
            } else {
                System.err.println("1 count prob: " + (1.0 - discount) / total);
            }
            if (discount >= 2.0) {
                System.err.println("2 count prob: " + zeroCountProb);
            } else {
                System.err.println("2 count prob: " + (2.0 - discount) / total);
            }
            if (discount >= 3.0) {
                System.err.println("3 count prob: " + zeroCountProb);
            } else {
                System.err.println("3 count prob: " + (3.0 - discount) / total);
            }
        }
        return norm;
    }

    public static <E> Distribution<E> laplaceSmoothedDistribution(Counter<E> counter, int numberOfKeys) {
        return Distribution.laplaceSmoothedDistribution(counter, numberOfKeys, 1.0);
    }

    public static <E> Distribution<E> laplaceSmoothedDistribution(Counter<E> counter, int numberOfKeys, double lambda) {
        Distribution<E> norm = new Distribution<E>();
        norm.counter = new ClassicCounter();
        double total = counter.totalCount();
        double newTotal = total + lambda * (double)numberOfKeys;
        double reservedMass = ((double)numberOfKeys - (double)counter.size()) * lambda / newTotal;
        if (verbose) {
            System.err.println((double)numberOfKeys - (double)counter.size() + " * " + lambda + " / (" + total + " + ( " + lambda + " * " + (double)numberOfKeys + ") )");
        }
        norm.numberOfKeys = numberOfKeys;
        norm.reservedMass = reservedMass;
        if (verbose) {
            System.err.println("reserved mass=" + reservedMass);
        }
        for (E key : counter.keySet()) {
            double count = counter.getCount(key);
            norm.counter.setCount(key, (count + lambda) / newTotal);
        }
        if (verbose) {
            System.err.println("unseenKeys=" + (norm.numberOfKeys - norm.counter.size()) + " seenKeys=" + norm.counter.size() + " reservedMass=" + norm.reservedMass);
            System.err.println("0 count prob: " + lambda / newTotal);
            System.err.println("1 count prob: " + (1.0 + lambda) / newTotal);
            System.err.println("2 count prob: " + (2.0 + lambda) / newTotal);
            System.err.println("3 count prob: " + (3.0 + lambda) / newTotal);
        }
        return norm;
    }

    public static <E> Distribution<E> laplaceWithExplicitUnknown(Counter<E> counter, double lambda, E UNK) {
        Distribution<E> norm = new Distribution<E>();
        norm.counter = new ClassicCounter();
        double total = counter.totalCount() + lambda * (double)(counter.size() - 1);
        norm.numberOfKeys = counter.size();
        norm.reservedMass = 0.0;
        for (E key : counter.keySet()) {
            if (key.equals(UNK)) {
                norm.counter.setCount(key, counter.getCount(key) / total);
                continue;
            }
            norm.counter.setCount(key, (counter.getCount(key) + lambda) / total);
        }
        return norm;
    }

    public static <E> Distribution<E> goodTuringSmoothedCounter(Counter<E> counter, int numberOfKeys) {
        int[] countCounts = Distribution.getCountCounts(counter);
        for (int i = 1; i <= 10; ++i) {
            if (countCounts[i] >= 3) continue;
            return Distribution.laplaceSmoothedDistribution(counter, numberOfKeys, 0.5);
        }
        double observedMass = counter.totalCount();
        double reservedMass = (double)countCounts[1] / observedMass;
        double[] adjustedFreq = new double[10];
        for (int freq = 1; freq < 10; ++freq) {
            adjustedFreq[freq] = (double)(freq + 1) * (double)countCounts[freq + 1] / (double)countCounts[freq];
            observedMass -= ((double)freq - adjustedFreq[freq]) * (double)countCounts[freq];
        }
        double normFactor = (1.0 - reservedMass) / observedMass;
        Distribution<E> norm = new Distribution<E>();
        norm.counter = new ClassicCounter();
        for (E key : counter.keySet()) {
            int origFreq = (int)Math.round(counter.getCount(key));
            if (origFreq < 10) {
                norm.counter.setCount(key, adjustedFreq[origFreq] * normFactor);
                continue;
            }
            norm.counter.setCount(key, (double)origFreq * normFactor);
        }
        norm.numberOfKeys = numberOfKeys;
        norm.reservedMass = reservedMass;
        return norm;
    }

    public static <E> Distribution<E> goodTuringWithExplicitUnknown(Counter<E> counter, E UNK) {
        int[] countCounts = Distribution.getCountCounts(counter);
        for (int i = 1; i <= 10; ++i) {
            if (countCounts[i] >= 3) continue;
            return Distribution.laplaceWithExplicitUnknown(counter, 0.5, UNK);
        }
        double observedMass = counter.totalCount();
        double[] adjustedFreq = new double[10];
        for (int freq = 1; freq < 10; ++freq) {
            adjustedFreq[freq] = (double)(freq + 1) * (double)countCounts[freq + 1] / (double)countCounts[freq];
            observedMass -= ((double)freq - adjustedFreq[freq]) * (double)countCounts[freq];
        }
        Distribution<E> norm = new Distribution<E>();
        norm.counter = new ClassicCounter();
        for (E key : counter.keySet()) {
            int origFreq = (int)Math.round(counter.getCount(key));
            if (origFreq < 10) {
                norm.counter.setCount(key, adjustedFreq[origFreq] / observedMass);
                continue;
            }
            norm.counter.setCount(key, (double)origFreq / observedMass);
        }
        norm.numberOfKeys = counter.size();
        norm.reservedMass = 0.0;
        return norm;
    }

    private static <E> int[] getCountCounts(Counter<E> counter) {
        int[] countCounts = new int[11];
        for (int i = 0; i <= 10; ++i) {
            countCounts[i] = 0;
        }
        for (E key : counter.keySet()) {
            int count = (int)Math.round(counter.getCount(key));
            if (count > 10) continue;
            int n = count;
            countCounts[n] = countCounts[n] + 1;
        }
        return countCounts;
    }

    public static <E> Distribution<E> simpleGoodTuring(Counter<E> counter, int numberOfKeys) {
        Distribution.validateCounter(counter);
        int numUnseen = numberOfKeys - counter.size();
        if (numUnseen < 1) {
            throw new IllegalArgumentException(String.format("ERROR: numberOfKeys %d must be > size of counter %d!", numberOfKeys, counter.size()));
        }
        int[][] cc = Distribution.countCounts2IntArrays(Distribution.collectCountCounts(counter));
        int[] r = cc[0];
        int[] n = cc[1];
        SimpleGoodTuring sgt = new SimpleGoodTuring(r, n);
        ClassicCounter<Integer> probsByCount = new ClassicCounter<Integer>();
        double[] probs = sgt.getProbabilities();
        for (int i = 0; i < probs.length; ++i) {
            probsByCount.setCount(r[i], probs[i]);
        }
        Distribution<E> dist = new Distribution<E>();
        dist.counter = new ClassicCounter();
        for (Map.Entry<E, Double> entry : counter.entrySet()) {
            E item = entry.getKey();
            Integer count = (int)Math.round(entry.getValue());
            dist.counter.setCount(item, probsByCount.getCount(count));
        }
        dist.numberOfKeys = numberOfKeys;
        dist.reservedMass = sgt.getProbabilityForUnseen();
        return dist;
    }

    private static <E> void validateCounter(Counter<E> counts) {
        for (Map.Entry<E, Double> entry : counts.entrySet()) {
            E item = entry.getKey();
            Double dblCount = entry.getValue();
            if (dblCount == null) {
                throw new IllegalArgumentException("ERROR: null count for item " + item + "!");
            }
            if (!(dblCount < 0.0)) continue;
            throw new IllegalArgumentException("ERROR: negative count " + dblCount + " for item " + item + "!");
        }
    }

    private static <E> Counter<Integer> collectCountCounts(Counter<E> counts) {
        ClassicCounter<Integer> cc = new ClassicCounter<Integer>();
        for (Map.Entry<E, Double> entry : counts.entrySet()) {
            Integer count = (int)Math.round(entry.getValue());
            cc.incrementCount(count);
        }
        return cc;
    }

    private static int[][] countCounts2IntArrays(Counter<Integer> countCounts) {
        int size = countCounts.size();
        int[][] arrays = new int[][]{new int[size], new int[size]};
        PriorityQueue<Integer> q = new PriorityQueue<Integer>(countCounts.keySet());
        int i = 0;
        while (!q.isEmpty()) {
            Integer count = q.poll();
            Integer countCount = (int)Math.round(countCounts.getCount(count));
            arrays[0][i] = count;
            arrays[1][i] = countCount;
            ++i;
        }
        return arrays;
    }

    public static <E> Distribution<E> distributionWithDirichletPrior(Counter<E> c, Distribution<E> prior, double weight2) {
        Distribution<E> norm = new Distribution<E>();
        double totalWeight = c.totalCount() + weight2;
        if (prior instanceof DynamicDistribution) {
            throw new UnsupportedOperationException("Cannot make normalized counter with Dynamic prior.");
        }
        norm.counter = Counters.linearCombination(c, 1.0 / totalWeight, prior.counter, weight2 / totalWeight);
        norm.numberOfKeys = prior.numberOfKeys;
        norm.reservedMass = prior.reservedMass * weight2 / totalWeight;
        return norm;
    }

    public static <E> Distribution<E> dynamicCounterWithDirichletPrior(Counter<E> c, Distribution<E> prior, double weight2) {
        double totalWeight = c.totalCount() + weight2;
        DynamicDistribution<E> norm = new DynamicDistribution<E>(prior, weight2 / totalWeight);
        norm.counter = new ClassicCounter();
        for (E key : c.keySet()) {
            double count = c.getCount(key) / totalWeight;
            prior.addToKeySet(key);
            norm.counter.setCount(key, count);
        }
        norm.numberOfKeys = prior.numberOfKeys;
        return norm;
    }

    public static <E> Distribution<E> distributionFromLogisticCounter(Counter<E> cntr) {
        double expSum = 0.0;
        int numKeys = 0;
        for (E key : cntr.keySet()) {
            expSum += Math.exp(cntr.getCount(key));
            ++numKeys;
        }
        Distribution<E> probs = new Distribution<E>();
        probs.counter = new ClassicCounter();
        probs.reservedMass = 0.0;
        probs.numberOfKeys = numKeys;
        for (E key : cntr.keySet()) {
            probs.counter.setCount(key, Math.exp(cntr.getCount(key)) / expSum);
        }
        return probs;
    }

    public E sampleFrom() {
        return Counters.sample(this.counter);
    }

    public E sampleFrom(Random random) {
        return Counters.sample(this.counter, random);
    }

    @Override
    public double probabilityOf(E key) {
        if (this.counter.containsKey(key)) {
            return this.counter.getCount(key);
        }
        int remainingKeys = this.numberOfKeys - this.counter.size();
        if (remainingKeys <= 0) {
            return 0.0;
        }
        return this.reservedMass / (double)remainingKeys;
    }

    @Override
    public double logProbabilityOf(E key) {
        double prob = this.probabilityOf(key);
        return Math.log(prob);
    }

    public E argmax() {
        return Counters.argmax(this.counter);
    }

    public double totalCount() {
        return this.counter.totalCount() + this.reservedMass;
    }

    public void addToKeySet(E o) {
        if (!this.counter.containsKey(o)) {
            this.counter.setCount(o, 0.0);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof Distribution && this.equals((Distribution)o);
    }

    public boolean equals(Distribution<E> distribution) {
        if (this.numberOfKeys != distribution.numberOfKeys) {
            return false;
        }
        if (this.reservedMass != distribution.reservedMass) {
            return false;
        }
        return this.counter.equals(distribution.counter);
    }

    public int hashCode() {
        int result = this.numberOfKeys;
        long temp = Double.doubleToLongBits(this.reservedMass);
        result = 29 * result + (int)(temp ^ temp >>> 32);
        result = 29 * result + this.counter.hashCode();
        return result;
    }

    private Distribution() {
    }

    public String toString() {
        DecimalFormat nf = new DecimalFormat("0.0##E0");
        ArrayList<E> keyList = new ArrayList<E>(this.keySet());
        Collections.sort(keyList, new Comparator<E>(){

            @Override
            public int compare(E o1, E o2) {
                if (Distribution.this.probabilityOf(o1) < Distribution.this.probabilityOf(o2)) {
                    return 1;
                }
                return -1;
            }
        });
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < 20 && keyList.size() > i; ++i) {
            Object o = keyList.get(i);
            double prob = this.probabilityOf(o);
            sb.append(o).append(":").append(nf.format(prob)).append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static void main(String[] args) {
        String i;
        int rank;
        ClassicCounter<String> c2 = new ClassicCounter<String>();
        c2.incrementCount("p", 13.0);
        c2.setCount("q", 12.0);
        c2.setCount("w", 5.0);
        c2.incrementCount("x", 7.5);
        ClassicCounter<String> c = new ClassicCounter<String>();
        double p = 1000.0;
        String UNK = "!*UNKNOWN*!";
        Set<String> s = Generics.newHashSet();
        s.add(UNK);
        for (rank = 1; rank < 2000; ++rank) {
            i = String.valueOf(rank);
            c.setCount(i, Math.round(1000.0 / (double)rank));
            s.add(i);
        }
        for (rank = 2000; rank <= 4000; ++rank) {
            i = String.valueOf(rank);
            s.add(i);
        }
        Distribution<String> n = Distribution.getDistribution(c);
        Distribution prior = Distribution.getUniformDistribution(s);
        Distribution<String> dir1 = Distribution.distributionWithDirichletPrior(c, prior, 4000.0);
        Distribution<String> dir2 = Distribution.dynamicCounterWithDirichletPrior(c, prior, 4000.0);
        Distribution<String> add1 = Distribution.laplaceSmoothedDistribution(c, 4000);
        Distribution<String> gt = Distribution.goodTuringSmoothedCounter(c, 4000);
        Distribution<String> sgt = Distribution.simpleGoodTuring(c, 4000);
        System.out.printf("%10s %10s %10s %10s %10s %10s %10s%n", "Freq", "Norm", "Add1", "Dir1", "Dir2", "GT", "SGT");
        System.out.printf("%10s %10s %10s %10s %10s %10s %10s%n", "----------", "----------", "----------", "----------", "----------", "----------", "----------");
        for (int i2 = 1; i2 < 5; ++i2) {
            System.out.printf("%10d ", Math.round(1000.0 / (double)i2));
            String in = String.valueOf(i2);
            System.out.printf("%10.8f ", n.probabilityOf(String.valueOf(in)));
            System.out.printf("%10.8f ", add1.probabilityOf(in));
            System.out.printf("%10.8f ", dir1.probabilityOf(in));
            System.out.printf("%10.8f ", dir2.probabilityOf(in));
            System.out.printf("%10.8f ", gt.probabilityOf(in));
            System.out.printf("%10.8f ", sgt.probabilityOf(in));
            System.out.println();
        }
        System.out.printf("%10s %10s %10s %10s %10s %10s %10s%n", "----------", "----------", "----------", "----------", "----------", "----------", "----------");
        System.out.printf("%10d ", 1);
        String last = String.valueOf(1500);
        System.out.printf("%10.8f ", n.probabilityOf(last));
        System.out.printf("%10.8f ", add1.probabilityOf(last));
        System.out.printf("%10.8f ", dir1.probabilityOf(last));
        System.out.printf("%10.8f ", dir2.probabilityOf(last));
        System.out.printf("%10.8f ", gt.probabilityOf(last));
        System.out.printf("%10.8f ", sgt.probabilityOf(last));
        System.out.println();
        System.out.printf("%10s %10s %10s %10s %10s %10s %10s%n", "----------", "----------", "----------", "----------", "----------", "----------", "----------");
        System.out.printf("%10s ", "UNK");
        System.out.printf("%10.8f ", n.probabilityOf(UNK));
        System.out.printf("%10.8f ", add1.probabilityOf(UNK));
        System.out.printf("%10.8f ", dir1.probabilityOf(UNK));
        System.out.printf("%10.8f ", dir2.probabilityOf(UNK));
        System.out.printf("%10.8f ", gt.probabilityOf(UNK));
        System.out.printf("%10.8f ", sgt.probabilityOf(UNK));
        System.out.println();
        System.out.printf("%10s %10s %10s %10s %10s %10s %10s%n", "----------", "----------", "----------", "----------", "----------", "----------", "----------");
        System.out.printf("%10s ", "RESERVE");
        System.out.printf("%10.8f ", n.getReservedMass());
        System.out.printf("%10.8f ", add1.getReservedMass());
        System.out.printf("%10.8f ", dir1.getReservedMass());
        System.out.printf("%10.8f ", dir2.getReservedMass());
        System.out.printf("%10.8f ", gt.getReservedMass());
        System.out.printf("%10.8f ", sgt.getReservedMass());
        System.out.println();
        System.out.printf("%10s %10s %10s %10s %10s %10s %10s%n", "----------", "----------", "----------", "----------", "----------", "----------", "----------");
        System.out.printf("%10s ", "Total");
        System.out.printf("%10.8f ", n.totalCount());
        System.out.printf("%10.8f ", add1.totalCount());
        System.out.printf("%10.8f ", dir1.totalCount());
        System.out.printf("%10.8f ", dir2.totalCount());
        System.out.printf("%10.8f ", gt.totalCount());
        System.out.printf("%10.8f ", sgt.totalCount());
        System.out.println();
    }

    private static class DynamicDistribution<E>
    extends Distribution<E> {
        private static final long serialVersionUID = -6073849364871185L;
        private Distribution<E> prior;
        private double priorMultiplier;

        public DynamicDistribution(Distribution<E> prior, double priorMultiplier) {
            this.prior = prior;
            this.priorMultiplier = priorMultiplier;
        }

        @Override
        public double probabilityOf(E o) {
            return this.counter.getCount(o) + this.prior.probabilityOf(o) * this.priorMultiplier;
        }

        @Override
        public double totalCount() {
            return this.counter.totalCount() + this.prior.totalCount() * this.priorMultiplier;
        }

        @Override
        public Set<E> keySet() {
            return this.prior.keySet();
        }

        @Override
        public void addToKeySet(E o) {
            this.prior.addToKeySet(o);
        }

        @Override
        public boolean containsKey(E key) {
            return this.prior.containsKey(key);
        }

        public Object argMax() {
            return Counters.argmax(Counters.linearCombination(this.counter, 1.0, this.prior.counter, this.priorMultiplier));
        }

        @Override
        public E sampleFrom() {
            double d = Math.random();
            Set<E> s = this.prior.keySet();
            for (E o : s) {
                if (!((d -= this.probabilityOf(o)) < 0.0)) continue;
                return o;
            }
            System.err.println("ERROR: Distribution sums to less than 1");
            System.err.println("Sampled " + d + "      sum is " + this.totalCount());
            throw new RuntimeException("");
        }
    }
}

