/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeTransformer;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Set;

public class TrainOptions
implements Serializable {
    public String trainTreeFile = null;
    public int trainLengthLimit = 100000;
    public boolean cheatPCFG = false;
    public boolean markovFactor = false;
    public int markovOrder = 1;
    public boolean hSelSplit = false;
    public int HSEL_CUT = 10;
    public boolean markFinalStates = true;
    public int openClassTypesThreshold = 50;
    public double fractionBeforeUnseenCounting = 0.5;
    public boolean PA = true;
    public boolean gPA = false;
    public boolean postPA = false;
    public boolean postGPA = false;
    public boolean selectiveSplit = false;
    public double selectiveSplitCutOff = 0.0;
    public boolean selectivePostSplit = false;
    public double selectivePostSplitCutOff = 0.0;
    public boolean postSplitWithBaseCategory = false;
    public boolean sisterAnnotate = false;
    public Set<String> sisterSplitters;
    public int markUnary = 0;
    public boolean markUnaryTags = false;
    public boolean splitPrePreT = false;
    public boolean tagPA = false;
    public boolean tagSelectiveSplit = false;
    public double tagSelectiveSplitCutOff = 0.0;
    public boolean tagSelectivePostSplit = false;
    public double tagSelectivePostSplitCutOff = 0.0;
    public boolean rightRec = false;
    public boolean leftRec = false;
    public boolean collinsPunc = false;
    public Set<String> splitters;
    public Set postSplitters;
    public Set<String> deleteSplitters;
    public int printTreeTransformations = 0;
    public PrintWriter printAnnotatedPW;
    public PrintWriter printBinarizedPW;
    public boolean printStates = false;
    public int compactGrammar = 3;
    public boolean leftToRight = false;
    public boolean noTagSplit = false;
    public boolean ruleSmoothing = false;
    public double ruleSmoothingAlpha = 0.0;
    public boolean smoothing = false;
    public double ruleDiscount = 0.0;
    public boolean printAnnotatedRuleCounts = false;
    public boolean printAnnotatedStateCounts = false;
    public boolean basicCategoryTagsInDependencyGrammar = false;
    public TreeTransformer preTransformer = null;
    public String taggedFiles = null;
    public boolean predictSplits = false;
    public int splitCount = 1;
    public double splitRecombineRate = 0.0;
    public boolean simpleBinarizedLabels = false;
    public boolean noRebinarization = false;
    public int trainingThreads = 1;
    private static final long serialVersionUID = 72571349843538L;

    public boolean outsideFactor() {
        return !this.markovFactor;
    }

    public int compactGrammar() {
        if (this.markovFactor) {
            return this.compactGrammar;
        }
        return 0;
    }

    public void display() {
        System.err.println(this.toString());
    }

    public String toString() {
        return "Train parameters: smooth=" + this.smoothing + " PA=" + this.PA + " GPA=" + this.gPA + " selSplit=" + this.selectiveSplit + " (" + this.selectiveSplitCutOff + (this.deleteSplitters != null ? "; deleting " + this.deleteSplitters : "") + ")" + " mUnary=" + this.markUnary + " mUnaryTags=" + this.markUnaryTags + " sPPT=" + this.splitPrePreT + " tagPA=" + this.tagPA + " tagSelSplit=" + this.tagSelectiveSplit + " (" + this.tagSelectiveSplitCutOff + ")" + " rightRec=" + this.rightRec + " leftRec=" + this.leftRec + " collinsPunc=" + this.collinsPunc + " markov=" + this.markovFactor + " mOrd=" + this.markovOrder + " hSelSplit=" + this.hSelSplit + " (" + this.HSEL_CUT + ")" + " compactGrammar=" + this.compactGrammar() + " postPA=" + this.postPA + " postGPA=" + this.postGPA + " selPSplit=" + this.selectivePostSplit + " (" + this.selectivePostSplitCutOff + ")" + " tagSelPSplit=" + this.tagSelectivePostSplit + " (" + this.tagSelectivePostSplitCutOff + ")" + " postSplitWithBase=" + this.postSplitWithBaseCategory + " fractionBeforeUnseenCounting=" + this.fractionBeforeUnseenCounting + " openClassTypesThreshold=" + this.openClassTypesThreshold + " preTransformer=" + this.preTransformer + " taggedFiles=" + this.taggedFiles + " predictSplits=" + this.predictSplits + " splitCount=" + this.splitCount + " splitRecombineRate=" + this.splitRecombineRate + " simpleBinarizedLabels=" + this.simpleBinarizedLabels + " noRebinarization=" + this.noRebinarization + " trainingThreads=" + this.trainingThreads;
    }

    public static void printTrainTree(PrintWriter pw, String message, Tree t) {
        PrintWriter myPW = pw == null ? new PrintWriter(System.out, true) : pw;
        if (message != null && pw == null) {
            myPW.println(message);
        }
        boolean previousState = CategoryWordTag.printWordTag;
        CategoryWordTag.printWordTag = false;
        t.pennPrint(myPW);
        CategoryWordTag.printWordTag = previousState;
    }
}

