/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util.concurrent;

import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Interner;
import java.util.Set;

public class SynchronizedInterner<T> {
    protected static final Object globalMutex = new Object();
    protected static SynchronizedInterner<Object> interner = Generics.newSynchronizedInterner(Interner.getGlobal(), globalMutex);
    protected final Interner<T> delegate;
    protected final Object mutex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SynchronizedInterner<Object> getGlobal() {
        Object object = globalMutex;
        synchronized (object) {
            return interner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SynchronizedInterner<Object> setGlobal(Interner<Object> delegate) {
        Object object = globalMutex;
        synchronized (object) {
            SynchronizedInterner<Object> oldInterner = interner;
            interner = Generics.newSynchronizedInterner(delegate);
            return oldInterner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T globalIntern(T o) {
        Object object = globalMutex;
        synchronized (object) {
            return (T)SynchronizedInterner.getGlobal().intern(o);
        }
    }

    public SynchronizedInterner(Interner<T> delegate) {
        if (delegate == null) {
            throw new NullPointerException();
        }
        this.delegate = delegate;
        this.mutex = this;
    }

    public SynchronizedInterner(Interner<T> delegate, Object mutex) {
        if (delegate == null) {
            throw new NullPointerException();
        }
        this.delegate = delegate;
        this.mutex = mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mutex;
        synchronized (object) {
            this.delegate.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T intern(T o) {
        Object object = this.mutex;
        synchronized (object) {
            return this.delegate.intern(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<T> internAll(Set<T> s) {
        Object object = this.mutex;
        synchronized (object) {
            return this.delegate.internAll(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.mutex;
        synchronized (object) {
            return this.delegate.size();
        }
    }

    public static void main(final String[] args) throws InterruptedException {
        Thread[] threads = new Thread[100];
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (String str : args) {
                        String interned = SynchronizedInterner.globalIntern(str);
                        Thread.yield();
                        if (interned != str) {
                            throw new AssertionError((Object)("Interning failed for " + str));
                        }
                    }
                }
            });
        }
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
    }
}

