/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.neural.rnn.RNNCoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.sentiment.CollapseUnaryTransformer;
import edu.stanford.nlp.sentiment.SentimentCoreAnnotations;
import edu.stanford.nlp.sentiment.SentimentCostAndGradient;
import edu.stanford.nlp.sentiment.SentimentModel;
import edu.stanford.nlp.sentiment.SentimentUtils;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class SentimentAnnotator
implements Annotator {
    static final String DEFAULT_MODEL = "edu/stanford/nlp/models/sentiment/sentiment.ser.gz";
    String modelPath;
    SentimentModel model;
    CollapseUnaryTransformer transformer = new CollapseUnaryTransformer();

    public SentimentAnnotator(String name, Properties props) {
        this.modelPath = props.getProperty(name + ".model", DEFAULT_MODEL);
        if (this.modelPath == null) {
            throw new IllegalArgumentException("No model specified for Sentiment annotator");
        }
        this.model = SentimentModel.loadSerialized(this.modelPath);
    }

    @Override
    public Set<Annotator.Requirement> requirementsSatisfied() {
        return Collections.emptySet();
    }

    @Override
    public Set<Annotator.Requirement> requires() {
        return PARSE_TAG_BINARIZED_TREES;
    }

    @Override
    public void annotate(Annotation annotation) {
        if (annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
            for (CoreMap sentence : sentences) {
                Tree binarized = (Tree)sentence.get(TreeCoreAnnotations.BinarizedTreeAnnotation.class);
                if (binarized == null) {
                    throw new AssertionError((Object)"Binarized sentences not built by parser");
                }
                Tree collapsedUnary = this.transformer.transformTree(binarized);
                SentimentCostAndGradient scorer = new SentimentCostAndGradient(this.model, null);
                scorer.forwardPropagateTree(collapsedUnary);
                sentence.set(SentimentCoreAnnotations.AnnotatedTree.class, collapsedUnary);
                int sentiment = RNNCoreAnnotations.getPredictedClass(collapsedUnary);
                sentence.set(SentimentCoreAnnotations.ClassName.class, SentimentUtils.sentimentString(this.model, sentiment));
            }
        } else {
            throw new RuntimeException("unable to find sentences in: " + annotation);
        }
    }
}

