/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Timing;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class QuoteAnnotator
implements Annotator {
    private final boolean VERBOSE;
    private final boolean DEBUG = false;
    public static final Map<String, String> DIRECTED_QUOTES;
    public static final String[] QUOTES;
    public final boolean closeUnclosedQuotes = false;

    public QuoteAnnotator(Properties props) {
        this(props, false);
    }

    public QuoteAnnotator(Properties props, boolean verbose) {
        this.VERBOSE = verbose;
        Timing timer = null;
        if (this.VERBOSE) {
            timer = new Timing();
            System.err.print("Preparing quote annotator...");
        }
        if (this.VERBOSE) {
            timer.stop("done.");
        }
    }

    @Override
    public void annotate(Annotation annotation) {
        String text = (String)annotation.get(CoreAnnotations.TextAnnotation.class);
        List tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
        List<Pair<Integer, Integer>> overall = QuoteAnnotator.getQuotes(text);
        String docID = (String)annotation.get(CoreAnnotations.DocIDAnnotation.class);
        List<CoreMap> cmQuotes = QuoteAnnotator.getCoreMapQuotes(overall, tokens, text, docID);
        annotation.set(CoreAnnotations.QuotationsAnnotation.class, cmQuotes);
    }

    public static Comparator<CoreMap> getQuoteComparator() {
        return new Comparator<CoreMap>(){

            @Override
            public int compare(CoreMap o1, CoreMap o2) {
                int s1 = (Integer)o1.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
                int s2 = (Integer)o2.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
                return s1 - s2;
            }
        };
    }

    public static List<CoreMap> getCoreMapQuotes(List<Pair<Integer, Integer>> quotes, List<CoreLabel> tokens, String text, String docID) {
        ArrayList<CoreMap> cmQuotes = new ArrayList<CoreMap>();
        int tokenOffset = 0;
        int currTok = 0;
        for (Pair<Integer, Integer> p : quotes) {
            int begin = p.first();
            int end = p.second();
            ArrayList<CoreLabel> quoteTokens = new ArrayList<CoreLabel>();
            if (tokens != null) {
                while (currTok < tokens.size() && tokens.get(currTok).beginPosition() < begin) {
                    ++currTok;
                }
                for (int i = currTok; i < tokens.size() && tokens.get(i).endPosition() <= end; ++i) {
                    quoteTokens.add(tokens.get(i));
                }
            }
            int currQuoteSize = cmQuotes.size();
            Annotation quote = QuoteAnnotator.makeQuote(text, begin, end, quoteTokens, currQuoteSize, tokenOffset, docID);
            tokenOffset += quoteTokens.size();
            cmQuotes.add(quote);
        }
        Comparator<CoreMap> quoteComparator = QuoteAnnotator.getQuoteComparator();
        Collections.sort(cmQuotes, quoteComparator);
        ArrayList<CoreMap> toRemove = new ArrayList<CoreMap>();
        for (CoreMap cmQuote : cmQuotes) {
            int start = (Integer)cmQuote.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
            int end = (Integer)cmQuote.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
            ArrayList<CoreMap> embeddedQuotes = new ArrayList<CoreMap>();
            for (CoreMap cmQuoteComp : cmQuotes) {
                int startComp = (Integer)cmQuoteComp.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
                int endComp = (Integer)cmQuoteComp.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
                if (start >= startComp || end < endComp) continue;
                embeddedQuotes.add(cmQuoteComp);
                toRemove.add(cmQuoteComp);
            }
            cmQuote.set(CoreAnnotations.QuotationsAnnotation.class, embeddedQuotes);
        }
        for (CoreMap r : toRemove) {
            cmQuotes.remove(r);
        }
        return cmQuotes;
    }

    public static Annotation makeQuote(String text, int begin, int end, List<CoreLabel> quoteTokens, int currQuoteSize, int tokenOffset, String docID) {
        Annotation quote = new Annotation(text.substring(begin, end));
        quote.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, begin);
        quote.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, end);
        if (docID != null) {
            quote.set(CoreAnnotations.DocIDAnnotation.class, docID);
        }
        if (quoteTokens != null) {
            quote.set(CoreAnnotations.TokensAnnotation.class, quoteTokens);
            quote.set(CoreAnnotations.TokenBeginAnnotation.class, tokenOffset);
            quote.set(CoreAnnotations.TokenEndAnnotation.class, tokenOffset + quoteTokens.size());
        }
        quote.set(CoreAnnotations.SentenceIndexAnnotation.class, currQuoteSize);
        if (quoteTokens != null) {
            int index = 1;
            for (CoreLabel token : quoteTokens) {
                token.setIndex(index++);
                token.setSentIndex(currQuoteSize);
                if (docID == null) continue;
                token.setDocID(docID);
            }
        }
        return quote;
    }

    public static List<Pair<Integer, Integer>> getQuotes(String text) {
        return QuoteAnnotator.recursiveQuotes(text, 0, null);
    }

    public static List<Pair<Integer, Integer>> recursiveQuotes(String text, int offset, String prevQuote) {
        HashMap quotesMap = new HashMap();
        int start = -1;
        int end = -1;
        String quote = null;
        for (int i = 0; i < text.length(); ++i) {
            String c = text.substring(i, i + 1);
            if (start < 0 && !QuoteAnnotator.matchesPrevQuote(c, prevQuote) && (c.equals("'") && QuoteAnnotator.isSingleQuoteStart(text, i) || c.equals("\""))) {
                start = i;
                quote = text.substring(start, start + 1);
            } else if (start >= 0 && end < 0 && c.equals(quote) && (c.equals("'") && QuoteAnnotator.isSingleQuoteEnd(text, i) || c.equals("\"") && QuoteAnnotator.isDoubleQuoteEnd(text, i))) {
                end = i + 1;
            }
            if (start < 0 || end <= 0) continue;
            if (!quotesMap.containsKey(quote)) {
                quotesMap.put(quote, new ArrayList());
            }
            ((List)quotesMap.get(quote)).add(new Pair<Integer, Integer>(start, end));
            start = -1;
            end = -1;
            quote = null;
        }
        if (start >= 0) {
            String warning = text;
            if (text.length() > 150) {
                warning = text.substring(0, 150) + "...";
            }
            System.err.println("WARNING: unmatched quote of type " + quote + " at end of text segment: " + warning);
        }
        List<Object> embedded = new ArrayList();
        ArrayList<Pair<Integer, Integer>> quotes = new ArrayList<Pair<Integer, Integer>>();
        if (quotesMap.size() < 1 && start >= 0) {
            embedded = QuoteAnnotator.recursiveQuotes(text.substring(start, text.length()), start + offset, quote);
            for (Pair pair : embedded) {
                quotes.add(new Pair<Integer, Integer>((Integer)pair.first() + offset, (Integer)pair.second() + offset));
            }
        } else {
            for (String string : quotesMap.keySet()) {
                for (Pair q : (List)quotesMap.get(string)) {
                    if ((Integer)q.first() < (Integer)q.second() - 2) {
                        embedded = QuoteAnnotator.recursiveQuotes(text.substring((Integer)q.first() + 1, (Integer)q.second() - 1), (Integer)q.first() + 1 + offset, string);
                    }
                    quotes.add(new Pair<Integer, Integer>((Integer)q.first() + offset, (Integer)q.second() + offset));
                    for (Pair pair : embedded) {
                        quotes.add(new Pair<Integer, Integer>((Integer)pair.first() + offset, (Integer)pair.second() + offset));
                    }
                }
            }
        }
        return quotes;
    }

    private static boolean matchesPrevQuote(String c, String prev) {
        return prev != null && prev.equals(c);
    }

    private static boolean isSingleQuoteStart(String text, int i) {
        if (i == 0) {
            return true;
        }
        String prev = text.substring(i - 1, i);
        return QuoteAnnotator.isWhitespaceOrPunct(prev);
    }

    private static boolean isSingleQuoteEnd(String text, int i) {
        if (i == text.length() - 1) {
            return true;
        }
        String next = text.substring(i + 1, i + 2);
        return QuoteAnnotator.isWhitespaceOrPunct(next);
    }

    private static boolean isDoubleQuoteEnd(String text, int i) {
        if (i == text.length() - 1) {
            return true;
        }
        String next = text.substring(i + 1, i + 2);
        if (i == text.length() - 2 && QuoteAnnotator.isWhitespaceOrPunct(next)) {
            return true;
        }
        String nextNext = text.substring(i + 2, i + 3);
        return QuoteAnnotator.isWhitespaceOrPunct(next) && !QuoteAnnotator.isSingleQuote(next) || QuoteAnnotator.isSingleQuote(next) && QuoteAnnotator.isWhitespaceOrPunct(nextNext);
    }

    public static boolean isWhitespaceOrPunct(String c) {
        return c.matches("[\\s\\p{Punct}]");
    }

    public static boolean isSingleQuote(String c) {
        return c.matches("[']");
    }

    @Override
    public Set<Annotator.Requirement> requires() {
        return Collections.emptySet();
    }

    @Override
    public Set<Annotator.Requirement> requirementsSatisfied() {
        return Collections.singleton(QUOTE_REQUIREMENT);
    }

    static {
        HashMap<String, String> tmp = new HashMap<String, String>();
        tmp.put("\u201c", "\u201d");
        tmp.put("\u2018", "\u2019");
        tmp.put("\u00ab", "\u00bb");
        tmp.put("\u2039", "\u203a");
        tmp.put("\u300c", "\u300d");
        tmp.put("\u300e", "\u300f");
        tmp.put("\u201e", "\u201d");
        tmp.put("\u201a", "\u2019");
        DIRECTED_QUOTES = Collections.unmodifiableMap(tmp);
        QUOTES = new String[]{"\"", "'", "\u2019"};
    }
}

