/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ie.NERClassifierCombiner;
import edu.stanford.nlp.ie.regexp.NumberSequenceClassifier;
import edu.stanford.nlp.naturalli.NaturalLogicAnnotator;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.CharniakParserAnnotator;
import edu.stanford.nlp.pipeline.CleanXmlAnnotator;
import edu.stanford.nlp.pipeline.DependencyParseAnnotator;
import edu.stanford.nlp.pipeline.DeterministicCorefAnnotator;
import edu.stanford.nlp.pipeline.EntityMentionsAnnotator;
import edu.stanford.nlp.pipeline.GenderAnnotator;
import edu.stanford.nlp.pipeline.MorphaAnnotator;
import edu.stanford.nlp.pipeline.NERCombinerAnnotator;
import edu.stanford.nlp.pipeline.POSTaggerAnnotator;
import edu.stanford.nlp.pipeline.ParserAnnotator;
import edu.stanford.nlp.pipeline.QuoteAnnotator;
import edu.stanford.nlp.pipeline.RelationExtractorAnnotator;
import edu.stanford.nlp.pipeline.SentimentAnnotator;
import edu.stanford.nlp.pipeline.TokenizerAnnotator;
import edu.stanford.nlp.pipeline.TokensRegexNERAnnotator;
import edu.stanford.nlp.pipeline.TrueCaseAnnotator;
import edu.stanford.nlp.pipeline.WordsToSentencesAnnotator;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.ReflectionLoading;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;

public class AnnotatorImplementations {
    public Annotator tokenizer(Properties properties, boolean verbose, String options) {
        return new TokenizerAnnotator(verbose, properties, options);
    }

    public CleanXmlAnnotator cleanXML(Properties properties, String xmlTagsToRemove, String sentenceEndingTags, String dateTags, boolean allowFlawedXml) {
        return new CleanXmlAnnotator(xmlTagsToRemove, sentenceEndingTags, dateTags, allowFlawedXml);
    }

    public Annotator wordToSentences(Properties properties, boolean verbose, String boundaryTokenRegex, Set<String> boundaryToDiscard, Set<String> htmlElementsToDiscard, String newlineIsSentenceBreak, String boundaryMultiTokenRegex, Set<String> tokenRegexesToDiscard) {
        return new WordsToSentencesAnnotator(verbose, boundaryTokenRegex, boundaryToDiscard, htmlElementsToDiscard, newlineIsSentenceBreak, boundaryMultiTokenRegex, tokenRegexesToDiscard);
    }

    public Annotator posTagger(Properties properties) {
        String annotatorName = "pos";
        return new POSTaggerAnnotator(annotatorName, properties);
    }

    public Annotator morpha(Properties properties, boolean verbose) {
        return new MorphaAnnotator(verbose);
    }

    public Annotator ner(Properties properties) throws FileNotFoundException {
        ArrayList<String> models = new ArrayList<String>();
        String modelNames = properties.getProperty("ner.model");
        if (modelNames == null) {
            modelNames = "edu/stanford/nlp/models/ner/english.all.3class.distsim.crf.ser.gz,edu/stanford/nlp/models/ner/english.muc.7class.distsim.crf.ser.gz,edu/stanford/nlp/models/ner/english.conll.4class.distsim.crf.ser.gz";
        }
        if (modelNames.length() > 0) {
            models.addAll(Arrays.asList(modelNames.split(",")));
        }
        if (models.isEmpty()) {
            System.err.println("WARNING: no NER models specified");
        }
        boolean applyNumericClassifiers = PropertiesUtils.getBool(properties, "ner.applyNumericClassifiers", true);
        boolean useSUTime = PropertiesUtils.getBool(properties, "ner.useSUTime", NumberSequenceClassifier.USE_SUTIME_DEFAULT);
        boolean verbose = false;
        String[] loadPaths = models.toArray(new String[models.size()]);
        NERClassifierCombiner nerCombiner = new NERClassifierCombiner(applyNumericClassifiers, useSUTime, properties, loadPaths);
        int nThreads = PropertiesUtils.getInt(properties, "ner.nthreads", PropertiesUtils.getInt(properties, "nthreads", 1));
        long maxTime = PropertiesUtils.getLong(properties, "ner.maxtime", 0L);
        return new NERCombinerAnnotator(nerCombiner, verbose, nThreads, maxTime);
    }

    public Annotator tokensRegexNER(Properties properties, String name) {
        return new TokensRegexNERAnnotator(name, properties);
    }

    public Annotator mentions(Properties properties, String name) {
        return new EntityMentionsAnnotator(name, properties);
    }

    public Annotator gender(Properties properties, boolean verbose) {
        return new GenderAnnotator(false, properties.getProperty("gender.firstnames", "edu/stanford/nlp/models/gender/first_name_map_small"));
    }

    public Annotator parse(Properties properties) {
        String parserType = properties.getProperty("parse.type", "stanford");
        String maxLenStr = properties.getProperty("parse.maxlen");
        if (parserType.equalsIgnoreCase("stanford")) {
            return new ParserAnnotator("parse", properties);
        }
        if (parserType.equalsIgnoreCase("charniak")) {
            String model = properties.getProperty("parse.model");
            String parserExecutable = properties.getProperty("parse.executable");
            if (model == null || parserExecutable == null) {
                throw new RuntimeException("Both parse.model and parse.executable properties must be specified if parse.type=charniak");
            }
            int maxLen = 399;
            if (maxLenStr != null) {
                maxLen = Integer.parseInt(maxLenStr);
            }
            return new CharniakParserAnnotator(model, parserExecutable, false, maxLen);
        }
        throw new RuntimeException("Unknown parser type: " + parserType + " (currently supported: stanford and charniak)");
    }

    public Annotator custom(Properties properties, String property) {
        String customName = property.substring("customAnnotatorClass.".length());
        String customClassName = properties.getProperty(property);
        return (Annotator)ReflectionLoading.loadByReflection(customClassName, customName, properties);
    }

    public Annotator trueCase(Properties properties, String modelLoc, String classBias, String mixedCaseFileName, boolean verbose) {
        return new TrueCaseAnnotator(modelLoc, classBias, mixedCaseFileName, verbose);
    }

    public Annotator coref(Properties properties) {
        return new DeterministicCorefAnnotator(properties);
    }

    public Annotator relations(Properties properties) {
        return new RelationExtractorAnnotator(properties);
    }

    public Annotator sentiment(Properties properties, String name) {
        return new SentimentAnnotator(name, properties);
    }

    public Annotator dependencies(Properties properties) {
        Properties relevantProperties = PropertiesUtils.extractPrefixedProperties(properties, "depparse.");
        return new DependencyParseAnnotator(relevantProperties);
    }

    public Annotator natlog(Properties properties) {
        Properties relevantProperties = PropertiesUtils.extractPrefixedProperties(properties, "natlog.");
        return new NaturalLogicAnnotator(relevantProperties);
    }

    public Annotator quote(Properties properties) {
        Properties relevantProperties = PropertiesUtils.extractPrefixedProperties(properties, "quote.");
        return new QuoteAnnotator(relevantProperties);
    }
}

