/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns;

import edu.stanford.nlp.patterns.CandidatePhrase;
import edu.stanford.nlp.patterns.DataInstance;
import edu.stanford.nlp.patterns.dep.DepPatternFactory;
import edu.stanford.nlp.patterns.surface.SurfacePatternFactory;
import edu.stanford.nlp.util.Execution;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;

public class PatternFactory {
    @Execution.Option(name="useStopWordsBeforeTerm")
    public static boolean useStopWordsBeforeTerm = false;
    @Execution.Option(name="useTargetNERRestriction")
    public static boolean useTargetNERRestriction = false;
    @Execution.Option(name="numWordsCompound")
    public static int numWordsCompound = 2;
    @Execution.Option(name="useLemmaContextTokens")
    public static boolean useLemmaContextTokens = true;
    public static List<String> fillerWords = Arrays.asList("a", "an", "the", "`", "``", "'", "''");
    public static Pattern ignoreWordRegex = Pattern.compile("a^");

    public static void setUp(Properties props, PatternType patternType) {
        Execution.fillOptions(PatternFactory.class, props);
        if (patternType.equals((Object)PatternType.SURFACE)) {
            SurfacePatternFactory.setUp(props);
        } else if (patternType.equals((Object)PatternType.DEP)) {
            DepPatternFactory.setUp(props);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static boolean doNotUse(String word, Set<CandidatePhrase> stopWords) {
        return stopWords.contains(CandidatePhrase.createOrGet(word.toLowerCase())) || ignoreWordRegex.matcher(word).matches();
    }

    public static Map<Integer, Set> getPatternsAroundTokens(PatternType patternType, DataInstance sent, Set<CandidatePhrase> stopWords) {
        if (patternType.equals((Object)PatternType.SURFACE)) {
            return SurfacePatternFactory.getPatternsAroundTokens(sent, stopWords);
        }
        if (patternType.equals((Object)PatternType.DEP)) {
            return DepPatternFactory.getPatternsAroundTokens(sent, stopWords);
        }
        throw new UnsupportedOperationException();
    }

    public static enum PatternType {
        SURFACE,
        DEP;

    }
}

