/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.metrics;

import edu.stanford.nlp.international.Languages;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasIndex;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.StringUtils;
import java.io.File;
import java.io.PrintWriter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import java.util.TreeMap;

public class LeafAncestorEval {
    private final String name;
    private static final boolean DEBUG = false;
    private double sentAvg = 0.0;
    private double sentNum = 0.0;
    private int sentExact = 0;
    private double corpusAvg = 0.0;
    private double corpusNum = 0.0;
    private final Map<List<CoreLabel>, Double> catAvg;
    private final Map<List<CoreLabel>, Double> catNum;
    private static final String USAGE = String.format("Usage: java %s [OPTS] goldFile guessFile%n%nOptions:%n  -l lang   : Language name %s%n  -y num    : Skip gold trees with yields longer than num.%n  -v        : Verbose output%n", LeafAncestorEval.class.getName(), Languages.listOfLanguages());
    private static final int MIN_ARGS = 2;
    private static boolean VERBOSE = false;
    private static Languages.Language LANGUAGE = Languages.Language.English;
    private static int MAX_GOLD_YIELD = Integer.MAX_VALUE;
    private static File guessFile = null;
    private static File goldFile = null;
    public static final Map<String, Integer> optionArgDefs = Generics.newHashMap();

    public LeafAncestorEval(String str) {
        this.name = str;
        this.catAvg = Generics.newHashMap();
        this.catNum = Generics.newHashMap();
    }

    private static List<List<CoreLabel>> makeLineages(Tree t) {
        if (t == null) {
            return null;
        }
        ((HasIndex)((Object)t.label())).setIndex(0);
        Stack<Tree> treeStack = new Stack<Tree>();
        treeStack.push(t);
        Stack<CoreLabel> labelStack = new Stack<CoreLabel>();
        CoreLabel rootLabel = new CoreLabel(t.label());
        rootLabel.setIndex(0);
        labelStack.push(rootLabel);
        ArrayList<List<CoreLabel>> lineages = new ArrayList<List<CoreLabel>>();
        while (!treeStack.isEmpty()) {
            Tree node = (Tree)treeStack.pop();
            int nodeDepth = ((HasIndex)((Object)node.label())).index();
            while (!labelStack.isEmpty() && ((CoreLabel)labelStack.peek()).index() != nodeDepth - 1) {
                labelStack.pop();
            }
            if (node.isPreTerminal()) {
                ArrayList arrayList = new ArrayList(labelStack);
                lineages.add(arrayList);
                continue;
            }
            for (Tree kid : node.children()) {
                ((HasIndex)((Object)kid.label())).setIndex(nodeDepth + 1);
                treeStack.push(kid);
            }
            CoreLabel coreLabel = new CoreLabel(node.label());
            coreLabel.setIndex(nodeDepth);
            labelStack.add(coreLabel);
        }
        return lineages;
    }

    private void updateCatAverages(List<CoreLabel> lineage, double score) {
        if (this.catAvg.get(lineage) == null) {
            this.catAvg.put(lineage, score);
            this.catNum.put(lineage, 1.0);
        } else {
            double newAvg = this.catAvg.get(lineage) + score;
            this.catAvg.put(lineage, newAvg);
            double newNum = this.catNum.get(lineage) + 1.0;
            this.catNum.put(lineage, newNum);
        }
    }

    public void evaluate(Tree guess, Tree gold, PrintWriter pw) {
        if (gold == null || guess == null) {
            System.err.printf("%s: Cannot compare against a null gold or guess tree!%n", this.getClass().getName());
            return;
        }
        List<List<CoreLabel>> guessLineages = LeafAncestorEval.makeLineages(guess);
        List<List<CoreLabel>> goldLineages = LeafAncestorEval.makeLineages(gold);
        if (guessLineages.size() == goldLineages.size()) {
            double localScores = 0.0;
            for (int i = 0; i < guessLineages.size(); ++i) {
                List<CoreLabel> guessLin = guessLineages.get(i);
                List<CoreLabel> goldLin = goldLineages.get(i);
                double levDist = LeafAncestorEval.editDistance(guessLin, goldLin);
                double la = 1.0 - levDist / (double)(guessLin.size() + goldLin.size());
                localScores += la;
                this.updateCatAverages(goldLin, la);
            }
            this.corpusAvg += localScores;
            this.corpusNum += (double)goldLineages.size();
            double localSentAvg = localScores / (double)goldLineages.size();
            if (localSentAvg == 1.0) {
                ++this.sentExact;
            }
            this.sentAvg += localSentAvg;
            this.sentNum += 1.0;
        } else {
            System.err.printf("%s: Number of guess (%d) gold (%d) don't match!%n", this.getClass().getName(), guessLineages.size(), goldLineages.size());
            System.err.println("Cannot evaluate!");
            System.err.printf("GUESS tree:%n%s%n", guess.toString());
            System.err.printf("GOLD tree:%n%s%n", gold.toString());
        }
    }

    private static int editDistance(List<CoreLabel> l1, List<CoreLabel> l2) {
        int i;
        int[][] m = new int[l1.size() + 1][l2.size() + 1];
        for (i = 1; i <= l1.size(); ++i) {
            m[i][0] = i;
        }
        for (int j = 1; j <= l2.size(); ++j) {
            m[0][j] = j;
        }
        for (i = 1; i <= l1.size(); ++i) {
            for (int j = 1; j <= l2.size(); ++j) {
                m[i][j] = Math.min(m[i - 1][j - 1] + (l1.get(i - 1).equals(l2.get(j - 1)) ? 0 : 1), m[i - 1][j] + 1);
                m[i][j] = Math.min(m[i][j], m[i][j - 1] + 1);
            }
        }
        return m[l1.size()][l2.size()];
    }

    private static String toString(List<CoreLabel> lineage) {
        StringBuilder sb = new StringBuilder();
        for (CoreLabel cl : lineage) {
            sb.append(cl.value());
            sb.append(" <-- ");
        }
        return sb.toString();
    }

    public void display(boolean verbose, PrintWriter pw) {
        Random rand = new Random();
        double corpusLevel = this.corpusAvg / this.corpusNum;
        double sentLevel = this.sentAvg / this.sentNum;
        double sentEx = 100.0 * (double)this.sentExact / this.sentNum;
        if (verbose) {
            double avg;
            TreeMap<Double, List<CoreLabel>> avgMap = new TreeMap<Double, List<CoreLabel>>();
            for (Map.Entry<List<CoreLabel>, Double> entry : this.catAvg.entrySet()) {
                avg = entry.getValue() / this.catNum.get(entry.getKey());
                if (Double.isNaN(avg)) {
                    avg = -1.0;
                }
                if (avgMap.containsKey(avg)) {
                    avgMap.put(avg + rand.nextDouble() / 10000.0, entry.getKey());
                    continue;
                }
                avgMap.put(avg, entry.getKey());
            }
            pw.println("============================================================");
            pw.println("Leaf Ancestor Metric(" + this.name + ") -- final statistics");
            pw.println("============================================================");
            pw.println("#Sentences: " + (int)this.sentNum);
            pw.println();
            pw.println("Sentence-level (macro-averaged)");
            pw.printf(" Avg: %.3f%n", sentLevel);
            pw.printf(" Exact: %.2f%%%n", sentEx);
            pw.println();
            pw.println("Corpus-level (micro-averaged)");
            pw.printf(" Avg: %.3f%n", corpusLevel);
            pw.println("============================================================");
            for (List lineage : avgMap.values()) {
                if (this.catNum.get(lineage) < 30.0) continue;
                avg = this.catAvg.get(lineage) / this.catNum.get(lineage);
                pw.printf(" %.3f\t%d\t%s%n", avg, (int)this.catNum.get(lineage).doubleValue(), LeafAncestorEval.toString(lineage));
            }
            pw.println("============================================================");
        } else {
            pw.printf("%s summary: corpus: %.3f sent: %.3f sent-ex: %.2f%n", this.name, corpusLevel, sentLevel, sentEx);
        }
    }

    private static boolean validateCommandLine(String[] args) {
        Map<String, String[]> argsMap = StringUtils.argsToMap(args, optionArgDefs);
        block10: for (Map.Entry<String, String[]> opt : argsMap.entrySet()) {
            String key = opt.getKey();
            if (key == null) continue;
            switch (key) {
                case "-y": {
                    MAX_GOLD_YIELD = Integer.parseInt(opt.getValue()[0]);
                    continue block10;
                }
                case "-l": {
                    LANGUAGE = Languages.Language.valueOf(opt.getValue()[0]);
                    continue block10;
                }
                case "-v": {
                    VERBOSE = true;
                    continue block10;
                }
            }
            return false;
        }
        String[] rest = argsMap.get(null);
        if (rest == null || rest.length != 2) {
            return false;
        }
        goldFile = new File(rest[0]);
        guessFile = new File(rest[1]);
        return true;
    }

    public static void main(String[] args) {
        if (!LeafAncestorEval.validateCommandLine(args)) {
            System.err.println(USAGE);
            System.exit(-1);
        }
        TreebankLangParserParams tlpp = Languages.getLanguageParams(LANGUAGE);
        PrintWriter pwOut = tlpp.pw();
        DiskTreebank guessTreebank = tlpp.diskTreebank();
        guessTreebank.loadPath(guessFile);
        pwOut.println("GUESS TREEBANK:");
        pwOut.println(guessTreebank.textualSummary());
        DiskTreebank goldTreebank = tlpp.diskTreebank();
        goldTreebank.loadPath(goldFile);
        pwOut.println("GOLD TREEBANK:");
        pwOut.println(goldTreebank.textualSummary());
        LeafAncestorEval metric = new LeafAncestorEval("LeafAncestor");
        TreeTransformer tc = tlpp.collinizer();
        Iterator goldItr = ((AbstractCollection)goldTreebank).iterator();
        Iterator guessItr = ((AbstractCollection)guessTreebank).iterator();
        int goldLineId = 0;
        int guessLineId = 0;
        int skippedGuessTrees = 0;
        while (guessItr.hasNext() && goldItr.hasNext()) {
            Tree guessTree = (Tree)guessItr.next();
            ArrayList<Label> guessYield = guessTree.yield();
            ++guessLineId;
            Tree goldTree = (Tree)goldItr.next();
            ArrayList<Label> goldYield = goldTree.yield();
            ++goldLineId;
            if (goldYield.size() > MAX_GOLD_YIELD) {
                ++skippedGuessTrees;
                continue;
            }
            if (goldYield.size() != guessYield.size()) {
                pwOut.printf("Yield mismatch gold: %d tokens vs. guess: %d tokens (lines: gold %d guess %d)%n", goldYield.size(), guessYield.size(), goldLineId, guessLineId);
                ++skippedGuessTrees;
                continue;
            }
            Tree evalGuess = tc.transformTree(guessTree);
            Tree evalGold = tc.transformTree(goldTree);
            metric.evaluate(evalGuess, evalGold, VERBOSE ? pwOut : null);
        }
        if (guessItr.hasNext() || goldItr.hasNext()) {
            System.err.printf("Guess/gold files do not have equal lengths (guess: %d gold: %d)%n.", guessLineId, goldLineId);
        }
        pwOut.println("================================================================================");
        if (skippedGuessTrees != 0) {
            pwOut.printf("%s %d guess trees%n", "Unable to evaluate", skippedGuessTrees);
        }
        metric.display(true, pwOut);
        pwOut.close();
    }

    static {
        optionArgDefs.put("-y", 1);
        optionArgDefs.put("-l", 1);
        optionArgDefs.put("-v", 0);
    }
}

