/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.ling.CategoryWordTagFactory;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.parser.lexparser.AbstractTreebankParserParams;
import edu.stanford.nlp.parser.lexparser.BaseLexicon;
import edu.stanford.nlp.parser.lexparser.Lexicon;
import edu.stanford.nlp.parser.lexparser.Options;
import edu.stanford.nlp.parser.lexparser.TreeCollinizer;
import edu.stanford.nlp.trees.BobChrisTreeNormalizer;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.EnglishGrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.ModCollinsHeadFinder;
import edu.stanford.nlp.trees.NPTmpRetainingTreeNormalizer;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.TreebankLanguagePack;
import edu.stanford.nlp.util.Index;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class EnglishTreebankParserParams
extends AbstractTreebankParserParams {
    private HeadFinder headFinder;
    private EnglishTrain englishTrain = new EnglishTrain();
    private EnglishTest englishTest = new EnglishTest();
    private static final String[] sisterSplit1 = new String[]{"ADJP=l=VBD", "ADJP=l=VBP", "NP=r=RBR", "PRN=r=.", "ADVP=l=PP", "PP=l=JJ", "PP=r=NP", "SBAR=l=VB", "PP=l=VBG", "ADJP=r=,", "ADVP=r=.", "ADJP=l=VB", "FRAG=l=FRAG", "FRAG=r=:", "PP=r=,", "ADJP=l=,", "FRAG=r=FRAG", "FRAG=l=:", "PRN=r=VP", "PP=l=RB", "S=l=ADJP", "SBAR=l=VBN", "NP=r=NX", "SBAR=l=VBZ", "SBAR=l=ADVP", "QP=r=JJ", "SBAR=l=PP", "SBAR=l=ADJP", "NP=r=VBG", "VP=r=:", "VP=l=ADJP", "SBAR=l=VBP", "ADVP=r=NP", "PP=l=VB", "VP=r=PP", "ADJP=r=SBAR", "NP=r=JJR", "SBAR=l=NN", "S=l=RB", "S=l=NNS", "S=r=SBAR", "S=l=WHPP", "VP=l=:", "ADVP=l=NP", "ADVP=r=PP", "ADJP=l=JJ", "NP=r=VBN", "NP=l=PRN", "VP=r=S", "NP=r=NNPS", "NX=r=NX", "ADJP=l=PRP$", "SBAR=l=CC", "SBAR=l=S", "S=l=PRT", "ADVP=l=VB", "ADVP=r=JJ", "NP=l=DT"};
    private static final String[] sisterSplit2 = new String[]{"S=r=PP", "NP=r=JJS", "ADJP=r=NNP", "NP=l=PRT", "ADJP=r=PP", "ADJP=l=VBZ", "PP=r=VP", "NP=r=CD", "ADVP=l=IN", "ADVP=l=,", "ADJP=r=JJ", "ADVP=l=VBD", "PP=r=.", "S=l=ADVP", "S=l=DT", "PP=l=NP", "VP=l=PRN", "NP=r=IN", "NP=r=``"};
    private static final String[] sisterSplit3 = new String[]{"PP=l=VBD", "ADJP=r=NNS", "S=l=:", "NP=l=ADVP", "NP=r=PRN", "NP=r=-RRB-", "NP=l=-LRB-", "NP=l=JJ", "SBAR=r=.", "S=r=:", "ADVP=r=VP", "NP=l=RB", "NP=r=RB", "S=l=VBP", "SBAR=r=,", "VP=r=,", "PP=r=PP", "NP=r=S", "ADJP=l=NP", "VP=l=VBG", "PP=l=PP"};
    private static final String[] sisterSplit4 = new String[]{"VP=l=NP", "NP=r=NN", "NP=r=VP", "VP=r=.", "NP=r=PP", "VP=l=TO", "VP=l=MD", "NP=r=,", "NP=r=NP", "NP=r=.", "NP=l=IN", "NP=l=NP", "VP=l=,", "VP=l=S", "NP=l=,", "VP=l=VBZ", "S=r=.", "NP=r=NNS", "S=l=IN", "NP=r=JJ", "NP=r=NNP", "VP=l=VBD", "S=l=WHNP", "VP=r=NP", "VP=l=''", "VP=l=VBP", "NP=l=:", "S=r=,", "VP=l=``", "VP=l=VB", "NP=l=S", "NP=l=VP", "NP=l=VB", "NP=l=VBD", "NP=r=SBAR", "NP=r=:", "VP=l=PP", "NP=l=VBZ", "NP=l=CC", "NP=l=''", "S=r=NP", "S=r=S", "S=l=VBN", "NP=l=``", "ADJP=r=NN", "S=r=VP", "NP=r=CC", "VP=l=RB", "S=l=S", "S=l=NP", "NP=l=TO", "S=l=,", "S=l=VBD", "S=r=''", "S=l=``", "S=r=CC", "PP=l=,", "S=l=CC", "VP=l=CC", "ADJP=l=DT", "NP=l=VBG", "VP=r=''", "SBAR=l=NP", "VP=l=VP", "NP=l=PP", "S=l=VB", "SBAR=l=VBD", "VP=l=ADVP", "VP=l=VBN", "NP=r=''", "VP=l=SBAR", "SBAR=l=,", "S=l=WHADVP", "VP=r=VP", "NP=r=ADVP", "QP=r=NNS", "NP=l=VBP", "S=l=VBZ", "NP=l=VBN", "S=l=PP", "VP=r=CC", "NP=l=SBAR", "SBAR=r=NP", "S=l=VBG", "SBAR=r=VP", "NP=r=ADJP", "S=l=JJ", "S=l=NN", "QP=r=NN"};
    private static final TreeFactory categoryWordTagTreeFactory = new LabeledScoredTreeFactory(new CategoryWordTagFactory());
    private static final String[] RETAIN_TMP_ARGS = new String[]{"-retainTmpSubcategories"};
    private static final long serialVersionUID = 4153878351331522581L;

    public EnglishTreebankParserParams() {
        super(new PennTreebankLanguagePack());
        this.headFinder = new ModCollinsHeadFinder(this.tlp);
    }

    @Override
    public HeadFinder headFinder() {
        return this.headFinder;
    }

    @Override
    public HeadFinder typedDependencyHeadFinder() {
        return new SemanticHeadFinder(this.treebankLanguagePack(), !this.englishTest.makeCopulaHead);
    }

    @Override
    public DiskTreebank diskTreebank() {
        return new DiskTreebank(this.treeReaderFactory());
    }

    @Override
    public MemoryTreebank memoryTreebank() {
        return new MemoryTreebank(this.treeReaderFactory());
    }

    @Override
    public TreeReaderFactory treeReaderFactory() {
        return in -> new PennTreeReader(in, new LabeledScoredTreeFactory(), new NPTmpRetainingTreeNormalizer(this.englishTrain.splitTMP, this.englishTrain.splitSGapped == 5, this.englishTrain.leaveItAll, this.englishTrain.splitNPADV >= 1, this.headFinder()));
    }

    @Override
    public MemoryTreebank testMemoryTreebank() {
        return new MemoryTreebank(in -> new PennTreeReader(in, new LabeledScoredTreeFactory(), new BobChrisTreeNormalizer(this.tlp)));
    }

    @Override
    public TreeTransformer collinizer() {
        return new TreeCollinizer(this.tlp, true, this.englishTrain.splitBaseNP == 2, this.englishTrain.collapseWhCategories);
    }

    @Override
    public TreeTransformer collinizerEvalb() {
        return new TreeCollinizer(this.tlp, true, this.englishTrain.splitBaseNP == 2, this.englishTrain.collapseWhCategories);
    }

    @Override
    public TreebankLanguagePack treebankLanguagePack() {
        return this.tlp;
    }

    @Override
    public PrintWriter pw(OutputStream o) {
        return new PrintWriter(o, true);
    }

    @Override
    public Lexicon lex(Options op, Index<String> wordIndex, Index<String> tagIndex) {
        if (op.lexOptions.uwModelTrainer == null) {
            op.lexOptions.uwModelTrainer = "edu.stanford.nlp.parser.lexparser.EnglishUnknownWordModelTrainer";
        }
        return new BaseLexicon(op, wordIndex, tagIndex);
    }

    @Override
    public String[] sisterSplitters() {
        switch (this.englishTrain.sisterSplitLevel) {
            case 1: {
                return sisterSplit1;
            }
            case 2: {
                return sisterSplit2;
            }
            case 3: {
                return sisterSplit3;
            }
            case 4: {
                return sisterSplit4;
            }
        }
        return new String[0];
    }

    @Override
    public TreeTransformer subcategoryStripper() {
        return new EnglishSubcategoryStripper();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Tree transformTree(Tree t, Tree root) {
        String cat;
        String tag;
        String word;
        block494: {
            Tree[] kids;
            String baseCat;
            String parentStr;
            block496: {
                String cat2;
                Tree kid;
                Tree[] kid222;
                int seenNP;
                int seenS;
                boolean sawSBeforePredCat;
                boolean seenPredCat;
                int kid32;
                block501: {
                    Tree[] kid222;
                    int seenNP2;
                    boolean seenS2;
                    boolean seenCC;
                    boolean seenPredCat2;
                    block500: {
                        int n;
                        Tree[] word22;
                        int seenNP3;
                        boolean seenPredCat3;
                        block498: {
                            block499: {
                                block497: {
                                    block495: {
                                        String baseTag;
                                        String baseParentStr;
                                        block476: {
                                            Tree[] foundOrder2;
                                            boolean split;
                                            int infinitive;
                                            block479: {
                                                Tree parent;
                                                block487: {
                                                    boolean annotateHave;
                                                    Tree[] sisters;
                                                    int j;
                                                    block485: {
                                                        block483: {
                                                            block493: {
                                                                block492: {
                                                                    block491: {
                                                                        block490: {
                                                                            block489: {
                                                                                block488: {
                                                                                    block486: {
                                                                                        block484: {
                                                                                            int i;
                                                                                            block480: {
                                                                                                block482: {
                                                                                                    block481: {
                                                                                                        char ch;
                                                                                                        Tree[] kids2;
                                                                                                        block470: {
                                                                                                            block471: {
                                                                                                                block478: {
                                                                                                                    block477: {
                                                                                                                        block472: {
                                                                                                                            block474: {
                                                                                                                                block475: {
                                                                                                                                    block473: {
                                                                                                                                        String baseGrandParentStr;
                                                                                                                                        block375: {
                                                                                                                                            block458: {
                                                                                                                                                block469: {
                                                                                                                                                    block468: {
                                                                                                                                                        String grandParentStr;
                                                                                                                                                        block467: {
                                                                                                                                                            block463: {
                                                                                                                                                                block466: {
                                                                                                                                                                    block465: {
                                                                                                                                                                        block464: {
                                                                                                                                                                            block460: {
                                                                                                                                                                                block462: {
                                                                                                                                                                                    block461: {
                                                                                                                                                                                        block459: {
                                                                                                                                                                                            block457: {
                                                                                                                                                                                                block376: {
                                                                                                                                                                                                    block378: {
                                                                                                                                                                                                        block456: {
                                                                                                                                                                                                            block455: {
                                                                                                                                                                                                                block454: {
                                                                                                                                                                                                                    block453: {
                                                                                                                                                                                                                        block452: {
                                                                                                                                                                                                                            block451: {
                                                                                                                                                                                                                                block450: {
                                                                                                                                                                                                                                    block449: {
                                                                                                                                                                                                                                        block448: {
                                                                                                                                                                                                                                            block447: {
                                                                                                                                                                                                                                                block445: {
                                                                                                                                                                                                                                                    block446: {
                                                                                                                                                                                                                                                        block444: {
                                                                                                                                                                                                                                                            block443: {
                                                                                                                                                                                                                                                                block442: {
                                                                                                                                                                                                                                                                    block384: {
                                                                                                                                                                                                                                                                        block441: {
                                                                                                                                                                                                                                                                            block440: {
                                                                                                                                                                                                                                                                                block439: {
                                                                                                                                                                                                                                                                                    block438: {
                                                                                                                                                                                                                                                                                        block437: {
                                                                                                                                                                                                                                                                                            block436: {
                                                                                                                                                                                                                                                                                                block387: {
                                                                                                                                                                                                                                                                                                    block435: {
                                                                                                                                                                                                                                                                                                        block434: {
                                                                                                                                                                                                                                                                                                            block433: {
                                                                                                                                                                                                                                                                                                                block432: {
                                                                                                                                                                                                                                                                                                                    block431: {
                                                                                                                                                                                                                                                                                                                        block430: {
                                                                                                                                                                                                                                                                                                                            block429: {
                                                                                                                                                                                                                                                                                                                                block428: {
                                                                                                                                                                                                                                                                                                                                    block427: {
                                                                                                                                                                                                                                                                                                                                        block426: {
                                                                                                                                                                                                                                                                                                                                            block425: {
                                                                                                                                                                                                                                                                                                                                                block424: {
                                                                                                                                                                                                                                                                                                                                                    block423: {
                                                                                                                                                                                                                                                                                                                                                        block422: {
                                                                                                                                                                                                                                                                                                                                                            block421: {
                                                                                                                                                                                                                                                                                                                                                                block420: {
                                                                                                                                                                                                                                                                                                                                                                    block419: {
                                                                                                                                                                                                                                                                                                                                                                        block418: {
                                                                                                                                                                                                                                                                                                                                                                            block417: {
                                                                                                                                                                                                                                                                                                                                                                                block416: {
                                                                                                                                                                                                                                                                                                                                                                                    block415: {
                                                                                                                                                                                                                                                                                                                                                                                        block414: {
                                                                                                                                                                                                                                                                                                                                                                                            block413: {
                                                                                                                                                                                                                                                                                                                                                                                                block412: {
                                                                                                                                                                                                                                                                                                                                                                                                    block411: {
                                                                                                                                                                                                                                                                                                                                                                                                        block410: {
                                                                                                                                                                                                                                                                                                                                                                                                            block409: {
                                                                                                                                                                                                                                                                                                                                                                                                                block408: {
                                                                                                                                                                                                                                                                                                                                                                                                                    block407: {
                                                                                                                                                                                                                                                                                                                                                                                                                        block406: {
                                                                                                                                                                                                                                                                                                                                                                                                                            block405: {
                                                                                                                                                                                                                                                                                                                                                                                                                                block404: {
                                                                                                                                                                                                                                                                                                                                                                                                                                    block403: {
                                                                                                                                                                                                                                                                                                                                                                                                                                        block402: {
                                                                                                                                                                                                                                                                                                                                                                                                                                            block401: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                block400: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    block399: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        block398: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            block397: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                block396: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block395: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block394: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block393: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block392: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block391: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block390: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block389: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block388: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block386: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block385: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block382: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block383: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    block381: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        block380: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            block379: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                block377: {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (t == null || t.isLeaf()) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return t;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (root == null || t.equals(root)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        parent = null;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        parentStr = "";
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        parent = t.parent(root);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        parentStr = parent.label().value();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (parent == null || parent.equals(root)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        grandParentStr = "";
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        Tree grandParent = parent.parent(root);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        grandParentStr = grandParent.label().value();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    baseParentStr = this.tlp.basicCategory(parentStr);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    baseGrandParentStr = this.tlp.basicCategory(grandParentStr);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    CoreLabel lab = (CoreLabel)t.label();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    word = lab.word();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    tag = lab.tag();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    baseTag = this.tlp.basicCategory(tag);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = lab.value();
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    baseCat = this.tlp.basicCategory(cat);
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!t.isPreTerminal()) break block375;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!this.englishTrain.correctTags) break block376;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!baseParentStr.equals("NP")) break block377;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    switch (baseCat) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        case "IN": {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equalsIgnoreCase("a") || word.equalsIgnoreCase("that")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "DT");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equalsIgnoreCase("so") || word.equalsIgnoreCase("about")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "RB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("fiscal") || word.equalsIgnoreCase("next")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        case "RB": {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("McNally")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("multifamily")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("MORE")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "JJR");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("hand")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("fist")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        case "RP": {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("Howard")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("whole")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        case "JJ": {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("U.S.")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("ours")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "PRP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("mine")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("Sept.")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        case "NN": {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("Chapman") || word.equals("Jan.") || word.equals("Sept.") || word.equals("Oct.") || word.equals("Nov.") || word.equals("Dec.")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("members") || word.equals("bureaus") || word.equals("days") || word.equals("outfits") || word.equals("institutes") || word.equals("innings") || word.equals("write-offs") || word.equals("wines") || word.equals("trade-offs") || word.equals("tie-ins") || word.equals("thrips") || word.equals("1980s") || word.equals("1920s")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NNS");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("this")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "DT");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        case ":": {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("'")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "''");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        case "NNS": {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("start-up") || word.equals("ground-handling") || word.equals("word-processing") || word.equals("T-shirt") || word.equals("co-pilot")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("Sens.") || word.equals("Aichi")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        case "VBZ": {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("'s")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "POS");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("kills")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NNS");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        case "VBG": {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("preferred")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        case "VB": {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("The")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "DT");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("allowed")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBD");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("short") || word.equals("key") || word.equals("many") || word.equals("last") || word.equals("further")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("lower")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "JJR");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("Nov.") || word.equals("Jan.") || word.equals("Dec.") || word.equals("Tandy") || word.equals("Release") || word.equals("Orkem")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("watch") || word.equals("review") || word.equals("risk") || word.equals("realestate") || word.equals("love") || word.equals("experience") || word.equals("control") || word.equals("Transport") || word.equals("mind") || word.equals("term") || word.equals("program") || word.equals("gender") || word.equals("audit") || word.equals("blame") || word.equals("stock") || word.equals("run") || word.equals("group") || word.equals("affect") || word.equals("rent") || word.equals("show") || word.equals("accord") || word.equals("change") || word.equals("finish") || word.equals("work") || word.equals("schedule") || word.equals("influence") || word.equals("school") || word.equals("freight") || word.equals("growth") || word.equals("travel") || word.equals("call") || word.equals("autograph") || word.equals("demand") || word.equals("abuse") || word.equals("return") || word.equals("defeat") || word.equals("pressure") || word.equals("bank") || word.equals("notice") || word.equals("tax") || word.equals("ooze") || word.equals("network") || word.equals("concern") || word.equals("pit") || word.equals("contract") || word.equals("cash")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        case "NNP": {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("Officials")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NNS");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("Currently")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "RB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        case "PRP": {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("her") && parent.numChildren() > 1) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "PRP$");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("US")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!baseParentStr.equals("WHNP")) break block379;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (baseCat.equals("VBP") && word.equalsIgnoreCase("that")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "WDT");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!baseParentStr.equals("UCP")) break block380;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (word.equals("multifamily")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!baseParentStr.equals("PRT")) break block381;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (baseCat.equals("RBR") && word.equals("in")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "RP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        } else if (baseCat.equals("NNP") && word.equals("up")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "RP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!baseParentStr.equals("PP")) break block382;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (parentStr.equals("PP-TMP") && baseCat.equals("RP")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "IN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("in") || !baseCat.equals("RP") && !baseCat.equals("NN")) break block383;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "IN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (baseCat.equals("RB")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (word.equals("for") || word.equals("After")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "IN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                } else if (word.equals("if") && baseCat.equals("JJ")) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "IN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!baseParentStr.equals("VP")) break block384;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!baseCat.equals("NNS")) break block385;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBZ");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!baseCat.equals("IN")) break block386;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        switch (word) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            case "complicated": {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBD");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            case "post": {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            case "like": {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            case "off": {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "RP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!baseCat.equals("NN")) break block387;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.endsWith("ing")) break block388;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBG");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("bid")) break block389;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("are")) break block390;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("lure")) break block391;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("cost")) break block392;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("agreed")) break block393;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("restructure")) break block394;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("rule")) break block395;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("fret")) break block396;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("retort")) break block397;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                                break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("draft")) break block398;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("will")) break block399;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "MD");
                                                                                                                                                                                                                                                                                                                                                                                                                                                        break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("yield")) break block400;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                    break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("lure")) break block401;
                                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                                break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("feel")) break block402;
                                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("institutes")) break block403;
                                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBZ");
                                                                                                                                                                                                                                                                                                                                                                                                                                        break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("share")) break block404;
                                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                                                    break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("trade")) break block405;
                                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                                break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("beat")) break block406;
                                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("effect")) break block407;
                                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                        break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("speed")) break block408;
                                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                    break block378;
                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("work")) break block409;
                                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                                break block378;
                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("act")) break block410;
                                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("drop")) break block411;
                                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                        break block378;
                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("stand")) break block412;
                                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                                    break block378;
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("push")) break block413;
                                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                                break block378;
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("service")) break block414;
                                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("set")) break block415;
                                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                                                                                                        break block378;
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("appeal")) break block416;
                                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                                    break block378;
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("mold")) break block417;
                                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                                break block378;
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("mean")) break block418;
                                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("reconfirm")) break block419;
                                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                        break block378;
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("land")) break block420;
                                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                                    break block378;
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                if (!word.equals("point")) break block421;
                                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                                break block378;
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                            if (!word.equals("rise")) break block422;
                                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                        if (!word.equals("pressured")) break block423;
                                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                                                                        break block378;
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                    if (!word.equals("smell")) break block424;
                                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                    break block378;
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                if (!word.equals("pay")) break block425;
                                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                                break block378;
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                            if (!word.equals("hum")) break block426;
                                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                        if (!word.equals("shape")) break block427;
                                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                                                        break block378;
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                    if (!word.equals("benefit")) break block428;
                                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                                    break block378;
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                if (!word.equals("abducted")) break block429;
                                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                                                break block378;
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                            if (!word.equals("look")) break block430;
                                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                        if (!word.equals("fare")) break block431;
                                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                        break block378;
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                    if (!word.equals("change")) break block432;
                                                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                    break block378;
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                if (!word.equals("farm")) break block433;
                                                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                                break block378;
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            if (!word.equals("increase")) break block434;
                                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                        if (!word.equals("stem")) break block435;
                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                        break block378;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    if (word.equals("rebounded")) {
                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBD");
                                                                                                                                                                                                                                                                                                        break block378;
                                                                                                                                                                                                                                                                                                    } else if (word.equals("face")) {
                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    break block378;
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                if (!baseCat.equals("NNP")) break block436;
                                                                                                                                                                                                                                                                                                switch (word) {
                                                                                                                                                                                                                                                                                                    case "GRAB": {
                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                        break;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    case "mature": {
                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                        break;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    case "Face": {
                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                        break;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    case "are": {
                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                        break;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    case "Urging": {
                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBG");
                                                                                                                                                                                                                                                                                                        break;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    case "Finding": {
                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBG");
                                                                                                                                                                                                                                                                                                        break;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    case "say": {
                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBP");
                                                                                                                                                                                                                                                                                                        break;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    case "Added": {
                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBD");
                                                                                                                                                                                                                                                                                                        break;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    case "Adds": {
                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBZ");
                                                                                                                                                                                                                                                                                                        break;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    case "BRACED": {
                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBD");
                                                                                                                                                                                                                                                                                                        break;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    case "REQUIRED": {
                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                        break;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    case "SIZING": {
                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBG");
                                                                                                                                                                                                                                                                                                        break;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    case "REVIEW": {
                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                                                        break;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    case "code-named": {
                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                        break;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    case "Printed": {
                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                        break;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    case "Rated": {
                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                        break;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    case "FALTERS": {
                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBZ");
                                                                                                                                                                                                                                                                                                        break;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    case "Got": {
                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBN");
                                                                                                                                                                                                                                                                                                        break;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    case "JUMPING": {
                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBG");
                                                                                                                                                                                                                                                                                                        break;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    case "Branching": {
                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBG");
                                                                                                                                                                                                                                                                                                        break;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    case "Excluding": {
                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBG");
                                                                                                                                                                                                                                                                                                        break;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    case "OKing": {
                                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBG");
                                                                                                                                                                                                                                                                                                        break;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                break block378;
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                            if (!baseCat.equals("POS")) break block437;
                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBZ");
                                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                        if (!baseCat.equals("VBD")) break block438;
                                                                                                                                                                                                                                                                                        if (word.equals("heaves")) {
                                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "VBZ");
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                        break block378;
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                    if (!baseCat.equals("VB")) break block439;
                                                                                                                                                                                                                                                                                    if (word.equals("allowed") || word.equals("increased")) {
                                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "VBD");
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                    break block378;
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                if (!baseCat.equals("VBN")) break block440;
                                                                                                                                                                                                                                                                                if (word.equals("has")) {
                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBZ");
                                                                                                                                                                                                                                                                                    break block378;
                                                                                                                                                                                                                                                                                } else if (word.equals("grew") || word.equals("fell")) {
                                                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "VBD");
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                break block378;
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                            if (!baseCat.equals("JJ")) break block441;
                                                                                                                                                                                                                                                                            if (word.equals("own")) {
                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VB");
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        if (word.equalsIgnoreCase("being")) {
                                                                                                                                                                                                                                                                            if (!cat.equals("VBG")) {
                                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "VBG");
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                                        } else if (word.equalsIgnoreCase("all")) {
                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "RB");
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        break block378;
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    if (!baseParentStr.equals("S")) break block442;
                                                                                                                                                                                                                                                                    if (word.equalsIgnoreCase("all")) {
                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "RB");
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    break block378;
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                if (!baseParentStr.equals("ADJP")) break block443;
                                                                                                                                                                                                                                                                switch (baseCat) {
                                                                                                                                                                                                                                                                    case "UH": {
                                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                                                                                                                                                        break;
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    case "JJ": {
                                                                                                                                                                                                                                                                        if (word.equalsIgnoreCase("more")) {
                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "JJR");
                                                                                                                                                                                                                                                                            break;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        break block378;
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    case "RB": {
                                                                                                                                                                                                                                                                        if (word.equalsIgnoreCase("free")) {
                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                                                                                                                                                            break;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        if (word.equalsIgnoreCase("clear")) {
                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                                                                                                                                                            break;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        if (word.equalsIgnoreCase("tight")) {
                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                                                                                                                                                            break;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        if (word.equalsIgnoreCase("sure")) {
                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                                                                                                                                                            break;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        if (word.equalsIgnoreCase("particular")) {
                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                                                                                                                                                            break;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        break block378;
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    case "VB": {
                                                                                                                                                                                                                                                                        if (word.equalsIgnoreCase("stock")) {
                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "NN");
                                                                                                                                                                                                                                                                            break;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        if (word.equalsIgnoreCase("secure")) {
                                                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                                                                                                                                                            break;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        break block378;
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                break block378;
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            if (!baseParentStr.equals("QP")) break block444;
                                                                                                                                                                                                                                                            if (word.equalsIgnoreCase("about")) {
                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "RB");
                                                                                                                                                                                                                                                                break block378;
                                                                                                                                                                                                                                                            } else if (baseCat.equals("JJ") && word.equalsIgnoreCase("more")) {
                                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "JJR");
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        if (!baseParentStr.equals("ADVP")) break block445;
                                                                                                                                                                                                                                                        if (!baseCat.equals("EX")) break block446;
                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "RB");
                                                                                                                                                                                                                                                        break block378;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    if (baseCat.equals("NN") && word.equalsIgnoreCase("that")) {
                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "DT");
                                                                                                                                                                                                                                                        break block378;
                                                                                                                                                                                                                                                    } else if (baseCat.equals("NNP") && (word.endsWith("ly") || word.equals("Overall"))) {
                                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "RB");
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    break block378;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                if (!baseParentStr.equals("SBAR")) break block447;
                                                                                                                                                                                                                                                if ((word.equalsIgnoreCase("that") || word.equalsIgnoreCase("because") || word.equalsIgnoreCase("while")) && !baseCat.equals("IN")) {
                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "IN");
                                                                                                                                                                                                                                                    break block378;
                                                                                                                                                                                                                                                } else if ((word.equals("Though") || word.equals("Whether")) && baseCat.equals("NNP")) {
                                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "IN");
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                break block378;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (!baseParentStr.equals("SBARQ")) break block448;
                                                                                                                                                                                                                                            if (baseCat.equals("S") && word.equalsIgnoreCase("had")) {
                                                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "SQ");
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        if (!baseCat.equals("JJS")) break block449;
                                                                                                                                                                                                                                        if (word.equalsIgnoreCase("less")) {
                                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "JJR");
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        break block378;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if (!baseCat.equals("JJ")) break block450;
                                                                                                                                                                                                                                    if (word.equalsIgnoreCase("%")) {
                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "NN");
                                                                                                                                                                                                                                        break block378;
                                                                                                                                                                                                                                    } else if (word.equalsIgnoreCase("to")) {
                                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "TO");
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    break block378;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                if (!baseCat.equals("VB")) break block451;
                                                                                                                                                                                                                                if (word.equalsIgnoreCase("even")) {
                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "RB");
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                break block378;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            if (!baseCat.equals(",")) break block452;
                                                                                                                                                                                                                            switch (word) {
                                                                                                                                                                                                                                case "2": {
                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "CD");
                                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                case "an": {
                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "DT");
                                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                case "Wa": {
                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                case "section": {
                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "NN");
                                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                case "underwriters": {
                                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "NNS");
                                                                                                                                                                                                                                    break;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        if (!baseCat.equals("CD")) break block453;
                                                                                                                                                                                                                        if (word.equals("high-risk")) {
                                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        break block378;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    if (!baseCat.equals("RB")) break block454;
                                                                                                                                                                                                                    if (word.equals("for")) {
                                                                                                                                                                                                                        cat = this.changeBaseCat(cat, "IN");
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    break block378;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                if (!baseCat.equals("RP")) break block455;
                                                                                                                                                                                                                if (word.equals("for")) {
                                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "IN");
                                                                                                                                                                                                                }
                                                                                                                                                                                                                break block378;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            if (!baseCat.equals("NN")) break block456;
                                                                                                                                                                                                            if (word.length() == 2 && word.charAt(1) == '.' && Character.isUpperCase(word.charAt(0))) {
                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                                break block378;
                                                                                                                                                                                                            } else if (word.equals("Lorillard")) {
                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "NNP");
                                                                                                                                                                                                            }
                                                                                                                                                                                                            break block378;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        if (word.equals("for") || word.equals("at")) {
                                                                                                                                                                                                            if (!baseCat.equals("IN")) {
                                                                                                                                                                                                                cat = this.changeBaseCat(cat, "IN");
                                                                                                                                                                                                            }
                                                                                                                                                                                                        } else if (word.equalsIgnoreCase("and") && !baseCat.equals("CC")) {
                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "CC");
                                                                                                                                                                                                        } else if (word.equals("ago") && !baseCat.equals("RB")) {
                                                                                                                                                                                                            cat = this.changeBaseCat(cat, "RB");
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                    baseCat = this.tlp.basicCategory(cat);
                                                                                                                                                                                                }
                                                                                                                                                                                                if (this.englishTrain.makePPTOintoIN > 0 && baseCat.equals("TO") && !baseParentStr.equals("VP") && !baseParentStr.equals("CONJP") && !baseParentStr.startsWith("S")) {
                                                                                                                                                                                                    cat = this.englishTrain.makePPTOintoIN == 1 ? this.changeBaseCat(cat, "IN") : cat + "-IN";
                                                                                                                                                                                                }
                                                                                                                                                                                                if (this.englishTrain.splitIN == 5 && baseCat.equals("TO") && grandParentStr.charAt(0) == 'N' && (parentStr.charAt(0) == 'P' || parentStr.charAt(0) == 'A')) {
                                                                                                                                                                                                    cat = this.changeBaseCat(cat, "IN") + "-N";
                                                                                                                                                                                                }
                                                                                                                                                                                                if (this.englishTrain.splitIN != 1 || !baseCat.equals("IN") || parentStr.charAt(0) != 'S') break block457;
                                                                                                                                                                                                cat = cat + "^S";
                                                                                                                                                                                                break block458;
                                                                                                                                                                                            }
                                                                                                                                                                                            if (this.englishTrain.splitIN != 2 || !baseCat.equals("IN")) break block459;
                                                                                                                                                                                            if (parentStr.charAt(0) == 'S') {
                                                                                                                                                                                                cat = cat + "^S";
                                                                                                                                                                                                break block458;
                                                                                                                                                                                            } else if (grandParentStr.charAt(0) == 'N') {
                                                                                                                                                                                                cat = cat + "^N";
                                                                                                                                                                                            }
                                                                                                                                                                                            break block458;
                                                                                                                                                                                        }
                                                                                                                                                                                        if (this.englishTrain.splitIN != 3 || !baseCat.equals("IN")) break block460;
                                                                                                                                                                                        if (grandParentStr.charAt(0) != 'N' || parentStr.charAt(0) != 'P' && parentStr.charAt(0) != 'A') break block461;
                                                                                                                                                                                        cat = cat + "-N";
                                                                                                                                                                                        break block458;
                                                                                                                                                                                    }
                                                                                                                                                                                    if (parentStr.charAt(0) != 'Q' || grandParentStr.charAt(0) != 'N' && !grandParentStr.startsWith("ADJP")) break block462;
                                                                                                                                                                                    cat = cat + "-Q";
                                                                                                                                                                                    break block458;
                                                                                                                                                                                }
                                                                                                                                                                                if (grandParentStr.equals("S")) {
                                                                                                                                                                                    cat = baseParentStr.equals("SBAR") ? cat + "-SCC" : cat + "-SC";
                                                                                                                                                                                    break block458;
                                                                                                                                                                                } else if (baseParentStr.equals("SBAR") || baseParentStr.equals("WHNP")) {
                                                                                                                                                                                    cat = cat + "-T";
                                                                                                                                                                                }
                                                                                                                                                                                break block458;
                                                                                                                                                                            }
                                                                                                                                                                            if (this.englishTrain.splitIN < 4 || this.englishTrain.splitIN > 5 || !baseCat.equals("IN")) break block463;
                                                                                                                                                                            if (grandParentStr.charAt(0) != 'N' || parentStr.charAt(0) != 'P' && parentStr.charAt(0) != 'A') break block464;
                                                                                                                                                                            cat = cat + "-N";
                                                                                                                                                                            break block458;
                                                                                                                                                                        }
                                                                                                                                                                        if (parentStr.charAt(0) != 'Q' || grandParentStr.charAt(0) != 'N' && !grandParentStr.startsWith("ADJP")) break block465;
                                                                                                                                                                        cat = cat + "-Q";
                                                                                                                                                                        break block458;
                                                                                                                                                                    }
                                                                                                                                                                    if (baseGrandParentStr.charAt(0) != 'S' || baseGrandParentStr.equals("SBAR")) break block466;
                                                                                                                                                                    if (baseParentStr.equals("SBAR")) {
                                                                                                                                                                        cat = cat + "-SCC";
                                                                                                                                                                        break block458;
                                                                                                                                                                    } else if (!baseParentStr.equals("NP") && !baseParentStr.equals("ADJP")) {
                                                                                                                                                                        cat = cat + "-SC";
                                                                                                                                                                    }
                                                                                                                                                                    break block458;
                                                                                                                                                                }
                                                                                                                                                                if (baseParentStr.equals("SBAR") || baseParentStr.equals("WHNP") || baseParentStr.equals("WHADVP")) {
                                                                                                                                                                    cat = cat + "-T";
                                                                                                                                                                }
                                                                                                                                                                break block458;
                                                                                                                                                            }
                                                                                                                                                            if (this.englishTrain.splitIN != 6 || !baseCat.equals("IN")) break block458;
                                                                                                                                                            if (grandParentStr.charAt(0) != 'V' && grandParentStr.charAt(0) != 'A') break block467;
                                                                                                                                                            cat = cat + "-V";
                                                                                                                                                            break block458;
                                                                                                                                                        }
                                                                                                                                                        if (grandParentStr.charAt(0) == 'N' && (parentStr.charAt(0) == 'P' || parentStr.charAt(0) == 'A')) break block458;
                                                                                                                                                        if (parentStr.charAt(0) != 'Q' || grandParentStr.charAt(0) != 'N' && !grandParentStr.startsWith("ADJP")) break block468;
                                                                                                                                                        cat = cat + "-Q";
                                                                                                                                                        break block458;
                                                                                                                                                    }
                                                                                                                                                    if (baseGrandParentStr.charAt(0) != 'S' || baseGrandParentStr.equals("SBAR")) break block469;
                                                                                                                                                    if (baseParentStr.equals("SBAR")) {
                                                                                                                                                        cat = cat + "-SCC";
                                                                                                                                                        break block458;
                                                                                                                                                    } else if (!baseParentStr.equals("NP") && !baseParentStr.equals("ADJP")) {
                                                                                                                                                        cat = cat + "-SC";
                                                                                                                                                    }
                                                                                                                                                    break block458;
                                                                                                                                                }
                                                                                                                                                if (baseParentStr.equals("SBAR") || baseParentStr.equals("WHNP") || baseParentStr.equals("WHADVP")) {
                                                                                                                                                    cat = cat + "-T";
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                            if (this.englishTrain.splitPercent && word.equals("%")) {
                                                                                                                                                cat = cat + "-%";
                                                                                                                                            }
                                                                                                                                            if (this.englishTrain.splitNNP > 0 && baseCat.startsWith("NNP")) {
                                                                                                                                                if (this.englishTrain.splitNNP == 1) {
                                                                                                                                                    if (baseCat.equals("NNP")) {
                                                                                                                                                        cat = parent.numChildren() == 1 ? cat + "-S" : (parent.firstChild().equals(t) ? cat + "-L" : (parent.lastChild().equals(t) ? cat + "-R" : cat + "-I"));
                                                                                                                                                    }
                                                                                                                                                } else if (this.englishTrain.splitNNP == 2) {
                                                                                                                                                    if (word.matches("[A-Z]\\.?")) {
                                                                                                                                                        cat = cat + "-I";
                                                                                                                                                    } else if (EnglishTreebankParserParams.firstOfSeveralNNP(parent, t)) {
                                                                                                                                                        cat = cat + "-B";
                                                                                                                                                    } else if (EnglishTreebankParserParams.lastOfSeveralNNP(parent, t)) {
                                                                                                                                                        cat = cat + "-E";
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                            if (this.englishTrain.splitQuotes && (word.equals("'") || word.equals("`"))) {
                                                                                                                                                cat = cat + "-SG";
                                                                                                                                            }
                                                                                                                                            if (this.englishTrain.splitSFP && baseTag.equals(".")) {
                                                                                                                                                if (word.equals("?")) {
                                                                                                                                                    cat = cat + "-QUES";
                                                                                                                                                } else if (word.equals("!")) {
                                                                                                                                                    cat = cat + "-EXCL";
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                            if (this.englishTrain.tagRBGPA && baseCat.equals("RB")) {
                                                                                                                                                cat = cat + "^" + baseGrandParentStr;
                                                                                                                                            }
                                                                                                                                            if (this.englishTrain.joinPound && baseCat.equals("#")) {
                                                                                                                                                cat = this.changeBaseCat(cat, "$");
                                                                                                                                            }
                                                                                                                                            if (this.englishTrain.joinNounTags) {
                                                                                                                                                if (baseCat.equals("NNP")) {
                                                                                                                                                    cat = this.changeBaseCat(cat, "NN");
                                                                                                                                                } else if (baseCat.equals("NNPS")) {
                                                                                                                                                    cat = this.changeBaseCat(cat, "NNS");
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                            if (this.englishTrain.joinJJ && cat.startsWith("JJ")) {
                                                                                                                                                cat = this.changeBaseCat(cat, "JJ");
                                                                                                                                            }
                                                                                                                                            if (this.englishTrain.splitPPJJ && cat.startsWith("JJ") && parentStr.startsWith("PP")) {
                                                                                                                                                cat = cat + "^S";
                                                                                                                                            }
                                                                                                                                            if (!this.englishTrain.splitTRJJ || !cat.startsWith("JJ") || !parentStr.startsWith("PP") && !parentStr.startsWith("ADJP") || this.headFinder().determineHead(parent) != t) break block470;
                                                                                                                                            kids2 = parent.children();
                                                                                                                                            boolean foundJJ = false;
                                                                                                                                            for (int i2 = 0; i2 < kids2.length && !foundJJ; ++i2) {
                                                                                                                                                if (!kids2[i2].label().value().startsWith("JJ")) continue;
                                                                                                                                                foundJJ = true;
                                                                                                                                            }
                                                                                                                                            if (!foundJJ) break block470;
                                                                                                                                            break block471;
                                                                                                                                        }
                                                                                                                                        kids = t.children();
                                                                                                                                        if (!baseCat.equals("VP")) break block472;
                                                                                                                                        if (this.englishTrain.gpaRootVP && this.tlp.isStartSymbol(baseGrandParentStr)) {
                                                                                                                                            cat = cat + "~ROOT";
                                                                                                                                        }
                                                                                                                                        if (!this.englishTrain.splitVPNPAgr) break block473;
                                                                                                                                        switch (baseTag) {
                                                                                                                                            case "VBD": 
                                                                                                                                            case "MD": {
                                                                                                                                                cat = cat + "-VBF";
                                                                                                                                                break;
                                                                                                                                            }
                                                                                                                                            case "VBZ": 
                                                                                                                                            case "TO": 
                                                                                                                                            case "VBG": 
                                                                                                                                            case "VBP": 
                                                                                                                                            case "VBN": 
                                                                                                                                            case "VB": {
                                                                                                                                                cat = cat + "-" + baseTag;
                                                                                                                                                break;
                                                                                                                                            }
                                                                                                                                            default: {
                                                                                                                                                System.err.println("XXXX Head of " + t + " is " + word + "/" + baseTag);
                                                                                                                                                break;
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                        break block472;
                                                                                                                                    }
                                                                                                                                    if (this.englishTrain.splitVP != 3 && this.englishTrain.splitVP != 4) break block474;
                                                                                                                                    if (!baseTag.equals("VBZ") && !baseTag.equals("VBD") && !baseTag.equals("VBP") && !baseTag.equals("MD")) break block475;
                                                                                                                                    cat = cat + "-VBF";
                                                                                                                                    break block472;
                                                                                                                                }
                                                                                                                                if (baseTag.equals("TO") || baseTag.equals("VBG") || baseTag.equals("VBN") || baseTag.equals("VB")) {
                                                                                                                                    cat = cat + "-" + baseTag;
                                                                                                                                    break block472;
                                                                                                                                } else if (this.englishTrain.splitVP == 4) {
                                                                                                                                    String dTag = EnglishTreebankParserParams.deduceTag(word);
                                                                                                                                    cat = cat + "-" + dTag;
                                                                                                                                }
                                                                                                                                break block472;
                                                                                                                            }
                                                                                                                            if (this.englishTrain.splitVP == 2) {
                                                                                                                                cat = baseTag.equals("VBZ") || baseTag.equals("VBD") || baseTag.equals("VBP") || baseTag.equals("MD") ? cat + "-VBF" : cat + "-" + baseTag;
                                                                                                                            } else if (this.englishTrain.splitVP == 1) {
                                                                                                                                cat = cat + "-" + baseTag;
                                                                                                                            }
                                                                                                                        }
                                                                                                                        if (this.englishTrain.dominatesV > 0) {
                                                                                                                            if (this.englishTrain.dominatesV == 2) {
                                                                                                                                if (EnglishTreebankParserParams.hasClausalV(t)) {
                                                                                                                                    cat = cat + "-v";
                                                                                                                                }
                                                                                                                            } else if (this.englishTrain.dominatesV == 3) {
                                                                                                                                if (!(!EnglishTreebankParserParams.hasV(t.preTerminalYield()) || baseCat.equals("WHPP") || baseCat.equals("RRC") || baseCat.equals("QP") || baseCat.equals("PRT"))) {
                                                                                                                                    cat = cat + "-v";
                                                                                                                                }
                                                                                                                            } else if (EnglishTreebankParserParams.hasV(t.preTerminalYield())) {
                                                                                                                                cat = cat + "-v";
                                                                                                                            }
                                                                                                                        }
                                                                                                                        if (this.englishTrain.dominatesI && EnglishTreebankParserParams.hasI(t.preTerminalYield())) {
                                                                                                                            cat = cat + "-i";
                                                                                                                        }
                                                                                                                        if (this.englishTrain.dominatesC && EnglishTreebankParserParams.hasC(t.preTerminalYield())) {
                                                                                                                            cat = cat + "-c";
                                                                                                                        }
                                                                                                                        if (this.englishTrain.splitNPpercent > 0 && word.equals("%") && (baseCat.equals("NP") || this.englishTrain.splitNPpercent > 1 && baseCat.equals("ADJP") || this.englishTrain.splitNPpercent > 2 && baseCat.equals("QP") || this.englishTrain.splitNPpercent > 3)) {
                                                                                                                            cat = cat + "-%";
                                                                                                                        }
                                                                                                                        if (this.englishTrain.splitNPPRP && baseTag.equals("PRP")) {
                                                                                                                            cat = cat + "-PRON";
                                                                                                                        }
                                                                                                                        if (this.englishTrain.splitSbar > 0 && baseCat.equals("SBAR")) {
                                                                                                                            boolean foundIn = false;
                                                                                                                            boolean foundOrder2 = false;
                                                                                                                            infinitive = baseTag.equals("TO");
                                                                                                                            for (Tree kid4 : kids) {
                                                                                                                                if (kid4.isPreTerminal() && kid4.children()[0].value().equalsIgnoreCase("in")) {
                                                                                                                                    foundIn = true;
                                                                                                                                }
                                                                                                                                if (!kid4.isPreTerminal() || !kid4.children()[0].value().equalsIgnoreCase("order")) continue;
                                                                                                                                foundOrder2 = true;
                                                                                                                            }
                                                                                                                            if (this.englishTrain.splitSbar > 1 && infinitive != 0) {
                                                                                                                                cat = cat + "-INF";
                                                                                                                            }
                                                                                                                            if ((this.englishTrain.splitSbar == 1 || this.englishTrain.splitSbar == 3) && foundIn && foundOrder2) {
                                                                                                                                cat = cat + "-PURP";
                                                                                                                            }
                                                                                                                        }
                                                                                                                        if (this.englishTrain.splitNPNNP <= 0) break block476;
                                                                                                                        if (this.englishTrain.splitNPNNP != 1 || !baseCat.equals("NP") || !baseTag.equals("NNP")) break block477;
                                                                                                                        cat = cat + "-NNP";
                                                                                                                        break block476;
                                                                                                                    }
                                                                                                                    if (this.englishTrain.splitNPNNP != 2 || !baseCat.equals("NP") || !baseTag.startsWith("NNP")) break block478;
                                                                                                                    cat = cat + "-NNP";
                                                                                                                    break block476;
                                                                                                                }
                                                                                                                if (this.englishTrain.splitNPNNP != 3 || !baseCat.equals("NP")) break block476;
                                                                                                                split = false;
                                                                                                                foundOrder2 = kids;
                                                                                                                infinitive = foundOrder2.length;
                                                                                                                break block479;
                                                                                                            }
                                                                                                            for (j = i2; j < kids2.length; ++j) {
                                                                                                                if (!kids2[j].label().value().startsWith("NP")) continue;
                                                                                                                cat = cat + "^T";
                                                                                                                break;
                                                                                                            }
                                                                                                        }
                                                                                                        if (this.englishTrain.splitJJCOMP && cat.startsWith("JJ") && (parentStr.startsWith("PP") || parentStr.startsWith("ADJP")) && this.headFinder().determineHead(parent) == t) {
                                                                                                            kids2 = parent.children();
                                                                                                            boolean foundJJ = false;
                                                                                                            for (i = 0; i < kids2.length && !foundJJ; ++i) {
                                                                                                                if (!kids2[i].label().value().startsWith("JJ")) continue;
                                                                                                                foundJJ = true;
                                                                                                            }
                                                                                                            for (int j2 = i; j2 < kids2.length; ++j2) {
                                                                                                                String kid5 = this.tlp.basicCategory(kids2[j2].label().value());
                                                                                                                if (!"S".equals(kid5) && !"SBAR".equals(kid5) && !"PP".equals(kid5) && !"NP".equals(kid5)) continue;
                                                                                                                cat = cat + "^CMPL";
                                                                                                                break;
                                                                                                            }
                                                                                                        }
                                                                                                        if (this.englishTrain.splitMoreLess && ((ch = cat.charAt(0)) == 'R' || ch == 'J' || ch == 'C') && (word.equalsIgnoreCase("more") || word.equalsIgnoreCase("most") || word.equalsIgnoreCase("less") || word.equalsIgnoreCase("least"))) {
                                                                                                            cat = cat + "-ML";
                                                                                                        }
                                                                                                        if (this.englishTrain.unaryDT && cat.startsWith("DT") && parent.children().length == 1) {
                                                                                                            cat = cat + "^U";
                                                                                                        }
                                                                                                        if (this.englishTrain.unaryRB && cat.startsWith("RB") && parent.children().length == 1) {
                                                                                                            cat = cat + "^U";
                                                                                                        }
                                                                                                        if (this.englishTrain.markReflexivePRP && cat.startsWith("PRP") && (word.equalsIgnoreCase("itself") || word.equalsIgnoreCase("themselves") || word.equalsIgnoreCase("himself") || word.equalsIgnoreCase("herself") || word.equalsIgnoreCase("ourselves") || word.equalsIgnoreCase("yourself") || word.equalsIgnoreCase("yourselves") || word.equalsIgnoreCase("myself") || word.equalsIgnoreCase("thyself"))) {
                                                                                                            cat = cat + "-SE";
                                                                                                        }
                                                                                                        if (this.englishTrain.unaryPRP && cat.startsWith("PRP") && parent.children().length == 1) {
                                                                                                            cat = cat + "^U";
                                                                                                        }
                                                                                                        if (this.englishTrain.unaryIN && cat.startsWith("IN") && parent.children().length == 1) {
                                                                                                            cat = cat + "^U";
                                                                                                        }
                                                                                                        if (this.englishTrain.splitCC <= 0 || !baseCat.equals("CC")) break block480;
                                                                                                        if (this.englishTrain.splitCC != 1 || !word.equals("and") && !word.equals("or")) break block481;
                                                                                                        cat = cat + "-C";
                                                                                                        break block480;
                                                                                                    }
                                                                                                    if (this.englishTrain.splitCC != 2) break block482;
                                                                                                    if (word.equalsIgnoreCase("but")) {
                                                                                                        cat = cat + "-B";
                                                                                                        break block480;
                                                                                                    } else if (word.equals("&")) {
                                                                                                        cat = cat + "-A";
                                                                                                    }
                                                                                                    break block480;
                                                                                                }
                                                                                                if (this.englishTrain.splitCC == 3 && word.equalsIgnoreCase("and")) {
                                                                                                    cat = cat + "-A";
                                                                                                }
                                                                                            }
                                                                                            if (this.englishTrain.splitNOT && baseCat.equals("RB") && (word.equalsIgnoreCase("n't") || word.equalsIgnoreCase("not") || word.equalsIgnoreCase("nt"))) {
                                                                                                cat = cat + "-N";
                                                                                            } else if (this.englishTrain.splitRB && baseCat.equals("RB") && (baseParentStr.equals("NP") || baseParentStr.equals("QP") || baseParentStr.equals("ADJP"))) {
                                                                                                cat = cat + "^M";
                                                                                            }
                                                                                            if (this.englishTrain.splitAux <= 1 || !baseCat.equals("VBZ") && !baseCat.equals("VBP") && !baseCat.equals("VBD") && !baseCat.equals("VBN") && !baseCat.equals("VBG") && !baseCat.equals("VB")) break block483;
                                                                                            if (!word.equalsIgnoreCase("'s") && !word.equalsIgnoreCase("s")) break block484;
                                                                                            sisters = parent.children();
                                                                                            boolean foundMe = false;
                                                                                            for (i = 0; i < sisters.length && !foundMe; ++i) {
                                                                                                if (!sisters[i].label().value().startsWith("VBZ")) continue;
                                                                                                foundMe = true;
                                                                                            }
                                                                                            annotateHave = false;
                                                                                            break block485;
                                                                                        }
                                                                                        if (!word.equalsIgnoreCase("am") && !word.equalsIgnoreCase("is") && !word.equalsIgnoreCase("are") && !word.equalsIgnoreCase("was") && !word.equalsIgnoreCase("were") && !word.equalsIgnoreCase("'m") && !word.equalsIgnoreCase("'re") && !word.equalsIgnoreCase("be") && !word.equalsIgnoreCase("being") && !word.equalsIgnoreCase("been") && !word.equalsIgnoreCase("ai")) break block486;
                                                                                        cat = cat + "-BE";
                                                                                        break block487;
                                                                                    }
                                                                                    if (!word.equalsIgnoreCase("have") && !word.equalsIgnoreCase("'ve") && !word.equalsIgnoreCase("having") && !word.equalsIgnoreCase("has") && !word.equalsIgnoreCase("had") && !word.equalsIgnoreCase("'d")) break block488;
                                                                                    cat = cat + "-HV";
                                                                                    break block487;
                                                                                }
                                                                                if (this.englishTrain.splitAux < 3 || !word.equalsIgnoreCase("do") && !word.equalsIgnoreCase("did") && !word.equalsIgnoreCase("does") && !word.equalsIgnoreCase("done") && !word.equalsIgnoreCase("doing")) break block489;
                                                                                cat = cat + "-DO";
                                                                                break block487;
                                                                            }
                                                                            if (this.englishTrain.splitAux < 4 || !word.equalsIgnoreCase("help") && !word.equalsIgnoreCase("helps") && !word.equalsIgnoreCase("helped") && !word.equalsIgnoreCase("helping")) break block490;
                                                                            cat = cat + "-DO";
                                                                            break block487;
                                                                        }
                                                                        if (this.englishTrain.splitAux < 5 || !word.equalsIgnoreCase("let") && !word.equalsIgnoreCase("lets") && !word.equalsIgnoreCase("letting")) break block491;
                                                                        cat = cat + "-DO";
                                                                        break block487;
                                                                    }
                                                                    if (this.englishTrain.splitAux < 6 || !word.equalsIgnoreCase("make") && !word.equalsIgnoreCase("makes") && !word.equalsIgnoreCase("making") && !word.equalsIgnoreCase("made")) break block492;
                                                                    cat = cat + "-DO";
                                                                    break block487;
                                                                }
                                                                if (this.englishTrain.splitAux < 7 || !word.equalsIgnoreCase("watch") && !word.equalsIgnoreCase("watches") && !word.equalsIgnoreCase("watching") && !word.equalsIgnoreCase("watched") && !word.equalsIgnoreCase("see") && !word.equalsIgnoreCase("sees") && !word.equalsIgnoreCase("seeing") && !word.equalsIgnoreCase("saw") && !word.equalsIgnoreCase("seen")) break block493;
                                                                cat = cat + "-DO";
                                                                break block487;
                                                            }
                                                            if (this.englishTrain.splitAux >= 8 && (word.equalsIgnoreCase("go") || word.equalsIgnoreCase("come"))) {
                                                                cat = cat + "-DO";
                                                                break block487;
                                                            } else if (this.englishTrain.splitAux >= 9 && (word.equalsIgnoreCase("get") || word.equalsIgnoreCase("gets") || word.equalsIgnoreCase("getting") || word.equalsIgnoreCase("got") || word.equalsIgnoreCase("gotten"))) {
                                                                cat = cat + "-BE";
                                                            }
                                                            break block487;
                                                        }
                                                        if (this.englishTrain.splitAux > 0 && (baseCat.equals("VBZ") || baseCat.equals("VBP") || baseCat.equals("VBD") || baseCat.equals("VBN") || baseCat.equals("VBG") || baseCat.equals("VB"))) {
                                                            if (word.equalsIgnoreCase("is") || word.equalsIgnoreCase("am") || word.equalsIgnoreCase("are") || word.equalsIgnoreCase("was") || word.equalsIgnoreCase("were") || word.equalsIgnoreCase("'m") || word.equalsIgnoreCase("'re") || word.equalsIgnoreCase("'s") || word.equalsIgnoreCase("being") || word.equalsIgnoreCase("be") || word.equalsIgnoreCase("been")) {
                                                                cat = cat + "-BE";
                                                            }
                                                            if (word.equalsIgnoreCase("have") || word.equalsIgnoreCase("'ve") || word.equalsIgnoreCase("having") || word.equalsIgnoreCase("has") || word.equalsIgnoreCase("had") || word.equalsIgnoreCase("'d")) {
                                                                cat = cat + "-HV";
                                                            }
                                                        }
                                                        break block487;
                                                    }
                                                    for (j = i; j < sisters.length; ++j) {
                                                        if (!sisters[j].label().value().startsWith("VP")) continue;
                                                        for (Tree kid6 : sisters[j].children()) {
                                                            if (!kid6.label().value().startsWith("VBN") && !kid6.label().value().startsWith("VBD")) continue;
                                                            annotateHave = true;
                                                        }
                                                    }
                                                    cat = annotateHave ? cat + "-HV" : cat + "-BE";
                                                }
                                                if (this.englishTrain.collapseWhCategories != 0) {
                                                    if ((this.englishTrain.collapseWhCategories & 1) != 0) {
                                                        cat = cat.replaceAll("WH(NP|PP|ADVP|ADJP)", "$1");
                                                    }
                                                    if ((this.englishTrain.collapseWhCategories & 2) != 0) {
                                                        cat = cat.replaceAll("WP", "PRP");
                                                        cat = cat.replaceAll("WDT", "DT");
                                                        cat = cat.replaceAll("WRB", "RB");
                                                    }
                                                    if ((this.englishTrain.collapseWhCategories & 4) != 0) {
                                                        cat = cat.replaceAll("WH(PP|ADVP|ADJP)", "$1");
                                                    }
                                                }
                                                if (this.englishTrain.markDitransV > 0 && cat.startsWith("VB")) {
                                                    cat = cat + this.ditrans(parent);
                                                } else if (this.englishTrain.vpSubCat && cat.startsWith("VB")) {
                                                    cat = cat + EnglishTreebankParserParams.subCatify(parent);
                                                }
                                                tag = cat;
                                                break block494;
                                            }
                                            for (int i = 0; i < infinitive; ++i) {
                                                Tree kid222 = foundOrder2[i];
                                                if (!kid222.value().startsWith("NNP")) continue;
                                                split = true;
                                                break;
                                            }
                                            if (split) {
                                                cat = cat + "-NNP";
                                            }
                                        }
                                        if (this.englishTrain.collapseWhCategories != 0) {
                                            if ((this.englishTrain.collapseWhCategories & 1) != 0) {
                                                cat = cat.replaceAll("WH(NP|PP|ADVP|ADJP)", "$1");
                                            }
                                            if ((this.englishTrain.collapseWhCategories & 2) != 0) {
                                                cat = cat.replaceAll("WP", "PRP");
                                                cat = cat.replaceAll("WDT", "DT");
                                                cat = cat.replaceAll("WRB", "RB");
                                            }
                                            if ((this.englishTrain.collapseWhCategories & 4) != 0) {
                                                cat = cat.replaceAll("WH(PP|ADVP|ADJP)", "$1");
                                            }
                                        }
                                        if (this.englishTrain.splitVPNPAgr && baseCat.equals("NP") && baseParentStr.startsWith("S")) {
                                            if (baseTag.equals("NNPS") || baseTag.equals("NNS")) {
                                                cat = cat + "-PL";
                                            } else if (word.equalsIgnoreCase("many") || word.equalsIgnoreCase("more") || word.equalsIgnoreCase("most") || word.equalsIgnoreCase("plenty")) {
                                                cat = cat + "-PL";
                                            } else if (!(baseTag.equals("NN") || baseTag.equals("NNP") || baseTag.equals("POS") || baseTag.equals("CD") || baseTag.equals("PRP$") || baseTag.equals("JJ") || baseTag.equals("EX") || baseTag.equals("$") || baseTag.equals("RB") || baseTag.equals("FW") || baseTag.equals("VBG") || baseTag.equals("JJS") || baseTag.equals("JJR"))) {
                                                if (baseTag.equals("PRP")) {
                                                    if (word.equalsIgnoreCase("they") || word.equalsIgnoreCase("them") || word.equalsIgnoreCase("we") || word.equalsIgnoreCase("us")) {
                                                        cat = cat + "-PL";
                                                    }
                                                } else if (baseTag.equals("DT") || baseTag.equals("WDT")) {
                                                    if (word.equalsIgnoreCase("these") || word.equalsIgnoreCase("those") || word.equalsIgnoreCase("several")) {
                                                        cat = cat + "-PL";
                                                    }
                                                } else {
                                                    System.err.println("XXXX Head of " + t + " is " + word + "/" + baseTag);
                                                }
                                            }
                                        }
                                        if (this.englishTrain.splitSTag > 0 && (baseCat.equals("S") || this.englishTrain.splitSTag <= 3 && (baseCat.equals("SINV") || baseCat.equals("SQ")))) {
                                            if (this.englishTrain.splitSTag == 1) {
                                                cat = cat + "-" + baseTag;
                                            } else if (baseTag.equals("VBZ") || baseTag.equals("VBD") || baseTag.equals("VBP") || baseTag.equals("MD")) {
                                                cat = cat + "-VBF";
                                            } else if ((this.englishTrain.splitSTag == 3 || this.englishTrain.splitSTag == 5) && (baseTag.equals("TO") || baseTag.equals("VBG") || baseTag.equals("VBN") || baseTag.equals("VB"))) {
                                                cat = cat + "-VBNF";
                                            }
                                        }
                                        if (this.englishTrain.markContainedVP && this.containsVP(t)) {
                                            cat = cat + "-vp";
                                        }
                                        if (this.englishTrain.markCC > 0) {
                                            for (int i = 1; i < kids.length - 1; ++i) {
                                                String cat22 = kids[i].label().value();
                                                if (cat22.startsWith("CC")) {
                                                    String word22 = kids[i].children()[0].value();
                                                    if (word22.equals("either") || word22.equals("both") || word22.equals("neither")) continue;
                                                    cat = cat + "-CC";
                                                    break;
                                                }
                                                if (this.englishTrain.markCC <= 1 || !cat22.startsWith("CONJP")) continue;
                                                cat = cat + "-CC";
                                                break;
                                            }
                                        }
                                        if (this.englishTrain.splitSGapped != 1 || !baseCat.equals("S") || kids[0].label().value().startsWith("NP")) break block495;
                                        cat = cat + "-G";
                                        break block496;
                                    }
                                    if (this.englishTrain.splitSGapped != 2 || !baseCat.equals("S")) break block497;
                                    seenPredCat3 = false;
                                    seenNP3 = 0;
                                    word22 = kids;
                                    n = word22.length;
                                    break block498;
                                }
                                if (this.englishTrain.splitSGapped != 3 || !baseCat.equals("S")) break block499;
                                seenPredCat2 = false;
                                seenCC = false;
                                seenS2 = false;
                                seenNP2 = 0;
                                kid222 = kids;
                                kid32 = kid222.length;
                                break block500;
                            }
                            if (this.englishTrain.splitSGapped != 4 || !baseCat.equals("S")) break block496;
                            seenPredCat = false;
                            sawSBeforePredCat = false;
                            seenS = 0;
                            seenNP = 0;
                            kid222 = kids;
                            kid32 = kid222.length;
                            break block501;
                        }
                        for (int kid222 = 0; kid222 < n; ++kid222) {
                            Tree kid32 = word22[kid222];
                            String cat23 = kid32.label().value();
                            if (cat23.startsWith("NP")) {
                                ++seenNP3;
                                continue;
                            }
                            if (!cat23.startsWith("VP") && !cat23.startsWith("ADJP") && !cat23.startsWith("PP") && !cat23.startsWith("UCP")) continue;
                            seenPredCat3 = true;
                        }
                        if (seenNP3 == 0 || seenNP3 == 1 && !seenPredCat3) {
                            cat = cat + "-G";
                        }
                        break block496;
                    }
                    for (int i = 0; i < kid32; ++i) {
                        kid = kid222[i];
                        cat2 = kid.label().value();
                        if (cat2.startsWith("NP")) {
                            ++seenNP2;
                            continue;
                        }
                        if (cat2.startsWith("VP") || cat2.startsWith("ADJP") || cat2.startsWith("PP") || cat2.startsWith("UCP")) {
                            seenPredCat2 = true;
                            continue;
                        }
                        if (cat2.startsWith("CC")) {
                            seenCC = true;
                            continue;
                        }
                        if (!cat2.startsWith("S")) continue;
                        seenS2 = true;
                    }
                    if (!(seenCC && seenS2 || seenNP2 != 0 && (seenNP2 != 1 || seenPredCat2))) {
                        cat = cat + "-G";
                    }
                    break block496;
                }
                for (int i = 0; i < kid32; ++i) {
                    kid = kid222[i];
                    cat2 = kid.label().value();
                    if (cat2.startsWith("NP")) {
                        ++seenNP;
                        continue;
                    }
                    if (cat2.startsWith("VP") || cat2.startsWith("ADJP") || cat2.startsWith("PP") || cat2.startsWith("UCP")) {
                        seenPredCat = true;
                        continue;
                    }
                    if (!cat2.startsWith("S")) continue;
                    ++seenS;
                    if (seenPredCat) continue;
                    sawSBeforePredCat = true;
                }
                if (!(seenS >= 2 || sawSBeforePredCat && seenPredCat || seenNP != 0 && (seenNP != 1 || seenPredCat))) {
                    cat = cat + "-G";
                }
            }
            if (this.englishTrain.splitNumNP && baseCat.equals("NP")) {
                boolean seenNum = false;
                for (Tree kid : kids) {
                    String cat2 = kid.label().value();
                    if (!cat2.startsWith("QP") && !cat2.startsWith("CD") && !cat2.startsWith("$") && !cat2.startsWith("#") && (!cat2.startsWith("NN") || !cat2.contains("-%"))) continue;
                    seenNum = true;
                    break;
                }
                if (seenNum) {
                    cat = cat + "-NUM";
                }
            }
            if (this.englishTrain.splitPoss > 0 && baseCat.equals("NP") && kids[kids.length - 1].label().value().startsWith("POS")) {
                if (this.englishTrain.splitPoss == 2) {
                    CategoryWordTag labelBot = t.isPrePreTerminal() ? new CategoryWordTag("NP^POSSP-B", word, tag) : new CategoryWordTag("NP^POSSP", word, tag);
                    t.setLabel(labelBot);
                    List<Tree> oldKids = t.getChildrenAsList();
                    ArrayList<Tree> newKids = new ArrayList<Tree>();
                    for (int i = 0; i < oldKids.size() - 1; ++i) {
                        newKids.add(oldKids.get(i));
                    }
                    t.setChildren(newKids);
                    cat = this.changeBaseCat(cat, "POSSP");
                    CategoryWordTag labelTop = new CategoryWordTag(cat, word, tag);
                    ArrayList<Tree> newerChildren = new ArrayList<Tree>(2);
                    newerChildren.add(t);
                    Tree last = oldKids.get(oldKids.size() - 1);
                    if (!last.value().equals("POS^NP")) {
                        System.err.println("Unexpected POS value (!): " + last);
                    }
                    last.setValue("POS^POSSP");
                    newerChildren.add(last);
                    return categoryWordTagTreeFactory.newTreeNode(labelTop, newerChildren);
                }
                cat = cat + "-P";
            }
            if (this.englishTrain.splitBaseNP > 0 && baseCat.equals("NP") && t.isPrePreTerminal()) {
                if (this.englishTrain.splitBaseNP == 2) {
                    if (!parentStr.startsWith("NP")) {
                        CategoryWordTag labelBot = new CategoryWordTag("NP^NP-B", word, tag);
                        t.setLabel(labelBot);
                        CategoryWordTag labelTop = new CategoryWordTag(cat, word, tag);
                        ArrayList<Tree> newerChildren = new ArrayList<Tree>(1);
                        newerChildren.add(t);
                        return categoryWordTagTreeFactory.newTreeNode(labelTop, newerChildren);
                    }
                    cat = cat + "-B";
                } else {
                    cat = cat + "-B";
                }
            }
            if (this.englishTrain.rightPhrasal && EnglishTreebankParserParams.rightPhrasal(t)) {
                cat = cat + "-RX";
            }
        }
        t.setLabel(new CategoryWordTag(cat, word, tag));
        return t;
    }

    private boolean containsVP(Tree t) {
        String cat = this.tlp.basicCategory(t.label().value());
        if (cat.equals("VP")) {
            return true;
        }
        for (Tree kid : t.children()) {
            if (!this.containsVP(kid)) continue;
            return true;
        }
        return false;
    }

    private static boolean firstOfSeveralNNP(Tree parent, Tree t) {
        boolean firstIsT = false;
        int numNNP = 0;
        for (Tree kid : parent.children()) {
            if (!kid.value().startsWith("NNP")) continue;
            if (t.equals(kid) && numNNP == 0) {
                firstIsT = true;
            }
            ++numNNP;
        }
        return numNNP > 1 && firstIsT;
    }

    private static boolean lastOfSeveralNNP(Tree parent, Tree t) {
        Tree last = null;
        int numNNP = 0;
        for (Tree kid : parent.children()) {
            if (!kid.value().startsWith("NNP")) continue;
            ++numNNP;
            last = kid;
        }
        return numNNP > 1 && t.equals(last);
    }

    private static String deduceTag(String w) {
        String word = w.toLowerCase();
        if (word.endsWith("ing")) {
            return "VBG";
        }
        if (word.endsWith("d") || word.endsWith("t")) {
            return "VBN";
        }
        if (word.endsWith("s")) {
            return "VBZ";
        }
        if (word.equals("to")) {
            return "TO";
        }
        return "VB";
    }

    private static boolean rightPhrasal(Tree t) {
        while (!t.isLeaf()) {
            String str = (t = t.lastChild()).label().value();
            if (!str.startsWith("NP") && !str.startsWith("PP") && !str.startsWith("VP") && !str.startsWith("S") && !str.startsWith("Q") && !str.startsWith("A")) continue;
            return true;
        }
        return false;
    }

    private static String subCatify(Tree t) {
        StringBuilder sb = new StringBuilder("^a");
        boolean n = false;
        boolean s = false;
        boolean p = false;
        for (int i = 0; i < t.children().length; ++i) {
            String childStr = t.children()[i].label().value();
            n = n || childStr.startsWith("NP");
            s = s || childStr.startsWith("S");
            p = p || childStr.startsWith("PP");
        }
        n = false;
        if (n) {
            sb.append('N');
        }
        if (p) {
            sb.append('P');
        }
        if (s) {
            sb.append('S');
        }
        return sb.toString();
    }

    private String ditrans(Tree t) {
        int n = 0;
        for (Tree kid : t.children()) {
            String childStr = kid.label().value();
            if (childStr.startsWith("NP") && !childStr.contains("-TMP")) {
                ++n;
                continue;
            }
            if (this.englishTrain.markDitransV != 1 || !childStr.startsWith("S")) continue;
            ++n;
        }
        if (n >= 2) {
            return "^2Arg";
        }
        return "";
    }

    private String changeBaseCat(String cat, String newBaseCat) {
        int i;
        int length = cat.length();
        for (i = 1; i < length && !this.tlp.isLabelAnnotationIntroducingCharacter(cat.charAt(i)); ++i) {
        }
        if (i < length) {
            return newBaseCat + cat.substring(i);
        }
        return newBaseCat;
    }

    private static boolean hasClausalV(Tree tree) {
        if (tree.isPhrasal()) {
            Tree[] kids;
            if (tree.isPrePreTerminal() && tree.value().startsWith("NP")) {
                return false;
            }
            for (Tree t : kids = tree.children()) {
                if (!EnglishTreebankParserParams.hasClausalV(t)) continue;
                return true;
            }
            return false;
        }
        String str = tree.value();
        return str.startsWith("VB") || str.startsWith("MD");
    }

    private static boolean hasV(List<? extends Label> tags) {
        for (Label label : tags) {
            String str = label.toString();
            if (!str.startsWith("V") && !str.startsWith("MD")) continue;
            return true;
        }
        return false;
    }

    private static boolean hasI(List<? extends Label> tags) {
        for (Label label : tags) {
            if (!label.toString().startsWith("I")) continue;
            return true;
        }
        return false;
    }

    private static boolean hasC(List<? extends Label> tags) {
        for (Label label : tags) {
            if (!label.toString().startsWith("CC")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void display() {
        this.englishTrain.display();
    }

    @Override
    public int setOptionFlag(String[] args, int i) {
        if (args[i].equalsIgnoreCase("-splitIN")) {
            this.englishTrain.splitIN = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitPercent")) {
            this.englishTrain.splitPercent = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitQuotes")) {
            this.englishTrain.splitQuotes = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitSFP")) {
            this.englishTrain.splitSFP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitNNP")) {
            this.englishTrain.splitNNP = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-rbGPA")) {
            this.englishTrain.tagRBGPA = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitTRJJ")) {
            this.englishTrain.splitTRJJ = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitJJCOMP")) {
            this.englishTrain.splitJJCOMP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitMoreLess")) {
            this.englishTrain.splitMoreLess = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-unaryDT")) {
            this.englishTrain.unaryDT = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-unaryRB")) {
            this.englishTrain.unaryRB = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-unaryIN")) {
            this.englishTrain.unaryIN = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markReflexivePRP")) {
            this.englishTrain.markReflexivePRP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitCC") && i + 1 < args.length) {
            this.englishTrain.splitCC = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitRB")) {
            this.englishTrain.splitRB = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitAux") && i + 1 < args.length) {
            this.englishTrain.splitAux = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitSbar") && i + 1 < args.length) {
            this.englishTrain.splitSbar = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitVP") && i + 1 < args.length) {
            this.englishTrain.splitVP = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitVPNPAgr")) {
            this.englishTrain.splitVPNPAgr = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-gpaRootVP")) {
            this.englishTrain.gpaRootVP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-makePPTOintoIN")) {
            this.englishTrain.makePPTOintoIN = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-collapseWhCategories") && i + 1 < args.length) {
            this.englishTrain.collapseWhCategories = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitSTag")) {
            this.englishTrain.splitSTag = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitSGapped") && i + 1 < args.length) {
            this.englishTrain.splitSGapped = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitNPpercent") && i + 1 < args.length) {
            this.englishTrain.splitNPpercent = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitNPPRP")) {
            this.englishTrain.splitNPPRP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-dominatesV") && i + 1 < args.length) {
            this.englishTrain.dominatesV = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-dominatesI")) {
            this.englishTrain.dominatesI = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-dominatesC")) {
            this.englishTrain.dominatesC = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-splitNPNNP") && i + 1 < args.length) {
            this.englishTrain.splitNPNNP = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitTMP") && i + 1 < args.length) {
            this.englishTrain.splitTMP = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitNPADV") && i + 1 < args.length) {
            this.englishTrain.splitNPADV = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-markContainedVP")) {
            this.englishTrain.markContainedVP = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markDitransV") && i + 1 < args.length) {
            this.englishTrain.markDitransV = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-splitPoss") && i + 1 < args.length) {
            this.englishTrain.splitPoss = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-baseNP") && i + 1 < args.length) {
            this.englishTrain.splitBaseNP = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-joinNounTags")) {
            this.englishTrain.joinNounTags = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-correctTags")) {
            this.englishTrain.correctTags = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-noCorrectTags")) {
            this.englishTrain.correctTags = false;
            ++i;
        } else if (args[i].equalsIgnoreCase("-markCC") && i + 1 < args.length) {
            this.englishTrain.markCC = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-noAnnotations")) {
            this.englishTrain.splitVP = 0;
            this.englishTrain.splitTMP = 0;
            this.englishTrain.splitSGapped = 0;
            ++i;
        } else if (args[i].equalsIgnoreCase("-retainNPTMPSubcategories")) {
            this.englishTest.retainNPTMPSubcategories = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-retainTMPSubcategories")) {
            this.englishTest.retainTMPSubcategories = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-retainADVSubcategories")) {
            this.englishTest.retainADVSubcategories = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-leaveItAll") && i + 1 < args.length) {
            this.englishTrain.leaveItAll = Integer.parseInt(args[i + 1]);
            i += 2;
        } else if (args[i].equalsIgnoreCase("-headFinder") && i + 1 < args.length) {
            try {
                this.headFinder = (HeadFinder)Class.forName(args[i + 1]).newInstance();
            }
            catch (Exception e) {
                System.err.println(e);
                System.err.println("Warning: Default HeadFinder will be used.");
            }
            i += 2;
        } else if (args[i].equalsIgnoreCase("-makeCopulaHead")) {
            this.englishTest.makeCopulaHead = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-acl03pcfg")) {
            this.englishTrain.splitIN = 3;
            this.englishTrain.splitPercent = true;
            this.englishTrain.splitPoss = 1;
            this.englishTrain.splitCC = 2;
            this.englishTrain.unaryDT = true;
            this.englishTrain.unaryRB = true;
            this.englishTrain.splitAux = 1;
            this.englishTrain.splitVP = 2;
            this.englishTrain.splitSGapped = 3;
            this.englishTrain.dominatesV = 1;
            this.englishTrain.splitTMP = 1;
            this.englishTrain.splitBaseNP = 1;
            ++i;
        } else if (args[i].equalsIgnoreCase("-jenny")) {
            this.englishTrain.splitIN = 3;
            this.englishTrain.splitPercent = true;
            this.englishTrain.splitPoss = 1;
            this.englishTrain.splitCC = 2;
            this.englishTrain.unaryDT = true;
            this.englishTrain.unaryRB = true;
            this.englishTrain.splitAux = 1;
            this.englishTrain.splitVP = 2;
            this.englishTrain.splitSGapped = 3;
            this.englishTrain.dominatesV = 1;
            this.englishTrain.splitTMP = 1;
            this.englishTrain.splitBaseNP = 1;
            ++i;
        } else if (args[i].equalsIgnoreCase("-linguisticPCFG")) {
            this.englishTrain.splitIN = 3;
            this.englishTrain.splitPercent = true;
            this.englishTrain.splitPoss = 1;
            this.englishTrain.splitCC = 2;
            this.englishTrain.unaryDT = true;
            this.englishTrain.unaryRB = true;
            this.englishTrain.splitAux = 2;
            this.englishTrain.splitVP = 3;
            this.englishTrain.splitSGapped = 4;
            this.englishTrain.dominatesV = 0;
            this.englishTrain.splitTMP = 1;
            this.englishTrain.splitBaseNP = 1;
            this.englishTrain.splitMoreLess = true;
            this.englishTrain.correctTags = true;
            ++i;
        } else if (args[i].equalsIgnoreCase("-goodPCFG")) {
            this.englishTrain.splitIN = 4;
            this.englishTrain.splitPercent = true;
            this.englishTrain.splitNPpercent = 0;
            this.englishTrain.splitPoss = 1;
            this.englishTrain.splitCC = 1;
            this.englishTrain.unaryDT = true;
            this.englishTrain.unaryRB = true;
            this.englishTrain.splitAux = 2;
            this.englishTrain.splitVP = 3;
            this.englishTrain.splitSGapped = 4;
            this.englishTrain.dominatesV = 1;
            this.englishTrain.splitTMP = 1;
            this.englishTrain.splitNPADV = 1;
            this.englishTrain.splitBaseNP = 1;
            this.englishTrain.correctTags = true;
            this.englishTrain.markDitransV = 2;
            ++i;
        } else if (args[i].equalsIgnoreCase("-ijcai03")) {
            this.englishTrain.splitIN = 3;
            this.englishTrain.splitPercent = true;
            this.englishTrain.splitPoss = 1;
            this.englishTrain.splitCC = 2;
            this.englishTrain.unaryDT = false;
            this.englishTrain.unaryRB = false;
            this.englishTrain.splitAux = 0;
            this.englishTrain.splitVP = 2;
            this.englishTrain.splitSGapped = 4;
            this.englishTrain.dominatesV = 0;
            this.englishTrain.splitTMP = 1;
            this.englishTrain.splitBaseNP = 1;
            ++i;
        } else if (args[i].equalsIgnoreCase("-goodFactored")) {
            this.englishTrain.splitIN = 3;
            this.englishTrain.splitPercent = true;
            this.englishTrain.splitPoss = 1;
            this.englishTrain.splitCC = 2;
            this.englishTrain.unaryDT = false;
            this.englishTrain.unaryRB = false;
            this.englishTrain.splitAux = 0;
            this.englishTrain.splitVP = 3;
            this.englishTrain.splitSGapped = 4;
            this.englishTrain.dominatesV = 0;
            this.englishTrain.splitTMP = 1;
            this.englishTrain.splitBaseNP = 1;
            this.englishTrain.correctTags = true;
            ++i;
        }
        return i;
    }

    public List<Word> defaultTestSentence() {
        String[] sent;
        ArrayList<Word> ret = new ArrayList<Word>();
        for (String str : sent = new String[]{"This", "is", "just", "a", "test", "."}) {
            ret.add(new Word(str));
        }
        return ret;
    }

    @Override
    public List<GrammaticalStructure> readGrammaticalStructureFromFile(String filename) {
        try {
            return EnglishGrammaticalStructure.readCoNLLXGrammaticalStructureCollection(filename);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public GrammaticalStructure getGrammaticalStructure(Tree t, Predicate<String> filter, HeadFinder hf) {
        return new EnglishGrammaticalStructure(t, filter, hf);
    }

    @Override
    public boolean supportsBasicDependencies() {
        return true;
    }

    @Override
    public String[] defaultCoreNLPFlags() {
        return RETAIN_TMP_ARGS;
    }

    public static void main(String[] args) {
        EnglishTreebankParserParams tlpp = new EnglishTreebankParserParams();
        MemoryTreebank tb = tlpp.memoryTreebank();
        tb.loadPath(args[0]);
        for (Tree t : tb) {
            t.pennPrint();
        }
    }

    public static class EnglishTrain
    implements Serializable {
        public int leaveItAll = 0;
        public int splitIN = 0;
        public boolean splitQuotes = false;
        public boolean splitSFP = false;
        public boolean splitPercent = false;
        public int splitNPpercent = 0;
        public boolean tagRBGPA = false;
        public int splitNNP = 0;
        public boolean joinPound = false;
        public boolean joinJJ = false;
        public boolean joinNounTags = false;
        public boolean splitPPJJ = false;
        public boolean splitTRJJ = false;
        public boolean splitJJCOMP = false;
        public boolean splitMoreLess = false;
        public boolean unaryDT = false;
        public boolean unaryRB = false;
        public boolean unaryPRP = false;
        public boolean markReflexivePRP = false;
        public boolean unaryIN = false;
        public int splitCC = 0;
        public boolean splitNOT = false;
        public boolean splitRB = false;
        public int splitAux = 0;
        public boolean vpSubCat = false;
        public int markDitransV = 0;
        public int splitVP = 0;
        public boolean splitVPNPAgr = false;
        public int splitSTag = 0;
        public boolean markContainedVP = false;
        public boolean splitNPPRP = false;
        public int dominatesV = 0;
        public boolean dominatesI = false;
        public boolean dominatesC = false;
        public int markCC = 0;
        public int splitSGapped = 0;
        public boolean splitNumNP = false;
        public int splitPoss = 0;
        public int splitBaseNP = 0;
        public int splitTMP = 0;
        public int splitSbar = 0;
        public int splitNPADV = 0;
        public int splitNPNNP = 0;
        public boolean correctTags = false;
        public boolean rightPhrasal = false;
        public int sisterSplitLevel = 1;
        public boolean gpaRootVP = false;
        public int makePPTOintoIN = 0;
        public int collapseWhCategories = 0;
        private static final long serialVersionUID = 1831576434872643L;

        EnglishTrain() {
        }

        public void display() {
            String englishParams = "Using EnglishTreebankParserParams splitIN=" + this.splitIN + " sPercent=" + this.splitPercent + " sNNP=" + this.splitNNP + " sQuotes=" + this.splitQuotes + " sSFP=" + this.splitSFP + " rbGPA=" + this.tagRBGPA + " j#=" + this.joinPound + " jJJ=" + this.joinJJ + " jNounTags=" + this.joinNounTags + " sPPJJ=" + this.splitPPJJ + " sTRJJ=" + this.splitTRJJ + " sJJCOMP=" + this.splitJJCOMP + " sMoreLess=" + this.splitMoreLess + " unaryDT=" + this.unaryDT + " unaryRB=" + this.unaryRB + " unaryPRP=" + this.unaryPRP + " reflPRP=" + this.markReflexivePRP + " unaryIN=" + this.unaryIN + " sCC=" + this.splitCC + " sNT=" + this.splitNOT + " sRB=" + this.splitRB + " sAux=" + this.splitAux + " vpSubCat=" + this.vpSubCat + " mDTV=" + this.markDitransV + " sVP=" + this.splitVP + " sVPNPAgr=" + this.splitVPNPAgr + " sSTag=" + this.splitSTag + " mVP=" + this.markContainedVP + " sNP%=" + this.splitNPpercent + " sNPPRP=" + this.splitNPPRP + " dominatesV=" + this.dominatesV + " dominatesI=" + this.dominatesI + " dominatesC=" + this.dominatesC + " mCC=" + this.markCC + " sSGapped=" + this.splitSGapped + " numNP=" + this.splitNumNP + " sPoss=" + this.splitPoss + " baseNP=" + this.splitBaseNP + " sNPNNP=" + this.splitNPNNP + " sTMP=" + this.splitTMP + " sNPADV=" + this.splitNPADV + " cTags=" + this.correctTags + " rightPhrasal=" + this.rightPhrasal + " gpaRootVP=" + this.gpaRootVP + " splitSbar=" + this.splitSbar + " mPPTOiIN=" + this.makePPTOintoIN + " cWh=" + this.collapseWhCategories;
            System.err.println(englishParams);
        }
    }

    public static class EnglishTest
    implements Serializable {
        boolean retainNPTMPSubcategories = false;
        boolean retainTMPSubcategories = false;
        boolean retainADVSubcategories = false;
        boolean makeCopulaHead = false;
        private static final long serialVersionUID = 183157656745674521L;

        EnglishTest() {
        }
    }

    protected class EnglishSubcategoryStripper
    implements TreeTransformer {
        protected TreeFactory tf = new LabeledScoredTreeFactory();

        protected EnglishSubcategoryStripper() {
        }

        @Override
        public Tree transformTree(Tree tree) {
            Label lab = tree.label();
            String s = lab.value();
            String tag = null;
            if (lab instanceof HasTag) {
                tag = ((HasTag)((Object)lab)).tag();
            }
            if (tree.isLeaf()) {
                Tree leaf = this.tf.newLeaf(lab);
                leaf.setScore(tree.score());
                return leaf;
            }
            if (tree.isPhrasal()) {
                Tree[] kids;
                if (((EnglishTreebankParserParams)EnglishTreebankParserParams.this).englishTest.retainADVSubcategories && s.contains("-ADV")) {
                    s = EnglishTreebankParserParams.this.tlp.basicCategory(s);
                    s = s + "-ADV";
                } else if (((EnglishTreebankParserParams)EnglishTreebankParserParams.this).englishTest.retainTMPSubcategories && s.contains("-TMP")) {
                    s = EnglishTreebankParserParams.this.tlp.basicCategory(s);
                    s = s + "-TMP";
                } else {
                    s = ((EnglishTreebankParserParams)EnglishTreebankParserParams.this).englishTest.retainNPTMPSubcategories && s.startsWith("NP-TMP") ? "NP-TMP" : EnglishTreebankParserParams.this.tlp.basicCategory(s);
                }
                if (((EnglishTreebankParserParams)EnglishTreebankParserParams.this).englishTrain.splitBaseNP == 2 && s.equals("NP") && (kids = tree.children()).length == 1 && EnglishTreebankParserParams.this.tlp.basicCategory(kids[0].value()).equals("NP")) {
                    ArrayList<Tree> kidkids = new ArrayList<Tree>();
                    for (int cNum = 0; cNum < kids[0].children().length; ++cNum) {
                        Tree child = kids[0].children()[cNum];
                        Tree newChild = this.transformTree(child);
                        if (newChild == null) continue;
                        kidkids.add(newChild);
                    }
                    CategoryWordTag myLabel = new CategoryWordTag(lab);
                    myLabel.setCategory(s);
                    return this.tf.newTreeNode(myLabel, kidkids);
                }
                if (((EnglishTreebankParserParams)EnglishTreebankParserParams.this).englishTrain.splitPoss == 2 && s.equals("POSSP")) {
                    kids = tree.children();
                    ArrayList<Tree> newkids = new ArrayList<Tree>();
                    for (int j = 0; j < kids.length - 1; ++j) {
                        for (int cNum = 0; cNum < kids[j].children().length; ++cNum) {
                            Tree child = kids[0].children()[cNum];
                            Tree newChild = this.transformTree(child);
                            if (newChild == null) continue;
                            newkids.add(newChild);
                        }
                    }
                    Tree finalChild = this.transformTree(kids[kids.length - 1]);
                    newkids.add(finalChild);
                    CategoryWordTag myLabel = new CategoryWordTag(lab);
                    myLabel.setCategory("NP");
                    return this.tf.newTreeNode(myLabel, newkids);
                }
            } else {
                s = EnglishTreebankParserParams.this.tlp.basicCategory(s);
                if (tag != null) {
                    tag = EnglishTreebankParserParams.this.tlp.basicCategory(tag);
                }
            }
            ArrayList<Tree> children = new ArrayList<Tree>();
            for (int cNum = 0; cNum < tree.numChildren(); ++cNum) {
                Tree child = tree.getChild(cNum);
                Tree newChild = this.transformTree(child);
                if (newChild == null) continue;
                children.add(newChild);
            }
            if (children.isEmpty()) {
                return null;
            }
            CategoryWordTag newLabel = new CategoryWordTag(lab);
            newLabel.setCategory(s);
            if (tag != null) {
                newLabel.setTag(tag);
            }
            Tree node = this.tf.newTreeNode(newLabel, children);
            node.setScore(tree.score());
            return node;
        }
    }
}

