/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.naturalli.Monotonicity;
import edu.stanford.nlp.naturalli.MonotonicityType;
import edu.stanford.nlp.naturalli.NaturalLogicRelation;
import edu.stanford.nlp.util.Pair;
import java.util.Arrays;
import java.util.List;

public class Polarity {
    private final byte[] projectionFunction = new byte[7];

    protected Polarity(List<Pair<Monotonicity, MonotonicityType>> operatorsInNarrowingScopeOrder) {
        if (operatorsInNarrowingScopeOrder.isEmpty()) {
            for (int i = 0; i < this.projectionFunction.length; i = (int)((byte)(i + 1))) {
                this.projectionFunction[i] = i;
            }
        } else {
            for (int rel = 0; rel < 7; ++rel) {
                NaturalLogicRelation relation = NaturalLogicRelation.byFixedIndex(rel);
                for (int op = operatorsInNarrowingScopeOrder.size() - 1; op >= 0; --op) {
                    relation = this.project(relation, (Monotonicity)((Object)operatorsInNarrowingScopeOrder.get((int)op).first), (MonotonicityType)((Object)operatorsInNarrowingScopeOrder.get((int)op).second));
                }
                this.projectionFunction[rel] = (byte)relation.fixedIndex;
            }
        }
    }

    public Polarity(byte[] projectionFunction) {
        if (projectionFunction.length != 7) {
            throw new IllegalArgumentException("Invalid projection function: " + Arrays.toString(projectionFunction));
        }
        for (int i = 0; i < 7; ++i) {
            if (projectionFunction[i] >= 0 && projectionFunction[i] <= 6) continue;
            throw new IllegalArgumentException("Invalid projection function: " + Arrays.toString(projectionFunction));
        }
        System.arraycopy(projectionFunction, 0, this.projectionFunction, 0, 7);
    }

    private NaturalLogicRelation project(NaturalLogicRelation input, Monotonicity mono, MonotonicityType type) {
        block0 : switch (input) {
            case EQUIVALENCE: {
                return NaturalLogicRelation.EQUIVALENCE;
            }
            case FORWARD_ENTAILMENT: {
                switch (mono) {
                    case MONOTONE: {
                        return NaturalLogicRelation.FORWARD_ENTAILMENT;
                    }
                    case ANTITONE: {
                        return NaturalLogicRelation.REVERSE_ENTAILMENT;
                    }
                    case NONMONOTONE: 
                    case INVALID: {
                        return NaturalLogicRelation.INDEPENDENCE;
                    }
                }
            }
            case REVERSE_ENTAILMENT: {
                switch (mono) {
                    case MONOTONE: {
                        return NaturalLogicRelation.REVERSE_ENTAILMENT;
                    }
                    case ANTITONE: {
                        return NaturalLogicRelation.FORWARD_ENTAILMENT;
                    }
                    case NONMONOTONE: 
                    case INVALID: {
                        return NaturalLogicRelation.INDEPENDENCE;
                    }
                }
            }
            case NEGATION: {
                switch (type) {
                    case NONE: {
                        return NaturalLogicRelation.INDEPENDENCE;
                    }
                    case ADDITIVE: {
                        switch (mono) {
                            case MONOTONE: {
                                return NaturalLogicRelation.COVER;
                            }
                            case ANTITONE: {
                                return NaturalLogicRelation.ALTERNATION;
                            }
                            case NONMONOTONE: 
                            case INVALID: {
                                return NaturalLogicRelation.INDEPENDENCE;
                            }
                        }
                    }
                    case MULTIPLICATIVE: {
                        switch (mono) {
                            case MONOTONE: {
                                return NaturalLogicRelation.ALTERNATION;
                            }
                            case ANTITONE: {
                                return NaturalLogicRelation.COVER;
                            }
                            case NONMONOTONE: 
                            case INVALID: {
                                return NaturalLogicRelation.INDEPENDENCE;
                            }
                        }
                        break block0;
                    }
                    case BOTH: {
                        return NaturalLogicRelation.NEGATION;
                    }
                }
                break;
            }
            case ALTERNATION: {
                switch (mono) {
                    case MONOTONE: {
                        switch (type) {
                            case NONE: 
                            case ADDITIVE: {
                                return NaturalLogicRelation.INDEPENDENCE;
                            }
                            case MULTIPLICATIVE: 
                            case BOTH: {
                                return NaturalLogicRelation.ALTERNATION;
                            }
                        }
                    }
                    case ANTITONE: {
                        switch (type) {
                            case NONE: 
                            case ADDITIVE: {
                                return NaturalLogicRelation.INDEPENDENCE;
                            }
                            case MULTIPLICATIVE: 
                            case BOTH: {
                                return NaturalLogicRelation.COVER;
                            }
                        }
                    }
                    case NONMONOTONE: 
                    case INVALID: {
                        return NaturalLogicRelation.INDEPENDENCE;
                    }
                }
            }
            case COVER: {
                switch (mono) {
                    case MONOTONE: {
                        switch (type) {
                            case NONE: 
                            case MULTIPLICATIVE: {
                                return NaturalLogicRelation.INDEPENDENCE;
                            }
                            case ADDITIVE: 
                            case BOTH: {
                                return NaturalLogicRelation.COVER;
                            }
                        }
                    }
                    case ANTITONE: {
                        switch (type) {
                            case NONE: 
                            case MULTIPLICATIVE: {
                                return NaturalLogicRelation.INDEPENDENCE;
                            }
                            case ADDITIVE: 
                            case BOTH: {
                                return NaturalLogicRelation.ALTERNATION;
                            }
                        }
                    }
                    case NONMONOTONE: 
                    case INVALID: {
                        return NaturalLogicRelation.INDEPENDENCE;
                    }
                }
            }
            case INDEPENDENCE: {
                return NaturalLogicRelation.INDEPENDENCE;
            }
        }
        throw new IllegalStateException("[should not happen!] Projection table is incomplete for " + (Object)((Object)mono) + " : " + (Object)((Object)type) + " on relation " + (Object)((Object)input));
    }

    public NaturalLogicRelation projectLexicalRelation(NaturalLogicRelation lexicalRelation) {
        return NaturalLogicRelation.byFixedIndex(this.projectionFunction[lexicalRelation.fixedIndex]);
    }

    public boolean maintainsEntailment(NaturalLogicRelation lexicalRelation) {
        return this.projectLexicalRelation((NaturalLogicRelation)lexicalRelation).isEntailed;
    }

    public boolean introducesNegation(NaturalLogicRelation lexicalRelation) {
        return this.projectLexicalRelation((NaturalLogicRelation)lexicalRelation).isNegated;
    }

    public boolean isUpwards() {
        return this.projectLexicalRelation(NaturalLogicRelation.FORWARD_ENTAILMENT) == NaturalLogicRelation.FORWARD_ENTAILMENT && this.projectLexicalRelation(NaturalLogicRelation.REVERSE_ENTAILMENT) == NaturalLogicRelation.REVERSE_ENTAILMENT;
    }

    public boolean isDownwards() {
        return this.projectLexicalRelation(NaturalLogicRelation.FORWARD_ENTAILMENT) == NaturalLogicRelation.REVERSE_ENTAILMENT && this.projectLexicalRelation(NaturalLogicRelation.REVERSE_ENTAILMENT) == NaturalLogicRelation.FORWARD_ENTAILMENT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Polarity)) {
            return false;
        }
        Polarity polarity = (Polarity)o;
        return Arrays.equals(this.projectionFunction, polarity.projectionFunction);
    }

    public int hashCode() {
        return Arrays.hashCode(this.projectionFunction);
    }

    public String toString() {
        if (this.isUpwards()) {
            return "up";
        }
        if (this.isDownwards()) {
            return "down";
        }
        return "flat";
    }
}

