/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

public enum NaturalLogicRelation {
    EQUIVALENCE(0, true, false),
    FORWARD_ENTAILMENT(1, true, false),
    REVERSE_ENTAILMENT(2, false, false),
    NEGATION(3, false, true),
    ALTERNATION(4, false, true),
    COVER(5, false, false),
    INDEPENDENCE(6, false, false);

    public final int fixedIndex;
    public final boolean isEntailed;
    public final boolean isNegated;

    private NaturalLogicRelation(int fixedIndex, boolean isEntailed, boolean isNegated) {
        this.fixedIndex = fixedIndex;
        this.isEntailed = isEntailed;
        this.isNegated = isNegated;
    }

    protected static NaturalLogicRelation byFixedIndex(int index) {
        switch (index) {
            case 0: {
                return EQUIVALENCE;
            }
            case 1: {
                return FORWARD_ENTAILMENT;
            }
            case 2: {
                return REVERSE_ENTAILMENT;
            }
            case 3: {
                return NEGATION;
            }
            case 4: {
                return ALTERNATION;
            }
            case 5: {
                return COVER;
            }
            case 6: {
                return INDEPENDENCE;
            }
        }
        throw new IllegalArgumentException("Unknown index for Natural Logic relation: " + index);
    }

    public NaturalLogicRelation join(NaturalLogicRelation other) {
        switch (this) {
            case EQUIVALENCE: {
                return other;
            }
            case FORWARD_ENTAILMENT: {
                switch (other) {
                    case EQUIVALENCE: 
                    case FORWARD_ENTAILMENT: {
                        return FORWARD_ENTAILMENT;
                    }
                    case NEGATION: 
                    case ALTERNATION: {
                        return COVER;
                    }
                    case REVERSE_ENTAILMENT: 
                    case COVER: 
                    case INDEPENDENCE: {
                        return INDEPENDENCE;
                    }
                }
            }
            case REVERSE_ENTAILMENT: {
                switch (other) {
                    case EQUIVALENCE: 
                    case REVERSE_ENTAILMENT: {
                        return REVERSE_ENTAILMENT;
                    }
                    case NEGATION: 
                    case COVER: {
                        return COVER;
                    }
                    case FORWARD_ENTAILMENT: 
                    case ALTERNATION: 
                    case INDEPENDENCE: {
                        return INDEPENDENCE;
                    }
                }
            }
            case NEGATION: {
                switch (other) {
                    case EQUIVALENCE: {
                        return NEGATION;
                    }
                    case FORWARD_ENTAILMENT: {
                        return COVER;
                    }
                    case REVERSE_ENTAILMENT: {
                        return ALTERNATION;
                    }
                    case NEGATION: {
                        return EQUIVALENCE;
                    }
                    case ALTERNATION: {
                        return REVERSE_ENTAILMENT;
                    }
                    case COVER: {
                        return FORWARD_ENTAILMENT;
                    }
                    case INDEPENDENCE: {
                        return INDEPENDENCE;
                    }
                }
            }
            case ALTERNATION: {
                switch (other) {
                    case EQUIVALENCE: 
                    case REVERSE_ENTAILMENT: {
                        return ALTERNATION;
                    }
                    case NEGATION: 
                    case COVER: {
                        return FORWARD_ENTAILMENT;
                    }
                    case FORWARD_ENTAILMENT: 
                    case ALTERNATION: 
                    case INDEPENDENCE: {
                        return INDEPENDENCE;
                    }
                }
            }
            case COVER: {
                switch (other) {
                    case EQUIVALENCE: 
                    case FORWARD_ENTAILMENT: {
                        return COVER;
                    }
                    case NEGATION: 
                    case ALTERNATION: {
                        return REVERSE_ENTAILMENT;
                    }
                    case REVERSE_ENTAILMENT: 
                    case COVER: 
                    case INDEPENDENCE: {
                        return INDEPENDENCE;
                    }
                }
            }
            case INDEPENDENCE: {
                return INDEPENDENCE;
            }
        }
        throw new IllegalStateException("[should be impossible]: Incomplete join table for " + (Object)((Object)this) + " joined with " + (Object)((Object)other));
    }
}

