/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.naturalli.Monotonicity;
import edu.stanford.nlp.naturalli.MonotonicityType;
import edu.stanford.nlp.naturalli.NaturalLogicAnnotations;
import edu.stanford.nlp.naturalli.Operator;
import edu.stanford.nlp.naturalli.OperatorSpec;
import edu.stanford.nlp.naturalli.Polarity;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.SentenceAnnotator;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Triple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;

public class NaturalLogicAnnotator
extends SentenceAnnotator {
    private static final String DET = "/(pre)?det|a(dv)?mod|neg|num|nn/";
    private static final String GEN_SUBJ = "/[ni]subj(pass)?/";
    private static final String GEN_OBJ = "/[di]obj|xcomp|advcl|acomp/";
    private static final String GEN_COP = "/cop|aux(pass)?/";
    private static final String GEN_CLAUSE = "/prep|rcmod/";
    private static final String GEN_PREP = "/prep|advcl|ccomp|advmod/";
    private static final String QUANTIFIER;
    private static final List<SemgrexPattern> PATTERNS;
    private static final Set<String> MODIFIER_ARCS;
    public final boolean doPolarity;

    private static Pair<Integer, Integer> getGeneralizedSubtreeSpan(SemanticGraph tree, IndexedWord root, Set<String> validArcs) {
        int min = root.index();
        int max = root.index();
        LinkedList<IndexedWord> fringe = new LinkedList<IndexedWord>();
        for (SemanticGraphEdge edge : tree.getOutEdgesSorted(root)) {
            String edgeLabel = edge.getRelation().getShortName();
            if (validArcs != null && !validArcs.contains(edgeLabel) || "punct".equals(edgeLabel)) continue;
            fringe.add(edge.getDependent());
        }
        while (!fringe.isEmpty()) {
            IndexedWord node = (IndexedWord)fringe.poll();
            min = Math.min(node.index(), min);
            max = Math.max(node.index(), max);
            for (SemanticGraphEdge edge : tree.getOutEdgesSorted(node)) {
                if ("punct".equals(edge.getRelation().getShortName())) continue;
                fringe.add(edge.getDependent());
            }
        }
        return Pair.makePair(min, max + 1);
    }

    private static Pair<Integer, Integer> getModifierSubtreeSpan(SemanticGraph tree, IndexedWord root) {
        return NaturalLogicAnnotator.getGeneralizedSubtreeSpan(tree, root, MODIFIER_ARCS);
    }

    private static Pair<Integer, Integer> getSubtreeSpan(SemanticGraph tree, IndexedWord root) {
        return NaturalLogicAnnotator.getGeneralizedSubtreeSpan(tree, root, null);
    }

    private static Pair<Integer, Integer> includeInSpan(Pair<Integer, Integer> span, Pair<Integer, Integer> toInclude) {
        return Pair.makePair(Math.min((Integer)span.first, (Integer)toInclude.first), Math.max((Integer)span.second, (Integer)toInclude.second));
    }

    private static Pair<Integer, Integer> excludeFromSpan(Pair<Integer, Integer> span, Pair<Integer, Integer> toExclude) {
        if ((Integer)toExclude.second <= (Integer)span.first || (Integer)toExclude.first >= (Integer)span.second) {
            return span;
        }
        if ((Integer)toExclude.first <= (Integer)span.first && (Integer)toExclude.second > (Integer)span.first) {
            return Pair.makePair(toExclude.second, span.second);
        }
        if ((Integer)toExclude.first < (Integer)span.second && (Integer)toExclude.second >= (Integer)span.second) {
            return Pair.makePair(span.first, toExclude.first);
        }
        if ((Integer)toExclude.first > (Integer)span.first && (Integer)toExclude.second < (Integer)span.second) {
            return span;
        }
        throw new IllegalStateException("This case should be impossible");
    }

    private OperatorSpec computeScope(SemanticGraph tree, Operator operator, IndexedWord pivot, Pair<Integer, Integer> quantifierSpan, IndexedWord subject, IndexedWord object) {
        Pair<Object, Object> objSpan;
        Pair<Integer, Integer> subjSpan;
        if (subject == null && object == null) {
            subjSpan = NaturalLogicAnnotator.getSubtreeSpan(tree, pivot);
            objSpan = Pair.makePair(subjSpan.second, subjSpan.second);
        } else if (subject == null) {
            subjSpan = NaturalLogicAnnotator.includeInSpan(NaturalLogicAnnotator.getSubtreeSpan(tree, object), NaturalLogicAnnotator.getGeneralizedSubtreeSpan(tree, pivot, Collections.singleton("prep")));
            objSpan = Pair.makePair(subjSpan.second, subjSpan.second);
        } else {
            Pair<Integer, Integer> subjectSubtree = NaturalLogicAnnotator.getSubtreeSpan(tree, subject);
            subjSpan = NaturalLogicAnnotator.excludeFromSpan(subjectSubtree, quantifierSpan);
            objSpan = NaturalLogicAnnotator.excludeFromSpan(NaturalLogicAnnotator.includeInSpan(NaturalLogicAnnotator.getSubtreeSpan(tree, object), NaturalLogicAnnotator.getModifierSubtreeSpan(tree, pivot)), subjectSubtree);
        }
        return new OperatorSpec(operator, (Integer)quantifierSpan.first - 1, (Integer)quantifierSpan.second - 1, (Integer)subjSpan.first - 1, (Integer)subjSpan.second - 1, (Integer)objSpan.first - 1, (Integer)objSpan.second - 1);
    }

    private Optional<Triple<Operator, Integer, Integer>> validateQuantiferByHead(CoreMap sentence, IndexedWord quantifier) {
        int end = quantifier.index();
        for (int start = Math.max(0, end - 10); start < end; ++start) {
            Function<CoreLabel, String> glossFn = label -> "CD".equals(label.tag()) ? "__NUM__" : label.lemma();
            String gloss = StringUtils.join((List)sentence.get(CoreAnnotations.TokensAnnotation.class), " ", glossFn, start, end).toLowerCase();
            for (Operator q : Operator.values()) {
                if (!q.surfaceForm.equals(gloss)) continue;
                return Optional.of(Triple.makeTriple(q, start + 1, end + 1));
            }
        }
        return Optional.empty();
    }

    private void annotateOperators(CoreMap sentence) {
        SemanticGraph tree = (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
        for (SemgrexPattern pattern : PATTERNS) {
            SemgrexMatcher matcher = pattern.matcher(tree);
            while (matcher.find()) {
                Optional<Triple<Operator, Integer, Integer>> quantifierInfo;
                IndexedWord quantifier;
                IndexedWord subject;
                IndexedWord properSubject = matcher.getNode("Subject");
                boolean namedEntityQuantifier = false;
                if (properSubject != null) {
                    quantifier = subject = properSubject;
                    namedEntityQuantifier = true;
                } else {
                    quantifier = matcher.getNode("quantifier");
                    subject = matcher.getNode("subject");
                }
                if (!(quantifierInfo = namedEntityQuantifier ? Optional.of(Triple.makeTriple(Operator.ALL, quantifier.index(), quantifier.index())) : this.validateQuantiferByHead(sentence, quantifier)).isPresent()) continue;
                OperatorSpec scope = this.computeScope(tree, (Operator)((Object)quantifierInfo.get().first), matcher.getNode("pivot"), Pair.makePair(quantifierInfo.get().second, quantifierInfo.get().third), subject, matcher.getNode("object"));
                CoreLabel token = (CoreLabel)((List)sentence.get(CoreAnnotations.TokensAnnotation.class)).get(quantifier.index() - 1);
                OperatorSpec oldScope = (OperatorSpec)token.get(NaturalLogicAnnotations.OperatorAnnotation.class);
                if (oldScope == null || oldScope.quantifierLength() < scope.quantifierLength() || oldScope.instance != scope.instance) {
                    token.set(NaturalLogicAnnotations.OperatorAnnotation.class, scope);
                    continue;
                }
                token.set(NaturalLogicAnnotations.OperatorAnnotation.class, OperatorSpec.merge(oldScope, scope));
            }
        }
        ArrayList quantifiers = new ArrayList();
        for (CoreLabel token : (List)sentence.get(CoreAnnotations.TokensAnnotation.class)) {
            if (!token.has(NaturalLogicAnnotations.OperatorAnnotation.class)) continue;
            quantifiers.add(token.get(NaturalLogicAnnotations.OperatorAnnotation.class));
        }
        quantifiers.sort((x, y) -> y.quantifierLength() - x.quantifierLength());
        for (OperatorSpec quantifier : quantifiers) {
            for (int i = quantifier.quantifierBegin; i < quantifier.quantifierEnd; ++i) {
                if (i == quantifier.quantifierHead) continue;
                ((CoreLabel)((List)sentence.get(CoreAnnotations.TokensAnnotation.class)).get(i)).remove(NaturalLogicAnnotations.OperatorAnnotation.class);
            }
        }
    }

    private void annotatePolarity(CoreMap sentence) {
        ArrayList<OperatorSpec> operators = new ArrayList<OperatorSpec>();
        List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        for (CoreLabel token : tokens) {
            OperatorSpec specOrNull = (OperatorSpec)token.get(NaturalLogicAnnotations.OperatorAnnotation.class);
            if (specOrNull == null) continue;
            operators.add(specOrNull);
        }
        for (int i = 0; i < tokens.size(); ++i) {
            CoreLabel token;
            token = (CoreLabel)tokens.get(i);
            ArrayList<Triple<Integer, Monotonicity, MonotonicityType>> inScope = new ArrayList<Triple<Integer, Monotonicity, MonotonicityType>>(4);
            for (OperatorSpec operatorSpec : operators) {
                if (i >= operatorSpec.subjectBegin && i < operatorSpec.subjectEnd) {
                    inScope.add(Triple.makeTriple(operatorSpec.subjectEnd - operatorSpec.subjectBegin, operatorSpec.instance.subjMono, operatorSpec.instance.subjType));
                    continue;
                }
                if (i < operatorSpec.objectBegin || i >= operatorSpec.objectEnd) continue;
                inScope.add(Triple.makeTriple(operatorSpec.objectEnd - operatorSpec.objectBegin, operatorSpec.instance.objMono, operatorSpec.instance.objType));
            }
            inScope.sort((x, y) -> (Integer)y.first - (Integer)x.first);
            ArrayList<Pair<Monotonicity, MonotonicityType>> info = new ArrayList<Pair<Monotonicity, MonotonicityType>>(inScope.size());
            for (Triple triple : inScope) {
                info.add(Pair.makePair(triple.second, triple.third));
            }
            Polarity polarity = new Polarity(info);
            token.set(NaturalLogicAnnotations.PolarityAnnotation.class, polarity);
        }
    }

    public NaturalLogicAnnotator(String annotatorName, Properties props) {
        this.doPolarity = Boolean.valueOf(props.getProperty(annotatorName + ".doPolarity", "true"));
    }

    public NaturalLogicAnnotator(Properties props) {
        this("natlog", props);
    }

    public NaturalLogicAnnotator() {
        this("__irrelevant__", new Properties());
    }

    @Override
    protected void doOneSentence(Annotation annotation, CoreMap sentence) {
        this.annotateOperators(sentence);
        if (this.doPolarity) {
            this.annotatePolarity(sentence);
        }
    }

    @Override
    protected int nThreads() {
        return 1;
    }

    @Override
    protected long maxTime() {
        return Long.MAX_VALUE;
    }

    @Override
    protected void doOneFailedSentence(Annotation annotation, CoreMap sentence) {
        System.err.println("Failed to annotate: " + (String)sentence.get(CoreAnnotations.TextAnnotation.class));
    }

    @Override
    public Set<Annotator.Requirement> requirementsSatisfied() {
        return Collections.singleton(NATLOG_REQUIREMENT);
    }

    @Override
    public Set<Annotator.Requirement> requires() {
        return TOKENIZE_SSPLIT_PARSE;
    }

    static {
        HashSet<String> singleWordQuantifiers = new HashSet<String>();
        for (Operator q : Operator.values()) {
            String[] tokens = q.surfaceForm.split("\\s+");
            if (tokens[tokens.length - 1].startsWith("_")) continue;
            singleWordQuantifiers.add("(" + tokens[tokens.length - 1].toLowerCase() + ")");
        }
        QUANTIFIER = "[ {lemma:/" + StringUtils.join(singleWordQuantifiers, "|") + "/}=quantifier | {pos:CD}=quantifier ]";
        PATTERNS = Collections.unmodifiableList(new ArrayList<SemgrexPattern>(){
            {
                this.add(SemgrexPattern.compile("{}=pivot >/[ni]subj(pass)?/ ({}=subject >>/(pre)?det|a(dv)?mod|neg|num|nn/ " + QUANTIFIER + ") >" + NaturalLogicAnnotator.GEN_OBJ + " {}=object"));
                this.add(SemgrexPattern.compile("{pos:/V.*/}=pivot >/[ni]subj(pass)?/ ({}=subject >>/(pre)?det|a(dv)?mod|neg|num|nn/ " + QUANTIFIER + ") >" + NaturalLogicAnnotator.GEN_PREP + " {}=object"));
                this.add(SemgrexPattern.compile("{}=object >/[ni]subj(pass)?/ ({}=subject >>/(pre)?det|a(dv)?mod|neg|num|nn/ " + QUANTIFIER + ") >" + NaturalLogicAnnotator.GEN_COP + " {}=pivot"));
                this.add(SemgrexPattern.compile("{}=pivot >/[ni]subj(pass)?/ ( " + QUANTIFIER + " >" + NaturalLogicAnnotator.GEN_CLAUSE + " {}=subject ) >" + NaturalLogicAnnotator.GEN_OBJ + " {}=object"));
                this.add(SemgrexPattern.compile("{pos:/V.*/}=pivot >/[ni]subj(pass)?/ ( " + QUANTIFIER + " >" + NaturalLogicAnnotator.GEN_CLAUSE + " {}=subject ) >" + NaturalLogicAnnotator.GEN_PREP + " {}=object"));
                this.add(SemgrexPattern.compile("{}=pivot >/[ni]subj(pass)?/ {pos:NNP}=Subject >/[di]obj|xcomp|advcl|acomp/ {}=object"));
                this.add(SemgrexPattern.compile("{pos:/V.*/}=pivot >/[ni]subj(pass)?/ {pos:NNP}=Subject >/prep|ccomp|[di]obj/ {}=object"));
                this.add(SemgrexPattern.compile("{}=object >/[ni]subj(pass)?/ {pos:NNP}=Subject >/cop|aux(pass)?/ {}=pivot"));
                this.add(SemgrexPattern.compile("{}=pivot >neg " + QUANTIFIER + " >" + NaturalLogicAnnotator.GEN_OBJ + " {}=object"));
                this.add(SemgrexPattern.compile("{pos:/V.*/}=pivot >/[ni]subj(pass)?/ ( " + QUANTIFIER + " >prep {}=subject ) >" + NaturalLogicAnnotator.GEN_OBJ + " {}=object"));
                this.add(SemgrexPattern.compile("{pos:/V.*/}=pivot >dep ( " + QUANTIFIER + " >prep {}=subject ) >" + NaturalLogicAnnotator.GEN_SUBJ + " {}=object"));
                this.add(SemgrexPattern.compile("{pos:/V.*/}=pivot >dep {lemma:either}=quantifier >/[ni]subj(pass)?/ {}=subject >/[di]obj|xcomp|advcl|acomp/ {}=object"));
                this.add(SemgrexPattern.compile("{}=quantifier >/[ni]subj(pass)?/ {}=pivot >>expl {}"));
            }
        });
        MODIFIER_ARCS = Collections.unmodifiableSet(new HashSet<String>(){
            {
                this.add("aux");
                this.add("prep");
            }
        });
    }
}

