/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.util;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.util.FixedPrioritiesPriorityQueue;
import edu.stanford.nlp.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class RelationTriple {
    public final List<CoreLabel> subject;
    public final List<CoreLabel> relation;
    public final List<CoreLabel> object;
    private static final List<SemgrexPattern> PATTERNS = Collections.unmodifiableList(new ArrayList<SemgrexPattern>(){
        {
            this.add(SemgrexPattern.compile("{$}=verb ?>/advmod/ {}=adv >/nsubj(pass)?/ {}=subject >/prep/ ({}=prep >/pobj/ {}=object)"));
        }
    });
    private static final Set<String> VALID_ENTITY_ARCS = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("amod");
            this.add("nn");
        }
    });

    public RelationTriple(List<CoreLabel> subject, List<CoreLabel> relation, List<CoreLabel> object) {
        this.subject = subject;
        this.relation = relation;
        this.object = object;
    }

    public String subjectGloss() {
        return StringUtils.join(this.subject.stream().map(CoreLabel::word), " ");
    }

    public String objectGloss() {
        return StringUtils.join(this.object.stream().map(CoreLabel::word), " ");
    }

    public String relationGloss() {
        return StringUtils.join(this.relation.stream().map(CoreLabel::word), " ");
    }

    public Optional<SemanticGraph> asDependencyTree() {
        return Optional.empty();
    }

    public List<CoreLabel> asSentence() {
        FixedPrioritiesPriorityQueue<CoreLabel> orderedSentence = new FixedPrioritiesPriorityQueue<CoreLabel>();
        double defaultIndex = 0.0;
        for (CoreLabel token : this.subject) {
            orderedSentence.add(token, token.index() >= 0 ? (double)(-token.index()) : -defaultIndex);
            defaultIndex += 1.0;
        }
        for (CoreLabel token : this.relation) {
            orderedSentence.add(token, token.index() >= 0 ? (double)(-token.index()) : -defaultIndex);
            defaultIndex += 1.0;
        }
        for (CoreLabel token : this.object) {
            orderedSentence.add(token, token.index() >= 0 ? (double)(-token.index()) : -defaultIndex);
            defaultIndex += 1.0;
        }
        return orderedSentence.toSortedList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RelationTriple)) {
            return false;
        }
        RelationTriple that = (RelationTriple)o;
        return this.object.equals(that.object) && this.relation.equals(that.relation) && this.subject.equals(that.subject);
    }

    public int hashCode() {
        int result = this.subject.hashCode();
        result = 31 * result + this.relation.hashCode();
        result = 31 * result + this.object.hashCode();
        return result;
    }

    public String toString() {
        return this.subjectGloss() + "\t" + this.relationGloss() + "\t" + this.objectGloss();
    }

    private static Optional<List<CoreLabel>> getValidEntityChunk(SemanticGraph parse, IndexedWord root) {
        FixedPrioritiesPriorityQueue<CoreLabel> chunk = new FixedPrioritiesPriorityQueue<CoreLabel>();
        LinkedList<IndexedWord> fringe = new LinkedList<IndexedWord>();
        fringe.add(root);
        while (!fringe.isEmpty()) {
            root = (IndexedWord)fringe.poll();
            chunk.add(root.backingLabel(), -root.index());
            for (SemanticGraphEdge edge : parse.getOutEdgesSorted(root)) {
                if (!VALID_ENTITY_ARCS.contains(edge.getRelation().getShortName())) {
                    return Optional.empty();
                }
                fringe.add(edge.getDependent());
            }
        }
        return Optional.of(chunk.toSortedList());
    }

    public static Optional<RelationTriple> segment(SemanticGraph parse) {
        for (SemgrexPattern pattern : PATTERNS) {
            SemgrexMatcher m = pattern.matcher(parse);
            if (!m.matches()) continue;
            FixedPrioritiesPriorityQueue<CoreLabel> verbChunk = new FixedPrioritiesPriorityQueue<CoreLabel>();
            IndexedWord verb = m.getNode("verb");
            IndexedWord prep = m.getNode("prep");
            IndexedWord adv = m.getNode("adv");
            verbChunk.add(verb.backingLabel(), -verb.index());
            if (prep != null) {
                verbChunk.add(prep.backingLabel(), -prep.index());
            }
            if (adv != null) {
                verbChunk.add(adv.backingLabel(), -adv.index());
            }
            List<CoreLabel> relation = verbChunk.toSortedList();
            Optional<List<CoreLabel>> subject = RelationTriple.getValidEntityChunk(parse, m.getNode("subject"));
            Optional<List<CoreLabel>> object = RelationTriple.getValidEntityChunk(parse, m.getNode("object"));
            if (!subject.isPresent() || !object.isPresent()) continue;
            return Optional.of(new WithTree(subject.get(), relation, object.get(), parse));
        }
        return Optional.empty();
    }

    protected static class WithTree
    extends RelationTriple {
        public final SemanticGraph sourceTree;

        public WithTree(List<CoreLabel> subject, List<CoreLabel> relation, List<CoreLabel> object, SemanticGraph tree) {
            super(subject, relation, object);
            this.sourceTree = new SemanticGraph(tree);
        }

        @Override
        public Optional<SemanticGraph> asDependencyTree() {
            return Optional.of(this.sourceTree);
        }
    }
}

