/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ie.AbstractSequenceClassifier;
import edu.stanford.nlp.ie.ClassifierCombiner;
import edu.stanford.nlp.ie.QuantifiableEntityNormalizer;
import edu.stanford.nlp.ie.regexp.NumberSequenceClassifier;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import edu.stanford.nlp.util.StringUtils;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Properties;

public class NERClassifierCombiner
extends ClassifierCombiner<CoreLabel> {
    private final boolean applyNumericClassifiers;
    public static final boolean APPLY_NUMERIC_CLASSIFIERS_DEFAULT = true;
    public static final String APPLY_NUMERIC_CLASSIFIERS_PROPERTY = "ner.applyNumericClassifiers";
    private final boolean useSUTime;
    private final AbstractSequenceClassifier<CoreLabel> nsc;

    public NERClassifierCombiner(Properties props) throws FileNotFoundException {
        super(props);
        this.applyNumericClassifiers = PropertiesUtils.getBool(props, APPLY_NUMERIC_CLASSIFIERS_PROPERTY, true);
        this.useSUTime = PropertiesUtils.getBool(props, "ner.useSUTime", NumberSequenceClassifier.USE_SUTIME_DEFAULT);
        this.nsc = new NumberSequenceClassifier(new Properties(), this.useSUTime, props);
    }

    public NERClassifierCombiner(String ... loadPaths) throws FileNotFoundException {
        this(true, NumberSequenceClassifier.USE_SUTIME_DEFAULT, loadPaths);
    }

    public NERClassifierCombiner(boolean applyNumericClassifiers, boolean useSUTime, String ... loadPaths) throws FileNotFoundException {
        super(loadPaths);
        this.applyNumericClassifiers = applyNumericClassifiers;
        this.useSUTime = useSUTime;
        this.nsc = new NumberSequenceClassifier(useSUTime);
    }

    public NERClassifierCombiner(boolean applyNumericClassifiers, boolean useSUTime, Properties nscProps, String ... loadPaths) throws FileNotFoundException {
        super(ClassifierCombiner.extractCombinationModeSafe(nscProps), loadPaths);
        this.applyNumericClassifiers = applyNumericClassifiers;
        this.useSUTime = useSUTime;
        this.nsc = new NumberSequenceClassifier(new Properties(), useSUTime, nscProps);
    }

    public NERClassifierCombiner(AbstractSequenceClassifier<CoreLabel> ... classifiers) throws FileNotFoundException {
        this(true, NumberSequenceClassifier.USE_SUTIME_DEFAULT, classifiers);
    }

    public NERClassifierCombiner(boolean applyNumericClassifiers, boolean useSUTime, AbstractSequenceClassifier<CoreLabel> ... classifiers) throws FileNotFoundException {
        super(classifiers);
        this.applyNumericClassifiers = applyNumericClassifiers;
        this.useSUTime = useSUTime;
        this.nsc = new NumberSequenceClassifier(useSUTime);
    }

    public boolean appliesNumericClassifiers() {
        return this.applyNumericClassifiers;
    }

    public boolean usesSUTime() {
        return this.useSUTime && this.applyNumericClassifiers;
    }

    private static <INN extends CoreMap> void copyAnswerFieldsToNERField(List<INN> l) {
        for (CoreMap m : l) {
            m.set(CoreAnnotations.NamedEntityTagAnnotation.class, m.get(CoreAnnotations.AnswerAnnotation.class));
        }
    }

    @Override
    public List<CoreLabel> classify(List<CoreLabel> tokens) {
        return this.classifyWithGlobalInformation(tokens, (CoreMap)null, (CoreMap)null);
    }

    @Override
    public List<CoreLabel> classifyWithGlobalInformation(List<CoreLabel> tokens, CoreMap document, CoreMap sentence) {
        List<CoreLabel> output = super.classify(tokens);
        if (this.applyNumericClassifiers) {
            try {
                this.recognizeNumberSequences(output, document, sentence);
            }
            catch (RuntimeInterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                System.err.println("Ignored an exception in NumberSequenceClassifier: (result is that some numbers were not classified)");
                System.err.println("Tokens: " + StringUtils.joinWords(tokens, " "));
                e.printStackTrace(System.err);
            }
            NERClassifierCombiner.copyAnswerFieldsToNERField(output);
            try {
                QuantifiableEntityNormalizer.addNormalizedQuantitiesToEntities(output, false, this.useSUTime);
            }
            catch (Exception e) {
                System.err.println("Ignored an exception in QuantifiableEntityNormalizer: (result is that entities were not normalized)");
                System.err.println("Tokens: " + StringUtils.joinWords(tokens, " "));
                e.printStackTrace(System.err);
            }
            catch (AssertionError e) {
                System.err.println("Ignored an assertion in QuantifiableEntityNormalizer: (result is that entities were not normalized)");
                System.err.println("Tokens: " + StringUtils.joinWords(tokens, " "));
                ((Throwable)((Object)e)).printStackTrace(System.err);
            }
        } else {
            NERClassifierCombiner.copyAnswerFieldsToNERField(output);
        }
        return output;
    }

    private void recognizeNumberSequences(List<CoreLabel> words, CoreMap document, CoreMap sentence) {
        List<CoreLabel> newWords = NumberSequenceClassifier.copyTokens(words, sentence);
        this.nsc.classifyWithGlobalInformation(newWords, document, sentence);
        int sz = words.size();
        for (int i = 0; i < sz; ++i) {
            CoreLabel origWord = words.get(i);
            CoreLabel newWord = newWords.get(i);
            String before = (String)origWord.get(CoreAnnotations.AnswerAnnotation.class);
            String newGuess = (String)newWord.get(CoreAnnotations.AnswerAnnotation.class);
            if ((before == null || before.equals(this.nsc.flags.backgroundSymbol) || before.equals("MISC")) && !newGuess.equals(this.nsc.flags.backgroundSymbol)) {
                origWord.set(CoreAnnotations.AnswerAnnotation.class, newGuess);
            }
            NumberSequenceClassifier.transferAnnotations(newWord, origWord);
        }
    }

    public void finalizeAnnotation(Annotation annotation) {
        this.nsc.finalizeClassification(annotation);
    }
}

