/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util.concurrent;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Index;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;

public class ConcurrentHashIndex<E>
extends AbstractCollection<E>
implements Index<E>,
RandomAccess {
    private static final long serialVersionUID = 6465313844985269109L;
    public static final int UNKNOWN_ID = -1;
    private static final int DEFAULT_INITIAL_CAPACITY = 100;
    private final ConcurrentHashMap<E, Integer> item2Index;
    private int indexSize;
    private final ReentrantLock lock;
    private final AtomicReference<Object[]> index2Item;

    public ConcurrentHashIndex() {
        this(100);
    }

    public ConcurrentHashIndex(int initialCapacity) {
        this.item2Index = new ConcurrentHashMap(initialCapacity);
        this.indexSize = 0;
        this.lock = new ReentrantLock();
        Object[] arr = new Object[initialCapacity];
        this.index2Item = new AtomicReference<Object[]>(arr);
    }

    @Override
    public E get(int i) {
        Object[] arr = this.index2Item.get();
        if (i < this.indexSize) {
            return (E)arr[i];
        }
        throw new ArrayIndexOutOfBoundsException(String.format("Out of bounds: %d >= %d", i, this.indexSize));
    }

    @Override
    public int indexOf(E o) {
        Integer id = this.item2Index.get(o);
        return id == null ? -1 : id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addToIndex(E o) {
        Integer index = this.item2Index.get(o);
        if (index != null) {
            return index;
        }
        this.lock.lock();
        try {
            if (this.item2Index.containsKey(o)) {
                int n = this.item2Index.get(o);
                return n;
            }
            int newIndex = this.indexSize++;
            Object[] arr = this.index2Item.get();
            assert (newIndex <= arr.length);
            if (newIndex == arr.length) {
                Object[] newArr = new Object[2 * newIndex];
                System.arraycopy(arr, 0, newArr, 0, arr.length);
                arr = newArr;
            }
            arr[newIndex] = o;
            this.index2Item.set(arr);
            this.item2Index.put(o, newIndex);
            int n = newIndex;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Deprecated
    public int indexOf(E o, boolean add) {
        if (add) {
            return this.addToIndex(o);
        }
        return this.indexOf(o);
    }

    @Override
    public boolean add(E o) {
        return this.addToIndex(o) != -1;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (E element : c) {
            changed |= this.add(element);
        }
        return changed;
    }

    @Override
    public List<E> objectsList() {
        return Generics.newArrayList(this.item2Index.keySet());
    }

    @Override
    public Collection<E> objects(final int[] indices) {
        return new AbstractList<E>(){

            @Override
            public E get(int index) {
                return ConcurrentHashIndex.this.get(indices[index]);
            }

            @Override
            public int size() {
                return indices.length;
            }
        };
    }

    @Override
    public boolean isLocked() {
        return false;
    }

    @Override
    public void lock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unlock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void saveToWriter(Writer out2) throws IOException {
        String nl = System.getProperty("line.separator");
        int sz = this.indexSize;
        for (int i = 0; i < sz; ++i) {
            E o = this.get(i);
            if (o == null) continue;
            out2.write(i + "=" + this.get(i) + nl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveToFilename(String s) {
        try (PrintWriter bw = null;){
            bw = IOUtils.getPrintWriter(s);
            int size = this.indexSize;
            for (int i = 0; i < size; ++i) {
                E o = this.get(i);
                if (o == null) continue;
                bw.printf("%d=%s%n", i, o.toString());
            }
            bw.close();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int index = 0;
            private int size = ConcurrentHashIndex.this.size();

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public E next() {
                return ConcurrentHashIndex.this.get(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.indexSize;
    }

    @Override
    public String toString() {
        int i;
        StringBuilder buff = new StringBuilder("[");
        int size = this.size();
        for (i = 0; i < size; ++i) {
            E e = this.get(i);
            if (e == null) continue;
            buff.append(i).append('=').append(e);
            if (i >= size - 1) continue;
            buff.append(',');
        }
        if (i < this.size()) {
            buff.append("...");
        }
        buff.append(']');
        return buff.toString();
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            int size = this.item2Index.size();
            this.item2Index.clear();
            Object[] arr = new Object[size];
            this.index2Item.set(arr);
        }
        finally {
            this.lock.unlock();
        }
    }
}

