/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationOutputter;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.time.TimeAnnotations;
import edu.stanford.nlp.time.Timex;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JSONOutputter
extends AnnotationOutputter {
    protected static final String INDENT_CHAR = "  ";

    @Override
    public void print(Annotation doc, OutputStream target, AnnotationOutputter.Options options) throws IOException {
        JSONWriter l0 = new JSONWriter(new PrintWriter(target));
        l0.object(l1 -> {
            l1.set("docId", doc.get(CoreAnnotations.DocIDAnnotation.class));
            l1.set("docDate", doc.get(CoreAnnotations.DocDateAnnotation.class));
            l1.set("docSourceType", doc.get(CoreAnnotations.DocSourceTypeAnnotation.class));
            l1.set("docType", doc.get(CoreAnnotations.DocTypeAnnotation.class));
            l1.set("author", doc.get(CoreAnnotations.AuthorAnnotation.class));
            l1.set("location", doc.get(CoreAnnotations.LocationAnnotation.class));
            if (options.includeText) {
                l1.set("text", doc.get(CoreAnnotations.TextAnnotation.class));
            }
            if (doc.get(CoreAnnotations.SentencesAnnotation.class) != null) {
                l1.set("sentences", ((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).stream().map(sentence -> l2 -> {
                    l2.set("id", sentence.get(CoreAnnotations.SentenceIDAnnotation.class));
                    l2.set("index", sentence.get(CoreAnnotations.SentenceIndexAnnotation.class));
                    l2.set("line", sentence.get(CoreAnnotations.LineNumberAnnotation.class));
                    StringWriter treeStrWriter = new StringWriter();
                    options.constituentTreePrinter.printTree((Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class), new PrintWriter((java.io.Writer)treeStrWriter, true));
                    l2.set("parse", treeStrWriter.toString());
                    l2.set("basic-dependencies", JSONOutputter.buildDependencyTree((SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class)));
                    l2.set("collapsed-dependencies", JSONOutputter.buildDependencyTree((SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class)));
                    l2.set("collapsed-ccprocessed-dependencies", JSONOutputter.buildDependencyTree((SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class)));
                    if (sentence.get(CoreAnnotations.TokensAnnotation.class) != null) {
                        l2.set("tokens", ((List)doc.get(CoreAnnotations.TokensAnnotation.class)).stream().map(token -> l3 -> {
                            l3.set("index", token.index());
                            l3.set("word", token.word());
                            l3.set("lemma", token.lemma());
                            l3.set("characterOffsetBegin", token.beginPosition());
                            l3.set("characterOffsetEnd", token.endPosition());
                            l3.set("pos", token.tag());
                            l3.set("ner", token.ner());
                            l3.set("normalizedNER", token.get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class));
                            l3.set("speaker", token.get(CoreAnnotations.SpeakerAnnotation.class));
                            l3.set("truecase", token.get(CoreAnnotations.TrueCaseAnnotation.class));
                            l3.set("truecaseText", token.get(CoreAnnotations.TrueCaseTextAnnotation.class));
                            Timex time = (Timex)token.get(TimeAnnotations.TimexAnnotation.class);
                            if (time != null) {
                                l3.set("timex", l4 -> {
                                    l4.set("tid", time.tid());
                                    l4.set("type", time.timexType());
                                    l4.set("value", time.value());
                                    l4.set("altValue", time.altVal());
                                });
                            }
                        }));
                    }
                }));
            }
        });
        l0.writer.flush();
    }

    private static Object buildDependencyTree(SemanticGraph graph) {
        if (graph != null) {
            return Stream.concat(graph.getRoots().stream().map(root -> dep -> {
                dep.set("dep", "ROOT");
                dep.set("governor", "0");
                dep.set("governorGloss", "ROOT");
                dep.set("dependent", Integer.toString(root.index()));
                dep.set("dependentGloss", root.word());
            }), graph.edgeListSorted().stream().map(edge -> dep -> {
                dep.set("dep", edge.getRelation().toString());
                dep.set("governor", Integer.toString(edge.getGovernor().index()));
                dep.set("governorGloss", edge.getGovernor().word());
                dep.set("dependent", Integer.toString(edge.getDependent().index()));
                dep.set("dependentGloss", edge.getDependent().word());
            }));
        }
        return null;
    }

    public static void jsonPrint(Annotation annotation, OutputStream os) throws IOException {
        new JSONOutputter().print(annotation, os);
    }

    public static void jsonPrint(Annotation annotation, OutputStream os, StanfordCoreNLP pipeline) throws IOException {
        new JSONOutputter().print(annotation, os, pipeline);
    }

    public static void jsonPrint(Annotation annotation, OutputStream os, AnnotationOutputter.Options options) throws IOException {
        new JSONOutputter().print(annotation, os, options);
    }

    @FunctionalInterface
    protected static interface Writer {
        public void set(String var1, Object var2);
    }

    protected static class JSONWriter {
        private final PrintWriter writer;

        private JSONWriter(PrintWriter writer) {
            this.writer = writer;
        }

        protected static String cleanJSON(String s) {
            return s.replace("\\", "\\\\").replace("\b", "\\b").replace("\f", "\\f").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t").replace("'", "\\'").replace("\"", "\\\"");
        }

        private void routeObject(int indent, Object value) {
            if (value instanceof String) {
                this.writer.write("\"");
                this.writer.write(JSONWriter.cleanJSON(value.toString()));
                this.writer.write("\"");
            } else if (value instanceof Collection) {
                this.writer.write("[\n");
                Iterator elems = ((Collection)value).iterator();
                while (elems.hasNext()) {
                    this.indent(indent + 1);
                    this.routeObject(indent + 1, elems.next());
                    if (elems.hasNext()) {
                        this.writer.write(",");
                    }
                    this.writer.write("\n");
                }
                this.indent(indent);
                this.writer.write("]");
            } else if (value instanceof Consumer) {
                this.object(indent, (Consumer)value);
            } else if (value instanceof Stream) {
                this.routeObject(indent, ((Stream)value).collect(Collectors.toList()));
            } else if (value.getClass().isArray()) {
                this.routeObject(indent, Arrays.asList((Object[])value));
            } else if (value instanceof Integer) {
                this.routeObject(indent, Integer.toString((Integer)value));
            } else if (value instanceof Double) {
                this.routeObject(indent, Double.toString((Double)value));
            } else {
                throw new RuntimeException("Unknown object to serialize: " + value);
            }
        }

        private void indent(int num) {
            for (int i = 0; i < num; ++i) {
                this.writer.write(JSONOutputter.INDENT_CHAR);
            }
        }

        public void object(int indent, Consumer<Writer> callback) {
            this.writer.write("{");
            boolean[] firstCall = new boolean[]{true};
            callback.accept((key, value) -> {
                if (key != null && value != null) {
                    if (!firstCall[0]) {
                        this.writer.write(",");
                    }
                    blArray[0] = false;
                    this.writer.write("\n");
                    this.indent(indent + 1);
                    this.writer.write("\"");
                    this.writer.write(JSONWriter.cleanJSON(key));
                    this.writer.write("\": ");
                    this.routeObject(indent + 1, value);
                }
            });
            this.writer.write("\n");
            this.indent(indent);
            this.writer.write("}");
        }

        public void object(Consumer<Writer> callback) {
            this.object(0, callback);
        }

        public static String objectToJSON(Consumer<Writer> callback) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PrintWriter out2 = new PrintWriter(os);
            new JSONWriter(out2).object(callback);
            out2.close();
            return ((Object)os).toString();
        }
    }
}

