/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.parser.nndep.DependencyParser;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.SentenceAnnotator;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphFactory;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class DependencyParseAnnotator
extends SentenceAnnotator {
    private final DependencyParser parser;
    private final int nThreads;
    private static final int DEFAULT_NTHREADS = 1;
    private final long maxTime;
    private static final long DEFAULT_MAXTIME = Long.MAX_VALUE;

    public DependencyParseAnnotator() {
        this(new Properties());
    }

    public DependencyParseAnnotator(Properties properties) {
        String modelPath = PropertiesUtils.getString(properties, "model", "edu/stanford/nlp/models/parser/nndep/PTB_Stanford_params.txt.gz");
        this.parser = DependencyParser.loadFromModelFile(modelPath, properties);
        this.nThreads = PropertiesUtils.getInt(properties, "testThreads", 1);
        this.maxTime = PropertiesUtils.getLong(properties, "sentenceTimeout", Long.MAX_VALUE);
    }

    @Override
    protected int nThreads() {
        return this.nThreads;
    }

    @Override
    protected long maxTime() {
        return this.maxTime;
    }

    @Override
    protected void doOneSentence(Annotation annotation, CoreMap sentence) {
        GrammaticalStructure gs = this.parser.predict(sentence);
        SemanticGraph deps = SemanticGraphFactory.generateCollapsedDependencies(gs);
        SemanticGraph uncollapsedDeps = SemanticGraphFactory.generateUncollapsedDependencies(gs);
        SemanticGraph ccDeps = SemanticGraphFactory.generateCCProcessedDependencies(gs);
        sentence.set(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class, deps);
        sentence.set(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class, uncollapsedDeps);
        sentence.set(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class, ccDeps);
    }

    @Override
    protected void doOneFailedSentence(Annotation annotation, CoreMap sentence) {
        System.err.println("fail");
    }

    @Override
    public Set<Annotator.Requirement> requires() {
        return TOKENIZE_SSPLIT_POS;
    }

    @Override
    public Set<Annotator.Requirement> requirementsSatisfied() {
        return new HashSet<Annotator.Requirement>();
    }
}

