/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationOutputter;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class CoNLLOutputter
extends AnnotationOutputter {
    private static final String NULL_PLACEHOLDER = "_";

    private String orNull(String in) {
        if (in == null) {
            return NULL_PLACEHOLDER;
        }
        return in;
    }

    private String line(int index, CoreLabel token, int head, String deprel) {
        ArrayList<String> fields = new ArrayList<String>(16);
        fields.add(Integer.toString(index));
        fields.add(this.orNull(token.word()));
        fields.add(this.orNull(token.lemma()));
        fields.add(this.orNull(token.tag()));
        fields.add(this.orNull(token.ner()));
        if (head >= 0) {
            fields.add(Integer.toString(head));
            fields.add(deprel);
        } else {
            fields.add(NULL_PLACEHOLDER);
            fields.add(NULL_PLACEHOLDER);
        }
        return StringUtils.join(fields, "\t");
    }

    @Override
    public void print(Annotation doc, OutputStream target, AnnotationOutputter.Options options) throws IOException {
        PrintWriter writer = new PrintWriter(target);
        boolean firstSentence = true;
        if (doc.get(CoreAnnotations.SentencesAnnotation.class) != null) {
            for (CoreMap sentence : (List)doc.get(CoreAnnotations.SentencesAnnotation.class)) {
                if (!firstSentence) {
                    writer.println();
                    writer.println();
                }
                firstSentence = false;
                if (sentence.get(CoreAnnotations.TokensAnnotation.class) == null) continue;
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                SemanticGraph depTree = (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
                for (int i = 0; i < tokens.size(); ++i) {
                    if (i > 0) {
                        writer.println();
                    }
                    int head = -1;
                    String deprel = null;
                    if (depTree != null) {
                        Set rootSet = depTree.getRoots().stream().map(IndexedWord::index).collect(Collectors.toSet());
                        IndexedWord node = depTree.getNodeByIndexSafe(i + 1);
                        if (node != null) {
                            List<SemanticGraphEdge> edgeList = depTree.getIncomingEdgesSorted(node);
                            if (!edgeList.isEmpty()) {
                                assert (edgeList.size() == 1);
                                head = edgeList.get(0).getGovernor().index();
                                deprel = edgeList.get(0).getRelation().toString();
                            } else if (rootSet.contains(i + 1)) {
                                head = 0;
                                deprel = "ROOT";
                            }
                        }
                    }
                    writer.print(this.line(i + 1, (CoreLabel)tokens.get(i), head, deprel));
                }
            }
        }
        writer.flush();
    }

    public static void conllPrint(Annotation annotation, OutputStream os) throws IOException {
        new CoNLLOutputter().print(annotation, os);
    }

    public static void conllPrint(Annotation annotation, OutputStream os, StanfordCoreNLP pipeline) throws IOException {
        new CoNLLOutputter().print(annotation, os, pipeline);
    }

    public static void conllPrint(Annotation annotation, OutputStream os, AnnotationOutputter.Options options) throws IOException {
        new CoNLLOutputter().print(annotation, os, options);
    }
}

