/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.surface;

import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class Token
implements Serializable {
    public static Env env = TokenSequencePattern.getNewEnv();
    static Map<Class, String> class2KeyMapping = new ConcurrentHashMap<Class, String>();
    Map<Class, String> classORrestrictions;
    String envBindBooleanRestriction;
    final Pattern alphaNumeric = Pattern.compile("^[\\p{Alnum}\\s\\.]+$");
    int numMinOcc = 1;
    int numMaxOcc = 1;

    public Map<String, String> classORRestrictionsAsString() {
        if (this.classORrestrictions == null || this.classORrestrictions.isEmpty()) {
            return null;
        }
        HashMap<String, String> str = new HashMap<String, String>();
        for (Map.Entry<Class, String> en : this.classORrestrictions.entrySet()) {
            str.put(class2KeyMapping.get(en.getKey()), en.getValue().toString());
        }
        return str;
    }

    String[] trim(String[] p) {
        if (p == null) {
            return null;
        }
        for (int i = 0; i < p.length; ++i) {
            p[i] = p[i].trim();
        }
        return p;
    }

    public String toString() {
        String str = "";
        if (this.classORrestrictions != null && !this.classORrestrictions.isEmpty()) {
            for (Map.Entry<Class, String> en : this.classORrestrictions.entrySet()) {
                String orgVal = en.getValue().toString();
                String val = !this.alphaNumeric.matcher(orgVal).matches() ? "/" + Pattern.quote(orgVal.replaceAll("/", "\\\\/")) + "/" : "\"" + orgVal + "\"";
                if (str.isEmpty()) {
                    str = "{" + class2KeyMapping.get(en.getKey()) + ":" + val + "}";
                    continue;
                }
                str = str + " | {" + class2KeyMapping.get(en.getKey()) + ":" + val + "}";
            }
            str = "[" + str + "]";
        } else if (this.envBindBooleanRestriction != null && !this.envBindBooleanRestriction.isEmpty()) {
            str = this.envBindBooleanRestriction;
        }
        if (this.numMinOcc != 1 || this.numMaxOcc != 1) {
            str = str + "{" + this.numMinOcc + "," + this.numMaxOcc + "}";
        }
        return str.trim();
    }

    public String getSimple() {
        String str = "";
        if (this.classORrestrictions != null && !this.classORrestrictions.isEmpty()) {
            for (Map.Entry<Class, String> en : this.classORrestrictions.entrySet()) {
                if (str.isEmpty()) {
                    str = en.getValue().toString();
                    continue;
                }
                str = str + "|" + en.getValue().toString();
            }
        } else if (this.envBindBooleanRestriction != null && !this.envBindBooleanRestriction.isEmpty()) {
            if (this.envBindBooleanRestriction.startsWith("$FILLER")) {
                str = "FW";
            } else if (this.envBindBooleanRestriction.startsWith("$STOP")) {
                str = "SW";
            }
        }
        return str.trim();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Token)) {
            return false;
        }
        return o.toString().equals(this.toString());
    }

    public void addORRestriction(Class classR, String value) {
        Token.getKeyForClass(classR);
        if (this.envBindBooleanRestriction != null && !this.envBindBooleanRestriction.isEmpty()) {
            throw new RuntimeException("cannot add restriction to something that is binding to an env variable");
        }
        if (this.classORrestrictions == null) {
            this.classORrestrictions = new TreeMap<Class, String>(new ClassComparator());
        }
        this.classORrestrictions.put(classR, value);
    }

    public void setEnvBindRestriction(String envBind) {
        if (this.classORrestrictions != null && !this.classORrestrictions.isEmpty()) {
            throw new RuntimeException("cannot add env bind restriction to something that has restricted");
        }
        this.envBindBooleanRestriction = envBind;
    }

    public void setNumOcc(int min, int max) {
        this.numMinOcc = min;
        this.numMaxOcc = max;
    }

    public boolean isEmpty() {
        return !(this.envBindBooleanRestriction != null && !this.envBindBooleanRestriction.isEmpty() || this.classORrestrictions != null && !this.classORrestrictions.isEmpty());
    }

    public static String getKeyForClass(Class classR) {
        String key = class2KeyMapping.get(classR);
        if (key == null) {
            for (Map.Entry<String, Object> vars : env.getVariables().entrySet()) {
                if (!vars.getValue().equals(classR)) continue;
                key = vars.getKey().toLowerCase();
                class2KeyMapping.put(classR, key);
                break;
            }
        }
        if (key == null) {
            key = classR.getSimpleName().toLowerCase();
            class2KeyMapping.put(classR, key);
            env.bind(key, classR);
        }
        return key;
    }

    public class ClassComparator
    implements Serializable,
    Comparator<Class> {
        @Override
        public int compare(Class o1, Class o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

