/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.surface;

import edu.stanford.nlp.patterns.surface.ConstantsAndVariables;
import edu.stanford.nlp.patterns.surface.GetPatternsFromDataMultiClass;
import edu.stanford.nlp.patterns.surface.ScorePatterns;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.TwoDimensionalCounter;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ScorePatternsFreqBased<E>
extends ScorePatterns<E> {
    public ScorePatternsFreqBased(ConstantsAndVariables constVars, GetPatternsFromDataMultiClass.PatternScoring patternScoring, String label, Set<String> allCandidatePhrases, TwoDimensionalCounter<E, String> patternsandWords4Label, TwoDimensionalCounter<E, String> negPatternsandWords4Label, TwoDimensionalCounter<E, String> unLabeledPatternsandWords4Label, Properties props) {
        super(constVars, patternScoring, label, allCandidatePhrases, patternsandWords4Label, negPatternsandWords4Label, unLabeledPatternsandWords4Label, props);
    }

    @Override
    public void setUp(Properties props) {
    }

    @Override
    Counter<E> score() {
        Counter currentPatternWeights4Label = new ClassicCounter();
        ClassicCounter pos_i = new ClassicCounter();
        ClassicCounter neg_i = new ClassicCounter();
        ClassicCounter unlab_i = new ClassicCounter();
        for (Map.Entry en : this.negPatternsandWords4Label.entrySet()) {
            neg_i.setCount(en.getKey(), en.getValue().size());
        }
        for (Map.Entry en : this.unLabeledPatternsandWords4Label.entrySet()) {
            unlab_i.setCount(en.getKey(), en.getValue().size());
        }
        for (Map.Entry en : this.patternsandWords4Label.entrySet()) {
            pos_i.setCount(en.getKey(), en.getValue().size());
        }
        Counter all_i = Counters.add(pos_i, neg_i);
        all_i.addAll(unlab_i);
        Counter posneg_i = Counters.add(pos_i, neg_i);
        ClassicCounter logFi = new ClassicCounter(pos_i);
        Counters.logInPlace(logFi);
        if (this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.RlogF)) {
            currentPatternWeights4Label = Counters.product(Counters.division(pos_i, all_i), logFi);
        } else if (this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.RlogFPosNeg)) {
            Redwood.log("extremePatDebug", "computing rlogfposneg");
            currentPatternWeights4Label = Counters.product(Counters.division(pos_i, posneg_i), logFi);
        } else if (this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.RlogFUnlabNeg)) {
            Redwood.log("extremePatDebug", "computing rlogfunlabeg");
            currentPatternWeights4Label = Counters.product(Counters.division(pos_i, Counters.add(neg_i, unlab_i)), logFi);
        } else if (this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.RlogFNeg)) {
            Redwood.log("extremePatDebug", "computing rlogfneg");
            currentPatternWeights4Label = Counters.product(Counters.division(pos_i, neg_i), logFi);
        } else if (this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.YanGarber02)) {
            Counter acc = Counters.division(pos_i, Counters.add(pos_i, neg_i));
            double thetaPrecision = 0.8;
            Counters.retainAbove(acc, thetaPrecision);
            Counter conf = Counters.product(Counters.division(pos_i, all_i), logFi);
            for (Object p : acc.keySet()) {
                currentPatternWeights4Label.setCount(p, conf.getCount(p));
            }
        } else if (this.patternScoring.equals((Object)GetPatternsFromDataMultiClass.PatternScoring.LinICML03)) {
            Counter acc = Counters.division(pos_i, Counters.add(pos_i, neg_i));
            double thetaPrecision = 0.8;
            Counters.retainAbove(acc, thetaPrecision);
            Counter conf = Counters.product(Counters.division(Counters.add(pos_i, Counters.scale(neg_i, -1.0)), all_i), logFi);
            for (Object p : acc.keySet()) {
                currentPatternWeights4Label.setCount(p, conf.getCount(p));
            }
        } else {
            throw new RuntimeException("not implemented " + (Object)((Object)this.patternScoring) + " . check spelling!");
        }
        return currentPatternWeights4Label;
    }
}

