/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.surface;

import edu.stanford.nlp.patterns.surface.ConstantsAndVariables;
import edu.stanford.nlp.patterns.surface.Data;
import edu.stanford.nlp.patterns.surface.Pattern;
import edu.stanford.nlp.process.WordShapeClassifier;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.TwoDimensionalCounter;
import edu.stanford.nlp.util.Execution;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class PhraseScorer<E extends Pattern> {
    ConstantsAndVariables<E> constVars;
    double OOVExternalFeatWt = 0.5;
    double OOVdictOdds = 1.0E-10;
    double OOVDomainNgramScore = 1.0E-10;
    double OOVGoogleNgramScore = 1.0E-10;
    @Execution.Option(name="usePatternWeights")
    public boolean usePatternWeights = true;
    @Execution.Option(name="wordFreqNorm")
    Normalization wordFreqNorm = Normalization.valueOf("LOG");
    @Execution.Option(name="useAvgInsteadofMinPhraseScoring")
    boolean useAvgInsteadofMinPhraseScoring = false;
    boolean forLearningPatterns;
    Counter<String> learnedScores = new ClassicCounter<String>();

    public PhraseScorer(ConstantsAndVariables constvar) {
        this.constVars = constvar;
    }

    abstract Counter<String> scorePhrases(String var1, TwoDimensionalCounter<String, E> var2, TwoDimensionalCounter<String, E> var3, Counter<E> var4, Set<String> var5, boolean var6) throws IOException, ClassNotFoundException;

    Counter<String> getLearnedScores() {
        return this.learnedScores;
    }

    double getPatTFIDFScore(String word, Counter<E> patsThatExtractedThis, Counter<E> allSelectedPatterns) {
        double total = 0.0;
        HashSet<E> rem = new HashSet<E>();
        for (Map.Entry<E, Double> en2 : patsThatExtractedThis.entrySet()) {
            double weight = 1.0;
            if (this.usePatternWeights && (weight = allSelectedPatterns.getCount(en2.getKey())) == 0.0) {
                Redwood.log(new Object[]{Redwood.FORCE, "Warning: Weight zero for " + en2.getKey() + ". May be pattern was removed when choosing other patterns (if subsumed by another pattern)."});
                rem.add(en2.getKey());
            }
            total += weight;
        }
        Counters.removeKeys(patsThatExtractedThis, rem);
        assert (Data.processedDataFreq.containsKey(word)) : "How come the processed corpus freq doesnt have " + word + " .Size of processedDataFreq is " + Data.processedDataFreq.size() + " and size of raw freq is " + Data.rawFreq.size();
        return total / Data.processedDataFreq.getCount(word);
    }

    public double getGoogleNgramScore(String g) {
        if (Data.googleNGram.containsKey(g)) {
            assert (Data.rawFreq.containsKey(g));
            return (1.0 + Data.rawFreq.getCount(g) * Math.sqrt(Data.ratioGoogleNgramFreqWithDataFreq)) / Data.googleNGram.getCount(g);
        }
        return 0.0;
    }

    public double getDomainNgramScore(String g) {
        assert (Data.domainNGramRawFreq.containsKey(g)) : " How come dowmin ngram raw freq does not contain " + g;
        if (Data.domainNGramRawFreq.getCount(g) == 0.0) {
            System.err.println("domain count 0 for " + g);
            return 0.0;
        }
        return (1.0 + Data.rawFreq.getCount(g) * Math.sqrt(Data.ratioDomainNgramFreqWithDataFreq)) / Data.domainNGramRawFreq.getCount(g);
    }

    public double getDistSimWtScore(String ph, String label) {
        Integer num = this.constVars.getWordClassClusters().get(ph);
        if (num != null && this.constVars.distSimWeights.get(label).containsKey(num)) {
            return this.constVars.distSimWeights.get(label).getCount(num);
        }
        String[] t = ph.split("\\s+");
        if (t.length < 2) {
            return this.OOVExternalFeatWt;
        }
        double totalscore = 0.0;
        double minScore = Double.MAX_VALUE;
        for (String w : t) {
            double score = this.OOVExternalFeatWt;
            Integer numw = this.constVars.getWordClassClusters().get(w);
            if (numw != null && this.constVars.distSimWeights.get(label).containsKey(numw)) {
                score = this.constVars.distSimWeights.get(label).getCount(numw);
            }
            if (score < minScore) {
                minScore = score;
            }
            totalscore += score;
        }
        if (this.useAvgInsteadofMinPhraseScoring) {
            return totalscore / (double)ph.length();
        }
        return minScore;
    }

    public double getWordShapeScore(String word, String label) {
        String wordShape = this.constVars.getWordShapeCache().get(word);
        if (wordShape == null) {
            wordShape = WordShapeClassifier.wordShape(word, this.constVars.wordShaper);
            this.constVars.getWordShapeCache().put(word, wordShape);
        }
        double thislabel = 0.0;
        double alllabels = 0.0;
        for (Map.Entry<String, Counter<String>> en : this.constVars.getWordShapesForLabels().entrySet()) {
            if (en.getKey().equals(label)) {
                thislabel = en.getValue().getCount(wordShape);
            }
            alllabels += en.getValue().getCount(wordShape);
        }
        double score = thislabel / (alllabels + 1.0);
        return score;
    }

    public double getDictOddsScore(String word, String label) {
        Counter<String> dictOddsWordWeights = this.constVars.dictOddsWeights.get(label);
        assert (dictOddsWordWeights != null) : "dictOddsWordWeights is null for label " + label;
        double dscore = dictOddsWordWeights.containsKey(word) ? dictOddsWordWeights.getCount(word) : this.getPhraseWeightFromWords(dictOddsWordWeights, word, this.OOVdictOdds);
        return dscore;
    }

    public double getPhraseWeightFromWords(Counter<String> weights, String ph, double defaultWt) {
        String[] t = ph.split("\\s+");
        if (t.length < 2) {
            if (weights.containsKey(ph)) {
                return weights.getCount(ph);
            }
            return defaultWt;
        }
        double totalscore = 0.0;
        double minScore = Double.MAX_VALUE;
        for (String w : t) {
            double score = defaultWt;
            if (weights.containsKey(w)) {
                score = weights.getCount(w);
            }
            if (score < minScore) {
                minScore = score;
            }
            totalscore += score;
        }
        if (this.useAvgInsteadofMinPhraseScoring) {
            return totalscore / (double)ph.length();
        }
        return minScore;
    }

    public abstract Counter<String> scorePhrases(String var1, Set<String> var2, boolean var3) throws IOException, ClassNotFoundException;

    public static enum Normalization {
        NONE,
        SQRT,
        LOG;

    }
}

