/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.surface;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.patterns.surface.Pattern;
import edu.stanford.nlp.patterns.surface.PatternsForEachToken;
import edu.stanford.nlp.util.Execution;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class PatternsForEachTokenInMemory<E extends Pattern>
extends PatternsForEachToken<E> {
    public static ConcurrentHashMap<String, Map<Integer, Set<? extends Pattern>>> patternsForEachToken = null;

    public PatternsForEachTokenInMemory(Properties props, Map<String, Map<Integer, Set<E>>> pats) {
        Execution.fillOptions((Object)this, props);
        if (patternsForEachToken == null) {
            patternsForEachToken = new ConcurrentHashMap();
        }
        if (pats != null) {
            this.addPatterns(pats);
        }
    }

    public PatternsForEachTokenInMemory(Properties props) {
        this(props, null);
    }

    @Override
    public void addPatterns(String sentId, Map<Integer, Set<E>> patterns) {
        if (!patternsForEachToken.containsKey(sentId)) {
            patternsForEachToken.put(sentId, new ConcurrentHashMap());
        }
        patternsForEachToken.get(sentId).putAll(patterns);
    }

    @Override
    public void addPatterns(Map<String, Map<Integer, Set<E>>> pats) {
        for (Map.Entry<String, Map<Integer, Set<E>>> en : pats.entrySet()) {
            this.addPatterns(en.getKey(), en.getValue());
        }
    }

    @Override
    public Map<Integer, Set<E>> getPatternsForAllTokens(String sentId) {
        return patternsForEachToken.containsKey(sentId) ? patternsForEachToken.get(sentId) : Collections.emptyMap();
    }

    @Override
    public void setupSearch() {
    }

    @Override
    public Map<String, Map<Integer, Set<E>>> getPatternsForAllTokens(Collection<String> sampledSentIds) {
        HashMap<String, Map<Integer, Set<E>>> pats = new HashMap<String, Map<Integer, Set<E>>>();
        for (String s : sampledSentIds) {
            pats.put(s, this.getPatternsForAllTokens(s));
        }
        return pats;
    }

    @Override
    public void close() {
    }

    @Override
    public void load(String allPatternsDir) {
        try {
            this.addPatterns((Map)IOUtils.readObjectFromFile(allPatternsDir + "/allpatterns.ser"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean save(String dir) {
        try {
            IOUtils.writeObjectToFile(patternsForEachToken, dir + "/allpatterns.ser");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    @Override
    public void createIndexIfUsingDBAndNotExists() {
    }

    public boolean containsSentId(String sentId) {
        return patternsForEachToken.containsKey(sentId);
    }

    @Override
    public int size() {
        return patternsForEachToken.size();
    }
}

