/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.surface;

import edu.stanford.nlp.patterns.surface.SurfacePatternFactory;
import edu.stanford.nlp.util.Execution;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;

public class PatternFactory {
    @Execution.Option(name="useStopWordsBeforeTerm")
    public static boolean useStopWordsBeforeTerm = false;
    @Execution.Option(name="useTargetNERRestriction")
    public static boolean useTargetNERRestriction = false;
    @Execution.Option(name="numWordsCompound")
    public static int numWordsCompound = 2;
    @Execution.Option(name="useLemmaContextTokens")
    public static boolean useLemmaContextTokens = true;
    public static List<String> fillerWords = Arrays.asList("a", "an", "the", "`", "``", "'", "''");
    public static Pattern ignoreWordRegex = Pattern.compile("a^");

    public static void setUp(Properties props) {
        Execution.fillOptions(PatternFactory.class, props);
        SurfacePatternFactory.setUp(props);
    }

    public static boolean doNotUse(String word, Set<String> stopWords) {
        return stopWords.contains(word.toLowerCase()) || ignoreWordRegex.matcher(word).matches();
    }

    public static enum PatternType {
        SURFACE;

    }
}

