/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.surface;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.patterns.surface.ConstantsAndVariables;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.Execution;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Data {
    public static double ratioDomainNgramFreqWithDataFreq = 1.0;
    public static Counter<String> rawFreq = null;
    public static List<File> sentsFiles = null;
    public static Map<String, File> sentId2File = null;
    public static List<String> fileNamesUsedToComputeRawFreq = new ArrayList<String>();
    public static Map<String, List<CoreLabel>> sents = null;
    public static Counter<String> processedDataFreq = null;
    public static Counter<String> domainNGramRawFreq = new ClassicCounter<String>();
    public static double ratioGoogleNgramFreqWithDataFreq = 1.0;
    @Execution.Option(name="googleNGramsFile")
    public static String googleNGramsFile = null;
    @Execution.Option(name="domainNGramsFile")
    public static String domainNGramsFile = null;
    public static Counter<String> googleNGram = new ClassicCounter<String>();

    public static void computeRawFreqIfNull(Map<String, List<CoreLabel>> sents, int numWordsCompound) {
        for (List<CoreLabel> l : sents.values()) {
            List<List<CoreLabel>> ngrams = CollectionUtils.getNGrams(l, 1, numWordsCompound);
            for (List<CoreLabel> n : ngrams) {
                String s = "";
                for (CoreLabel c : n) {
                    s = s + " " + c.word();
                }
                if (s.trim().isEmpty()) continue;
                rawFreq.incrementCount(s.trim());
            }
        }
        if (googleNGram != null && googleNGram.size() > 0) {
            Data.setRatioGoogleNgramFreqWithDataFreq();
        }
        if (domainNGramRawFreq != null && domainNGramRawFreq.size() > 0) {
            ratioDomainNgramFreqWithDataFreq = domainNGramRawFreq.totalCount() / rawFreq.totalCount();
        }
    }

    public static void setRatioGoogleNgramFreqWithDataFreq() {
        ratioGoogleNgramFreqWithDataFreq = googleNGram.totalCount() / rawFreq.totalCount();
        Redwood.log(ConstantsAndVariables.minimaldebug, "Data", "ratioGoogleNgramFreqWithDataFreq is " + ratioGoogleNgramFreqWithDataFreq);
    }

    public static void loadGoogleNGrams() {
        if (googleNGram == null || googleNGram.size() == 0) {
            for (String line : IOUtils.readLines(googleNGramsFile)) {
                String[] t = line.split("\t");
                googleNGram.setCount(t[0], Double.valueOf(t[1]));
            }
            Redwood.log(ConstantsAndVariables.minimaldebug, "Data", "loading freq from google ngram file " + googleNGramsFile);
        }
    }

    public static void loadDomainNGrams() {
        assert (domainNGramsFile != null);
        if (domainNGramRawFreq == null || domainNGramRawFreq.size() == 0) {
            for (String line : IOUtils.readLines(domainNGramsFile)) {
                String[] t = line.split("\t");
                domainNGramRawFreq.setCount(t[0], Double.valueOf(t[1]));
            }
            Redwood.log(ConstantsAndVariables.minimaldebug, "Data", "loading freq from domain ngram file " + domainNGramsFile);
        }
    }
}

