/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.surface;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.patterns.surface.ConstantsAndVariables;
import edu.stanford.nlp.patterns.surface.GetPatternsFromDataMultiClass;
import edu.stanford.nlp.patterns.surface.Pattern;
import edu.stanford.nlp.patterns.surface.PatternFactory;
import edu.stanford.nlp.patterns.surface.PatternsForEachToken;
import edu.stanford.nlp.util.Execution;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class CreatePatterns<E> {
    ConstantsAndVariables constVars;
    private Map<String, Map<Integer, Set<Integer>>> patternsForEachToken;

    public CreatePatterns(Properties props, ConstantsAndVariables constVars) throws IOException {
        this.constVars = constVars;
        Execution.fillOptions(ConstantsAndVariables.class, props);
        constVars.setUp(props);
        this.setUp(props);
    }

    void setUp(Properties props) {
        Execution.fillOptions((Object)this, props);
    }

    public void getAllPatterns(Map<String, List<CoreLabel>> sents, Properties props, ConstantsAndVariables.PatternForEachTokenWay storePatsForEachTokenWay) {
        Date startDate = new Date();
        ArrayList<String> keyset = new ArrayList<String>(sents.keySet());
        int num = this.constVars.numThreads == 1 ? keyset.size() : keyset.size() / this.constVars.numThreads;
        ExecutorService executor = Executors.newFixedThreadPool(this.constVars.numThreads);
        Redwood.log(ConstantsAndVariables.extremedebug, "Computing all patterns. keyset size is " + keyset.size() + ". Assigning " + num + " values to each thread");
        ArrayList<Future<Map<String, Map<Integer, Set<Integer>>>>> list = new ArrayList<Future<Map<String, Map<Integer, Set<Integer>>>>>();
        for (int i = 0; i < this.constVars.numThreads; ++i) {
            int n = i * num;
            int to = -1;
            to = i == this.constVars.numThreads - 1 ? keyset.size() : Math.min(keyset.size(), (i + 1) * num);
            CreatePatternsThread task = null;
            List<String> ids = keyset.subList(n, to);
            task = new CreatePatternsThread(sents, ids, props, storePatsForEachTokenWay);
            Future<Map<String, Map<Integer, Set<Integer>>>> submit = executor.submit(task);
            list.add(submit);
        }
        for (Future future : list) {
            try {
                future.get();
            }
            catch (Exception e) {
                executor.shutdownNow();
                throw new RuntimeException(e);
            }
        }
        executor.shutdown();
        Date endDate = new Date();
        String string = GetPatternsFromDataMultiClass.elapsedTime(startDate, endDate);
        Redwood.log(new Object[]{Redwood.DBG, "Done computing all patterns [" + string + "]"});
    }

    public Map<String, Map<Integer, Set<Integer>>> getPatternsForEachToken() {
        return this.patternsForEachToken;
    }

    public class CreatePatternsThread
    implements Callable<Map<String, Map<Integer, Set<Integer>>>> {
        Map<String, List<CoreLabel>> sents;
        List<String> sentIds;
        PatternsForEachToken patsForEach;

        public CreatePatternsThread(Map<String, List<CoreLabel>> sents, List<String> sentIds, Properties props, ConstantsAndVariables.PatternForEachTokenWay storePatsForEachToken) {
            this.sents = sents;
            this.sentIds = sentIds;
            this.patsForEach = PatternsForEachToken.getPatternsInstance(props, storePatsForEachToken);
        }

        @Override
        public Map<String, Map<Integer, Set<Integer>>> call() throws Exception {
            HashMap tempPatternsForTokens = new HashMap();
            int numSentencesInOneCommit = 0;
            for (String id : this.sentIds) {
                List<CoreLabel> sent = this.sents.get(id);
                if (!CreatePatterns.this.constVars.storePatsForEachToken.equals((Object)ConstantsAndVariables.PatternForEachTokenWay.MEMORY)) {
                    tempPatternsForTokens.put(id, new HashMap());
                }
                HashMap p = new HashMap();
                for (int i = 0; i < sent.size(); ++i) {
                    p.put(i, new HashSet());
                    CoreLabel token = sent.get(i);
                    CreatePatterns createPatterns = CreatePatterns.this;
                    if (PatternFactory.doNotUse(token.word(), createPatterns.constVars.getStopWords())) continue;
                    Set pat = Pattern.getContext(CreatePatterns.this.constVars.patternType, sent, i);
                    p.put(i, pat);
                }
                if (!CreatePatterns.this.constVars.storePatsForEachToken.equals((Object)ConstantsAndVariables.PatternForEachTokenWay.MEMORY)) {
                    tempPatternsForTokens.put(id, p);
                    if (++numSentencesInOneCommit % 1000 != 0) continue;
                    this.patsForEach.addPatterns(tempPatternsForTokens);
                    tempPatternsForTokens.clear();
                    numSentencesInOneCommit = 0;
                    continue;
                }
                this.patsForEach.addPatterns(id, p);
            }
            if (!CreatePatterns.this.constVars.storePatsForEachToken.equals((Object)ConstantsAndVariables.PatternForEachTokenWay.MEMORY)) {
                this.patsForEach.addPatterns(tempPatternsForTokens);
            }
            return null;
        }
    }
}

