/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.surface;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.patterns.surface.Data;
import edu.stanford.nlp.patterns.surface.EditDistanceDamerauLevenshteinLike;
import edu.stanford.nlp.patterns.surface.GetPatternsFromDataMultiClass;
import edu.stanford.nlp.patterns.surface.InvertedIndexByTokens;
import edu.stanford.nlp.patterns.surface.PatternFactory;
import edu.stanford.nlp.patterns.surface.PatternsAnnotations;
import edu.stanford.nlp.patterns.surface.SentenceIndex;
import edu.stanford.nlp.process.WordShapeClassifier;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.util.EditDistance;
import edu.stanford.nlp.util.Execution;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.TypesafeMap;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class ConstantsAndVariables<E>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Execution.Option(name="numIterationsForPatterns")
    public Integer numIterationsForPatterns = 10;
    @Execution.Option(name="numPatterns")
    public int numPatterns = 10;
    @Execution.Option(name="outDir")
    public String outDir = null;
    @Execution.Option(name="allPatternsDir")
    public String allPatternsDir = null;
    @Execution.Option(name="computeAllPatterns")
    public boolean computeAllPatterns = true;
    @Execution.Option(name="patternScoring")
    public GetPatternsFromDataMultiClass.PatternScoring patternScoring = GetPatternsFromDataMultiClass.PatternScoring.PosNegUnlabOdds;
    @Execution.Option(name="thresholdSelectPattern")
    public double thresholdSelectPattern = 1.0;
    @Execution.Option(name="restrictToMatched")
    public boolean restrictToMatched = false;
    @Execution.Option(name="usePatternResultAsLabel")
    public boolean usePatternResultAsLabel = true;
    @Execution.Option(name="debug")
    public int debug = 1;
    @Execution.Option(name="identifier")
    public String identifier = "getpatterns";
    @Execution.Option(name="useMatchingPhrase")
    public boolean useMatchingPhrase = true;
    @Execution.Option(name="tuneThresholdKeepRunning")
    public boolean tuneThresholdKeepRunning = false;
    @Execution.Option(name="maxExtractNumWords")
    public int maxExtractNumWords = Integer.MAX_VALUE;
    @Execution.Option(name="useOtherLabelsWordsasNegative")
    public boolean useOtherLabelsWordsasNegative = true;
    @Execution.Option(name="markedOutputTextFile")
    String markedOutputTextFile = null;
    @Execution.Option(name="columnOutputFile")
    String columnOutputFile = null;
    @Execution.Option(name="matchLowerCaseContext")
    public boolean matchLowerCaseContext = true;
    @Execution.Option(name="targetAllowedTagsInitialsStr")
    public String targetAllowedTagsInitialsStr = null;
    public Map<String, Set<String>> allowedTagsInitials = null;
    @Execution.Option(name="targetAllowedNERs")
    public String targetAllowedNERs = null;
    public Map<String, Set<String>> allowedNERsforLabels = null;
    @Execution.Option(name="numWordsToAdd")
    public int numWordsToAdd = 10;
    @Execution.Option(name="thresholdNumPatternsApplied")
    public double thresholdNumPatternsApplied = 2.0;
    @Execution.Option(name="wordScoring")
    public GetPatternsFromDataMultiClass.WordScoring wordScoring = GetPatternsFromDataMultiClass.WordScoring.WEIGHTEDNORM;
    @Execution.Option(name="thresholdWordExtract")
    public double thresholdWordExtract = 0.2;
    public boolean justify = false;
    @Execution.Option(name="LRSigma")
    public double LRSigma = 1.0;
    @Execution.Option(name="englishWordsFiles")
    public String englishWordsFiles = null;
    private Set<String> englishWords = null;
    @Execution.Option(name="commonWordsPatternFiles")
    public String commonWordsPatternFiles = null;
    private Set<String> commonEngWords = null;
    @Execution.Option(name="otherSemanticClassesFiles")
    public String otherSemanticClassesFiles = null;
    private Set<String> otherSemanticClassesWords = null;
    private Map<String, Set<String>> labelDictionary = new HashMap<String, Set<String>>();
    private Set<String> labels = new HashSet<String>();
    private Map<String, Class<? extends TypesafeMap.Key<String>>> answerClass = null;
    private Map<String, Map<Class, Object>> ignoreWordswithClassesDuringSelection = null;
    private static Map<String, Class> generalizeClasses = new HashMap<String, Class>();
    @Execution.Option(name="minLen4FuzzyForPattern")
    public int minLen4FuzzyForPattern = 6;
    @Execution.Option(name="wordIgnoreRegex")
    public String wordIgnoreRegex = "[^a-zA-Z]*";
    @Execution.Option(name="numThreads")
    public int numThreads = 1;
    @Execution.Option(name="stopWordsPatternFiles", gloss="stop words")
    public String stopWordsPatternFiles = null;
    private static Set<String> stopWords = null;
    public Map<String, Env> env = new HashMap<String, Env>();
    @Execution.Option(name="removeStopWordsFromSelectedPhrases")
    public boolean removeStopWordsFromSelectedPhrases = false;
    @Execution.Option(name="removePhrasesWithStopWords")
    public boolean removePhrasesWithStopWords = false;
    private boolean alreadySetUp = false;
    @Execution.Option(name="wordClassClusterFile")
    String wordClassClusterFile = null;
    private Map<String, Integer> wordClassClusters = null;
    @Execution.Option(name="generalWordClassClusterFile")
    String generalWordClassClusterFile = null;
    private Map<String, Integer> generalWordClassClusters = null;
    @Execution.Option(name="includeExternalFeatures")
    public boolean includeExternalFeatures = false;
    @Execution.Option(name="externalFeatureWeightsFile")
    public String externalFeatureWeightsFile = null;
    @Execution.Option(name="doNotApplyPatterns")
    public boolean doNotApplyPatterns = false;
    @Execution.Option(name="sqrtPatScore")
    public boolean sqrtPatScore = false;
    @Execution.Option(name="minUnlabPhraseSupportForPat")
    public int minUnlabPhraseSupportForPat = 0;
    @Execution.Option(name="minPosPhraseSupportForPat")
    public int minPosPhraseSupportForPat = 1;
    @Execution.Option(name="addIndvWordsFromPhrasesExceptLastAsNeg")
    public boolean addIndvWordsFromPhrasesExceptLastAsNeg = false;
    private ConcurrentHashMap<String, Double> editDistanceFromEnglishWords = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> editDistanceFromEnglishWordsMatches = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Double> editDistanceFromOtherSemanticClasses = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> editDistanceFromOtherSemanticClassesMatches = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Double> editDistanceFromThisClass = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> editDistanceFromThisClassMatches = new ConcurrentHashMap();
    private Map<String, Counter<String>> wordShapesForLabels = new HashMap<String, Counter<String>>();
    String channelNameLogger = "settingUp";
    public Map<String, Counter<Integer>> distSimWeights = new HashMap<String, Counter<Integer>>();
    public Map<String, Counter<String>> dictOddsWeights = new HashMap<String, Counter<String>>();
    @Execution.Option(name="invertedIndexClass", gloss="another option is Lucene backed, which is not included in the CoreNLP release. Contact us to get a copy (distributed under Apache License).")
    public Class<? extends SentenceIndex> invertedIndexClass = InvertedIndexByTokens.class;
    @Execution.Option(name="invertedIndexDirectory")
    public String invertedIndexDirectory;
    @Execution.Option(name="clubNeighboringLabeledWords")
    public boolean clubNeighboringLabeledWords = false;
    public PatternFactory.PatternType patternType = PatternFactory.PatternType.SURFACE;
    @Execution.Option(name="removeOverLappingLabelsFromSeed")
    public boolean removeOverLappingLabelsFromSeed = false;
    @Execution.Option(name="usePhraseEvalWordClass")
    public boolean usePhraseEvalWordClass = false;
    @Execution.Option(name="usePhraseEvalGoogleNgram")
    public boolean usePhraseEvalGoogleNgram = false;
    @Execution.Option(name="usePhraseEvalDomainNgram")
    public boolean usePhraseEvalDomainNgram = false;
    @Execution.Option(name="usePhraseEvalPatWtByFreq")
    public boolean usePhraseEvalPatWtByFreq = false;
    @Execution.Option(name="usePhraseEvalSemanticOdds")
    public boolean usePhraseEvalSemanticOdds = false;
    @Execution.Option(name="usePhraseEvalEditDistSame")
    public boolean usePhraseEvalEditDistSame = false;
    @Execution.Option(name="usePhraseEvalEditDistOther")
    public boolean usePhraseEvalEditDistOther = false;
    @Execution.Option(name="usePhraseEvalWordShape")
    public boolean usePhraseEvalWordShape = false;
    @Execution.Option(name="usePatternEvalWordClass")
    public boolean usePatternEvalWordClass = false;
    @Execution.Option(name="usePatternEvalWordShape")
    public boolean usePatternEvalWordShape = false;
    @Execution.Option(name="usePatternEvalGoogleNgram")
    public boolean usePatternEvalGoogleNgram = false;
    @Execution.Option(name="usePatternEvalDomainNgram")
    public boolean usePatternEvalDomainNgram = false;
    @Execution.Option(name="usePatternEvalSemanticOdds")
    public boolean usePatternEvalSemanticOdds = false;
    @Execution.Option(name="usePatternEvalEditDistSame")
    public boolean usePatternEvalEditDistSame = false;
    @Execution.Option(name="usePatternEvalEditDistOther")
    public boolean usePatternEvalEditDistOther = false;
    @Execution.Option(name="perSelectRand")
    public double perSelectRand = 0.01;
    @Execution.Option(name="perSelectNeg")
    public double perSelectNeg = 1.0;
    @Execution.Option(name="doNotExtractPhraseAnyWordLabeledOtherClass")
    public boolean doNotExtractPhraseAnyWordLabeledOtherClass = true;
    @Execution.Option(name="saveInvertedIndex")
    public boolean saveInvertedIndex = false;
    @Execution.Option(name="loadInvertedIndex")
    public boolean loadInvertedIndex = false;
    @Execution.Option(name="storePatsForEachToken", gloss="used for storing patterns in PSQL/MEMORY/LUCENE")
    public PatternForEachTokenWay storePatsForEachToken = PatternForEachTokenWay.MEMORY;
    @Execution.Option(name="storePatsIndex", gloss="used for storing patterns index")
    public PatternIndexWay storePatsIndex = PatternIndexWay.MEMORY;
    @Execution.Option(name="sampleSentencesForSufficientStats", gloss="% sentences to use for learning pattterns")
    double sampleSentencesForSufficientStats = 1.0;
    public static String backgroundSymbol = "O";
    int wordShaper = 8;
    private Map<String, String> wordShapeCache = new HashMap<String, String>();
    public SentenceIndex invertedIndex;
    public static String extremedebug = "extremePatDebug";
    public static String minimaldebug = "minimaldebug";
    Properties props;
    double editDistMax = 100.0;
    @Execution.Option(name="batchProcessSents")
    public boolean batchProcessSents = false;
    @Execution.Option(name="writeMatchedTokensFiles")
    public boolean writeMatchedTokensFiles = false;

    public ConstantsAndVariables(Properties props, Set<String> labels, Map<String, Class<? extends TypesafeMap.Key<String>>> answerClass, Map<String, Class> generalizeClasses, Map<String, Map<Class, Object>> ignoreClasses) throws IOException {
        this.labels = labels;
        this.answerClass = answerClass;
        ConstantsAndVariables.generalizeClasses = generalizeClasses;
        if (ConstantsAndVariables.generalizeClasses == null) {
            ConstantsAndVariables.generalizeClasses = new HashMap<String, Class>();
        }
        ConstantsAndVariables.generalizeClasses.putAll(answerClass);
        this.ignoreWordswithClassesDuringSelection = ignoreClasses;
        this.setUp(props);
    }

    public ConstantsAndVariables(Properties props, Map<String, Set<String>> labelDictionary, Map<String, Class<? extends TypesafeMap.Key<String>>> answerClass, Map<String, Class> generalizeClasses, Map<String, Map<Class, Object>> ignoreClasses) throws IOException {
        this.labelDictionary = labelDictionary;
        this.labels = labelDictionary.keySet();
        this.answerClass = answerClass;
        ConstantsAndVariables.generalizeClasses = generalizeClasses;
        if (ConstantsAndVariables.generalizeClasses == null) {
            ConstantsAndVariables.generalizeClasses = new HashMap<String, Class>();
        }
        ConstantsAndVariables.generalizeClasses.putAll(answerClass);
        this.ignoreWordswithClassesDuringSelection = ignoreClasses;
        this.setUp(props);
    }

    public ConstantsAndVariables(Properties props, Set<String> labels, Map<String, Class<? extends TypesafeMap.Key<String>>> answerClass) throws IOException {
        this.labels = labels;
        this.answerClass = answerClass;
        this.setUp(props);
    }

    public ConstantsAndVariables(Properties props, Set<String> labels, Map<String, Class<? extends TypesafeMap.Key<String>>> answerClass, Map<String, Class> generalizeClasses) throws IOException {
        this.labels = labels;
        this.answerClass = answerClass;
        ConstantsAndVariables.generalizeClasses = generalizeClasses;
        if (ConstantsAndVariables.generalizeClasses == null) {
            ConstantsAndVariables.generalizeClasses = new HashMap<String, Class>();
        }
        ConstantsAndVariables.generalizeClasses.putAll(answerClass);
        this.setUp(props);
    }

    public void setUp(Properties props) throws IOException {
        int j;
        HashSet<String> st;
        String[] t;
        String[] t2;
        if (this.alreadySetUp) {
            return;
        }
        Execution.fillOptions((Object)this, props);
        if (this.wordIgnoreRegex != null && !this.wordIgnoreRegex.isEmpty()) {
            PatternFactory.ignoreWordRegex = Pattern.compile(this.wordIgnoreRegex);
        }
        for (String label : this.labels) {
            this.env.put(label, TokenSequencePattern.getNewEnv());
            for (Map.Entry<String, Class<? extends TypesafeMap.Key<String>>> entry : this.answerClass.entrySet()) {
                this.env.get(label).bind(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Class<? extends TypesafeMap.Key<String>>> entry : generalizeClasses.entrySet()) {
                this.env.get(label).bind(entry.getKey(), entry.getValue());
            }
        }
        Redwood.log(new Object[]{Redwood.DBG, this.channelNameLogger, "Running with debug output"});
        stopWords = new HashSet<String>();
        Redwood.log(minimaldebug, this.channelNameLogger, "Reading stop words from " + this.stopWordsPatternFiles);
        for (String string : this.stopWordsPatternFiles.split("[;,]")) {
            stopWords.addAll(IOUtils.linesFromFile(string));
        }
        this.englishWords = new HashSet<String>();
        System.out.println("Reading english words from " + this.englishWordsFiles);
        for (String string : this.englishWordsFiles.split("[;,]")) {
            this.englishWords.addAll(IOUtils.linesFromFile(string));
        }
        if (this.commonWordsPatternFiles != null) {
            this.commonEngWords = Collections.synchronizedSet(new HashSet());
            for (String string : this.commonWordsPatternFiles.split("[;,]")) {
                this.commonEngWords.addAll(IOUtils.linesFromFile(string));
            }
        }
        if (this.otherSemanticClassesFiles != null) {
            if (this.otherSemanticClassesWords == null) {
                this.otherSemanticClassesWords = Collections.synchronizedSet(new HashSet());
            }
            for (String string : this.otherSemanticClassesFiles.split("[;,]")) {
                for (String w : IOUtils.linesFromFile(string)) {
                    String[] t22 = w.split("\\s+");
                    if (t22.length > PatternFactory.numWordsCompound) continue;
                    this.otherSemanticClassesWords.add(w);
                }
            }
            System.out.println("Size of othersemantic class variables is " + this.otherSemanticClassesWords.size());
        } else {
            this.otherSemanticClassesWords = Collections.synchronizedSet(new HashSet());
            System.out.println("Size of othersemantic class variables is 0");
        }
        String stopStr = "/";
        int i = 0;
        for (String string : stopWords) {
            if (i > 0) {
                stopStr = stopStr + "|";
            }
            stopStr = stopStr + Pattern.quote(string.replaceAll("\\\\", "\\\\\\\\"));
            ++i;
        }
        stopStr = stopStr + "/";
        for (String string : this.labels) {
            this.env.get(string).bind("$FILLER", "/" + StringUtils.join(PatternFactory.fillerWords, "|") + "/");
            this.env.get(string).bind("$STOPWORD", stopStr);
            this.env.get(string).bind("$MOD", "[{tag:/JJ.*/}]");
            if (this.matchLowerCaseContext) {
                this.env.get(string).setDefaultStringMatchFlags(2);
                this.env.get(string).setDefaultStringPatternFlags(2);
            }
            this.env.get(string).bind("OTHERSEM", PatternsAnnotations.OtherSemanticLabel.class);
            this.env.get(string).bind("grandparentparsetag", CoreAnnotations.GrandparentAnnotation.class);
        }
        if (this.wordClassClusterFile != null) {
            this.wordClassClusters = new HashMap<String, Integer>();
            for (String string : IOUtils.readLines(this.wordClassClusterFile)) {
                t2 = string.split("\t");
                this.wordClassClusters.put(t2[0], Integer.parseInt(t2[1]));
            }
        }
        if (this.generalWordClassClusterFile != null) {
            this.setGeneralWordClassClusters(new HashMap<String, Integer>());
            for (String string : IOUtils.readLines(this.generalWordClassClusterFile)) {
                t2 = string.split("\t");
                this.getGeneralWordClassClusters().put(t2[0], Integer.parseInt(t2[1]));
            }
        }
        if (this.targetAllowedTagsInitialsStr != null) {
            this.allowedTagsInitials = new HashMap<String, Set<String>>();
            for (String labelstr : this.targetAllowedTagsInitialsStr.split(";")) {
                t = labelstr.split(",");
                st = new HashSet<String>();
                for (j = 1; j < t.length; ++j) {
                    st.add(t[j]);
                }
                this.allowedTagsInitials.put(t[0], st);
            }
        }
        if (PatternFactory.useTargetNERRestriction && this.targetAllowedNERs != null) {
            this.allowedNERsforLabels = new HashMap<String, Set<String>>();
            for (String labelstr : this.targetAllowedNERs.split(";")) {
                t = labelstr.split(",");
                st = new HashSet();
                for (j = 1; j < t.length; ++j) {
                    st.add(t[j]);
                }
                this.allowedNERsforLabels.put(t[0], st);
            }
        }
        this.alreadySetUp = true;
    }

    public Map<String, Counter<String>> getWordShapesForLabels() {
        return this.wordShapesForLabels;
    }

    public void setWordShapesForLabels(Map<String, Counter<String>> wordShapesForLabels) {
        this.wordShapesForLabels = wordShapesForLabels;
    }

    public void addGeneralizeClasses(Map<String, Class> gen) {
        generalizeClasses.putAll(gen);
    }

    public static Map<String, Class> getGeneralizeClasses() {
        return generalizeClasses;
    }

    public static Set<String> getStopWords() {
        return stopWords;
    }

    public void addWordShapes(String label, Set<String> words) {
        if (!this.wordShapesForLabels.containsKey(label)) {
            this.wordShapesForLabels.put(label, new ClassicCounter());
        }
        for (String w : words) {
            String ws = null;
            if (this.wordShapeCache.containsKey(w)) {
                ws = this.wordShapeCache.get(w);
            } else {
                ws = WordShapeClassifier.wordShape(w, this.wordShaper);
                this.wordShapeCache.put(w, ws);
            }
            this.wordShapesForLabels.get(label).incrementCount(ws);
        }
    }

    public void setLabelDictionary(Map<String, Set<String>> seedSets) {
        this.labelDictionary = seedSets;
        if (this.usePhraseEvalWordShape || this.usePatternEvalWordShape) {
            this.wordShapesForLabels.clear();
            for (Map.Entry<String, Set<String>> en : seedSets.entrySet()) {
                this.addWordShapes(en.getKey(), en.getValue());
            }
        }
    }

    public Map<String, Set<String>> getLabelDictionary() {
        return this.labelDictionary;
    }

    public void addLabelDictionary(String label, Set<String> words) {
        this.labelDictionary.get(label).addAll(words);
        if (this.usePhraseEvalWordShape || this.usePatternEvalWordShape) {
            this.addWordShapes(label, words);
        }
    }

    public Set<String> getEnglishWords() {
        return this.englishWords;
    }

    public Set<String> getCommonEngWords() {
        return this.commonEngWords;
    }

    public Set<String> getOtherSemanticClassesWords() {
        return this.otherSemanticClassesWords;
    }

    public void setOtherSemanticClassesWords(Set<String> other) {
        this.otherSemanticClassesWords = other;
    }

    public Map<String, Integer> getWordClassClusters() {
        return this.wordClassClusters;
    }

    private Pair<String, Double> getEditDist(Set<String> words, String ph) {
        double minD = this.editDistMax;
        String minPh = ph;
        for (String e : words) {
            if (e.equals(ph)) {
                return new Pair<String, Double>(ph, 0.0);
            }
            double d = EditDistanceDamerauLevenshteinLike.editDistance(e, ph, 3);
            if (d == 1.0) {
                return new Pair<String, Double>(e, d);
            }
            if (d == -1.0) {
                d = this.editDistMax;
            }
            if (!(d < minD)) continue;
            minD = d;
            minPh = e;
        }
        return new Pair<String, Double>(minPh, minD);
    }

    public Pair<String, Double> getEditDistanceFromThisClass(String label, String ph, int minLen) {
        if (ph.length() < minLen) {
            return new Pair<String, Double>(ph, this.editDistMax);
        }
        if (this.editDistanceFromThisClass.containsKey(ph)) {
            return new Pair<String, Double>(this.editDistanceFromThisClassMatches.get(ph), this.editDistanceFromThisClass.get(ph));
        }
        Pair<String, Double> minD = this.getEditDist(this.labelDictionary.get(label), ph);
        double minDtotal = minD.second();
        String minPh = minD.first();
        assert (!minPh.isEmpty());
        this.editDistanceFromThisClass.putIfAbsent(ph, minDtotal);
        this.editDistanceFromThisClassMatches.putIfAbsent(ph, minPh);
        return new Pair<String, Double>(minPh, minDtotal);
    }

    public Pair<String, Double> getEditDistanceFromOtherSemanticClasses(String ph, int minLen) {
        if (ph.length() < minLen) {
            return new Pair<String, Double>(ph, this.editDistMax);
        }
        if (this.editDistanceFromOtherSemanticClasses.containsKey(ph)) {
            return new Pair<String, Double>(this.editDistanceFromOtherSemanticClassesMatches.get(ph), this.editDistanceFromOtherSemanticClasses.get(ph));
        }
        Pair<String, Double> minD = this.getEditDist(this.otherSemanticClassesWords, ph);
        double minDtotal = minD.second();
        String minPh = minD.first();
        assert (!minPh.isEmpty());
        this.editDistanceFromOtherSemanticClasses.putIfAbsent(ph, minDtotal);
        this.editDistanceFromOtherSemanticClassesMatches.putIfAbsent(ph, minPh);
        return new Pair<String, Double>(minPh, minDtotal);
    }

    public double getEditDistanceFromEng(String ph, int minLen) {
        if (ph.length() < minLen) {
            return this.editDistMax;
        }
        if (this.editDistanceFromEnglishWords.containsKey(ph)) {
            return this.editDistanceFromEnglishWords.get(ph);
        }
        Pair<String, Double> d = this.getEditDist(this.commonEngWords, ph);
        double minD = d.second();
        String minPh = d.first();
        if (d.second() > 2.0) {
            Pair<String, Double> minD2 = this.getEditDist(this.otherSemanticClassesWords, ph);
            if ((Double)minD2.second < minD) {
                minD = minD2.second();
                minPh = minD2.first();
            }
        }
        this.editDistanceFromEnglishWords.putIfAbsent(ph, minD);
        this.editDistanceFromEnglishWordsMatches.putIfAbsent(ph, minPh);
        return minD;
    }

    public ConcurrentHashMap<String, Double> getEditDistanceFromEnglishWords() {
        return this.editDistanceFromEnglishWords;
    }

    public ConcurrentHashMap<String, String> getEditDistanceFromEnglishWordsMatches() {
        return this.editDistanceFromEnglishWordsMatches;
    }

    public double getEditDistanceScoresOtherClass(String g) {
        String editDistPh;
        double editDist;
        if (this.editDistanceFromOtherSemanticClasses.containsKey(g)) {
            editDist = this.editDistanceFromOtherSemanticClasses.get(g);
            editDistPh = this.editDistanceFromOtherSemanticClassesMatches.get(g);
        } else {
            Pair<String, Double> editMatch = this.getEditDistanceFromOtherSemanticClasses(g, 4);
            editDist = editMatch.second();
            editDistPh = editMatch.first();
        }
        assert (!editDistPh.isEmpty());
        return editDist / (double)editDistPh.length();
    }

    public double getEditDistanceScoresOtherClassThreshold(String g) {
        double editDistRatio = this.getEditDistanceScoresOtherClass(g);
        if (editDistRatio < 0.2) {
            return 1.0;
        }
        return 0.0;
    }

    public double getEditDistanceScoresThisClassThreshold(String label, String g) {
        double editDistRatio = this.getEditDistanceScoresThisClass(label, g);
        if (editDistRatio < 0.2) {
            return 1.0;
        }
        return 0.0;
    }

    public double getEditDistanceScoresThisClass(String label, String g) {
        String editDistPh;
        double editDist;
        if (this.editDistanceFromThisClass.containsKey(g)) {
            editDist = this.editDistanceFromThisClass.get(g);
            editDistPh = this.editDistanceFromThisClassMatches.get(g);
        } else {
            Pair<String, Double> editMatch = this.getEditDistanceFromThisClass(label, g, 4);
            editDist = editMatch.second();
            editDistPh = editMatch.first();
        }
        assert (!editDistPh.isEmpty());
        return editDist / (double)editDistPh.length();
    }

    public static boolean isFuzzyMatch(String w1, String w2, int minLen4Fuzzy) {
        double d;
        EditDistance editDistance = new EditDistance(true);
        if (w1.equals(w2)) {
            return true;
        }
        return w2.length() > minLen4Fuzzy && (d = editDistance.score(w1, w2)) == 1.0;
    }

    public static String containsFuzzy(Set<String> words, String w, int minLen4Fuzzy) {
        for (String w1 : words) {
            if (!ConstantsAndVariables.isFuzzyMatch(w1, w, minLen4Fuzzy)) continue;
            return w1;
        }
        return null;
    }

    public Map<String, Integer> getGeneralWordClassClusters() {
        return this.generalWordClassClusters;
    }

    public void setGeneralWordClassClusters(Map<String, Integer> generalWordClassClusters) {
        this.generalWordClassClusters = generalWordClassClusters;
    }

    public Map<String, String> getWordShapeCache() {
        return this.wordShapeCache;
    }

    public Map<String, Class<? extends TypesafeMap.Key<String>>> getAnswerClass() {
        return this.answerClass;
    }

    public Map<String, Map<Class, Object>> getIgnoreWordswithClassesDuringSelection() {
        return this.ignoreWordswithClassesDuringSelection;
    }

    public static class DataSentsIterator
    implements Iterator<Pair<Map<String, List<CoreLabel>>, File>> {
        boolean readInMemory = false;
        Iterator<File> sentfilesIter = null;
        boolean batchProcessSents;

        public DataSentsIterator(boolean batchProcessSents) {
            this.batchProcessSents = batchProcessSents;
            if (batchProcessSents) {
                this.sentfilesIter = Data.sentsFiles.iterator();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.batchProcessSents) {
                return this.sentfilesIter.hasNext();
            }
            return !this.readInMemory;
        }

        @Override
        public Pair<Map<String, List<CoreLabel>>, File> next() {
            if (this.batchProcessSents) {
                try {
                    File f = this.sentfilesIter.next();
                    return new Pair<Map<String, List<CoreLabel>>, File>((Map<String, List<CoreLabel>>)IOUtils.readObjectFromFile(f), f);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            this.readInMemory = true;
            return new Pair<Map<String, List<CoreLabel>>, File>(Data.sents, new File(""));
        }
    }

    public static enum PatternIndexWay {
        MEMORY,
        OPENHFT,
        LUCENE;

    }

    public static enum PatternForEachTokenWay {
        MEMORY,
        LUCENE,
        DB;

    }

    public static enum ScorePhraseMeasures {
        DISTSIM,
        GOOGLENGRAM,
        PATWTBYFREQ,
        EDITDISTSAME,
        EDITDISTOTHER,
        DOMAINNGRAM,
        SEMANTICODDS,
        WORDSHAPE;

    }
}

